/*
 * Decompiled with CFR 0.152.
 */
package uristqwerty.CraftGuide.client.ui;

import uristqwerty.CraftGuide.CraftGuide;
import uristqwerty.gui_craftguide.components.GuiElement;
import uristqwerty.gui_craftguide.components.Window;

public class GuiResizeHandle
extends GuiElement {
    private GuiElement.AnchorPoint corner;
    private boolean dragging = false;
    private int targetX;
    private int targetY;
    private int targetOffsetX;
    private int targetOffsetY;
    private int minWidth;
    private int minHeight;
    private GuiElement target;

    public GuiResizeHandle(int x, int y, int width, int height, GuiElement element) {
        this(x, y, width, height, element, GuiElement.AnchorPoint.BOTTOM_RIGHT);
    }

    public GuiResizeHandle(int x, int y, int width, int height, GuiElement element, GuiElement.AnchorPoint corner) {
        this(x, y, width, height, element, corner, element.width(), element.height());
    }

    public GuiResizeHandle(int x, int y, int width, int height, GuiElement element, int minimumWidth, int minimumHeight) {
        this(x, y, width, height, element, GuiElement.AnchorPoint.BOTTOM_RIGHT, minimumWidth, minimumHeight);
    }

    public GuiResizeHandle(int x, int y, int width, int height, GuiElement element, GuiElement.AnchorPoint corner, int minimumWidth, int minimumHeight) {
        super(x, y, width, height);
        this.corner = corner;
        this.target = element;
        this.minWidth = minimumWidth;
        this.minHeight = minimumHeight;
        this.anchor(corner, corner);
    }

    @Override
    public void mouseMoved(int x, int y) {
        super.mouseMoved(x, y);
        if (this.dragging) {
            this.targetX = this.absoluteX() + x - this.bounds.x() - this.targetOffsetX;
            this.targetY = this.absoluteY() + y - this.bounds.y() - this.targetOffsetY;
        }
    }

    @Override
    public void mousePressed(int x, int y) {
        if (this.containsPoint(x, y)) {
            this.dragging = true;
            this.targetX = this.absoluteX();
            this.targetY = this.absoluteY();
            this.targetOffsetX = x - this.bounds.x();
            this.targetOffsetY = y - this.bounds.y();
        }
        super.mousePressed(x, y);
    }

    @Override
    public void mouseReleased(int x, int y) {
        super.mouseReleased(x, y);
        this.dragging = false;
    }

    @Override
    public void update() {
        if (this.dragging) {
            int xDif = this.targetX - this.absoluteX();
            int yDif = this.targetY - this.absoluteY();
            if (CraftGuide.resizeRate > 0) {
                int xDir = (int)Math.signum(xDif);
                int yDir = (int)Math.signum(yDif);
                xDif = Math.min(Math.abs(xDif), CraftGuide.resizeRate) * xDir;
                yDif = Math.min(Math.abs(yDif), CraftGuide.resizeRate) * yDir;
            }
            if (xDif != 0 || yDif != 0) {
                if (this.corner == GuiElement.AnchorPoint.TOP_LEFT || this.corner == GuiElement.AnchorPoint.TOP_RIGHT) {
                    yDif = -yDif;
                }
                if (this.corner == GuiElement.AnchorPoint.TOP_LEFT || this.corner == GuiElement.AnchorPoint.BOTTOM_LEFT) {
                    xDif = -xDif;
                }
                if (this.target instanceof Window && ((Window)this.target).isCentred()) {
                    xDif *= 2;
                    yDif *= 2;
                }
                this.target.setSize(Math.max(this.target.width() + xDif, this.minWidth), Math.max(this.target.height() + yDif, this.minHeight));
            }
        }
        super.update();
    }
}

