/*
 * Decompiled with CFR 0.152.
 */
package uristqwerty.CraftGuide.client.ui;

import java.util.LinkedList;
import java.util.List;
import uristqwerty.CraftGuide.client.ui.ButtonTemplate;
import uristqwerty.CraftGuide.client.ui.GuiCentredText;
import uristqwerty.CraftGuide.client.ui.IButtonListener;
import uristqwerty.CraftGuide.client.ui.Rendering.FloatingItemText;
import uristqwerty.CraftGuide.client.ui.Rendering.Overlay;
import uristqwerty.CraftGuide.client.ui.text.PlainTextSource;
import uristqwerty.CraftGuide.client.ui.text.TextSource;
import uristqwerty.gui_craftguide.components.GuiElement;
import uristqwerty.gui_craftguide.texture.Texture;
import uristqwerty.gui_craftguide.texture.TextureClip;

public class GuiButton
extends GuiElement {
    private List<IButtonListener> buttonListeners = new LinkedList<IButtonListener>();
    private ButtonTemplate template;
    protected ButtonState currentState = ButtonState.UP;
    private static FloatingItemText toolTip = new FloatingItemText("");
    private static Overlay toolTipRender = new Overlay(toolTip);
    private TextSource toolTipText = new PlainTextSource("");

    public GuiButton(int x, int y, int width, int height, Texture texture, int u, int v) {
        this(x, y, width, height, texture, u, v, width, 0);
    }

    public GuiButton(int x, int y, int width, int height, Texture texture, int u, int v, int dx, int dy) {
        super(x, y, width, height);
        this.template = new ButtonTemplate();
        int yOffset = 0;
        int xOffset = 0;
        for (ButtonState state : ButtonState.values()) {
            this.template.setStateImage(state, new TextureClip(texture, u + xOffset, v + yOffset, width, height));
            xOffset += dx;
            yOffset += dy;
        }
    }

    protected GuiButton(int x, int y, int width, int height) {
        super(x, y, width, height);
    }

    public GuiButton(int x, int y, int width, int height, ButtonTemplate template) {
        super(x, y, width, height);
        this.template = template;
    }

    public GuiButton(int x, int y, int width, int height, ButtonTemplate template, String text) {
        this(x, y, width, height, template);
        this.addElement(new GuiCentredText(0, 0, width, height, text).anchor(GuiElement.AnchorPoint.TOP_LEFT, GuiElement.AnchorPoint.BOTTOM_RIGHT));
    }

    @Override
    public void draw() {
        if (this.isOver() && !this.toolTipText.getText().isEmpty()) {
            toolTip.setText(this.toolTipText.getText());
            this.render(toolTipRender);
        }
        this.setBackground(this.template.getStateImage(this.currentState));
        super.draw();
    }

    @Override
    public void mouseMoved(int x, int y) {
        this.updateState(this.containsPoint(x, y), this.isHeld());
    }

    @Override
    public void mousePressed(int x, int y) {
        if (this.containsPoint(x, y)) {
            if (!this.isHeld()) {
                this.sendButtonEvent(IButtonListener.Event.PRESS);
            }
            this.updateState(true, true);
        }
    }

    @Override
    public void mouseReleased(int x, int y) {
        if (this.isHeld()) {
            this.sendButtonEvent(IButtonListener.Event.RELEASE);
        }
        this.updateState(this.containsPoint(x, y), false);
    }

    protected void updateState(boolean over, boolean held) {
        this.currentState = held ? (over ? ButtonState.DOWN_OVER : ButtonState.DOWN) : (over ? ButtonState.UP_OVER : ButtonState.UP);
    }

    protected boolean isHeld() {
        return this.currentState == ButtonState.DOWN || this.currentState == ButtonState.DOWN_OVER;
    }

    protected boolean isOver() {
        return this.currentState == ButtonState.UP_OVER || this.currentState == ButtonState.DOWN_OVER;
    }

    public GuiButton addButtonListener(IButtonListener listener) {
        this.buttonListeners.add(listener);
        return this;
    }

    protected void sendButtonEvent(IButtonListener.Event eventType) {
        for (IButtonListener listener : this.buttonListeners) {
            listener.onButtonEvent(this, eventType);
        }
    }

    public GuiButton setToolTip(String text) {
        return this.setToolTip(new PlainTextSource(text));
    }

    public GuiButton setToolTip(TextSource textSource) {
        this.toolTipText = textSource;
        return this;
    }

    public static enum ButtonState {
        UP,
        UP_OVER,
        DOWN,
        DOWN_OVER;

    }
}

