/*
 * Decompiled with CFR 0.152.
 */
package uristqwerty.CraftGuide.api.slotTypes;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import uristqwerty.CraftGuide.api.ItemFilter;
import uristqwerty.CraftGuide.api.Renderer;
import uristqwerty.CraftGuide.api.Slot;
import uristqwerty.CraftGuide.api.SlotType;

public class IconSlot
implements Slot {
    private static final double RAW_COORD_SCALE = 0.0625;
    private int x;
    private int y;
    private int width;
    private int height;

    public IconSlot(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    @Override
    public void draw(Renderer renderer, int recipeX, int recipeY, Object[] dataArray, int dataIndex, boolean isMouseOver) {
        Object[] data = (Object[])dataArray[dataIndex];
        Object source = data[0];
        ResourceLocation texture = null;
        IIcon icon = null;
        if (source instanceof ResourceLocation) {
            texture = (ResourceLocation)source;
        } else if (source instanceof Object[]) {
            texture = (ResourceLocation)((Object[])source)[0];
            icon = (IIcon)((Object[])source)[1];
        }
        int x = recipeX + this.x;
        int y = recipeY + this.y;
        if (texture != null) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
            double u = ((Float)data[1]).floatValue();
            double v = ((Float)data[2]).floatValue();
            double u2 = ((Float)data[3]).floatValue();
            double v2 = ((Float)data[4]).floatValue();
            int color = (Integer)data[5];
            if (icon != null) {
                u = icon.func_94214_a(u);
                u2 = icon.func_94214_a(u2);
                v = icon.func_94207_b(v);
                v2 = icon.func_94207_b(v2);
            } else {
                u *= 0.0625;
                u2 *= 0.0625;
                v *= 0.0625;
                v2 *= 0.0625;
            }
            int x2 = x + this.width;
            int y2 = y + this.height;
            GL11.glEnable((int)3553);
            GL11.glDisable((int)2929);
            GL11.glEnable((int)3553);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            this.setColor(color);
            GL11.glBegin((int)7);
            GL11.glTexCoord2d((double)u, (double)v);
            GL11.glVertex2i((int)x, (int)y);
            GL11.glTexCoord2d((double)u, (double)v2);
            GL11.glVertex2i((int)x, (int)y2);
            GL11.glTexCoord2d((double)u2, (double)v2);
            GL11.glVertex2i((int)x2, (int)y2);
            GL11.glTexCoord2d((double)u2, (double)v);
            GL11.glVertex2i((int)x2, (int)y);
            GL11.glEnd();
        }
        if (data.length > 6) {
            String text = data[6].toString();
            int textWidth = Minecraft.func_71410_x().field_71466_p.func_78256_a(text);
            int textX = Math.max(x, x + this.width + 1 - textWidth);
            renderer.renderText(textX, y + this.height - 7, text, -1, true);
        }
    }

    private void setColor(int color) {
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color >> 0 & 0xFF) / 255.0f;
        GL11.glColor4f((float)r, (float)g, (float)b, (float)a);
    }

    @Override
    public ItemFilter getClickedFilter(int x, int y, Object[] data, int dataIndex) {
        return null;
    }

    @Override
    public boolean isPointInBounds(int x, int y, Object[] data, int dataIndex) {
        return false;
    }

    @Override
    public List<String> getTooltip(int x, int y, Object[] data, int dataIndex) {
        return null;
    }

    @Override
    public boolean matches(ItemFilter filter, Object[] data, int dataIndex, SlotType type) {
        return false;
    }
}

