/*
 * Decompiled with CFR 0.152.
 */
package uristqwerty.CraftGuide.api;

import java.util.List;
import uristqwerty.CraftGuide.api.ItemFilter;
import uristqwerty.CraftGuide.api.ItemSlot;
import uristqwerty.CraftGuide.api.Renderer;
import uristqwerty.CraftGuide.api.SlotType;

public class ChanceSlot
extends ItemSlot {
    private int ratio = 100;
    private String formatString = " (%1$.0f%% chance)";

    public ChanceSlot(int x, int y, int width, int height) {
        super(x, y, width, height);
    }

    public ChanceSlot(int x, int y, int width, int height, boolean drawQuantity) {
        super(x, y, width, height, drawQuantity);
    }

    @Override
    public void draw(Renderer renderer, int x, int y, Object[] data, int dataIndex, boolean isMouseOver) {
        implementation.draw(this, renderer, x, y, this.stack(data, dataIndex), isMouseOver);
    }

    @Override
    public List<String> getTooltip(int x, int y, Object[] data, int dataIndex) {
        if (data[dataIndex] == null || this.stack(data, dataIndex) == null) {
            return implementation.getTooltip(this, null);
        }
        List<String> tooltip = implementation.getTooltip(this, this.stack(data, dataIndex));
        double val = ChanceSlot.unboxToDouble(((Object[])data[dataIndex])[1]) * 100.0 / (double)this.ratio;
        tooltip.set(0, tooltip.get(0) + String.format(this.formatString, val));
        return tooltip;
    }

    private static double unboxToDouble(Object obj) {
        if (obj instanceof Double) {
            return (Double)obj;
        }
        if (obj instanceof Float) {
            return ((Float)obj).floatValue();
        }
        if (obj instanceof Long) {
            return ((Long)obj).longValue();
        }
        if (obj instanceof Integer) {
            return ((Integer)obj).intValue();
        }
        if (obj instanceof Short) {
            return ((Short)obj).shortValue();
        }
        if (obj instanceof Character) {
            return ((Character)obj).charValue();
        }
        if (obj instanceof Byte) {
            return ((Byte)obj).byteValue();
        }
        return (Double)obj;
    }

    @Override
    public boolean matches(ItemFilter search, Object[] data, int dataIndex, SlotType type) {
        return implementation.matches(this, search, this.stack(data, dataIndex), type);
    }

    @Override
    public ItemFilter getClickedFilter(int x, int y, Object[] data, int dataIndex) {
        return implementation.getClickedFilter(x, y, this.stack(data, dataIndex));
    }

    private Object stack(Object[] data, int dataIndex) {
        return data[dataIndex] != null ? ((Object[])data[dataIndex])[0] : null;
    }

    public ChanceSlot setRatio(int ratio) {
        this.ratio = ratio;
        return this;
    }

    public ChanceSlot setFormatString(String format) {
        this.formatString = format;
        return this;
    }
}

