/*
 * Decompiled with CFR 0.152.
 */
package uristqwerty.CraftGuide;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import uristqwerty.CraftGuide.CommonUtilities;
import uristqwerty.CraftGuide.CraftGuideLog;
import uristqwerty.CraftGuide.ForgeExtensions;
import uristqwerty.CraftGuide.api.ItemFilter;
import uristqwerty.CraftGuide.api.ItemSlot;
import uristqwerty.CraftGuide.api.ItemSlotImplementation;
import uristqwerty.CraftGuide.api.NamedTexture;
import uristqwerty.CraftGuide.api.Renderer;
import uristqwerty.CraftGuide.api.SlotType;
import uristqwerty.CraftGuide.api.Util;

public class ItemSlotImplementationImplementation
implements ItemSlotImplementation {
    private NamedTexture overlayAny = Util.instance.getTexture("ItemStack-Any");
    private NamedTexture overlayForge = Util.instance.getTexture("ItemStack-OreDict");
    private NamedTexture overlayForgeSingle = Util.instance.getTexture("ItemStack-OreDict-Single");
    private NamedTexture background = Util.instance.getTexture("ItemStack-Background");

    @Override
    public List<String> getTooltip(ItemSlot itemSlot, Object data) {
        ItemStack stack = ItemSlotImplementationImplementation.item(data);
        if (stack == null) {
            if (data instanceof List && ((List)data).size() < 1) {
                return this.emptyOreDictEntryText((List)data);
            }
            return null;
        }
        return CommonUtilities.getExtendedItemStackText(data);
    }

    @Override
    public void draw(ItemSlot itemSlot, Renderer renderer, int recipeX, int recipeY, Object data, boolean isMouseOver) {
        int x = recipeX + itemSlot.x;
        int y = recipeY + itemSlot.y;
        ItemStack stack = ItemSlotImplementationImplementation.item(data);
        if (itemSlot.drawBackground) {
            renderer.renderRect(x - 1, y - 1, 18, 18, this.background);
        }
        if (stack != null) {
            renderer.renderItemStack(x, y, stack);
            if (isMouseOver) {
                renderer.renderRect(x, y, 16, 16, 255, 255, 255, 128);
            }
            if (CommonUtilities.getItemDamage(stack) == Short.MAX_VALUE) {
                renderer.renderRect(x - 1, y - 1, 18, 18, this.overlayAny);
            }
            if (data instanceof List) {
                if (((List)data).size() > 1) {
                    renderer.renderRect(x - 1, y - 1, 18, 18, this.overlayForge);
                } else {
                    renderer.renderRect(x - 1, y - 1, 18, 18, this.overlayForgeSingle);
                }
            }
        } else if (data instanceof List && ((List)data).size() < 1) {
            renderer.renderRect(x - 1, y - 1, 18, 18, this.overlayForge);
        }
    }

    private static ItemStack item(Object data) {
        if (data == null) {
            return null;
        }
        if (data instanceof ItemStack) {
            return (ItemStack)data;
        }
        if (data instanceof List && ((List)data).size() > 0) {
            return ItemSlotImplementationImplementation.item(((List)data).get(0));
        }
        return null;
    }

    @Override
    public boolean matches(ItemSlot itemSlot, ItemFilter search, Object data, SlotType type) {
        if (type != itemSlot.slotType && (type != SlotType.ANY_SLOT || itemSlot.slotType == SlotType.DISPLAY_SLOT || itemSlot.slotType == SlotType.HIDDEN_SLOT)) {
            return false;
        }
        try {
            if (search == null) {
                return false;
            }
            if (data == null || data instanceof ItemStack) {
                return search.matches(data);
            }
            if (data instanceof List) {
                for (Object content : (List)data) {
                    if (!search.matches(content)) continue;
                    return true;
                }
            }
        }
        catch (Throwable e) {
            CraftGuideLog.log("exception trace: uristqwerty.CraftGuide.ItemSlotImplementationImplementation.matches data " + (data != null ? data.getClass() : "null"));
            throw new RuntimeException(e);
        }
        return false;
    }

    @Override
    public boolean isPointInBounds(ItemSlot itemSlot, int x, int y) {
        return x >= itemSlot.x && x < itemSlot.x + itemSlot.width && y >= itemSlot.y && y < itemSlot.y + itemSlot.height;
    }

    @Override
    public ItemFilter getClickedFilter(int x, int y, Object object) {
        return Util.instance.getCommonFilter(object);
    }

    private List<String> emptyOreDictEntryText(List<?> oreDictionaryList) {
        List<String> list = ForgeExtensions.emptyOreDictEntryText(oreDictionaryList);
        if (list == null) {
            list = new ArrayList<String>(1);
            list.add("Empty item list, not in ore dictionary");
        }
        return list;
    }
}

