/*
 * Decompiled with CFR 0.152.
 */
package uristqwerty.CraftGuide;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import uristqwerty.CraftGuide.CommonUtilities;
import uristqwerty.CraftGuide.CraftGuideLog;
import uristqwerty.CraftGuide.ForgeExtensions;
import uristqwerty.CraftGuide.RecipeGeneratorImplementation;

public class ForgeExtensionsImplementation
extends ForgeExtensions {
    private IdentityHashMap<List<?>, String> mappingCache = new IdentityHashMap();
    private IdentityHashMap<List<?>, String> oreDictName = new IdentityHashMap();

    @Override
    public boolean matchesTypeImpl(IRecipe recipe) {
        return recipe instanceof ShapedOreRecipe || recipe instanceof ShapelessOreRecipe;
    }

    @Override
    public boolean isShapelessRecipeImpl(IRecipe recipe) {
        return recipe instanceof ShapelessOreRecipe;
    }

    @Override
    public Object[] getCraftingRecipeImpl(RecipeGeneratorImplementation gen, IRecipe recipe, boolean allowSmallGrid) {
        try {
            if (recipe instanceof ShapedOreRecipe) {
                int width = (Integer)CommonUtilities.getPrivateValue(ShapedOreRecipe.class, (ShapedOreRecipe)recipe, "width");
                int height = (Integer)CommonUtilities.getPrivateValue(ShapedOreRecipe.class, (ShapedOreRecipe)recipe, "height");
                Object[] items = (Object[])CommonUtilities.getPrivateValue(ShapedOreRecipe.class, (ShapedOreRecipe)recipe, "input");
                if (allowSmallGrid && width < 3 && height < 3) {
                    return gen.getSmallShapedRecipe(width, height, items, ((ShapedOreRecipe)recipe).func_77571_b());
                }
                return gen.getCraftingShapedRecipe(width, height, items, ((ShapedOreRecipe)recipe).func_77571_b());
            }
            if (recipe instanceof ShapelessOreRecipe) {
                List items = (List)CommonUtilities.getPrivateValue(ShapelessOreRecipe.class, (ShapelessOreRecipe)recipe, "input");
                return gen.getCraftingShapelessRecipe(items, ((ShapelessOreRecipe)recipe).func_77571_b());
            }
        }
        catch (SecurityException e) {
            CraftGuideLog.log(e);
        }
        catch (NoSuchFieldException e) {
            CraftGuideLog.log(e);
        }
        catch (IllegalArgumentException e) {
            CraftGuideLog.log(e);
        }
        catch (IllegalAccessException e) {
            CraftGuideLog.log(e);
        }
        return null;
    }

    @Override
    public List<String> emptyOreDictEntryTextImpl(List<?> oreDictionaryList) {
        String name;
        if (!this.mappingCache.containsKey(oreDictionaryList)) {
            this.mappingCache.put(oreDictionaryList, this.getOreDictionaryNameImpl(oreDictionaryList));
        }
        if ((name = this.mappingCache.get(oreDictionaryList)) == null) {
            return null;
        }
        ArrayList<String> text = new ArrayList<String>(1);
        text.add("0 items for Ore Dictionary name '" + name + "'");
        return text;
    }

    @Override
    public String getOreDictionaryNameImpl(List<?> list) {
        if (this.oreDictName.containsKey(list)) {
            return this.oreDictName.get(list);
        }
        String name = this.getOreDictName(list);
        this.oreDictName.put(list, name);
        return name;
    }

    private String getOreDictName(List<?> list) {
        try {
            Field oreStacks = OreDictionary.class.getDeclaredField("oreStacks");
            oreStacks.setAccessible(true);
            HashMap map = (HashMap)oreStacks.get(null);
            Integer integer = null;
            for (Map.Entry entry : map.entrySet()) {
                if (entry.getValue() != list) continue;
                integer = (Integer)entry.getKey();
                break;
            }
            if (integer != null) {
                return OreDictionary.getOreName((int)integer);
            }
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }
}

