/*
 * Decompiled with CFR 0.152.
 */
package uristqwerty.CraftGuide;

import net.minecraft.item.ItemStack;
import uristqwerty.CraftGuide.Recipe;
import uristqwerty.CraftGuide.api.CraftGuideRecipe;
import uristqwerty.CraftGuide.api.RecipeTemplate;
import uristqwerty.CraftGuide.api.Slot;
import uristqwerty.gui_craftguide.rendering.Renderable;
import uristqwerty.gui_craftguide.rendering.TexturedRect;
import uristqwerty.gui_craftguide.texture.Texture;

public class DefaultRecipeTemplate
implements RecipeTemplate {
    private Slot[] slots;
    private Texture backgroundTexture;
    private Texture backgroundSelectedTexture;
    private Renderable background;
    private Renderable backgroundSelected;
    private int width = 79;
    private int height = 58;
    private ItemStack craftingType;

    public DefaultRecipeTemplate(Slot[] slots, ItemStack craftingType, Texture background, Texture backgroundSelected) {
        this.slots = slots;
        this.backgroundTexture = background;
        this.backgroundSelectedTexture = backgroundSelected;
        this.background = new TexturedRect(0, 0, this.width, this.height, background, 0, 0);
        this.backgroundSelected = new TexturedRect(0, 0, this.width, this.height, backgroundSelected, 0, 0);
        this.craftingType = craftingType;
    }

    @Override
    public CraftGuideRecipe generate(Object[] items) {
        return new Recipe(this.slots, items, this.background, this.backgroundSelected).setSize(this.width, this.height);
    }

    public Recipe generateWithSize(Object[] items, int width, int height) {
        TexturedRect background = new TexturedRect(0, 0, width, height, this.backgroundTexture, 0, 0);
        TexturedRect backgroundSelected = new TexturedRect(0, 0, width, height, this.backgroundSelectedTexture, 0, 0);
        return new Recipe(this.slots, items, background, backgroundSelected).setSize(width, height);
    }

    @Override
    public RecipeTemplate setSize(int width, int height) {
        this.width = width;
        this.height = height;
        this.background = new TexturedRect(0, 0, width, height, this.backgroundTexture, 0, 0);
        this.backgroundSelected = new TexturedRect(0, 0, width, height, this.backgroundSelectedTexture, 0, 0);
        return this;
    }

    @Override
    public ItemStack getCraftingType() {
        return this.craftingType;
    }

    public int width() {
        return this.width;
    }

    public int height() {
        return this.height;
    }
}

