/*
 * Decompiled with CFR 0.152.
 */
package mmmlibx.lib;

import littleMaidMobX.LMM_EntityLittleMaid;
import mmmlibx.lib.ITextureEntity;
import mmmlibx.lib.MMMLib;
import mmmlibx.lib.MMM_EntitySelect;
import mmmlibx.lib.MMM_Helper;
import mmmlibx.lib.MMM_TextureBox;
import mmmlibx.lib.MMM_TextureBoxBase;
import mmmlibx.lib.MMM_TextureBoxServer;
import mmmlibx.lib.MMM_TextureManager;
import mmmlibx.lib.multiModel.model.mc162.IModelCaps;
import mmmlibx.lib.multiModel.model.mc162.ModelMultiBase;
import net.minecraft.entity.DataWatcher;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public class MMM_TextureData {
    public EntityLivingBase owner;
    public IModelCaps entityCaps;
    public ResourceLocation[][] textures;
    public int color;
    public boolean contract;
    public MMM_TextureBoxBase[] textureBox;
    public int[] textureIndex;
    public ModelMultiBase[] textureModel;
    public int selectValue;
    public int data_Color = 19;
    public int data_Texture = 20;
    public int data_Value = 21;

    public MMM_TextureData(EntityLivingBase pEntity, IModelCaps pCaps) {
        this.owner = pEntity;
        this.entityCaps = pCaps;
        this.textures = new ResourceLocation[][]{{null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}};
        this.color = 12;
        this.contract = false;
        this.textureBox = new MMM_TextureBoxBase[2];
        this.textureBox[0] = this.textureBox[1] = MMM_TextureManager.instance.getDefaultTexture(this.owner.getClass());
        this.textureIndex = new int[]{0, 0};
        this.textureModel = new ModelMultiBase[3];
    }

    public boolean setTextureNames() {
        this.textureModel[0] = null;
        this.textureModel[1] = null;
        this.textureModel[2] = null;
        if (this.owner.field_70170_p.field_72995_K) {
            return this.setTextureNamesClient();
        }
        return this.setTextureNamesServer();
    }

    protected boolean setTextureNamesClient() {
        MMM_TextureBox lbox;
        boolean lf = false;
        if (this.textureBox[0] instanceof MMM_TextureBox) {
            lbox = (MMM_TextureBox)this.textureBox[0];
            int lc = (this.color & 0xFF) + (this.contract ? 0 : 48);
            if (lbox.hasColor(lc)) {
                this.textures[0][0] = lbox.getTextureName(lc);
                lc = (this.color & 0xFF) + (this.contract ? 96 : 112);
                this.textures[0][1] = lbox.getTextureName(lc);
                lf = true;
                this.textureModel[0] = lbox.models[0];
            } else {
                lbox = MMM_TextureManager.instance.getDefaultTexture((ITextureEntity)this.owner);
                this.textureBox[0] = this.textureBox[1] = lbox;
                if (lbox.hasColor(lc)) {
                    this.textures[0][0] = lbox.getTextureName(lc);
                    lc = (this.color & 0xFF) + (this.contract ? 96 : 112);
                    this.textures[0][1] = lbox.getTextureName(lc);
                    lf = true;
                    this.textureModel[0] = lbox.models[0];
                }
            }
        } else {
            this.textureBox[0] = MMM_TextureManager.instance.getTextureBoxServerIndex(this.textureIndex[0]);
        }
        if (this.textureBox[1] instanceof MMM_TextureBox && this.owner != null) {
            lbox = (MMM_TextureBox)this.textureBox[1];
            for (int i = 0; i < 4; ++i) {
                ItemStack is = this.owner.func_71124_b(i + 1);
                this.textures[1][i] = lbox.getArmorTextureName(64, is);
                this.textures[2][i] = lbox.getArmorTextureName(80, is);
                this.textures[3][i] = lbox.getArmorTextureName(128, is);
                this.textures[4][i] = lbox.getArmorTextureName(144, is);
            }
            this.textureModel[1] = lbox.models[1];
            this.textureModel[2] = lbox.models[2];
        } else {
            this.textureBox[0] = MMM_TextureManager.instance.getTextureBoxServerIndex(this.textureIndex[0]);
        }
        return lf;
    }

    protected boolean setTextureNamesServer() {
        MMM_TextureBoxServer lbox;
        boolean lf = false;
        if (this.textureBox[0] instanceof MMM_TextureBoxServer) {
            int lc;
            lbox = (MMM_TextureBoxServer)this.textureBox[0];
            if (lbox.localBox != null && lbox.localBox.hasColor(lc = (this.color & 0xFF) + (this.contract ? 0 : 48))) {
                if (MMM_Helper.isClient) {
                    this.textures[0][0] = lbox.localBox.getTextureName(lc);
                    lc = (this.color & 0xFF) + (this.contract ? 96 : 112);
                    this.textures[0][1] = lbox.localBox.getTextureName(lc);
                }
                lf = true;
                this.textureModel[0] = lbox.localBox.models[0];
            }
        }
        if (this.textureBox[1] instanceof MMM_TextureBoxServer && this.owner != null) {
            lbox = (MMM_TextureBoxServer)this.textureBox[1];
            if (lbox.localBox != null) {
                if (MMM_Helper.isClient) {
                    for (int i = 0; i < 4; ++i) {
                        ItemStack is = this.owner.func_71124_b(i + 1);
                        this.textures[1][i] = lbox.localBox.getArmorTextureName(64, is);
                        this.textures[2][i] = lbox.localBox.getArmorTextureName(80, is);
                        this.textures[3][i] = lbox.localBox.getArmorTextureName(128, is);
                        this.textures[4][i] = lbox.localBox.getArmorTextureName(144, is);
                    }
                }
                this.textureModel[1] = lbox.localBox.models[1];
                this.textureModel[2] = lbox.localBox.models[2];
            }
        }
        return lf;
    }

    public void setNextTexturePackege(int pTargetTexture) {
        if (pTargetTexture == 0) {
            int lc = this.getColor() + (this.isContract() ? 0 : 48);
            this.textureBox[0] = this.textureBox[0] instanceof MMM_TextureBox ? MMM_TextureManager.instance.getNextPackege((MMM_TextureBox)this.textureBox[0], lc) : null;
            if (this.textureBox[0] == null) {
                this.textureBox[0] = this.textureBox[1] = MMM_TextureManager.instance.getDefaultTexture((ITextureEntity)this.owner);
                this.setColor(12);
            } else {
                this.textureBox[1] = this.textureBox[0];
            }
            if (!((MMM_TextureBox)this.textureBox[1]).hasArmor()) {
                pTargetTexture = 1;
            }
        }
        if (pTargetTexture == 1) {
            this.textureBox[1] = MMM_TextureManager.instance.getNextArmorPackege((MMM_TextureBox)this.textureBox[1]);
        }
    }

    public void setPrevTexturePackege(int pTargetTexture) {
        if (pTargetTexture == 0) {
            int lc = this.getColor() + (this.isContract() ? 0 : 48);
            this.textureBox[0] = MMM_TextureManager.instance.getPrevPackege((MMM_TextureBox)this.textureBox[0], lc);
            this.textureBox[1] = this.textureBox[0];
            if (!((MMM_TextureBox)this.textureBox[1]).hasArmor()) {
                pTargetTexture = 1;
            }
        }
        if (pTargetTexture == 1) {
            this.textureBox[1] = MMM_TextureManager.instance.getPrevArmorPackege((MMM_TextureBox)this.textureBox[1]);
        }
    }

    public void onUpdate() {
        if (this.textureBox != null && this.textureBox.length > 0 && this.textureBox[0] != null && this.textureBox[0].isUpdateSize) {
            this.setSize();
        }
    }

    protected void setSize() {
        if (this.textureBox != null && this.textureBox.length > 0 && this.textureBox[0] != null) {
            if (this.owner instanceof LMM_EntityLittleMaid) {
                ((LMM_EntityLittleMaid)this.owner).setSize2(this.textureBox[0].getWidth(this.entityCaps), this.textureBox[0].getHeight(this.entityCaps));
            } else if (this.owner instanceof MMM_EntitySelect) {
                ((MMM_EntitySelect)this.owner).setSize2(this.textureBox[0].getWidth(this.entityCaps), this.textureBox[0].getHeight(this.entityCaps));
            }
            if (this.owner instanceof EntityAgeable) {
                ((EntityAgeable)this.owner).func_98054_a(this.owner.func_70631_g_());
            }
        }
    }

    public void setTexturePackIndex(int pColor, int[] pIndex) {
        for (int li = 0; li < pIndex.length; ++li) {
            this.textureIndex[li] = pIndex[li];
            this.textureBox[li] = MMM_TextureManager.instance.getTextureBoxServer(this.textureIndex[li]);
        }
        this.color = pColor;
        this.setSize();
    }

    public void setTexturePackName(MMM_TextureBox[] pTextureBox) {
        for (int li = 0; li < pTextureBox.length; ++li) {
            this.textureBox[li] = pTextureBox[li];
        }
        this.setSize();
    }

    public boolean setColor(int pColor) {
        boolean lf = this.color != pColor;
        this.color = pColor;
        return lf;
    }

    public int getColor() {
        return this.color & 0xFF;
    }

    public void setContract(boolean pContract) {
        this.contract = pContract;
    }

    public boolean isContract() {
        return this.contract;
    }

    public void setTextureBox(MMM_TextureBoxBase[] pTextureBox) {
        this.textureBox = pTextureBox;
    }

    public MMM_TextureBoxBase[] getTextureBox() {
        return this.textureBox;
    }

    public void setTextureIndex(int[] pTextureIndex) {
        this.textureIndex = pTextureIndex;
    }

    public int[] getTextureIndex() {
        return this.textureIndex;
    }

    public void setTextures(int pIndex, ResourceLocation[] pNames) {
        this.textures[pIndex] = pNames;
    }

    public ResourceLocation[] getTextures(int pIndex) {
        return this.textures[pIndex];
    }

    public int getWildColor() {
        return this.textureBox[0].getRandomWildColor(this.owner.func_70681_au());
    }

    public void setTextureInitServer(String pName) {
        MMMLib.Debug("request Init Texture: %s", pName);
        this.textureIndex[0] = this.textureIndex[1] = MMM_TextureManager.instance.getIndexTextureBoxServer((ITextureEntity)this.owner, pName);
        this.textureBox[0] = this.textureBox[1] = MMM_TextureManager.instance.getTextureBoxServer(this.textureIndex[0]);
        this.color = this.textureBox[0].getRandomWildColor(this.owner.func_70681_au());
    }

    public void setTextureInitClient() {
        MMM_TextureBox lbox = MMM_TextureManager.instance.getDefaultTexture(this.owner.getClass());
        for (int li = 0; li < this.textureBox.length; ++li) {
            this.textureBox[li] = lbox;
            this.textureIndex[li] = MMM_TextureManager.instance.getIndexTextureBoxServerIndex(lbox);
        }
        this.color = this.textureBox[0].getRandomWildColor(this.owner.func_70681_au());
    }

    public String getTextureName(int pIndex) {
        return this.textureBox[pIndex].textureName;
    }

    public ResourceLocation getGUITexture() {
        return ((MMM_TextureBox)this.textureBox[0]).getTextureName(32);
    }

    public boolean isValueFlag(int pIndex) {
        return (this.selectValue >>> pIndex & 1) == 1;
    }

    public void setValueFlag(int pIndex, boolean pFlag) {
        this.selectValue |= (pFlag ? 1 : 0) << pIndex;
    }

    public void writeToNBT(NBTTagCompound par1nbtTagCompound) {
        NBTTagCompound lnbt = new NBTTagCompound();
        lnbt.func_74783_a("Textures", this.textureIndex);
        lnbt.func_74768_a("Color", this.color);
        lnbt.func_74757_a("Contract", this.contract);
        lnbt.func_74768_a("SelectValue", this.selectValue);
        par1nbtTagCompound.func_74782_a("TextureData", (NBTBase)lnbt);
    }

    public void readToNBT(NBTTagCompound par1nbtTagCompound) {
        if (par1nbtTagCompound.func_74764_b("TextureData")) {
            NBTTagCompound lnbt = par1nbtTagCompound.func_74775_l("TextureData");
            this.color = lnbt.func_74762_e("Color");
            this.contract = lnbt.func_74767_n("Contract");
            this.selectValue = lnbt.func_74762_e("SelectValue");
            int[] intList = lnbt.func_74759_k("Textures");
            if (intList.length > 0) {
                this.setTexturePackIndex(this.color, intList);
            } else {
                MMM_TextureBox lbox = MMM_TextureManager.instance.getDefaultTexture((ITextureEntity)this.owner);
                int li = MMM_TextureManager.instance.getIndexTextureBoxServerIndex(lbox);
                this.setTexturePackIndex(this.color, new int[]{li, li});
            }
        }
    }

    public boolean updateTexture(int pColor, int[] pTextureIndex) {
        boolean lf = false;
        lf |= this.setColor(pColor);
        for (int li = 0; li < pTextureIndex.length; ++li) {
            if (this.textureIndex[li] == pTextureIndex[li]) continue;
            this.textureIndex[li] = pTextureIndex[li];
            lf |= true;
        }
        if (lf) {
            this.setTextureNames();
        }
        return lf;
    }

    public void entityInit(DataWatcher pDataWatcher) {
        pDataWatcher.func_75682_a(this.data_Color, (Object)0);
        pDataWatcher.func_75682_a(this.data_Texture, (Object)0);
        pDataWatcher.func_75682_a(this.data_Value, (Object)0);
    }

    protected void setWatchedColor(int pColor) {
        this.owner.func_70096_w().func_75692_b(this.data_Color, (Object)((byte)pColor));
    }

    protected int getWatchedColor() {
        return this.owner.func_70096_w().func_75683_a(this.data_Color);
    }
}

