/*
 * Decompiled with CFR 0.152.
 */
package mmmlibx.lib;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import java.io.File;
import java.util.List;
import mmmlibx.lib.FileManager;
import mmmlibx.lib.MMM_Helper;
import mmmlibx.lib.MMM_ProxyCommon;
import mmmlibx.lib.MMM_StabilizerManager;
import mmmlibx.lib.MMM_TextureManager;
import mmmlibx.lib.guns.GunsBase;
import mmmlibx.lib.multiModel.MMMLoader.MMMTransformer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.config.Configuration;
import network.W_Message;
import network.W_Network;

@Mod(modid="MMMLibX", name="MMMLibX", version="1.7.x-srg-1")
public class MMMLib {
    public static boolean cfg_isModelAlphaBlend = true;
    public static boolean isDebugMessage = true;
    public static boolean isModelAlphaBlend = true;
    @SidedProxy(clientSide="mmmlibx.lib.MMM_ProxyClient", serverSide="mmmlibx.lib.MMM_ProxyCommon")
    public static MMM_ProxyCommon proxy;

    public static void Debug(String pText, Object ... pData) {
        if (isDebugMessage) {
            System.out.println(String.format("MMMLib-" + pText, pData));
        }
    }

    public static void Debug(boolean isRemote, String pText, Object ... pData) {
        if (isDebugMessage) {
            System.out.println(String.format("[" + (isRemote ? "Client" : "Server") + "]MMMLib-" + pText, pData));
        }
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent pEvent) {
        MMMTransformer.isEnable = true;
        File configFile = pEvent.getSuggestedConfigurationFile();
        Configuration lconf = new Configuration(configFile);
        lconf.load();
        isDebugMessage = lconf.get("MMMLib", "isDebugMessage", false).getBoolean(false);
        cfg_isModelAlphaBlend = isModelAlphaBlend = lconf.get("MMMLib", "isModelAlphaBlend", true).getBoolean(true);
        lconf.save();
        MMM_StabilizerManager.init();
        MMM_TextureManager.instance.loadTextures();
        if (MMM_Helper.isClient) {
            MMM_StabilizerManager.loadStabilizer();
            MMMLib.Debug("Localmode: InitTextureList.", new Object[0]);
            MMM_TextureManager.instance.initTextureList(true);
        } else {
            MMM_TextureManager.instance.loadTextureServer();
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent pEvent) {
        if (pEvent.getSide() == Side.CLIENT) {
            // empty if block
        }
    }

    @Mod.EventHandler
    public void loaded(FMLPostInitializationEvent pEvent) {
        GunsBase.initAppend();
        MMMTransformer.isEnable = true;
        List<File> llist = FileManager.getAllmodsFiles(this.getClass().getClassLoader(), true);
        for (File lf : llist) {
            MMMLib.Debug("targetFiles: %s", lf.getAbsolutePath());
        }
        try {
            Class lc = ReflectionHelper.getClass((ClassLoader)this.getClass().getClassLoader(), (String[])new String[]{"net.minecraft.entity.EntityLivingBase"});
            MMMLib.Debug("test-getClass: %s", lc.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void serverCustomPayload(EntityPlayer playerEntity, W_Message var2) {
        byte lmode = var2.data[0];
        int leid = 0;
        Entity lentity = null;
        if ((lmode & 0x80) != 0) {
            leid = MMM_Helper.getInt(var2.data, 1);
            lentity = MMM_Helper.getEntity(var2.data, 1, playerEntity.field_70170_p);
            if (lentity == null) {
                return;
            }
        }
        MMMLib.Debug("MMM|Upd Srv Call[%2x:%d].", lmode, leid);
        switch (lmode) {
            case -128: {
                MMM_TextureManager.instance.reciveFromClientSetTexturePackIndex(lentity, var2.data);
                break;
            }
            case 1: {
                MMM_TextureManager.instance.reciveFromClientGetTexturePackIndex(playerEntity, var2.data);
                break;
            }
            case 2: {
                MMM_TextureManager.instance.reciveFromClientGetTexturePackName(playerEntity, var2.data);
            }
        }
    }

    public static void sendToClient(EntityPlayer player, byte[] ldata) {
        W_Network.sendPacketToPlayer(1, player, ldata);
    }
}

