/*
 * Decompiled with CFR 0.152.
 */
package mmmlibx.lib;

import cpw.mods.fml.relauncher.FMLInjectionData;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mmmlibx.lib.MMMLib;

public class FileManager {
    public static File dirMinecraft;
    public static File dirMods;
    public static File dirModsVersion;
    public static List<File> files;
    public static String minecraftDir;
    public static String assetsDir;
    public static boolean isDevdir;
    public static Map<String, List<File>> fileList;

    public static void setSrcPath(File file) {
        assetsDir = file.getPath() + "/assets";
        MMMLib.Debug("mods path =" + dirMods.getAbsolutePath(), new Object[0]);
    }

    public static List<File> getAllmodsFiles(ClassLoader pClassLoader, boolean pFlag) {
        ArrayList<File> llist = new ArrayList<File>();
        if (pClassLoader instanceof URLClassLoader) {
            for (Serializable serializable : ((URLClassLoader)pClassLoader).getURLs()) {
                try {
                    String ls = ((URL)serializable).toString();
                    if (!ls.endsWith("/bin/") && ls.indexOf("/mods/") <= -1) continue;
                    llist.add(new File(((URL)serializable).toURI()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (pFlag) {
            if (dirMods.exists()) {
                for (Serializable serializable : dirMods.listFiles()) {
                    FileManager.addList(llist, (File)serializable);
                }
            }
            if (dirModsVersion.exists()) {
                for (Serializable serializable : dirModsVersion.listFiles()) {
                    FileManager.addList(llist, (File)serializable);
                }
            }
        }
        files = llist;
        return llist;
    }

    protected static boolean addList(List<File> pList, File pFile) {
        for (File lf : pList) {
            try {
                if (pFile.getCanonicalPath().compareTo(lf.getCanonicalPath()) != 0) continue;
                return false;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        pList.add(pFile);
        return true;
    }

    public static List<File> getModFile(String pname, String pprefix) {
        ArrayList<File> llist;
        if (fileList.containsKey(pname)) {
            llist = fileList.get(pname);
        } else {
            llist = new ArrayList();
            fileList.put(pname, llist);
        }
        MMMLib.Debug("getModFile:[%s]:%s", pname, dirMods.getAbsolutePath());
        try {
            if (dirMods.isDirectory()) {
                MMMLib.Debug("getModFile-get:%d.", dirMods.list().length);
                for (File t : dirMods.listFiles()) {
                    if (t.getName().indexOf(pprefix) == -1) continue;
                    if (t.getName().endsWith(".zip") || t.getName().endsWith(".jar")) {
                        llist.add(t);
                        MMMLib.Debug("getModFile-file:%s", t.getName());
                        continue;
                    }
                    if (!t.isDirectory()) continue;
                    llist.add(t);
                    MMMLib.Debug("getModFile-file:%s", t.getName());
                }
                MMMLib.Debug("getModFile-files:%d", llist.size());
            } else {
                MMMLib.Debug("getModFile-fail.", new Object[0]);
            }
            return llist;
        }
        catch (Exception exception) {
            MMMLib.Debug("getModFile-Exception.", new Object[0]);
            return null;
        }
    }

    public static void debugPrintAllFileList() {
        for (String key : fileList.keySet()) {
            List<File> list = fileList.get(key);
            for (File f : list) {
                System.out.println("MMMLib-AllFileList ### " + key + " : " + f.getPath());
            }
        }
    }

    public static List<File> getFileList(String pname) {
        return fileList.get(pname);
    }

    static {
        minecraftDir = "";
        assetsDir = "";
        fileList = new HashMap<String, List<File>>();
        Object[] lo = FMLInjectionData.data();
        dirMinecraft = (File)lo[6];
        minecraftDir = dirMinecraft.getPath();
        dirMods = new File(dirMinecraft, "mods");
        dirModsVersion = new File(dirMods, (String)lo[4]);
        MMMLib.Debug("init FileManager.", new Object[0]);
    }
}

