/*
 * Decompiled with CFR 0.152.
 */
package mmmlibx.lib;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import mmmlibx.lib.FileManager;

public abstract class FileLoaderBase {
    public void execute() {
        List<File> llist = FileManager.getAllmodsFiles(this.getClass().getClassLoader(), true);
        for (File lf : llist) {
            String ls = lf.getName();
            if (this.isZipLoad() && ls.matches("(.+).(zip|jar)$")) {
                this.decodeZip(lf);
            }
            if (lf.isDirectory()) {
                this.decodeDir(lf, lf);
                continue;
            }
            try {
                this.preLoad(lf, ls, new FileInputStream(lf));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void decodeZip(File pFile) {
        try {
            ZipFile lzf = new ZipFile(pFile);
            FileInputStream lfis = new FileInputStream(pFile);
            ZipInputStream lzis = new ZipInputStream(lfis);
            ZipEntry lze = lzis.getNextEntry();
            while (lze != null) {
                if (!lze.isDirectory()) {
                    this.preLoad(pFile, lze.getName(), lzf.getInputStream(lze));
                }
                lze = lzis.getNextEntry();
            }
            lzis.close();
            lfis.close();
            lzf.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void decodeDir(File pBaseDir, File pFile) {
        for (File lf : pFile.listFiles()) {
            if (lf.isDirectory()) {
                this.decodeDir(pBaseDir, lf);
                continue;
            }
            try {
                this.preLoad(lf, lf.getAbsolutePath().substring(pBaseDir.getAbsolutePath().length()), new FileInputStream(lf));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean isZipLoad() {
        return true;
    }

    public boolean load(File pFile, String pFileName, InputStream pInputStream) {
        System.out.println("load# " + pFile.getPath() + " # " + pFileName);
        return false;
    }

    protected boolean preLoad(File pFile, String pFileName, InputStream pInputStream) {
        pFileName = pFileName.replace("\\", "/");
        return this.load(pFile, pFileName, pInputStream);
    }
}

