/*
 * Decompiled with CFR 0.152.
 */
package littleMaidMobX;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import littleMaidMobX.LMM_EnumSound;
import littleMaidMobX.LMM_LittleMaidMobX;
import mmmlibx.lib.FileManager;
import mmmlibx.lib.MMMLib;
import net.minecraft.util.ResourceLocation;

public class LMM_SoundManager {
    private static File soundDir = null;
    private static File soundPackDir = null;
    private static Map<String, InputStream> soundStreamMap = new HashMap<String, InputStream>();
    public static final String SoundConfigName = "littleMaidMob.cfg";
    public static Map<Integer, String> soundsDefault = new HashMap<Integer, String>();
    public static Map<Integer, Map<String, Map<Integer, String>>> soundsTexture = new HashMap<Integer, Map<String, Map<Integer, String>>>();
    public static float soundRateDefault;
    public static Map<String, Map<Integer, Float>> soundRateTexture;

    public static void init() {
        soundDir = new File(FileManager.dirMods, "/littleMaidMobX/");
        if (!LMM_SoundManager.getSoundDir().exists() || !LMM_SoundManager.getSoundDir().isDirectory()) {
            LMM_SoundManager.getSoundDir().mkdirs();
            LMM_LittleMaidMobX.Debug("Create SoundDir: %s", LMM_SoundManager.getSoundDir().toString());
        } else {
            LMM_LittleMaidMobX.Debug("SoundDir: %s", LMM_SoundManager.getSoundDir().toString());
        }
    }

    public static File getSoundDir() {
        return soundDir;
    }

    public static InputStream getSoundJson() {
        try {
            return new FileInputStream(new File(LMM_SoundManager.getSoundDir(), "sounds.json"));
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    public static InputStream getResourceStream(ResourceLocation resource) {
        String path = resource.func_110623_a().toLowerCase();
        if (path.endsWith(".mcmeta")) {
            path = path.substring(0, path.length() - 7);
        }
        if (path.equalsIgnoreCase("sounds.json")) {
            return LMM_SoundManager.getSoundJson();
        }
        String fileName = path;
        int c = fileName.lastIndexOf(47);
        if (c >= 0) {
            fileName = fileName.substring(c + 1);
        }
        if (soundStreamMap.size() > 0 && fileName.endsWith(".ogg")) {
            return soundStreamMap.get(fileName);
        }
        return null;
    }

    public static void setSoundRate(int soundindex, String value, String target) {
        String[] arg = value.split(",");
        target = target == null ? "" : target.trim();
        for (String s : arg) {
            String[] ls;
            Map<Integer, Float> mif;
            if (s.indexOf(59) == -1) {
                float lf;
                float f = lf = (s = s.trim()).isEmpty() ? 1.0f : Float.valueOf(s).floatValue();
                if (target.isEmpty()) {
                    soundRateDefault = lf;
                    continue;
                }
                mif = soundRateTexture.get(target);
                if (mif == null) {
                    mif = new HashMap<Integer, Float>();
                    soundRateTexture.put(target.trim(), mif);
                }
                mif.put(-1, Float.valueOf(lf));
                continue;
            }
            String[] ss = s.trim().split(";");
            if (ss.length < 2) continue;
            if (target.isEmpty()) {
                if (ss.length > 2) {
                    ss[0] = ss[0].trim();
                    ls = new String[]{ss[0].isEmpty() ? ";" : ss[0], ss[1].trim(), ss[2].trim()};
                } else {
                    ls = new String[]{";", ss[0].trim(), ss[1].trim()};
                }
            } else {
                ls = ss.length > 2 ? new String[]{target, ss[1].trim(), ss[2].trim()} : new String[]{target, ss[0].trim(), ss[1].trim()};
            }
            int li = ls[1].isEmpty() ? -1 : Integer.valueOf(ls[1]);
            float lf = ls[2].isEmpty() ? 1.0f : Float.valueOf(ls[2]).floatValue();
            mif = soundRateTexture.get(ls[0]);
            if (mif == null) {
                mif = new HashMap<Integer, Float>();
                soundRateTexture.put(ls[0], mif);
            }
            mif.put(li, Float.valueOf(lf));
        }
    }

    public static float getSoundRate(String texturename, int colorvalue) {
        Map<Integer, Float> mif;
        if (texturename == null || texturename.length() == 0) {
            texturename = ";";
        }
        if ((mif = soundRateTexture.get(texturename)) == null && (mif = soundRateTexture.get(";")) == null) {
            return soundRateDefault;
        }
        Float lf = mif.get(colorvalue);
        if (lf == null && (lf = mif.get(-1)) == null) {
            return soundRateDefault;
        }
        return lf.floatValue();
    }

    public static void setSoundValue(int soundindex, String value, String target) {
        String[] arg;
        for (String s : arg = value.split(",")) {
            String[] ss;
            String tvalue = s.indexOf(59) == -1 ? (target == null || target.isEmpty() ? value : target + ";-1;" + value) : ((ss = s.trim().split(";")).length == 2 ? target + ";" + value : value);
            LMM_SoundManager.setSoundValue(soundindex, tvalue);
        }
    }

    public static void setSoundValue(int soundindex, String value) {
        String[] arg;
        for (String s : arg = value.split(",")) {
            int i;
            Map<Integer, String> mst;
            String[] ss;
            if (s.indexOf(59) == -1) {
                soundsDefault.put(soundindex, s.trim());
                continue;
            }
            Map<String, Map<Integer, String>> msi = soundsTexture.get(soundindex);
            if (msi == null) {
                msi = new HashMap<String, Map<Integer, String>>();
                soundsTexture.put(soundindex, msi);
            }
            if ((ss = s.trim().split(";")).length < 2) continue;
            if (ss[0].length() == 0) {
                ss[0] = ";";
            }
            if ((mst = msi.get(ss[0])) == null) {
                mst = new HashMap<Integer, String>();
                msi.put(ss[0], mst);
            }
            ss[1] = ss[1].trim();
            int n = i = ss[1].length() == 0 ? -1 : Integer.valueOf(ss[1]);
            if (ss.length < 3) {
                mst.put(i, "");
                continue;
            }
            mst.put(i, ss[2].trim());
        }
    }

    public static String getSoundValue(LMM_EnumSound enumsound, String texturename, int colorvalue) {
        Map<Integer, String> mst;
        if (enumsound == LMM_EnumSound.Null) {
            return null;
        }
        Map<String, Map<Integer, String>> msi = soundsTexture.get(enumsound.index);
        if (msi == null) {
            return soundsDefault.get(enumsound.index);
        }
        if (texturename == null || texturename.length() == 0) {
            texturename = ";";
        }
        if ((mst = msi.get(texturename)) == null && (mst = msi.get(";")) == null) {
            return soundsDefault.get(enumsound.index);
        }
        String s = mst.get(colorvalue);
        if (s == null && (s = mst.get(-1)) == null) {
            return soundsDefault.get(enumsound.index);
        }
        return "lmmx:" + s;
    }

    public static void rebuildSoundPack() {
        HashMap<Integer, String> lmap = new HashMap<Integer, String>();
        lmap.putAll(soundsDefault);
        for (Map.Entry<Integer, String> entry : soundsDefault.entrySet()) {
            int li = entry.getKey();
            if (entry.getValue().equals("^")) {
                String ls = (String)lmap.get(li & 0xFFFFFFF0);
                if (ls != null && (li & 0xF) != 0 && !ls.equals("^")) {
                    lmap.put(li, ls);
                    LMM_LittleMaidMobX.Debug(String.format("soundsDefault[%d] = [%d]", li, li & 0xFFFFFFF0), new Object[0]);
                    continue;
                }
                LMM_LittleMaidMobX.Debug(String.format("soundsDefault[%d] removed.", li), new Object[0]);
                continue;
            }
            lmap.put(li, entry.getValue());
        }
        soundsDefault = lmap;
        for (Map.Entry<Integer, Object> entry : soundsTexture.entrySet()) {
            for (Map.Entry msm : ((Map)entry.getValue()).entrySet()) {
                for (Map.Entry mis : ((Map)msm.getValue()).entrySet()) {
                    String ls;
                    Map<Integer, String> lmis;
                    Map<String, Map<Integer, String>> lmsm;
                    if (!((String)mis.getValue()).equals("^")) continue;
                    boolean lf = false;
                    if ((entry.getKey() & 0xF) != 0 && (lmsm = soundsTexture.get(entry.getKey() & 0xFFFFFFF0)) != null && (lmis = lmsm.get(msm.getKey())) != null && (ls = lmis.get(mis.getKey())) != null && !ls.equals("^")) {
                        ((Map)msm.getValue()).put(mis.getKey(), ls);
                        lf = true;
                        LMM_LittleMaidMobX.Debug(String.format("soundsTexture[%d, %s, %d] = [%d]", entry.getKey(), msm.getKey(), mis.getKey(), entry.getKey() & 0xFFFFFFF0), new Object[0]);
                    }
                    if (lf) continue;
                    ((Map)msm.getValue()).remove(mis.getKey());
                    LMM_LittleMaidMobX.Debug(String.format("soundsTexture[%d, %s, %d] removed.", entry.getKey(), msm.getKey(), mis.getKey()), new Object[0]);
                }
            }
        }
    }

    public static void decodeSoundPack(String fileName, Reader reader, boolean iswrite, boolean isdefault) {
        try {
            String str;
            ArrayList<LMM_EnumSound> list1 = new ArrayList<LMM_EnumSound>();
            list1.addAll(Arrays.asList(LMM_EnumSound.values()));
            list1.remove((Object)LMM_EnumSound.Null);
            BufferedReader breader = new BufferedReader(reader);
            boolean loadsoundrate = false;
            String packname = fileName;
            packname = packname.substring(0, packname.lastIndexOf("."));
            while ((str = breader.readLine()) != null) {
                int i;
                if ((str = str.trim()).isEmpty() || str.startsWith("#") || (i = str.indexOf(61)) <= -1) continue;
                String name = str.substring(0, i).trim();
                String value = str.substring(i + 1).trim();
                int index = -1;
                if (name.startsWith("se_")) {
                    int cd = value.lastIndexOf(46);
                    if (cd >= 0) {
                        value = value.substring(cd + 1);
                    }
                    value = value.replaceAll("\\d+$", "");
                    String ss = name.substring(3);
                    try {
                        index = LMM_EnumSound.valueOf((String)ss).index;
                        list1.remove((Object)LMM_EnumSound.valueOf(ss));
                    }
                    catch (Exception exception) {
                        LMM_LittleMaidMobX.Debug(String.format("unknown sound parameter:%s.cfg - %s", packname, ss), new Object[0]);
                    }
                } else if (name.equals("LivingVoiceRate")) {
                    if (isdefault) {
                        LMM_SoundManager.setSoundRate(index, value, null);
                    } else {
                        LMM_SoundManager.setSoundRate(index, value, packname);
                    }
                    loadsoundrate = true;
                }
                if (index <= -1) continue;
                if (isdefault) {
                    LMM_SoundManager.setSoundValue(index, value);
                } else {
                    LMM_SoundManager.setSoundValue(index, value, packname);
                }
                LMM_LittleMaidMobX.Debug(String.format("%s(%d) = %s", name, index, value), new Object[0]);
            }
            breader.close();
            if (iswrite) {
                if (!list1.isEmpty()) {
                    BufferedWriter bwriter = new BufferedWriter(new FileWriter(fileName, true));
                    for (int i = 0; i < list1.size(); ++i) {
                        LMM_SoundManager.writeBuffer(bwriter, (LMM_EnumSound)((Object)list1.get(i)));
                    }
                    bwriter.close();
                }
                if (!loadsoundrate) {
                    BufferedWriter bwriter = new BufferedWriter(new FileWriter(fileName, true));
                    LMM_SoundManager.writeBufferSoundRate(bwriter, 1.0f);
                    bwriter.close();
                }
            }
        }
        catch (Exception exception) {
            LMM_LittleMaidMobX.Debug("decodeSound Exception.", new Object[0]);
        }
    }

    public static void loadSoundPack() {
    }

    public static void loadDefaultSoundPack() {
        try {
            boolean loadCfg = LMM_SoundManager.loadSoundPackCfg();
            if (!loadCfg) {
                File soundCfg = new File(LMM_SoundManager.getSoundDir(), "default_littleMaidMob.cfg");
                soundPackDir = null;
                if (soundCfg.exists() && soundCfg.isFile()) {
                    LMM_LittleMaidMobX.Debug(soundCfg.getName(), new Object[0]);
                    FileReader reader = new FileReader(soundCfg);
                    LMM_SoundManager.decodeSoundPack(soundCfg.getName(), reader, true, true);
                    ((Reader)reader).close();
                } else {
                    LMM_LittleMaidMobX.Debug("no Default Sound cfg.", new Object[0]);
                    LMM_SoundManager.createDefaultSoundPack(soundCfg);
                }
            }
        }
        catch (Exception e) {
            LMM_LittleMaidMobX.Debug("Error: Create Sound cfg failed.", new Object[0]);
            e.printStackTrace();
        }
        LMM_SoundManager.rebuildSoundPack();
    }

    public static boolean loadSoundPackCfg() throws IOException {
        for (File file : FileManager.dirMods.listFiles()) {
            if (file.isDirectory()) {
                if (!LMM_SoundManager.searchSoundCfgDir(file)) continue;
                soundPackDir = file;
                LMM_SoundManager.putAllSoundStream(file);
                LMM_SoundManager.createSoundJson(file);
                return true;
            }
            if (!file.getName().toLowerCase().endsWith(".zip") || !LMM_SoundManager.searchSoundCfgZip(file)) continue;
            soundPackDir = file;
            LMM_SoundManager.createSoundJson(file);
            return true;
        }
        return false;
    }

    public static void putAllSoundStream(File dir) throws IOException {
        for (File file : dir.listFiles()) {
            String name = file.getName().toLowerCase();
            if (file.isDirectory()) {
                LMM_SoundManager.putAllSoundStream(file);
                continue;
            }
            if (!name.endsWith(".ogg")) continue;
            soundStreamMap.put(name, new FileInputStream(file));
        }
    }

    public static boolean searchSoundCfgDir(File dir) throws IOException {
        for (File file : dir.listFiles()) {
            if (file.isDirectory()) {
                if (!LMM_SoundManager.searchSoundCfgDir(file)) continue;
                return true;
            }
            if (!file.getName().equalsIgnoreCase(SoundConfigName)) continue;
            FileReader reader = new FileReader(file);
            LMM_SoundManager.decodeSoundPack(file.getName(), reader, false, true);
            ((Reader)reader).close();
            return true;
        }
        return false;
    }

    public static boolean searchSoundCfgZip(File file) {
        boolean foundCfg = false;
        try {
            int c;
            String name;
            ZipEntry zipentry;
            FileInputStream fileinputstream = new FileInputStream(file);
            ZipInputStream zipinputstream = new ZipInputStream(fileinputstream);
            while ((zipentry = zipinputstream.getNextEntry()) != null) {
                if (zipentry.isDirectory()) continue;
                name = zipentry.getName();
                c = name.lastIndexOf("/");
                if (c >= 0) {
                    name = name.substring(c + 1);
                }
                name = name.toLowerCase();
                if (foundCfg || !name.equalsIgnoreCase(SoundConfigName)) continue;
                ZipFile zipFile = new ZipFile(file);
                InputStream inputStream = zipFile.getInputStream(zipentry);
                InputStreamReader reader = new InputStreamReader(inputStream);
                LMM_SoundManager.decodeSoundPack(name, reader, false, true);
                ((Reader)reader).close();
                inputStream.close();
                zipFile.close();
                foundCfg = true;
                break;
            }
            zipinputstream.close();
            fileinputstream.close();
            if (foundCfg) {
                fileinputstream = new FileInputStream(file);
                zipinputstream = new ZipInputStream(fileinputstream);
                while ((zipentry = zipinputstream.getNextEntry()) != null) {
                    if (zipentry.isDirectory()) continue;
                    name = zipentry.getName();
                    c = name.lastIndexOf("/");
                    if (c >= 0) {
                        name = name.substring(c + 1);
                    }
                    if (!(name = name.toLowerCase()).endsWith(".ogg")) continue;
                    soundStreamMap.put(name, new ZipFile(file).getInputStream(zipentry));
                }
                zipinputstream.close();
                fileinputstream.close();
            }
        }
        catch (Exception exception) {
            MMMLib.Debug("Load Sound pack Zip-Exception.", new Object[0]);
        }
        return foundCfg;
    }

    public static boolean createDefaultSoundPack(File file1) {
        for (LMM_EnumSound eslm : LMM_EnumSound.values()) {
            if (eslm == LMM_EnumSound.Null) continue;
            LMM_SoundManager.setSoundValue(eslm.index, eslm.DefaultValue);
        }
        if (file1.exists()) {
            return false;
        }
        try {
            if (file1.createNewFile()) {
                BufferedWriter bwriter = new BufferedWriter(new FileWriter(file1));
                for (LMM_EnumSound eslm : LMM_EnumSound.values()) {
                    LMM_SoundManager.writeBuffer(bwriter, eslm);
                }
                LMM_SoundManager.writeBufferSoundRate(bwriter, 1.0f);
                bwriter.close();
                LMM_LittleMaidMobX.Debug("Success create Default Sound cfg.", new Object[0]);
            }
        }
        catch (IOException e) {
            LMM_LittleMaidMobX.Debug("Failed create Default Sound cfg(%s).", file1.getAbsolutePath());
            e.printStackTrace();
            return false;
        }
        return true;
    }

    protected static void writeBuffer(BufferedWriter buffer, LMM_EnumSound enumsound) throws IOException {
        if (enumsound == LMM_EnumSound.Null) {
            return;
        }
        buffer.write("# ");
        buffer.write(enumsound.info);
        buffer.newLine();
        buffer.write("se_");
        buffer.write(enumsound.name());
        buffer.write("=");
        buffer.write(enumsound.DefaultValue);
        buffer.newLine();
        buffer.newLine();
    }

    protected static void writeBufferSoundRate(BufferedWriter buffer, float prate) throws IOException {
        buffer.write("# Living Voice Rate. 1.0=100%, 0.5=50%, 0.0=0%");
        buffer.newLine();
        buffer.write("LivingVoiceRate=" + prate);
        buffer.newLine();
        buffer.newLine();
    }

    public static void createSoundJson(File dir) {
        if (!LMM_SoundManager.getSoundDir().exists() || !LMM_SoundManager.getSoundDir().isDirectory()) {
            return;
        }
        File file1 = new File(LMM_SoundManager.getSoundDir(), "sounds.json");
        try {
            BufferedWriter bwriter = new BufferedWriter(new FileWriter(file1));
            String str = LMM_SoundManager.searchSoundAndWriteFile("", dir, "");
            bwriter.write("{\n" + str + "\n}\n");
            bwriter.newLine();
            bwriter.close();
            LMM_LittleMaidMobX.Debug("Success create Sounds.json(%s).", file1.getAbsolutePath());
        }
        catch (IOException e) {
            LMM_LittleMaidMobX.Debug("Failed create Sounds.json(%s).", file1.getAbsolutePath());
            e.printStackTrace();
        }
    }

    private static String searchSoundAndWriteFile(String string, File dir, String string2) throws IOException {
        if (dir.isDirectory()) {
            return LMM_SoundManager.searchSoundAndWriteFileDir(string, dir, string2);
        }
        return LMM_SoundManager.searchSoundAndWriteFileZip(string, dir);
    }

    public static String searchSoundAndWriteFileDir(String output, File dir, String path) throws IOException {
        for (File file : dir.listFiles()) {
            if (!file.isDirectory()) continue;
            output = output + LMM_SoundManager.searchSoundAndWriteFileDir(output, file, path + file.getName() + ".");
        }
        LinkedHashMap map = new LinkedHashMap();
        for (File file : dir.listFiles()) {
            if (!file.isFile() || !file.getName().endsWith(".ogg")) continue;
            String fileName = file.getName().substring(0, file.getName().length() - 4);
            String soundName = fileName.replaceAll("\\d+$", "");
            String name = fileName.replace(".", "/");
            if (!map.containsKey(soundName)) {
                map.put(soundName, new ArrayList());
            }
            ((List)map.get(soundName)).add(name);
        }
        for (String key : map.keySet()) {
            String s = "";
            for (String name : (List)map.get(key)) {
                s = s.isEmpty() ? "\"" + key + "\":{\"category\":\"master\",\"sounds\":[" : s + ",";
                s = s + "\"" + name + "\"";
            }
            s = s + "]}";
            if (!output.isEmpty()) {
                output = output + ",\n";
            }
            output = output + s;
        }
        return output;
    }

    public static String searchSoundAndWriteFileZip(String output, File dir) throws IOException {
        LinkedHashMap map = new LinkedHashMap();
        try {
            ZipEntry zipentry;
            FileInputStream fileinputstream = new FileInputStream(dir);
            ZipInputStream zipinputstream = new ZipInputStream(fileinputstream);
            while ((zipentry = zipinputstream.getNextEntry()) != null) {
                String fileNameInZip = zipentry.getName();
                if (zipentry.isDirectory() || !fileNameInZip.endsWith(".ogg")) continue;
                String fileName = fileNameInZip.substring(0, fileNameInZip.length() - 4);
                int c = fileName.lastIndexOf(47);
                if (c >= 0) {
                    fileName = fileName.substring(c + 1);
                }
                String soundName = fileName.replaceAll("\\d+$", "");
                String name = fileName.replace(".", "/");
                if (!map.containsKey(soundName)) {
                    map.put(soundName, new ArrayList());
                }
                ((List)map.get(soundName)).add(name);
            }
            zipinputstream.close();
            fileinputstream.close();
            for (String key : map.keySet()) {
                String s = "";
                for (String name : (List)map.get(key)) {
                    s = s.isEmpty() ? "\"" + key + "\":{\"category\":\"master\",\"sounds\":[" : s + ",";
                    s = s + "\"" + name + "\"";
                }
                s = s + "]}";
                if (!output.isEmpty()) {
                    output = output + ",\n";
                }
                output = output + s;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return output;
    }

    static {
        soundRateTexture = new HashMap<String, Map<Integer, Float>>();
    }
}

