/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.render;

import com.yogpc.qp.QuarryPlusI;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;

public class RenderMarker
implements ISimpleBlockRenderingHandler {
    private static final double[][][] frontX = new double[6][3][4];
    private static final double[][][] frontZ = new double[6][3][4];
    private static final double[][][] frontY = new double[6][3][4];
    private static final int[] metaToOld = new int[6];
    public static final RenderMarker INSTANCE = new RenderMarker();

    private RenderMarker() {
        RenderMarker.metaToOld[0] = 0;
        RenderMarker.metaToOld[1] = 5;
        RenderMarker.metaToOld[2] = 4;
        RenderMarker.metaToOld[3] = 3;
        RenderMarker.metaToOld[4] = 2;
        RenderMarker.metaToOld[5] = 1;
        double[][] frontXBase = new double[][]{{-0.0625, -0.0625, -0.0625, -0.0625}, {1.0, 0.0, 0.0, 1.0}, {-0.5, -0.5, 0.5, 0.5}};
        RenderMarker.frontX[3] = RenderMarker.safeClone(frontXBase);
        RenderMarker.rotateFace(frontX[3]);
        RenderMarker.rotateFace(frontX[3]);
        RenderMarker.rotateFace(frontX[3]);
        RenderMarker.frontX[4] = RenderMarker.safeClone(frontXBase);
        RenderMarker.rotateFace(frontX[4]);
        RenderMarker.frontX[5] = RenderMarker.safeClone(frontXBase);
        RenderMarker.frontX[0] = RenderMarker.safeClone(frontXBase);
        RenderMarker.rotateFace(frontX[0]);
        RenderMarker.rotateFace(frontX[0]);
        double[][] frontZBase = new double[][]{{-0.5, -0.5, 0.5, 0.5}, {1.0, 0.0, 0.0, 1.0}, {0.0625, 0.0625, 0.0625, 0.0625}};
        RenderMarker.frontZ[5] = RenderMarker.safeClone(frontZBase);
        RenderMarker.frontZ[1] = RenderMarker.safeClone(frontZBase);
        RenderMarker.rotateFace(frontZ[1]);
        RenderMarker.rotateFace(frontZ[1]);
        RenderMarker.rotateFace(frontZ[1]);
        RenderMarker.frontZ[2] = RenderMarker.safeClone(frontZBase);
        RenderMarker.rotateFace(frontZ[2]);
        RenderMarker.frontZ[0] = RenderMarker.safeClone(frontZBase);
        RenderMarker.rotateFace(frontZ[0]);
        RenderMarker.rotateFace(frontZ[0]);
        double[][] frontYBase = new double[][]{{-0.5, -0.5, 0.5, 0.5}, {-0.0625, -0.0625, -0.0625, -0.0625}, {0.5, -0.5, -0.5, 0.5}};
        RenderMarker.frontY[4] = RenderMarker.safeClone(frontYBase);
        RenderMarker.rotateFace(frontY[4]);
        RenderMarker.rotateFace(frontY[4]);
        RenderMarker.frontY[3] = RenderMarker.safeClone(frontYBase);
        RenderMarker.frontY[2] = RenderMarker.safeClone(frontYBase);
        RenderMarker.rotateFace(frontY[2]);
        RenderMarker.frontY[1] = RenderMarker.safeClone(frontYBase);
        RenderMarker.rotateFace(frontY[1]);
        RenderMarker.rotateFace(frontY[1]);
        RenderMarker.rotateFace(frontY[1]);
    }

    private static double[][] safeClone(double[][] d) {
        double[][] ret = new double[d.length][d[0].length];
        for (int i = 0; i < d.length; ++i) {
            for (int j = 0; j < d[0].length; ++j) {
                ret[i][j] = d[i][j];
            }
        }
        return ret;
    }

    private static void rotateFace(double[][] face) {
        for (int j = 0; j < 3; ++j) {
            double tmp = face[j][0];
            face[j][0] = face[j][1];
            face[j][1] = face[j][2];
            face[j][2] = face[j][3];
            face[j][3] = tmp;
        }
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return false;
    }

    public int getRenderId() {
        return QuarryPlusI.markerRenderID;
    }

    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        Tessellator tessellator = Tessellator.field_78398_a;
        float f = block.func_149677_c(world, x, y, z);
        if (block.getLightValue(world, x, y, z) > 0) {
            f = 1.0f;
        }
        tessellator.func_78386_a(f, f, f);
        RenderMarker.renderMarkerWithMeta(world, block, x, y, z, world.func_72805_g(x, y, z));
        return true;
    }

    private static void renderMarkerWithMeta(IBlockAccess iblockaccess, Block block, double xi, double yi, double zi, int meta) {
        Tessellator tessellator = Tessellator.field_78398_a;
        int metadata = meta;
        if (metadata > 5 || metadata < 0) {
            metadata = 1;
        }
        double x = xi;
        double y = yi;
        double z = zi;
        int xCoord = (int)x;
        int yCoord = (int)y;
        int zCoord = (int)z;
        IIcon i = block.func_149673_e(iblockaccess, xCoord, yCoord, zCoord, 1);
        int m = metaToOld[metadata];
        x += 0.5;
        z += 0.5;
        double minU = i.func_94214_a(7.0);
        double minV = i.func_94207_b(7.0);
        double maxU = i.func_94214_a(9.0);
        double maxV = i.func_94207_b(9.0);
        tessellator.func_78380_c(block.func_149677_c(iblockaccess, xCoord, yCoord, zCoord));
        double s = 0.0625;
        if (m == 5) {
            tessellator.func_78374_a(x - 0.0625, y + 0.5 + 0.0625, z - 0.0625, minU, minV);
            tessellator.func_78374_a(x - 0.0625, y + 0.5 + 0.0625, z + 0.0625, minU, maxV);
            tessellator.func_78374_a(x + 0.0625, y + 0.5 + 0.0625, z + 0.0625, maxU, maxV);
            tessellator.func_78374_a(x + 0.0625, y + 0.5 + 0.0625, z - 0.0625, maxU, minV);
        } else if (m == 0) {
            tessellator.func_78374_a(x + 0.0625, y + 0.5 - 0.0625, z - 0.0625, maxU, minV);
            tessellator.func_78374_a(x + 0.0625, y + 0.5 - 0.0625, z + 0.0625, maxU, maxV);
            tessellator.func_78374_a(x - 0.0625, y + 0.5 - 0.0625, z + 0.0625, minU, maxV);
            tessellator.func_78374_a(x - 0.0625, y + 0.5 - 0.0625, z - 0.0625, minU, minV);
        } else if (m == 2) {
            tessellator.func_78374_a(x - 0.0625, y + 0.5 - 0.0625, z - 0.0625, minU, minV);
            tessellator.func_78374_a(x - 0.0625, y + 0.5 - 0.0625, z + 0.0625, minU, maxV);
            tessellator.func_78374_a(x - 0.0625, y + 0.5 + 0.0625, z + 0.0625, maxU, maxV);
            tessellator.func_78374_a(x - 0.0625, y + 0.5 + 0.0625, z - 0.0625, maxU, minV);
        } else if (m == 1) {
            tessellator.func_78374_a(x + 0.0625, y + 0.5 + 0.0625, z - 0.0625, maxU, minV);
            tessellator.func_78374_a(x + 0.0625, y + 0.5 + 0.0625, z + 0.0625, maxU, maxV);
            tessellator.func_78374_a(x + 0.0625, y + 0.5 - 0.0625, z + 0.0625, minU, maxV);
            tessellator.func_78374_a(x + 0.0625, y + 0.5 - 0.0625, z - 0.0625, minU, minV);
        } else if (m == 3) {
            tessellator.func_78374_a(x - 0.0625, y + 0.5 - 0.0625, z + 0.0625, minU, minV);
            tessellator.func_78374_a(x + 0.0625, y + 0.5 - 0.0625, z + 0.0625, minU, maxV);
            tessellator.func_78374_a(x + 0.0625, y + 0.5 + 0.0625, z + 0.0625, maxU, maxV);
            tessellator.func_78374_a(x - 0.0625, y + 0.5 + 0.0625, z + 0.0625, maxU, minV);
        } else if (m == 4) {
            tessellator.func_78374_a(x - 0.0625, y + 0.5 + 0.0625, z - 0.0625, maxU, minV);
            tessellator.func_78374_a(x + 0.0625, y + 0.5 + 0.0625, z - 0.0625, maxU, maxV);
            tessellator.func_78374_a(x + 0.0625, y + 0.5 - 0.0625, z - 0.0625, minU, maxV);
            tessellator.func_78374_a(x - 0.0625, y + 0.5 - 0.0625, z - 0.0625, minU, minV);
        }
        i = block.func_149673_e(iblockaccess, xCoord, yCoord, zCoord, 0);
        minU = i.func_94209_e();
        maxU = i.func_94212_f();
        minV = i.func_94206_g();
        maxV = i.func_94210_h();
        if (m == 5 || m == 4 || m == 3 || m == 0) {
            tessellator.func_78374_a(x + frontX[m][0][0], y + frontX[m][1][0], z + frontX[m][2][0], minU, minV);
            tessellator.func_78374_a(x + frontX[m][0][1], y + frontX[m][1][1], z + frontX[m][2][1], minU, maxV);
            tessellator.func_78374_a(x + frontX[m][0][2], y + frontX[m][1][2], z + frontX[m][2][2], maxU, maxV);
            tessellator.func_78374_a(x + frontX[m][0][3], y + frontX[m][1][3], z + frontX[m][2][3], maxU, minV);
            tessellator.func_78374_a(x - frontX[m][0][3], y + frontX[m][1][3], z + frontX[m][2][3], maxU, minV);
            tessellator.func_78374_a(x - frontX[m][0][2], y + frontX[m][1][2], z + frontX[m][2][2], maxU, maxV);
            tessellator.func_78374_a(x - frontX[m][0][1], y + frontX[m][1][1], z + frontX[m][2][1], minU, maxV);
            tessellator.func_78374_a(x - frontX[m][0][0], y + frontX[m][1][0], z + frontX[m][2][0], minU, minV);
        }
        if (m == 5 || m == 2 || m == 1 || m == 0) {
            tessellator.func_78374_a(x + frontZ[m][0][0], y + frontZ[m][1][0], z + frontZ[m][2][0], minU, minV);
            tessellator.func_78374_a(x + frontZ[m][0][1], y + frontZ[m][1][1], z + frontZ[m][2][1], minU, maxV);
            tessellator.func_78374_a(x + frontZ[m][0][2], y + frontZ[m][1][2], z + frontZ[m][2][2], maxU, maxV);
            tessellator.func_78374_a(x + frontZ[m][0][3], y + frontZ[m][1][3], z + frontZ[m][2][3], maxU, minV);
            tessellator.func_78374_a(x + frontZ[m][0][3], y + frontZ[m][1][3], z - frontZ[m][2][3], maxU, minV);
            tessellator.func_78374_a(x + frontZ[m][0][2], y + frontZ[m][1][2], z - frontZ[m][2][2], maxU, maxV);
            tessellator.func_78374_a(x + frontZ[m][0][1], y + frontZ[m][1][1], z - frontZ[m][2][1], minU, maxV);
            tessellator.func_78374_a(x + frontZ[m][0][0], y + frontZ[m][1][0], z - frontZ[m][2][0], minU, minV);
        }
        if (m == 4 || m == 3 || m == 2 || m == 1) {
            tessellator.func_78374_a(x + frontY[m][0][0], y + 0.5 + frontY[m][1][0], z + frontY[m][2][0], minU, minV);
            tessellator.func_78374_a(x + frontY[m][0][1], y + 0.5 + frontY[m][1][1], z + frontY[m][2][1], minU, maxV);
            tessellator.func_78374_a(x + frontY[m][0][2], y + 0.5 + frontY[m][1][2], z + frontY[m][2][2], maxU, maxV);
            tessellator.func_78374_a(x + frontY[m][0][3], y + 0.5 + frontY[m][1][3], z + frontY[m][2][3], maxU, minV);
            tessellator.func_78374_a(x + frontY[m][0][3], y + 0.5 - frontY[m][1][3], z + frontY[m][2][3], maxU, minV);
            tessellator.func_78374_a(x + frontY[m][0][2], y + 0.5 - frontY[m][1][2], z + frontY[m][2][2], maxU, maxV);
            tessellator.func_78374_a(x + frontY[m][0][1], y + 0.5 - frontY[m][1][1], z + frontY[m][2][1], minU, maxV);
            tessellator.func_78374_a(x + frontY[m][0][0], y + 0.5 - frontY[m][1][0], z + frontY[m][2][0], minU, minV);
        }
    }
}

