/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.compat;

import buildcraft.api.recipes.BuildcraftRecipeRegistry;
import buildcraft.api.recipes.CraftingResult;
import buildcraft.api.recipes.IFlexibleCrafter;
import buildcraft.api.recipes.IFlexibleRecipe;
import buildcraft.api.recipes.IRefineryRecipeManager;
import com.yogpc.qp.tile.TileRefinery;
import cpw.mods.fml.common.ModAPIManager;
import cpw.mods.fml.common.Optional;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

@Optional.Interface(iface="buildcraft.api.recipes.IFlexibleCrafter", modid="BuildCraftAPI|recipes")
public class RefineryRecipeHelper
implements IFlexibleCrafter {
    private final TileRefinery tile;

    private RefineryRecipeHelper(TileRefinery tr) {
        this.tile = tr;
    }

    public int getCraftingItemStackSize() {
        return 0;
    }

    public ItemStack getCraftingItemStack(int slotid) {
        return null;
    }

    public ItemStack decrCraftingItemStack(int slotid, int val) {
        return null;
    }

    public ItemStack decrCraftingItemgStack(int slotid, int val) {
        return null;
    }

    public FluidStack getCraftingFluidStack(int id) {
        return this.tile.src[id];
    }

    public FluidStack decrCraftingFluidStack(int id, int val) {
        FluidStack ret = this.tile.src[id];
        if (ret == null) {
            return null;
        }
        if (val >= ret.amount) {
            this.tile.src[id] = null;
            return ret;
        }
        this.tile.src[id] = ret.copy();
        this.tile.src[id].amount -= val;
        ret.amount = val;
        return ret;
    }

    public int getCraftingFluidStackSize() {
        return this.tile.src.length;
    }

    public static void get(TileRefinery tr) {
        if (!ModAPIManager.INSTANCE.hasAPI("BuildCraftAPI|recipes") || tr.cached != null) {
            return;
        }
        IRefineryRecipeManager irrm = BuildcraftRecipeRegistry.refinery;
        if (irrm == null) {
            return;
        }
        for (IFlexibleRecipe ifr : irrm.getRecipes()) {
            CraftingResult cr = ifr.craft((IFlexibleCrafter)new RefineryRecipeHelper(tr), true);
            if (cr == null || !RefineryRecipeHelper.check((FluidStack)cr.crafted, tr)) continue;
            ifr.craft((IFlexibleCrafter)new RefineryRecipeHelper(tr), false);
            tr.rem_energy = (double)cr.energyCost / 10.0;
            tr.rem_time = cr.craftingTime;
            tr.cached = ((FluidStack)cr.crafted).copy();
            RefineryRecipeHelper.get(tr);
            return;
        }
        tr.rem_energy = 0.0;
        tr.rem_time = 0L;
        tr.cached = null;
    }

    private static boolean check(FluidStack fs, TileRefinery tr) {
        Byte i = tr.get().get(Enchantment.field_77349_p.field_77352_x);
        return tr.res == null || tr.res.isFluidEqual(fs) && tr.buf - tr.res.amount >= fs.amount * (i == null ? 0 : i + 1);
    }
}

