/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.block;

import com.yogpc.qp.EnchantmentHelper;
import com.yogpc.qp.QuarryPlusI;
import com.yogpc.qp.block.ADismCBlock;
import com.yogpc.qp.compat.BuildCraftHelper;
import com.yogpc.qp.item.ItemTool;
import com.yogpc.qp.tile.IEnchantableTile;
import com.yogpc.qp.tile.TileBasic;
import com.yogpc.qp.tile.TileMiningWell;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockMiningWell
extends ADismCBlock {
    IIcon textureFront;
    IIcon textureBack;
    IIcon textureTop;
    IIcon texW;
    private final ArrayList<ItemStack> drop = new ArrayList();

    public BlockMiningWell() {
        super(Material.field_151578_c);
        this.func_149711_c(1.5f);
        this.func_149752_b(10.0f);
        this.func_149647_a(QuarryPlusI.ct);
        this.func_149672_a(field_149769_e);
        this.func_149663_c("MiningWellPlus");
    }

    public TileEntity func_149915_a(World w, int m) {
        return new TileMiningWell();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister par1IconRegister) {
        this.textureFront = par1IconRegister.func_94245_a("yogpstop_qp:miningwell_front");
        this.field_149761_L = par1IconRegister.func_94245_a("yogpstop_qp:miningwell");
        this.textureBack = par1IconRegister.func_94245_a("yogpstop_qp:miningwell_back");
        this.textureTop = par1IconRegister.func_94245_a("yogpstop_qp:miningwell_top");
        this.texW = par1IconRegister.func_94245_a("yogpstop_qp:miningwell_top_w");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess ba, int x, int y, int z, int side) {
        TileEntity tile = ba.func_147438_o(x, y, z);
        if (tile instanceof TileMiningWell && side == 1 && ((TileMiningWell)tile).working) {
            return this.texW;
        }
        return super.func_149673_e(ba, x, y, z, side);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int i, int j) {
        if (j == 0 && i == 3) {
            return this.textureFront;
        }
        if (i == 1) {
            return this.textureTop;
        }
        if (i == 0) {
            return this.textureBack;
        }
        if (i == j) {
            return this.textureFront;
        }
        if (j >= 0 && j < 6 && ForgeDirection.values()[j].getOpposite().ordinal() == i) {
            return this.textureBack;
        }
        return this.field_149761_L;
    }

    public void func_149689_a(World w, int x, int y, int z, EntityLivingBase el, ItemStack is) {
        super.func_149689_a(w, x, y, z, el, is);
        ForgeDirection orientation = BlockMiningWell.get2dOrientation(el.field_70165_t, el.field_70161_v, x, z);
        w.func_72921_c(x, y, z, orientation.getOpposite().ordinal(), 1);
        EnchantmentHelper.init((IEnchantableTile)w.func_147438_o(x, y, z), is.func_77986_q());
    }

    private static ForgeDirection get2dOrientation(double x1, double z1, double x2, double z2) {
        double Dz = z1 - z2;
        double Dx = x1 - x2;
        double angle = Math.atan2(Dz, Dx) / Math.PI * 180.0 + 180.0;
        if (angle < 45.0 || angle > 315.0) {
            return ForgeDirection.EAST;
        }
        if (angle < 135.0) {
            return ForgeDirection.SOUTH;
        }
        if (angle < 225.0) {
            return ForgeDirection.WEST;
        }
        return ForgeDirection.NORTH;
    }

    public void func_149749_a(World world, int x, int y, int z, Block b, int meta) {
        this.drop.clear();
        TileMiningWell tile = (TileMiningWell)world.func_147438_o(x, y, z);
        if (world.field_72995_K || tile == null) {
            return;
        }
        int count = this.quantityDropped(meta, 0, world.field_73012_v);
        Item it = this.func_149650_a(meta, world.field_73012_v, 0);
        if (it != null) {
            for (int i = 0; i < count; ++i) {
                ItemStack is = new ItemStack(it, 1, this.func_149692_a(meta));
                EnchantmentHelper.enchantmentToIS(tile, is);
                this.drop.add(is);
            }
        }
        super.func_149749_a(world, x, y, z, b, meta);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        return this.drop;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer ep, int side, float par7, float par8, float par9) {
        Item equipped;
        Item item = equipped = ep.func_71045_bC() != null ? ep.func_71045_bC().func_77973_b() : null;
        if (BuildCraftHelper.isWrench(equipped, ep, x, y, z)) {
            ((TileMiningWell)world.func_147438_o(x, y, z)).G_reinit();
            return true;
        }
        if (equipped instanceof ItemTool && ep.func_71045_bC().func_77960_j() == 0) {
            if (!world.field_72995_K) {
                for (IChatComponent s : EnchantmentHelper.getEnchantmentsChat((IEnchantableTile)world.func_147438_o(x, y, z))) {
                    ep.func_145747_a(s);
                }
            }
            return true;
        }
        return false;
    }

    public void func_149695_a(World world, int x, int y, int z, Block b) {
        if (!world.field_72995_K) {
            ((TileBasic)world.func_147438_o(x, y, z)).G_renew_powerConfigure();
        }
    }
}

