/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.tiles;

import moze_intel.projecte.gameObjs.tiles.CondenserTile;
import moze_intel.projecte.utils.EMCHelper;
import net.minecraft.item.ItemStack;

public class CondenserMK2Tile
extends CondenserTile {
    private static final int LOCK_SLOT = 0;
    private static final int INPUT_SLOTS_LOWER = 1;
    private static final int INPUT_SLOTS_UPPER = 42;
    private static final int OUTPUT_SLOTS_LOWER = 43;
    private static final int OUTPUT_SLOTS_UPPER = 84;

    public CondenserMK2Tile() {
        this.inventory = new ItemStack[85];
        this.loadChecks = false;
    }

    @Override
    protected void condense() {
        while (this.hasSpace() && this.getStoredEmc() >= (double)this.requiredEmc) {
            this.pushStack();
            this.removeEMC(this.requiredEmc);
        }
        if (this.hasSpace()) {
            for (int i = 1; i <= 42; ++i) {
                ItemStack stack = this.inventory[i];
                if (stack == null) continue;
                this.addEMC(EMCHelper.getEmcValue(stack) * stack.field_77994_a);
                this.inventory[i] = null;
                break;
            }
        }
    }

    @Override
    protected boolean hasSpace() {
        for (int i = 43; i <= 84; ++i) {
            ItemStack stack = this.inventory[i];
            if (stack == null) {
                return true;
            }
            if (!this.isStackEqualToLock(stack) || stack.field_77994_a >= stack.func_77976_d()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected int getSlotForStack() {
        for (int i = 43; i <= 84; ++i) {
            ItemStack stack = this.inventory[i];
            if (stack == null) {
                return i;
            }
            if (!this.isStackEqualToLock(stack) || stack.field_77994_a >= stack.func_77976_d()) continue;
            return i;
        }
        return 0;
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        if (slot == 0 || slot >= 43) {
            return false;
        }
        return !this.isStackEqualToLock(stack) && EMCHelper.doesItemHaveEmc(stack);
    }

    @Override
    public String func_145825_b() {
        return "tile.pe_condenser_mk2.name";
    }
}

