/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.tiles;

import cpw.mods.fml.common.network.NetworkRegistry;
import java.util.Map;
import moze_intel.projecte.api.item.IItemEmc;
import moze_intel.projecte.api.tile.IEmcProvider;
import moze_intel.projecte.emc.FuelMapper;
import moze_intel.projecte.gameObjs.items.ItemPE;
import moze_intel.projecte.gameObjs.tiles.RelayMK1Tile;
import moze_intel.projecte.gameObjs.tiles.RelayMK2Tile;
import moze_intel.projecte.gameObjs.tiles.RelayMK3Tile;
import moze_intel.projecte.gameObjs.tiles.TileEmc;
import moze_intel.projecte.network.PacketHandler;
import moze_intel.projecte.network.packets.CollectorSyncPKT;
import moze_intel.projecte.utils.EMCHelper;
import moze_intel.projecte.utils.ItemHelper;
import moze_intel.projecte.utils.WorldHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class CollectorMK1Tile
extends TileEmc
implements IInventory,
ISidedInventory,
IEmcProvider {
    private ItemStack[] inventory;
    private int[] accessibleSlots;
    private final int invBufferSize;
    private final int emcGen;
    private final int lockSlot;
    private final int upgradedSlot;
    private boolean hasChargeableItem;
    private boolean hasFuel;
    public double storedFuelEmc;
    public int displayEmc;
    public int displaySunLevel;
    public double displayItemCharge;
    private int numUsing;

    public CollectorMK1Tile() {
        super(10000);
        this.inventory = new ItemStack[11];
        this.invBufferSize = 8;
        this.accessibleSlots = new int[this.invBufferSize];
        for (int i = 0; i < this.invBufferSize; ++i) {
            this.accessibleSlots[i] = i + 1;
        }
        this.emcGen = 4;
        this.upgradedSlot = 9;
        this.lockSlot = 10;
    }

    public CollectorMK1Tile(int maxEmc, int emcGen, int upgradedSlot, int lockSlot) {
        super(maxEmc);
        this.inventory = new ItemStack[lockSlot + 1];
        this.invBufferSize = lockSlot - 2;
        this.accessibleSlots = new int[this.invBufferSize];
        for (int i = 0; i < this.invBufferSize; ++i) {
            this.accessibleSlots[i] = i + 1;
        }
        this.emcGen = emcGen;
        this.upgradedSlot = upgradedSlot;
        this.lockSlot = lockSlot;
    }

    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.sortInventory();
        if (this.inventory[0] == null) {
            this.hasChargeableItem = false;
            this.hasFuel = false;
        } else {
            this.checkFuelOrKlein();
        }
        if (!this.hasMaxedEmc()) {
            this.addEMC(this.getSunRelativeEmc(this.emcGen) / 20.0f);
        }
        this.updateEmc();
        this.displayEmc = (int)this.getStoredEmc();
        this.displaySunLevel = this.getSunLevel();
        this.displayItemCharge = this.getItemCharge();
        if (this.numUsing > 0) {
            PacketHandler.sendToAllAround(new CollectorSyncPKT(this.displayEmc, this.displayItemCharge, this.field_145851_c, this.field_145848_d, this.field_145849_e), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 8.0));
        }
    }

    private void sortInventory() {
        int i;
        if (this.inventory[this.upgradedSlot] != null && (this.inventory[this.lockSlot] == null || this.inventory[this.upgradedSlot].func_77973_b() != this.inventory[this.lockSlot].func_77973_b() || this.inventory[this.upgradedSlot].field_77994_a >= this.inventory[this.upgradedSlot].func_77976_d())) {
            for (i = 1; i < this.invBufferSize; ++i) {
                if (this.inventory[i] == null) {
                    this.inventory[i] = this.inventory[this.upgradedSlot];
                    this.inventory[this.upgradedSlot] = null;
                    break;
                }
                if (!ItemHelper.areItemStacksEqual(this.inventory[i], this.inventory[this.upgradedSlot])) continue;
                int remain = this.inventory[i].func_77976_d() - this.inventory[i].field_77994_a;
                if (remain >= this.inventory[this.upgradedSlot].field_77994_a) {
                    this.inventory[i].field_77994_a += this.inventory[this.upgradedSlot].field_77994_a;
                    this.inventory[this.upgradedSlot] = null;
                    break;
                }
                this.inventory[i].field_77994_a += remain;
                this.inventory[this.upgradedSlot].field_77994_a -= remain;
            }
        }
        for (i = 1; i <= this.invBufferSize; ++i) {
            ItemStack current = this.func_70301_a(i);
            if (current == null) continue;
            int nextIndex = i < this.invBufferSize ? i + 1 : 0;
            ItemStack following = this.inventory[nextIndex];
            if (following == null) {
                this.inventory[nextIndex] = current;
                this.func_70298_a(i, current.field_77994_a);
                continue;
            }
            if (!ItemHelper.areItemStacksEqual(current, following) || following.field_77994_a >= following.func_77976_d()) continue;
            int missingForFullStack = following.func_77976_d() - following.field_77994_a;
            if (current.field_77994_a <= missingForFullStack) {
                this.inventory[nextIndex].field_77994_a += current.field_77994_a;
                this.inventory[i] = null;
                continue;
            }
            this.inventory[nextIndex].field_77994_a += missingForFullStack;
            this.func_70298_a(i, missingForFullStack);
        }
    }

    public void checkFuelOrKlein() {
        if (this.inventory[0] != null && this.inventory[0].func_77973_b() instanceof IItemEmc) {
            IItemEmc itemEmc = (IItemEmc)this.inventory[0].func_77973_b();
            if (itemEmc.getStoredEmc(this.inventory[0]) != itemEmc.getMaximumEmc(this.inventory[0])) {
                this.hasChargeableItem = true;
                this.hasFuel = false;
            } else {
                this.hasChargeableItem = false;
            }
        } else {
            this.hasFuel = true;
            this.hasChargeableItem = false;
        }
    }

    public void updateEmc() {
        if (this.getStoredEmc() == 0.0) {
            return;
        }
        if (this.hasChargeableItem) {
            int maxStarEmc;
            double toSend = this.getStoredEmc() < (double)this.emcGen ? this.getStoredEmc() : (double)this.emcGen;
            double starEmc = ItemPE.getEmc(this.inventory[0]);
            if (starEmc + toSend > (double)(maxStarEmc = EMCHelper.getKleinStarMaxEmc(this.inventory[0]))) {
                toSend = (double)maxStarEmc - starEmc;
            }
            ItemPE.addEmcToStack(this.inventory[0], toSend);
            this.removeEMC(toSend);
        } else if (this.hasFuel) {
            ItemStack result;
            int upgradeCost;
            if (FuelMapper.getFuelUpgrade(this.inventory[0]) == null) {
                this.func_70299_a(0, null);
            }
            if ((upgradeCost = EMCHelper.getEmcValue(result = this.inventory[this.lockSlot] == null ? FuelMapper.getFuelUpgrade(this.inventory[0]) : this.inventory[this.lockSlot].func_77946_l()) - EMCHelper.getEmcValue(this.inventory[0])) > 0 && this.getStoredEmc() >= (double)upgradeCost) {
                ItemStack upgrade = this.inventory[this.upgradedSlot];
                if (this.inventory[this.upgradedSlot] == null) {
                    this.removeEMC(upgradeCost);
                    this.func_70299_a(this.upgradedSlot, result);
                    this.func_70298_a(0, 1);
                } else if (ItemHelper.basicAreStacksEqual(result, upgrade) && upgrade.field_77994_a < upgrade.func_77976_d()) {
                    this.removeEMC(upgradeCost);
                    ++this.inventory[this.upgradedSlot].field_77994_a;
                    this.func_70298_a(0, 1);
                }
            }
        } else {
            double toSend = this.getStoredEmc() < (double)this.emcGen ? this.getStoredEmc() : (double)this.emcGen;
            this.sendToAllAcceptors(toSend);
            this.sendRelayBonus();
        }
    }

    private float getSunRelativeEmc(int emc) {
        return (float)this.getSunLevel() * (float)emc / 16.0f;
    }

    public ItemStack getChargingItem() {
        return this.inventory[0];
    }

    public double getEmcToNextGoal() {
        if (this.inventory[this.lockSlot] != null) {
            return EMCHelper.getEmcValue(this.inventory[this.lockSlot]) - EMCHelper.getEmcValue(this.inventory[0]);
        }
        return EMCHelper.getEmcValue(FuelMapper.getFuelUpgrade(this.inventory[0])) - EMCHelper.getEmcValue(this.inventory[0]);
    }

    private double getItemCharge() {
        if (this.inventory[0] != null && this.inventory[0].func_77973_b() instanceof IItemEmc) {
            return ((IItemEmc)this.inventory[0].func_77973_b()).getStoredEmc(this.inventory[0]);
        }
        return -1.0;
    }

    public int getKleinStarChargeScaled(int i) {
        if (this.inventory[0] == null || this.displayItemCharge <= 0.0) {
            return 0;
        }
        return (int)Math.round(this.displayItemCharge * (double)i / ((IItemEmc)this.inventory[0].func_77973_b()).getMaximumEmc(this.inventory[0]));
    }

    public int getSunLevel() {
        if (this.field_145850_b.field_73011_w.field_76575_d) {
            return 16;
        }
        return this.field_145850_b.func_72957_l(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e) + 1;
    }

    public int getEmcScaled(int i) {
        if (this.displayEmc == 0) {
            return 0;
        }
        return (int)Math.round((double)(this.displayEmc * i) / this.getMaximumEmc());
    }

    public int getSunLevelScaled(int i) {
        return this.displaySunLevel * i / 16;
    }

    public int getFuelProgressScaled(int i) {
        if (this.inventory[0] == null || !FuelMapper.isStackFuel(this.inventory[0])) {
            return 0;
        }
        int reqEmc = 0;
        if (this.inventory[this.lockSlot] != null) {
            reqEmc = EMCHelper.getEmcValue(this.inventory[this.lockSlot]) - EMCHelper.getEmcValue(this.inventory[0]);
            if (reqEmc < 0) {
                return 0;
            }
        } else {
            if (FuelMapper.getFuelUpgrade(this.inventory[0]) == null) {
                this.func_70299_a(0, null);
                return 0;
            }
            reqEmc = EMCHelper.getEmcValue(FuelMapper.getFuelUpgrade(this.inventory[0])) - EMCHelper.getEmcValue(this.inventory[0]);
        }
        if (this.displayEmc >= reqEmc) {
            return i;
        }
        return this.displayEmc * i / reqEmc;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.storedFuelEmc = nbt.func_74769_h("FuelEMC");
        NBTTagList list = nbt.func_150295_c("Items", 10);
        this.inventory = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound subNBT = list.func_150305_b(i);
            byte slot = subNBT.func_74771_c("Slot");
            if (slot < 0 || slot >= this.func_70302_i_()) continue;
            this.inventory[slot] = ItemStack.func_77949_a((NBTTagCompound)subNBT);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74780_a("EMC", this.getStoredEmc());
        nbt.func_74780_a("FuelEMC", this.storedFuelEmc);
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.inventory[i] == null) continue;
            NBTTagCompound subNBT = new NBTTagCompound();
            subNBT.func_74774_a("Slot", (byte)i);
            this.inventory[i].func_77955_b(subNBT);
            list.func_74742_a((NBTBase)subNBT);
        }
        nbt.func_74782_a("Items", (NBTBase)list);
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int slot) {
        return this.inventory[slot];
    }

    public ItemStack func_70298_a(int slot, int qty) {
        ItemStack stack = this.inventory[slot];
        if (stack != null) {
            if (stack.field_77994_a <= qty) {
                this.inventory[slot] = null;
            } else {
                stack = stack.func_77979_a(qty);
                if (stack.field_77994_a == 0) {
                    this.inventory[slot] = null;
                }
            }
        }
        return stack;
    }

    public ItemStack func_70304_b(int slot) {
        if (this.inventory[slot] != null) {
            ItemStack stack = this.inventory[slot];
            this.inventory[slot] = null;
            return stack;
        }
        return null;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inventory[slot] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
    }

    public String func_145825_b() {
        return "tile.pe_collector_MK1.name";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer var1) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this ? false : var1.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
        ++this.numUsing;
    }

    public void func_70305_f() {
        --this.numUsing;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return true;
    }

    public int[] func_94128_d(int side) {
        if (side == 0 || side == 1) {
            return new int[]{this.upgradedSlot};
        }
        return this.accessibleSlots;
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        if (side == 0 || side == 1) {
            return false;
        }
        return FuelMapper.isStackFuel(stack);
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        if (side == 0 || side == 1) {
            return slot == this.upgradedSlot;
        }
        return false;
    }

    private void sendRelayBonus() {
        for (Map.Entry<ForgeDirection, TileEntity> entry : WorldHelper.getAdjacentTileEntitiesMapped(this.field_145850_b, this).entrySet()) {
            ForgeDirection dir = entry.getKey();
            TileEntity tile = entry.getValue();
            if (tile instanceof RelayMK3Tile) {
                ((RelayMK3Tile)tile).acceptEMC(dir, 0.5);
                continue;
            }
            if (tile instanceof RelayMK2Tile) {
                ((RelayMK2Tile)tile).acceptEMC(dir, 0.15);
                continue;
            }
            if (!(tile instanceof RelayMK1Tile)) continue;
            ((RelayMK1Tile)tile).acceptEMC(dir, 0.05);
        }
    }

    @Override
    public double provideEMC(ForgeDirection side, double toExtract) {
        double toRemove = Math.min(this.currentEMC, toExtract);
        this.removeEMC(toRemove);
        return toRemove;
    }
}

