/*
 * Decompiled with CFR 0.152.
 */
package net.slimevoid.library.tileentity;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.ForgeDirection;
import net.slimevoid.library.blocks.BlockBase;
import net.slimevoid.library.util.helpers.BlockHelper;
import net.slimevoid.library.util.helpers.ItemHelper;

public abstract class TileEntityBase
extends TileEntity
implements IInventory {
    protected long tickSchedule = -1L;
    protected int rotation = 0;
    protected boolean active = false;

    public void onBlockNeighborChange(Block block) {
    }

    public int onBlockPlaced(int side, float hitX, float hitY, float hitZ, int damage) {
        return damage;
    }

    public void onBlockPlacedBy(ItemStack itemstack, EntityLivingBase entity) {
        this.rotation = (int)Math.floor((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5) & 3;
    }

    public int getRotation() {
        return this.rotation;
    }

    public void setRotation(int newRotation) {
        this.rotation = newRotation;
    }

    public void onTileTick() {
    }

    public boolean onBlockActivated(EntityPlayer entityplayer) {
        return false;
    }

    public abstract int getExtendedBlockID();

    public int getExtendedMetadata() {
        return 0;
    }

    public boolean removeBlockByPlayer(EntityPlayer player, BlockBase blockBase) {
        return blockBase.superRemoveBlockByPlayer(this.func_145831_w(), player, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public ItemStack getPickBlock(MovingObjectPosition target, BlockBase blockBase) {
        return blockBase.superGetPickBlock(target, this.func_145831_w(), this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public float getBlockHardness(BlockBase blockBase) {
        return blockBase.superBlockHardness(this.func_145831_w(), this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public float getPlayerRelativeBlockHardness(EntityPlayer entityplayer, BlockBase blockBase) {
        return ForgeHooks.blockStrength((Block)blockBase, (EntityPlayer)entityplayer, (World)this.func_145831_w(), (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e);
    }

    public float getExplosionResistance(Entity entity, double explosionX, double explosionY, double explosionZ, BlockBase blockBase) {
        return blockBase.superGetExplosionResistance(entity, this.func_145831_w(), this.field_145851_c, this.field_145848_d, this.field_145849_e, explosionX, explosionY, explosionZ);
    }

    public int colorMultiplier(BlockBase blockBase) {
        return blockBase.superColorMultiplier(this.func_145831_w(), this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    protected abstract void addHarvestContents(ArrayList<ItemStack> var1);

    public void scheduleTick(int time) {
        long worldTime = this.func_145831_w().func_72820_D() + (long)time;
        if (this.tickSchedule > 0L && this.tickSchedule < worldTime) {
            return;
        }
        this.tickSchedule = worldTime;
        this.markBlockDirty();
    }

    public int getLightValue() {
        return 0;
    }

    public void updateBlock() {
        this.func_145831_w().func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.func_145831_w().func_147451_t(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void updateBlockAndNeighbours() {
        BlockHelper.updateIndirectNeighbors(this.func_145831_w(), this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
        this.updateBlock();
    }

    public void markBlockDirty() {
        BlockHelper.markBlockDirty(this.func_145831_w(), this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void breakBlock(Block block, int metadata) {
        ArrayList<ItemStack> harvestList = new ArrayList<ItemStack>();
        this.addHarvestContents(harvestList);
        for (ItemStack itemstack : harvestList) {
            ItemHelper.dropItem(this.func_145831_w(), this.field_145851_c, this.field_145848_d, this.field_145849_e, itemstack);
        }
    }

    public void func_145845_h() {
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        if (this.tickSchedule < 0L) {
            return;
        }
        long worldTime = this.func_145831_w().func_72820_D();
        if (this.tickSchedule > worldTime + 1200L) {
            this.tickSchedule = worldTime + 1200L;
        } else if (this.tickSchedule <= worldTime) {
            this.tickSchedule = -1L;
            this.onTileTick();
            this.markBlockDirty();
        }
    }

    public int getRotatedSide(int side) {
        switch (this.rotation) {
            case 0: {
                return side == 3 ? 2 : (side == 2 ? 3 : side);
            }
            case 1: {
                return side == 3 ? 5 : (side == 5 ? 3 : side);
            }
            case 2: {
                return side;
            }
            case 3: {
                return side == 3 ? 4 : (side == 4 ? 3 : side);
            }
        }
        return side;
    }

    public IIcon getBlockTexture(int x, int y, int z, int metadata, int side) {
        return this.func_145838_q().func_149691_a(this.getRotatedSide(side), metadata);
    }

    public void setBlockBoundsBasedOnState(BlockBase blockBase) {
        blockBase.superSetBlockBoundsBasedOnState(this.func_145831_w(), this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void setBlockBoundsForItemRender(BlockBase blockBase) {
        blockBase.func_149683_g();
    }

    public MovingObjectPosition collisionRayTrace(BlockBase blockbase, Vec3 startVec, Vec3 endVec) {
        return blockbase.superCollisionRayTrace(this.func_145831_w(), this.field_145851_c, this.field_145848_d, this.field_145849_e, startVec, endVec);
    }

    public void addCollisionBoxesToList(BlockBase blockBase, AxisAlignedBB axisAlignedBB, List aList, Entity anEntity) {
        blockBase.superAddCollisionBoxesToList(this.func_145831_w(), this.field_145851_c, this.field_145848_d, this.field_145849_e, axisAlignedBB, aList, anEntity);
    }

    public boolean isSideSolid(BlockBase blockBase, ForgeDirection side) {
        return blockBase.superSideSolid(this.func_145831_w(), this.field_145851_c, this.field_145848_d, this.field_145849_e, side);
    }

    public boolean addBlockDestroyEffects(BlockBase blockBase, int meta, EffectRenderer effectRenderer) {
        return blockBase.superDestroyEffects(this.func_145831_w(), this.field_145851_c, this.field_145848_d, this.field_145849_e, meta, effectRenderer);
    }

    public boolean addBlockHitEffects(BlockBase blockBase, MovingObjectPosition target, EffectRenderer effectRenderer) {
        return blockBase.superHitEffects(this.func_145831_w(), target, effectRenderer);
    }

    public Block.SoundType getStepSound() {
        return null;
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.tickSchedule = nbttagcompound.func_74763_f("Schedule");
        this.rotation = nbttagcompound.func_74771_c("Rotation");
        byte status = nbttagcompound.func_74771_c("Active");
        this.active = status > 0;
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74772_a("Schedule", this.tickSchedule);
        nbttagcompound.func_74774_a("Rotation", (byte)this.rotation);
        nbttagcompound.func_74774_a("Active", (byte)(this.active ? 1 : 0));
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
        this.onInventoryChanged();
        this.updateBlock();
    }

    public void onInventoryChanged() {
        this.func_70296_d();
        this.onInventoryHasChanged(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    protected void onInventoryHasChanged(World world, int x, int y, int z) {
        world.func_147471_g(x, y, z);
    }

    public String func_145825_b() {
        return this.getInvName();
    }

    public abstract String getInvName();

    public boolean func_145818_k_() {
        return false;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public Packet func_145844_m() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.func_145841_b(nbttagcompound);
        S35PacketUpdateTileEntity packet = new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nbttagcompound);
        return packet;
    }
}

