/*
 * Decompiled with CFR 0.152.
 */
package net.slimevoid.library.inventory;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.world.World;
import net.slimevoid.library.inventory.InventorySubUpdate;

public abstract class ContainerBase
extends Container {
    protected InventoryPlayer playerInventory;
    protected IInventory customInventory;
    protected World world;

    public ContainerBase(InventoryPlayer playerInventory, IInventory customInventory, World world, int playerColOffset, int playerRowOffset) {
        this.playerInventory = playerInventory;
        this.customInventory = customInventory;
        this.world = world;
        this.bindLocalInventory();
        if (this.shouldBindPlayerInventory()) {
            this.bindPlayerInventory(playerColOffset, playerRowOffset);
        }
    }

    protected boolean shouldBindPlayerInventory() {
        return true;
    }

    protected abstract void bindLocalInventory();

    protected void bindUpperInventory(int playerColOffset, int playerRowOffset) {
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                int slotIndex = column + row * 9;
                this.func_75146_a(new Slot((IInventory)new InventorySubUpdate(this, (IInventory)this.playerInventory, 9, 27), slotIndex, 8 + column * 18 + playerColOffset, row * 18 + playerRowOffset));
            }
        }
    }

    protected void bindHotBarInventory(int playerColOffset, int playerRowOffset) {
        for (int row = 0; row < 9; ++row) {
            int slotIndex = row;
            this.func_75146_a(new Slot((IInventory)this.playerInventory, slotIndex, 8 + row * 18 + playerColOffset, 58 + playerRowOffset));
        }
    }

    protected void bindPlayerInventory(int playerColOffset, int playerRowOffset) {
        this.bindUpperInventory(playerColOffset, playerRowOffset);
        this.bindHotBarInventory(playerColOffset, playerRowOffset);
    }

    public InventoryPlayer getPlayerInventory() {
        return this.playerInventory;
    }

    public IInventory getInventoryData() {
        return this.customInventory;
    }

    public boolean func_75145_c(EntityPlayer entityplayer) {
        return this.customInventory.func_70300_a(entityplayer);
    }

    protected static class ContainerNull
    extends Container {
        public boolean func_75145_c(EntityPlayer entityplayer) {
            return false;
        }

        public void func_75130_a(IInventory inventory) {
        }
    }
}

