/*
 * Decompiled with CFR 0.152.
 */
package net.slimevoid.library.data;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import net.slimevoid.library.core.SlimevoidLib;

public abstract class Logger {
    protected String name;
    protected LoggerWriter writer;
    protected LogLevel filterLevel;

    protected Logger() {
        this.setName(this.getLoggerName());
    }

    protected abstract String getLoggerName();

    public boolean setFilterLevel(String f) {
        if (f.equals(LogLevel.DEBUG.name())) {
            this.filterLevel = LogLevel.DEBUG;
            return true;
        }
        if (f.equals(LogLevel.INFO.name())) {
            this.filterLevel = LogLevel.INFO;
            return true;
        }
        if (f.equals(LogLevel.WARNING.name())) {
            this.filterLevel = LogLevel.WARNING;
            return true;
        }
        if (f.equals(LogLevel.ERROR.name())) {
            this.filterLevel = LogLevel.ERROR;
            return true;
        }
        this.filterLevel = LogLevel.INFO;
        return false;
    }

    private boolean filter(LogLevel lvl) {
        if (this.filterLevel == LogLevel.DEBUG) {
            return true;
        }
        if (this.filterLevel == LogLevel.INFO) {
            return lvl != LogLevel.DEBUG;
        }
        if (this.filterLevel == LogLevel.WARNING) {
            return lvl != LogLevel.DEBUG && lvl != LogLevel.INFO;
        }
        if (this.filterLevel == LogLevel.ERROR) {
            return lvl == LogLevel.ERROR;
        }
        return true;
    }

    public void write(boolean isRemote, String msg, LogLevel lvl) {
        String name = this.getName();
        if (this.filter(lvl)) {
            if (this.writer == null) {
                this.writer = new LoggerWriter(this.getLoggerName());
            }
            StringBuilder trace = new StringBuilder();
            try {
                throw new Exception();
            }
            catch (Exception e) {
                int min;
                StackTraceElement[] c = e.getStackTrace();
                for (int i = min = Math.min(3, c.length - 1); i >= 1; --i) {
                    trace.append(Logger.filterClassName(c[i].getClassName()) + "." + c[i].getMethodName());
                    if (i <= 1) continue;
                    trace.append("->");
                }
                this.writer.write(lvl.name() + ":" + this.getSide(isRemote) + ":" + name + ":" + msg + ":" + trace);
            }
        }
    }

    private String getSide(boolean isRemote) {
        if (!isRemote && FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            return "ISERVER";
        }
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            return "CLIENT";
        }
        if (FMLCommonHandler.instance().getSide() == Side.SERVER) {
            return "SERVER";
        }
        return "UNKNOWN";
    }

    public void writeStackTrace(Exception e) {
        if (this.writer == null) {
            this.writer = new LoggerWriter(this.getLoggerName());
        }
        this.writer.writeStackTrace(e);
        FMLCommonHandler.instance().raiseException((Throwable)e, e.getMessage(), false);
    }

    public static String filterClassName(String name) {
        return name.substring(name.lastIndexOf(".") + 1);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    private class LoggerWriter {
        private File file;
        private FileWriter fstream;
        private PrintWriter out;

        public LoggerWriter(String modName) {
            try {
                String fileName = SlimevoidLib.proxy.getMinecraftDir() + File.separator + modName + ".log";
                System.out.println(fileName);
                this.file = new File(fileName);
                this.fstream = new FileWriter(this.file);
                this.out = new PrintWriter(this.fstream);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public void finalize() {
            try {
                this.out.close();
                this.fstream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public void write(String msg) {
            this.out.write("\n" + System.currentTimeMillis() + ":" + msg);
            this.out.flush();
        }

        public void writeStackTrace(Exception e) {
            this.out.write("\n" + System.currentTimeMillis() + ":");
            this.out.flush();
            e.printStackTrace(this.out);
            this.out.flush();
            e.printStackTrace();
        }
    }

    public static enum LogLevel {
        DEBUG,
        WARNING,
        ERROR,
        INFO;

    }
}

