/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.additionalpipes.utils;

import buildcraft.additionalpipes.utils.Log;
import io.netty.buffer.ByteBuf;

public class NetworkUtils {
    public static void writeBooleanArray(ByteBuf buf, boolean[] booleans) {
        byte[] bytes = new byte[booleans.length / 8 + 1];
        Log.debug("Fitting " + booleans.length + " booleans in " + bytes.length + " byte" + (bytes.length > 1 ? "s" : ""));
        for (int index = 0; index < booleans.length; ++index) {
            int n = index / 8;
            bytes[n] = (byte)(bytes[n] | (booleans[index] ? 1 : 0) << index % 8);
        }
        buf.writeBytes(bytes);
    }

    public static boolean[] readBooleanArray(ByteBuf buf, int len) {
        byte[] bytes = new byte[len / 8 + 1];
        buf.readBytes(bytes);
        boolean[] booleans = new boolean[len];
        for (int index = 0; index < len; ++index) {
            booleans[index] = (bytes[index / 8] >> index % 8 & 1) == 1;
        }
        return booleans;
    }
}

