/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.logic;

import java.util.UUID;
import logisticspipes.logic.LogicParameterType;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public abstract class BaseLogicTask {
    protected int posX;
    protected int posY;
    protected String name = this.getTypeName();
    protected String comment = "";
    protected UUID uuid;

    public BaseLogicTask(NBTTagCompound nbt) {
        this.posX = nbt.func_74762_e("posX");
        this.posY = nbt.func_74762_e("posY");
        this.name = nbt.func_74779_i("name");
        this.comment = nbt.func_74779_i("comment");
        this.uuid = UUID.fromString(nbt.func_74779_i("uuid"));
    }

    public BaseLogicTask(int posX, int posY) {
        this.posX = posX;
        this.posY = posY;
        this.uuid = UUID.randomUUID();
    }

    public final NBTTagCompound getNBTTagCompound() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.addToNBT(nbt);
        return nbt;
    }

    protected void addToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("posX", this.posX);
        nbt.func_74768_a("posY", this.posY);
        nbt.func_74778_a("name", this.name);
        nbt.func_74778_a("comment", this.comment);
        nbt.func_74778_a("uuid", this.uuid.toString());
    }

    public abstract int getAmountOfInput();

    public abstract int getAmountOfOutput();

    public abstract LogicParameterType getInputParameterType(int var1);

    public abstract LogicParameterType getOutputParameterType(int var1);

    public abstract void setInputParameter(int var1, Object var2);

    public abstract boolean isCalculated();

    public abstract Object getResult(int var1);

    public abstract void resetState();

    public abstract String getTypeName();

    public abstract void syncTick(TileEntity var1);

    public int getPosX() {
        return this.posX;
    }

    public int getPosY() {
        return this.posY;
    }

    public String getName() {
        return this.name;
    }

    public String getComment() {
        return this.comment;
    }

    public UUID getUuid() {
        return this.uuid;
    }
}

