/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.utills;

import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.common.entity.EntityChaosGuardian;
import com.brandon3055.draconicevolution.common.utills.LogHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.MinecraftForge;

public class DragonChunkLoader
implements ForgeChunkManager.LoadingCallback {
    public static DragonChunkLoader instance;
    public static Map<EntityChaosGuardian, ForgeChunkManager.Ticket> ticketList;
    public static boolean hasReportedIssue;

    public static void init() {
        instance = new DragonChunkLoader();
        MinecraftForge.EVENT_BUS.register((Object)instance);
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)DraconicEvolution.instance, (ForgeChunkManager.LoadingCallback)instance);
    }

    public static void updateLoaded(EntityChaosGuardian guardian) {
        ForgeChunkManager.Ticket ticket;
        if (ticketList.containsKey((Object)guardian)) {
            ticket = ticketList.get((Object)guardian);
        } else {
            ticket = ForgeChunkManager.requestTicket((Object)DraconicEvolution.instance, (World)guardian.field_70170_p, (ForgeChunkManager.Type)ForgeChunkManager.Type.ENTITY);
            if (ticket != null) {
                ticket.bindEntity((Entity)guardian);
                ticket.setChunkListDepth(9);
                ticketList.put(guardian, ticket);
            } else {
                if (!hasReportedIssue) {
                    LogHelper.error("##########################################################################################");
                    LogHelper.error("Could not get ticket for dragon");
                    LogHelper.error("Fore some reason forge has denied DE's request for a loader ticket for the chaos guardian");
                    LogHelper.error("This means the chaos guardian may not behave as indented");
                    LogHelper.error("This error will not show again.");
                    LogHelper.error("##########################################################################################");
                    hasReportedIssue = true;
                }
                return;
            }
        }
        if (ticket == null || guardian.field_70173_aa % 4 != 0) {
            return;
        }
        HashSet<ChunkCoordIntPair> dragonChunks = new HashSet<ChunkCoordIntPair>();
        for (int xx = guardian.field_70176_ah - 1; xx <= guardian.field_70176_ah + 1; ++xx) {
            for (int zz = guardian.field_70164_aj - 1; zz <= guardian.field_70164_aj + 1; ++zz) {
                dragonChunks.add(new ChunkCoordIntPair(xx, zz));
            }
        }
        HashSet<ChunkCoordIntPair> toLoad = new HashSet<ChunkCoordIntPair>();
        HashSet<ChunkCoordIntPair> toUnload = new HashSet<ChunkCoordIntPair>();
        for (ChunkCoordIntPair pair : ticket.getChunkList()) {
            if (DragonChunkLoader.contains(dragonChunks, pair)) continue;
            toUnload.add(pair);
        }
        for (ChunkCoordIntPair pair : dragonChunks) {
            if (DragonChunkLoader.contains((Set<ChunkCoordIntPair>)ticket.getChunkList(), pair)) continue;
            toLoad.add(pair);
        }
        for (ChunkCoordIntPair unload : toUnload) {
            ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)ticket, (ChunkCoordIntPair)unload);
        }
        for (ChunkCoordIntPair load : toLoad) {
            ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkCoordIntPair)load);
        }
    }

    private static boolean contains(Set<ChunkCoordIntPair> set, ChunkCoordIntPair pair) {
        for (ChunkCoordIntPair pair1 : set) {
            if (!pair1.equals((Object)pair)) continue;
            return true;
        }
        return false;
    }

    public static void stopLoading(EntityChaosGuardian guardian) {
        if (!ticketList.containsKey((Object)guardian)) {
            return;
        }
        ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticketList.get((Object)guardian));
        ticketList.remove((Object)guardian);
    }

    public void ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world) {
        if (!tickets.isEmpty()) {
            for (ForgeChunkManager.Ticket ticket : tickets) {
                if (ticket.getType() != ForgeChunkManager.Type.ENTITY || !(ticket.getEntity() instanceof EntityChaosGuardian)) continue;
                DragonChunkLoader.updateLoaded((EntityChaosGuardian)ticket.getEntity());
            }
        }
    }

    static {
        ticketList = new HashMap<EntityChaosGuardian, ForgeChunkManager.Ticket>();
        hasReportedIssue = false;
    }
}

