/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.network;

import com.brandon3055.brandonscore.BrandonsCore;
import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.common.handler.ContributorHandler;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;

public class ContributorPacket
implements IMessage {
    public String contributor;
    public boolean wings;
    public boolean badge;

    public ContributorPacket() {
    }

    public ContributorPacket(String contributor, boolean wings, boolean badge) {
        this.contributor = contributor;
        this.wings = wings;
        this.badge = badge;
    }

    public void fromBytes(ByteBuf bytes) {
        this.contributor = ByteBufUtils.readUTF8String((ByteBuf)bytes);
        this.wings = bytes.readBoolean();
        this.badge = bytes.readBoolean();
    }

    public void toBytes(ByteBuf bytes) {
        ByteBufUtils.writeUTF8String((ByteBuf)bytes, (String)this.contributor);
        bytes.writeBoolean(this.wings);
        bytes.writeBoolean(this.badge);
    }

    public static class Handler
    implements IMessageHandler<ContributorPacket, IMessage> {
        public IMessage onMessage(ContributorPacket message, MessageContext ctx) {
            if (ContributorHandler.contributors.containsKey(message.contributor)) {
                ContributorHandler.Contributor contributor1 = ContributorHandler.contributors.get(message.contributor);
                if (ctx.side == Side.SERVER) {
                    if (!contributor1.isUserValid((EntityPlayer)ctx.getServerHandler().field_147369_b)) {
                        return null;
                    }
                    contributor1.contributorWingsEnabled = message.wings;
                    contributor1.patreonBadgeEnabled = message.badge;
                    DraconicEvolution.network.sendToAll((IMessage)message);
                } else {
                    EntityPlayer player = BrandonsCore.proxy.getClientPlayer();
                    if (!contributor1.isUserValid(player) || message.contributor.equals(player.func_70005_c_())) {
                        return null;
                    }
                    contributor1.contributorWingsEnabled = message.wings;
                    contributor1.patreonBadgeEnabled = message.badge;
                }
            }
            return null;
        }
    }
}

