/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.items.weapons;

import com.brandon3055.brandonscore.BrandonsCore;
import com.brandon3055.brandonscore.common.utills.InfoHelper;
import com.brandon3055.brandonscore.common.utills.ItemNBTHelper;
import com.brandon3055.brandonscore.common.utills.Utills;
import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.client.render.IRenderTweak;
import com.brandon3055.draconicevolution.common.ModItems;
import com.brandon3055.draconicevolution.common.entity.EntityPersistentItem;
import com.brandon3055.draconicevolution.common.handler.BalanceConfigHandler;
import com.brandon3055.draconicevolution.common.items.tools.baseclasses.ToolBase;
import com.brandon3055.draconicevolution.common.items.tools.baseclasses.ToolHandler;
import com.brandon3055.draconicevolution.common.items.weapons.IEnergyContainerWeaponItem;
import com.brandon3055.draconicevolution.common.lib.References;
import com.brandon3055.draconicevolution.common.network.ToolModePacket;
import com.brandon3055.draconicevolution.common.utills.IConfigurableItem;
import com.brandon3055.draconicevolution.common.utills.IHudDisplayItem;
import com.brandon3055.draconicevolution.common.utills.IInventoryTool;
import com.brandon3055.draconicevolution.common.utills.IUpgradableItem;
import com.brandon3055.draconicevolution.common.utills.ItemConfigField;
import com.google.common.collect.Multimap;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class DraconicSword
extends ItemSword
implements IEnergyContainerWeaponItem,
IInventoryTool,
IRenderTweak,
IUpgradableItem,
IHudDisplayItem {
    protected int capacity = BalanceConfigHandler.draconicWeaponsBaseStorage;
    protected int maxReceive = BalanceConfigHandler.draconicWeaponsMaxTransfer;
    protected int maxExtract = BalanceConfigHandler.draconicWeaponsMaxTransfer;

    public DraconicSword() {
        super(ModItems.AWAKENED);
        this.func_77655_b("draconicSword");
        this.func_77637_a(DraconicEvolution.tabToolsWeapons);
        if (ModItems.isEnabled((Item)this)) {
            GameRegistry.registerItem((Item)this, (String)"draconicSword");
        }
    }

    public boolean func_77616_k(ItemStack p_77616_1_) {
        return true;
    }

    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        list.add(ItemNBTHelper.setInteger((ItemStack)new ItemStack(item, 1, 0), (String)"Energy", (int)0));
        list.add(ItemNBTHelper.setInteger((ItemStack)new ItemStack(item, 1, 0), (String)"Energy", (int)this.capacity));
    }

    public String func_77658_a() {
        return String.format("item.%s%s", "DraconicEvolution".toLowerCase() + ":", super.func_77658_a().substring(super.func_77658_a().indexOf(".") + 1));
    }

    public String func_77667_c(ItemStack itemStack) {
        return this.func_77658_a();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a(References.RESOURCESPREFIX + "draconic_sword");
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        entity.field_70172_ad = 0;
        ToolHandler.AOEAttack(player, entity, stack, IConfigurableItem.ProfileHelper.getInteger(stack, "WeaponAttackAOE", 0));
        ToolHandler.damageEntityBasedOnHealth(entity, player, 0.2f);
        return true;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean extraInformation) {
        if (InfoHelper.holdShiftForDetails((List)list)) {
            List<ItemConfigField> l = this.getFields(stack, 0);
            for (ItemConfigField f : l) {
                list.add(f.getTooltipInfo());
            }
            list.add(InfoHelper.ITC() + StatCollector.func_74838_a((String)"info.de.sword.txt"));
            InfoHelper.addLore((ItemStack)stack, (List)list);
        }
        ToolBase.holdCTRLForUpgrades(list, stack);
        InfoHelper.addEnergyInfo((ItemStack)stack, (List)list);
        list.add("");
        list.add(EnumChatFormatting.BLUE + "+" + ToolHandler.getBaseAttackDamage(stack) + " " + StatCollector.func_74838_a((String)"info.de.attackDamage.txt"));
        list.add(EnumChatFormatting.BLUE + "+20%" + " " + StatCollector.func_74838_a((String)"info.de.bonusHealthDamage.txt"));
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.rare;
    }

    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        if (container.field_77990_d == null) {
            container.field_77990_d = new NBTTagCompound();
        }
        int energy = container.field_77990_d.func_74762_e("Energy");
        int energyReceived = Math.min(this.getMaxEnergyStored(container) - energy, Math.min(this.maxReceive, maxReceive));
        if (!simulate) {
            container.field_77990_d.func_74768_a("Energy", energy += energyReceived);
        }
        return energyReceived;
    }

    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        if (container.field_77990_d == null || !container.field_77990_d.func_74764_b("Energy")) {
            return 0;
        }
        int energy = container.field_77990_d.func_74762_e("Energy");
        int energyExtracted = Math.min(energy, Math.min(this.maxExtract, maxExtract));
        if (!simulate) {
            container.field_77990_d.func_74768_a("Energy", energy -= energyExtracted);
        }
        return energyExtracted;
    }

    public int getEnergyStored(ItemStack container) {
        if (container.field_77990_d == null || !container.field_77990_d.func_74764_b("Energy")) {
            return 0;
        }
        return container.field_77990_d.func_74762_e("Energy");
    }

    public int getMaxEnergyStored(ItemStack container) {
        int points = IUpgradableItem.EnumUpgrade.RF_CAPACITY.getUpgradePoints(container);
        return BalanceConfigHandler.draconicWeaponsBaseStorage + points * BalanceConfigHandler.draconicWeaponsStoragePerUpgrade;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.getEnergyStored(stack) != this.getMaxEnergyStored(stack);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - (double)this.getEnergyStored(stack) / (double)this.getMaxEnergyStored(stack);
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    public Entity createEntity(World world, Entity location, ItemStack itemstack) {
        return new EntityPersistentItem(world, location, itemstack);
    }

    @Override
    public String getInventoryName() {
        return StatCollector.func_74838_a((String)"info.de.toolInventoryEnch.txt");
    }

    @Override
    public int getInventorySlots() {
        return 0;
    }

    @Override
    public boolean isEnchantValid(Enchantment enchant) {
        return enchant.field_77351_y == EnumEnchantmentType.weapon;
    }

    @Override
    public List<ItemConfigField> getFields(ItemStack stack, int slot) {
        ArrayList<ItemConfigField> list = new ArrayList<ItemConfigField>();
        list.add(new ItemConfigField(2, slot, "WeaponAttackAOE").setMinMaxAndIncromente(0, IUpgradableItem.EnumUpgrade.ATTACK_AOE.getUpgradePoints(stack), 1).readFromItem(stack, 1).setModifier("AOE"));
        return list;
    }

    public Multimap getAttributeModifiers(ItemStack stack) {
        Multimap map = super.getAttributeModifiers(stack);
        map.clear();
        return map;
    }

    @Override
    public void tweakRender(IItemRenderer.ItemRenderType type) {
        GL11.glTranslated((double)-0.01, (double)1.11, (double)-0.15);
        GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)140.0f, (float)0.0f, (float)-1.0f, (float)0.0f);
        GL11.glScaled((double)0.7, (double)0.7, (double)0.7);
        if (type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON) {
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslated((double)0.0, (double)-0.4, (double)0.0);
        } else if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            GL11.glScalef((float)8.0f, (float)8.0f, (float)8.0f);
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslated((double)1.9, (double)0.0, (double)0.0);
        } else if (type == IItemRenderer.ItemRenderType.ENTITY) {
            GL11.glRotatef((float)-90.5f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslated((double)-0.8, (double)0.0, (double)0.0);
        }
    }

    @Override
    public List<IUpgradableItem.EnumUpgrade> getUpgrades(ItemStack itemstack) {
        return new ArrayList<IUpgradableItem.EnumUpgrade>(){
            {
                this.add(IUpgradableItem.EnumUpgrade.RF_CAPACITY);
                this.add(IUpgradableItem.EnumUpgrade.ATTACK_AOE);
                this.add(IUpgradableItem.EnumUpgrade.ATTACK_DAMAGE);
            }
        };
    }

    @Override
    public int getUpgradeCap(ItemStack itemstack) {
        return BalanceConfigHandler.draconicWeaponsMaxUpgrades;
    }

    @Override
    public int getMaxTier(ItemStack itemstack) {
        return 2;
    }

    @Override
    public int getMaxUpgradePoints(int upgradeIndex) {
        if (upgradeIndex == IUpgradableItem.EnumUpgrade.RF_CAPACITY.index) {
            return BalanceConfigHandler.draconicWeaponsMaxCapacityUpgradePoints;
        }
        if (upgradeIndex == IUpgradableItem.EnumUpgrade.ATTACK_AOE.index) {
            return 5;
        }
        if (upgradeIndex == IUpgradableItem.EnumUpgrade.ATTACK_DAMAGE.index) {
            return 16;
        }
        return BalanceConfigHandler.draconicWeaponsMaxUpgradePoints;
    }

    @Override
    public int getMaxUpgradePoints(int upgradeIndex, ItemStack stack) {
        return this.getMaxUpgradePoints(upgradeIndex);
    }

    @Override
    public int getBaseUpgradePoints(int upgradeIndex) {
        if (upgradeIndex == IUpgradableItem.EnumUpgrade.ATTACK_AOE.index) {
            return 2;
        }
        if (upgradeIndex == IUpgradableItem.EnumUpgrade.ARROW_DAMAGE.index) {
            return 0;
        }
        return 0;
    }

    @Override
    public List<String> getUpgradeStats(ItemStack stack) {
        ArrayList<String> strings = new ArrayList<String>();
        int attackaoe = 0;
        for (ItemConfigField field : this.getFields(stack, 0)) {
            if (!field.name.equals("WeaponAttackAOE")) continue;
            attackaoe = 1 + (Integer)field.max * 2;
        }
        strings.add(InfoHelper.ITC() + StatCollector.func_74838_a((String)"gui.de.RFCapacity.txt") + ": " + InfoHelper.HITC() + Utills.formatNumber((long)this.getMaxEnergyStored(stack)));
        strings.add(InfoHelper.ITC() + StatCollector.func_74838_a((String)"info.de.attackDamage.txt") + ": " + InfoHelper.HITC() + ToolHandler.getBaseAttackDamage(stack));
        strings.add(InfoHelper.ITC() + StatCollector.func_74838_a((String)"gui.de.max.txt") + " " + StatCollector.func_74838_a((String)"gui.de.AttackAOE.txt") + ": " + InfoHelper.HITC() + attackaoe + "x" + attackaoe);
        return strings;
    }

    @Override
    public List<String> getDisplayData(ItemStack stack) {
        ArrayList<String> list = new ArrayList<String>();
        for (ItemConfigField field : this.getFields(stack, 0)) {
            list.add(field.getTooltipInfo());
        }
        return list;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (!world.field_72995_K && !BrandonsCore.proxy.isDedicatedServer()) {
            ToolBase.handleModeChange(stack, player, InfoHelper.isShiftKeyDown(), InfoHelper.isCtrlKeyDown());
        } else if (world.field_72995_K && BrandonsCore.proxy.getMCServer() == null) {
            ToolBase.handleModeChange(stack, player, InfoHelper.isShiftKeyDown(), InfoHelper.isCtrlKeyDown());
            DraconicEvolution.network.sendToServer((IMessage)new ToolModePacket(InfoHelper.isShiftKeyDown(), InfoHelper.isCtrlKeyDown()));
        }
        return super.func_77659_a(stack, world, player);
    }

    @Override
    public boolean hasProfiles() {
        return true;
    }

    @Override
    public int getEnergyPerAttack() {
        return BalanceConfigHandler.draconicWeaponsEnergyPerAttack;
    }
}

