/*
 * Decompiled with CFR 0.152.
 */
package ruby.bamboo.item.enchant;

import net.minecraft.block.Block;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockOre;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import ruby.bamboo.item.enchant.EnchantBase;

public class EnchantChain
extends EnchantBase {
    public EnchantChain(int id, String name, int maxLevel, float weight, float tp) {
        super(id, name, maxLevel, weight, tp);
    }

    @Override
    void effect(ItemStack itemStack, World world, int posX, int posY, int posZ, EntityLivingBase entity, int enchantLvl) {
        Block targetBlock = world.func_147439_a(posX, posY, posZ);
        if (targetBlock instanceof BlockLog || targetBlock instanceof BlockOre) {
            this.chainBreak(world, posX, posY, posZ, this.getFortune(itemStack), 0, targetBlock);
        }
    }

    private int getFortune(ItemStack is) {
        if (!is.field_77990_d.func_150297_b("ench", 9)) {
            is.field_77990_d.func_74782_a("ench", (NBTBase)new NBTTagList());
        }
        NBTTagList nbttaglist = is.func_77986_q();
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            if (nbttaglist.func_150305_b(i).func_74765_d("id") != Enchantment.field_77346_s.field_77352_x) continue;
            return nbttaglist.func_150305_b(i).func_74765_d("lvl");
        }
        return 0;
    }

    private void chainBreak(World world, int posX, int posY, int posZ, int fortune, int loopCount, Block targetBlock) {
        if (loopCount > 100) {
            return;
        }
        for (ForgeDirection fd : ForgeDirection.VALID_DIRECTIONS) {
            Block block = world.func_147439_a(posX + fd.offsetX, posY + fd.offsetY, posZ + fd.offsetZ);
            if (block != targetBlock) continue;
            block.func_149697_b(world, posX, posY, posZ, world.func_72805_g(posX + fd.offsetX, posY + fd.offsetY, posZ + fd.offsetZ), fortune);
            world.func_147468_f(posX + fd.offsetX, posY + fd.offsetY, posZ + fd.offsetZ);
            this.chainBreak(world, posX + fd.offsetX, posY + fd.offsetY, posZ + fd.offsetZ, fortune, ++loopCount, targetBlock);
        }
    }
}

