/*
 * Decompiled with CFR 0.152.
 */
package ruby.bamboo.item;

import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import ruby.bamboo.item.crafting.CookingManager;

public class ItemCookBook
extends Item {
    private static final int MAX_LENGTH = 200;

    public ItemCookBook() {
        this.func_77656_e(0);
        this.func_77625_d(1);
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer player) {
        ItemStack book = new ItemStack(Items.field_151164_bB);
        book.func_77982_d(this.getCookRecipeNBT());
        return book;
    }

    private NBTTagCompound getCookRecipeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("title", StatCollector.func_74838_a((String)(this.func_77658_a() + ".name")) + " ver:" + "@VERSION@");
        nbt.func_74778_a("author", "ruby");
        NBTTagList pagelist = new NBTTagList();
        StringBuffer page = new StringBuffer();
        for (IRecipe recipe : CookingManager.getInstance().getRecipeList()) {
            StringBuffer stb = new StringBuffer();
            stb.append(this.getLocalizedName(recipe.func_77571_b()) + ":");
            if (recipe instanceof ShapelessOreRecipe) {
                for (Object obj : ((ShapelessOreRecipe)recipe).getInput()) {
                    if (obj instanceof ItemStack) {
                        stb.append(this.getLocalizedName((ItemStack)obj));
                    } else if (obj instanceof List) {
                        stb.append("[");
                        stb.append(this.getLocalizedName((ItemStack)((List)obj).get(0)) + ",");
                        stb.deleteCharAt(stb.length() - 1);
                        stb.append("]");
                    }
                    stb.append(",");
                }
                stb.deleteCharAt(stb.length() - 1);
            }
            stb.append("\n");
            if (200 < page.length() + stb.length()) {
                pagelist.func_74742_a((NBTBase)new NBTTagString(page.toString()));
                page = new StringBuffer();
            }
            page.append(stb);
        }
        if (page.length() != 0) {
            pagelist.func_74742_a((NBTBase)new NBTTagString(page.toString()));
        }
        nbt.func_74782_a("pages", (NBTBase)pagelist);
        return nbt;
    }

    private String getLocalizedName(ItemStack is) {
        return StatCollector.func_74838_a((String)(is.func_77977_a() + ".name"));
    }
}

