/*
 * Decompiled with CFR 0.152.
 */
package ruby.bamboo.entity.magatama;

import cpw.mods.fml.common.FMLLog;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import ruby.bamboo.BambooUtil;
import ruby.bamboo.entity.magatama.EntityRuneEffect;

public class EntityFlareEffect
extends Entity {
    private int timer = 100;
    private boolean isFirstUpdate = true;
    private boolean isExploded = false;
    private float explodeSize = 0.0f;
    private float alpha;
    private List<EnergeticParticle> particles = new ArrayList<EnergeticParticle>();
    private List<EntityRuneEffect> runes = new ArrayList<EntityRuneEffect>();
    private static final int EXPLODE_SIZE = 25;
    private static final boolean[][][] MATRIX = new boolean[50][50][50];

    public EntityFlareEffect(World par1World) {
        super(par1World);
        this.func_70105_a(1.0f, 1.0f);
    }

    public void func_70071_h_() {
        if (this.isFirstUpdate) {
            this.isFirstUpdate = false;
            if (this.field_70170_p.field_72995_K) {
                EntityRuneEffect rune = new EntityRuneEffect(this.field_70170_p);
                rune.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                rune.setRollSpeed(-1.0f);
                rune.setRingsize(12.0f);
                rune.setParentEntity(this);
                rune.setRingColor(0xEE1100);
                this.runes.add(rune);
                rune = rune.copy();
                rune.func_70080_a(this.field_70165_t - 0.5, this.field_70163_u + 0.5, this.field_70161_v, 90.0f, 0.0f);
                this.runes.add(rune);
                rune = rune.copy();
                rune.func_70080_a(this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v + 0.5, 0.0f, 90.0f);
                this.runes.add(rune);
                rune = rune.copy();
                rune.func_70080_a(this.field_70165_t, this.field_70163_u + 0.25, this.field_70161_v, 45.0f, 0.0f);
                rune.setRollSpeed(1.0f);
                this.runes.add(rune);
                rune = rune.copy();
                rune.func_70080_a(this.field_70165_t, this.field_70163_u + 0.25, this.field_70161_v, -45.0f, 0.0f);
                this.runes.add(rune);
                rune = rune.copy();
                rune.func_70080_a(this.field_70165_t, this.field_70163_u + 0.25, this.field_70161_v, 0.0f, 45.0f);
                this.runes.add(rune);
                rune = rune.copy();
                rune.func_70080_a(this.field_70165_t, this.field_70163_u + 0.25, this.field_70161_v, 0.0f, -45.0f);
                this.runes.add(rune);
                for (Entity entity : this.runes) {
                    this.field_70170_p.func_72897_h(entity);
                }
                for (int i = 0; i < 30; ++i) {
                    EnergeticParticle energeticParticle = new EnergeticParticle();
                    double cposX = this.field_70165_t + (double)(this.field_70146_Z.nextInt(40) - 20);
                    double cposY = this.field_70163_u + (double)(this.field_70146_Z.nextInt(20) - 10);
                    double cposZ = this.field_70161_v + (double)(this.field_70146_Z.nextInt(40) - 20);
                    energeticParticle.setTargetPosition(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                    energeticParticle.setPosition(cposX, cposY, cposZ);
                    this.particles.add(energeticParticle);
                }
            }
        }
        if (0 < --this.timer) {
            if (this.timer < 20) {
                this.explodeSize = (float)((double)this.explodeSize + (this.explodeSize < 30.0f ? (double)this.explodeSize + 0.4 : 0.0));
                this.func_70105_a(this.explodeSize, this.explodeSize);
                this.alpha = (float)this.timer / 20.0f;
                this.field_70170_p.func_72908_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, "random.explode", 4.0f, (1.0f + (this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
                if (!this.field_70170_p.field_72995_K && !this.isExploded) {
                    this.matrixExplosion(this.field_70170_p, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, MATRIX);
                    this.isExploded = true;
                }
            } else if (this.field_70170_p.field_72995_K) {
                for (EnergeticParticle c : this.particles) {
                    c.onUpdate(this.field_70170_p);
                }
                for (EntityRuneEffect rune : this.runes) {
                    if (this.timer > 40) {
                        rune.setRollSpeed(rune.getRollSpeed() + rune.getRollSpeed() * 0.05f);
                        continue;
                    }
                    if (this.timer > 35) {
                        rune.field_70163_u = rune.field_70163_u < this.field_70163_u ? rune.field_70163_u + 0.3 : rune.field_70163_u - 0.3;
                        rune.setRingsize(rune.getRingsize() - rune.getRingsize() * 0.3f);
                        continue;
                    }
                    rune.func_70106_y();
                }
            }
        } else {
            this.particles.clear();
            this.func_70076_C();
        }
    }

    private void matrixExplosion(World world, int posX, int posY, int posZ, boolean[][][] matrix) {
        try {
            int matrixX = matrix.length;
            int matrixY = matrix[0].length;
            int matrixZ = matrix[0][0].length;
            int offsetPosX = posX - matrixX / 2;
            int offsetPosY = posY - matrixY / 2;
            int offsetPosZ = posZ - matrixZ / 2;
            for (int i = 0; i < matrixX; ++i) {
                for (int j = 0; j < matrixY; ++j) {
                    for (int k = 0; k < matrixZ; ++k) {
                        if (!matrix[i][j][k] || world.func_147437_c(offsetPosX + i, offsetPosY + j, offsetPosZ + k) || world.func_147439_a(offsetPosX + i, offsetPosY + j, offsetPosZ + k).func_149712_f(world, offsetPosX + i, offsetPosY + j, offsetPosZ + k) == -1.0f) continue;
                        world.func_147465_d(offsetPosX + i, offsetPosY + j, offsetPosZ + k, Blocks.field_150350_a, 0, 2);
                    }
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            FMLLog.warning((String)"Illegal matrix", (Object[])new Object[0]);
        }
    }

    public float getExplodeSize() {
        return this.explodeSize;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public void func_70091_d(double par1, double par3, double par5) {
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound nbttagcompound) {
        this.func_70106_y();
    }

    protected void func_70014_b(NBTTagCompound nbttagcompound) {
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    static {
        for (int i = 0; i < 50; ++i) {
            for (int j = 0; j < 50; ++j) {
                for (int k = 0; k < 50; ++k) {
                    EntityFlareEffect.MATRIX[i][j][k] = BambooUtil.isInnerCircleCollision(0, 0, 0, 25 - i, 25 - j, 25 - k, 25);
                }
            }
        }
    }

    private class EnergeticParticle {
        private static final float time = 40.0f;
        double posX;
        double posY;
        double posZ;
        double preposX;
        double preposY;
        double preposZ;
        double tposX;
        double tposY;
        double tposZ;
        private int count;

        private EnergeticParticle() {
        }

        void setPosition(double posX, double posY, double posZ) {
            this.preposX = this.posX = posX;
            this.preposY = this.posY = posY;
            this.preposZ = this.posZ = posZ;
        }

        void setTargetPosition(double posX, double posY, double posZ) {
            this.tposX = posX;
            this.tposY = posY;
            this.tposZ = posZ;
        }

        public void onUpdate(World world) {
            int n;
            ++this.count;
            if ((float)n < 40.0f) {
                world.func_72869_a("fireworksSpark", this.preposX, this.preposY, this.preposZ, 0.0, 0.0, 0.0);
            }
            this.preposX -= (this.posX - this.tposX) / 40.0;
            this.preposY -= (this.posY - this.tposY) / 40.0;
            this.preposZ -= (this.posZ - this.tposZ) / 40.0;
        }
    }
}

