/*
 * Decompiled with CFR 0.152.
 */
package ruby.bamboo.entity;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import ruby.bamboo.BambooInit;
import ruby.bamboo.BambooUtil;
import ruby.bamboo.entity.EnumSlideDoor;

public class EntitySlideDoor
extends Entity {
    private byte closeTimer;
    private static final byte DIRECTION = 17;
    private static final byte ISMIRROR = 18;
    private static final byte ISMOVE = 19;
    private static final byte DOORID = 20;
    private static final byte ISSTOP = 22;
    private static final byte MOVEDIR = 23;
    private static EnumSlideDoor[] tex = EnumSlideDoor.values();

    public EntitySlideDoor(World world) {
        super(world);
        this.field_70129_M = 0.0f;
        this.func_70105_a(1.0f, 2.0f);
    }

    public boolean shouldRenderInPass(int pass) {
        return this.isBlend() ? pass == 1 : pass == 0;
    }

    public boolean func_130002_c(EntityPlayer par1EntityPlayer) {
        if (par1EntityPlayer.func_70093_af()) {
            this.setDataisStop(!this.getDataisStop());
            par1EntityPlayer.func_71038_i();
            return true;
        }
        if (this.getDataisStop()) {
            if (!this.getDataMoveflg()) {
                this.doorOpen((Entity)par1EntityPlayer);
            } else {
                this.doorClose();
            }
            par1EntityPlayer.func_71038_i();
            return true;
        }
        return false;
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public AxisAlignedBB func_70046_E() {
        return this.field_70121_D;
    }

    public void func_70056_a(double par1, double par3, double par5, float par7, float par8, int par9) {
        this.func_70107_b(par1, par3, par5);
        this.func_70101_b(par7, par8);
    }

    protected boolean func_145771_j(double par1, double par3, double par5) {
        return false;
    }

    public AxisAlignedBB func_70114_g(Entity par1Entity) {
        return null;
    }

    public String getTex() {
        return this.getEnumSlideDoor(this.getDataDoorId()).getTex();
    }

    public void setMirror(boolean b) {
        this.setDataMirror(b);
    }

    public boolean isMirror() {
        return this.getDataMirror();
    }

    public byte getDir() {
        return this.getDataDir();
    }

    public void func_70037_a(NBTTagCompound nbttagcompound) {
        this.setDataDir(nbttagcompound.func_74771_c("dir"));
        this.setDataMirror(nbttagcompound.func_74767_n("mirror"));
        this.setDataMoveflg(nbttagcompound.func_74767_n("moveflg"));
        this.setDataisStop(nbttagcompound.func_74767_n("isStop"));
        if (this.getDataDir() == 0 || this.getDataDir() == 3) {
            this.setDataMovedir((byte)-1);
        } else {
            this.setDataMovedir((byte)1);
        }
        if (nbttagcompound.func_74764_b("doorId")) {
            this.setDataDoorId(nbttagcompound.func_74765_d("doorId"));
        } else if (nbttagcompound.func_74779_i("toptex").indexOf("husuma") != -1) {
            this.setDataDoorId(EnumSlideDoor.HUSUMA.getId());
        } else {
            this.setDataDoorId(EnumSlideDoor.SHOZI.getId());
        }
    }

    public void func_70014_b(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74774_a("dir", this.getDataDir());
        nbttagcompound.func_74757_a("mirror", this.getDataMirror());
        nbttagcompound.func_74757_a("moveflg", this.getDataMoveflg());
        nbttagcompound.func_74757_a("isStop", this.getDataisStop());
        nbttagcompound.func_74777_a("doorId", this.getDataDoorId());
    }

    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        if (!(this.field_70170_p.field_72995_K || this.getDataisStop() || this.field_70128_L)) {
            EntityPlayer entityplayer = null;
            if (par1DamageSource.field_76373_n != "player") {
                return false;
            }
            entityplayer = (EntityPlayer)par1DamageSource.func_76346_g();
            this.func_70106_y();
            if (entityplayer != null && entityplayer.field_71075_bZ.field_75098_d) {
                return true;
            }
            this.dropItem(this.getDataDoorId());
        }
        if (this.getDataisStop() && par1DamageSource.func_76346_g() != null) {
            double offsetPosX = this.field_70165_t;
            double offsetPosZ = this.field_70161_v;
            if (BambooUtil.getPlayerDir(par1DamageSource.func_76346_g()) == 0) {
                offsetPosZ += 0.05;
            }
            if (BambooUtil.getPlayerDir(par1DamageSource.func_76346_g()) == 2) {
                offsetPosZ -= 0.05;
            }
            if (BambooUtil.getPlayerDir(par1DamageSource.func_76346_g()) == 1) {
                offsetPosX -= 0.05;
            }
            if (BambooUtil.getPlayerDir(par1DamageSource.func_76346_g()) == 3) {
                offsetPosX += 0.05;
            }
            this.func_70107_b(offsetPosX, this.field_70163_u, offsetPosZ);
        }
        return true;
    }

    private void dropItem(short damage) {
        this.func_70099_a(new ItemStack(BambooInit.slideDoors, 1, (int)damage), 1.0f);
    }

    public void func_70100_b_(EntityPlayer par1EntityPlayer) {
        if (!this.getDataisStop() && !this.getDataMoveflg()) {
            this.doorOpen((Entity)par1EntityPlayer);
        }
        this.closeTimer = (byte)10;
    }

    public void func_70071_h_() {
        List collideEntity;
        if (!this.field_70170_p.field_72995_K && (collideEntity = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(1.0, 0.0, 1.0))) != null) {
            for (Entity entity : collideEntity) {
                if (entity.field_70128_L || !(entity instanceof EntityTameable)) continue;
                if (!this.getDataisStop() && !this.getDataMoveflg()) {
                    this.doorOpen(entity);
                }
                this.closeTimer = (byte)30;
            }
        }
        if (!this.getDataisStop()) {
            if (this.closeTimer < 0 && this.getDataMoveflg()) {
                this.doorClose();
            } else {
                this.closeTimer = (byte)(this.closeTimer - 1);
            }
        }
    }

    private void doorOpen(Entity entity) {
        if (!this.getDataMoveflg() && this.isOpendir(0, 2, entity)) {
            this.field_70165_t -= (double)this.getDataMovedir();
            this.field_70121_D.func_72317_d((double)(-this.getDataMovedir()), 0.0, 0.0);
            this.setDataMoveflg(true);
        }
        if (!this.getDataMoveflg() && this.isOpendir(1, 3, entity)) {
            this.field_70161_v -= (double)this.getDataMovedir();
            this.field_70121_D.func_72317_d(0.0, 0.0, (double)(-this.getDataMovedir()));
            this.setDataMoveflg(true);
        }
    }

    private void doorClose() {
        if (this.getDataMoveflg() && (this.getDataDir() == 0 || this.getDataDir() == 2)) {
            this.field_70165_t += (double)this.getDataMovedir();
            this.field_70121_D.func_72317_d((double)this.getDataMovedir(), 0.0, 0.0);
            this.setDataMoveflg(false);
        }
        if (this.getDataMoveflg() && (this.getDataDir() == 1 || this.getDataDir() == 3)) {
            this.field_70161_v += (double)this.getDataMovedir();
            this.field_70121_D.func_72317_d(0.0, 0.0, (double)this.getDataMovedir());
            this.setDataMoveflg(false);
        }
    }

    private boolean isOpendir(int i, int i2, Entity entity) {
        byte pdir = BambooUtil.getPlayerDir(entity);
        if (!(this.getDataDir() == i ? pdir == i || pdir == i2 : this.getDataDir() == i2 && (pdir == i || pdir == i2))) {
            return false;
        }
        switch (this.getDataDir()) {
            case 1: 
            case 3: {
                if (!(Math.abs(this.field_70161_v - entity.field_70161_v) < 0.75)) break;
                return true;
            }
            case 0: 
            case 2: {
                if (!(Math.abs(this.field_70165_t - entity.field_70165_t) < 0.75)) break;
                return true;
            }
        }
        return false;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_75682_a(17, (Object)0);
        this.field_70180_af.func_75682_a(18, (Object)0);
        this.field_70180_af.func_75682_a(19, (Object)0);
        this.field_70180_af.func_75682_a(22, (Object)0);
        this.field_70180_af.func_75682_a(23, (Object)0);
        this.field_70180_af.func_75682_a(20, (Object)0);
    }

    private byte getDataDir() {
        return this.field_70180_af.func_75683_a(17);
    }

    private boolean getDataMirror() {
        return this.field_70180_af.func_75683_a(18) == 1;
    }

    private boolean getDataMoveflg() {
        return this.field_70180_af.func_75683_a(19) == 1;
    }

    private byte getDataMovedir() {
        return this.field_70180_af.func_75683_a(23);
    }

    private boolean getDataisStop() {
        return this.field_70180_af.func_75683_a(22) == 1;
    }

    private short getDataDoorId() {
        return this.field_70180_af.func_75693_b(20);
    }

    public EntitySlideDoor setDataDir(byte b) {
        this.field_70180_af.func_75692_b(17, (Object)b);
        return this;
    }

    public void setDataMirror(boolean flg) {
        this.field_70180_af.func_75692_b(18, (Object)(flg ? (byte)1 : 0));
    }

    public void setDataMoveflg(boolean flg) {
        this.field_70180_af.func_75692_b(19, (Object)(flg ? (byte)1 : 0));
    }

    public void setDataMovedir(byte dir) {
        this.field_70180_af.func_75692_b(23, (Object)dir);
    }

    public EntitySlideDoor setDataisStop(boolean flg) {
        this.field_70180_af.func_75692_b(22, (Object)(flg ? (byte)1 : 0));
        return this;
    }

    public EntitySlideDoor setDataDoorId(short id) {
        this.field_70180_af.func_75692_b(20, (Object)id);
        return this;
    }

    public boolean func_70027_ad() {
        return false;
    }

    public boolean isBlend() {
        return this.getEnumSlideDoor(this.getDataDoorId()).isBlend();
    }

    private EnumSlideDoor getEnumSlideDoor(int id) {
        if (id < tex.length) {
            return tex[id];
        }
        this.setDataDoorId(EnumSlideDoor.HUSUMA.getId());
        return EnumSlideDoor.HUSUMA;
    }
}

