/*
 * Decompiled with CFR 0.152.
 */
package ruby.bamboo.entity;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import ruby.bamboo.BambooInit;

public class EntityBambooSpear
extends EntityArrow {
    private int xTile = -1;
    private int yTile = -1;
    private int zTile = -1;
    private boolean inGround;
    private Block inTile;
    private int inData;
    private int ticksInGround;
    private int ticksInAir;
    private int knockbackStrength;
    private float power;
    private int count;
    private boolean isBarrage;
    private boolean isDie;
    private boolean isExplode = false;
    private Entity hitEntity;
    private int explodeTimer;
    private int maxAge = 600;
    private static final ArrayList<Class<Entity>> ignoreList;

    public EntityBambooSpear(World par1World) {
        super(par1World);
    }

    public EntityBambooSpear(World par1World, double par2, double par4, double par6) {
        super(par1World, par2, par4, par6);
        this.field_70251_a = 1;
    }

    public EntityBambooSpear(World par1World, EntityLivingBase par2EntityLiving, EntityLivingBase par3EntityLiving, float par4, float par5) {
        super(par1World, par2EntityLiving, par3EntityLiving, par4, par5);
    }

    public EntityBambooSpear(World par1World, EntityLivingBase par2EntityLiving, float par3) {
        super(par1World, par2EntityLiving, par3);
        this.count = 0;
        this.power = par3;
        this.isBarrage = false;
        this.isDie = false;
        this.field_70250_c = par2EntityLiving;
    }

    public EntityBambooSpear(World par1World, EntityBambooSpear par2EntityBambooSpear, float par3, boolean canBePicedUp) {
        super(par1World);
        this.field_70155_l = 10.0;
        this.field_70250_c = par2EntityBambooSpear;
        if (canBePicedUp) {
            this.field_70251_a = 1;
        }
        this.func_70105_a(0.5f, 0.5f);
        this.func_70012_b(par2EntityBambooSpear.field_70165_t, par2EntityBambooSpear.field_70163_u + (double)par2EntityBambooSpear.func_70047_e(), par2EntityBambooSpear.field_70161_v, par2EntityBambooSpear.field_70177_z, par2EntityBambooSpear.field_70125_A);
        this.field_70165_t -= (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        this.field_70163_u -= (double)0.1f;
        this.field_70161_v -= (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.field_70129_M = 0.0f;
        this.field_70159_w = -MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.field_70179_y = MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.field_70181_x = -MathHelper.func_76126_a((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.func_70186_c(this.field_70159_w, this.field_70181_x, this.field_70179_y, par3 * 1.5f, 1.0f);
    }

    public void setExplode() {
        this.isExplode = true;
    }

    public void setBarrage(int attackCount) {
        this.count = attackCount;
        this.isBarrage = true;
    }

    public void setMaxAge(int maxAge) {
        this.maxAge = maxAge;
    }

    public double func_70242_d() {
        return this.isExplode ? 0.0 : super.func_70242_d();
    }

    public void func_70071_h_() {
        this.func_70030_z();
        this.onUpdateArrow();
        if (0 < this.count) {
            this.field_70170_p.func_72956_a(this.field_70250_c, "random.bow", 1.0f, 1.0f / (this.field_70146_Z.nextFloat() * 0.4f + 1.2f) + this.power * 0.5f);
            if (!this.field_70170_p.field_72995_K) {
                EntityBambooSpear ebs = ignoreList.contains(this.field_70250_c.getClass()) ? new EntityBambooSpear(this.field_70170_p, this, this.power, true) : new EntityBambooSpear(this.field_70170_p, (EntityLivingBase)this.field_70250_c, this.power);
                if (this.isExplode) {
                    ebs.setExplode();
                }
                ebs.func_70243_d(this.power >= 1.0f);
                ebs.setBarrage(0);
                ebs.func_70239_b(this.func_70242_d() * 0.7);
                ebs.func_70015_d(this.func_70027_ad() ? 100 : 0);
                ebs.field_70251_a = this.field_70251_a;
                ebs.setMaxAge(this.maxAge);
                this.field_70170_p.func_72838_d((Entity)ebs);
            }
            --this.count;
        } else if (this.isDie) {
            this.func_70106_y();
        }
        if (this.isExplode && this.hitEntity != null && this.explodeTimer++ > 60 && !this.hitEntity.field_70128_L) {
            this.hitEntity.field_70181_x += 0.8;
            this.field_70170_p.func_72876_a((Entity)this, this.hitEntity.field_70165_t, this.hitEntity.field_70163_u + 1.0, this.hitEntity.field_70161_v, 0.0f, true);
            this.func_70106_y();
        }
    }

    private void onUpdateArrow() {
        Block var16;
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float var1 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70126_B = this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
            this.field_70127_C = this.field_70125_A = (float)(Math.atan2(this.field_70181_x, var1) * 180.0 / Math.PI);
        }
        if ((var16 = this.field_70170_p.func_147439_a(this.xTile, this.yTile, this.zTile)) != Blocks.field_150350_a) {
            var16.func_149719_a((IBlockAccess)this.field_70170_p, this.xTile, this.yTile, this.zTile);
            AxisAlignedBB var2 = var16.func_149668_a(this.field_70170_p, this.xTile, this.yTile, this.zTile);
            if (var2 != null && var2.func_72318_a(Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v))) {
                this.inGround = true;
            }
        }
        if (this.field_70249_b > 0) {
            --this.field_70249_b;
        }
        if (this.inGround) {
            Block var18 = this.field_70170_p.func_147439_a(this.xTile, this.yTile, this.zTile);
            int var19 = this.field_70170_p.func_72805_g(this.xTile, this.yTile, this.zTile);
            if (var18 == this.inTile && var19 == this.inData) {
                ++this.ticksInGround;
                if (this.ticksInGround == this.maxAge) {
                    this.func_70106_y();
                }
            } else {
                this.inGround = false;
                this.field_70159_w *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.field_70181_x *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.field_70179_y *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.ticksInGround = 0;
                this.ticksInAir = 0;
            }
        } else {
            float var11;
            ++this.ticksInAir;
            Vec3 var17 = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
            Vec3 var3 = Vec3.func_72443_a((double)(this.field_70165_t + this.field_70159_w), (double)(this.field_70163_u + this.field_70181_x), (double)(this.field_70161_v + this.field_70179_y));
            MovingObjectPosition var4 = this.field_70170_p.func_147447_a(var17, var3, false, true, false);
            var17 = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
            var3 = Vec3.func_72443_a((double)(this.field_70165_t + this.field_70159_w), (double)(this.field_70163_u + this.field_70181_x), (double)(this.field_70161_v + this.field_70179_y));
            if (var4 != null) {
                var3 = Vec3.func_72443_a((double)var4.field_72307_f.field_72450_a, (double)var4.field_72307_f.field_72448_b, (double)var4.field_72307_f.field_72449_c);
            }
            Entity var5 = null;
            List var6 = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72314_b(1.0, 1.0, 1.0));
            double var7 = 0.0;
            for (Entity var10 : var6) {
                double var14;
                AxisAlignedBB var12;
                MovingObjectPosition var13;
                if (!var10.func_70067_L() || var10 == this.field_70250_c && this.ticksInAir < 5 || (var13 = (var12 = var10.field_70121_D.func_72314_b((double)(var11 = 0.3f), (double)var11, (double)var11)).func_72327_a(var17, var3)) == null || !((var14 = var17.func_72438_d(var13.field_72307_f)) < var7) && var7 != 0.0) continue;
                var5 = var10;
                var7 = var14;
            }
            if (var5 != null) {
                var4 = new MovingObjectPosition(var5);
            }
            if (var4 != null) {
                if (var4.field_72308_g != null) {
                    if (!ignoreList.contains(var4.field_72308_g.getClass())) {
                        float var20 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y));
                        int var24 = MathHelper.func_76143_f((double)((double)var20 * 0.7 * this.func_70242_d()));
                        if (this.func_70241_g()) {
                            var24 += this.field_70146_Z.nextInt(var24 / 2 + 2);
                        }
                        DamageSource var22 = null;
                        var22 = this.field_70250_c == null ? DamageSource.func_76353_a((EntityArrow)this, (Entity)this) : DamageSource.func_76353_a((EntityArrow)this, (Entity)this.field_70250_c);
                        if (this.func_70027_ad()) {
                            var4.field_72308_g.func_70015_d(5);
                        }
                        if (var4.field_72308_g.func_70097_a(var22, (float)var24)) {
                            if (var4.field_72308_g instanceof EntityLiving) {
                                float var25;
                                if (this.isExplode) {
                                    this.hitEntity = var4.field_72308_g;
                                }
                                if (this.isBarrage) {
                                    var4.field_72308_g.field_70172_ad = 0;
                                }
                                ++((EntityLiving)var4.field_72308_g).field_70720_be;
                                if (this.knockbackStrength > 0 && (var25 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y))) > 0.0f) {
                                    var4.field_72308_g.func_70024_g(this.field_70159_w * (double)this.knockbackStrength * (double)0.6f / (double)var25, 0.1, this.field_70179_y * (double)this.knockbackStrength * (double)0.6f / (double)var25);
                                }
                            }
                            this.field_70170_p.func_72956_a((Entity)this, "random.bowhit", 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
                            if (!this.isExplode) {
                                this.func_70106_y();
                            }
                        }
                    }
                } else {
                    this.xTile = var4.field_72311_b;
                    this.yTile = var4.field_72312_c;
                    this.zTile = var4.field_72309_d;
                    this.inTile = this.field_70170_p.func_147439_a(this.xTile, this.yTile, this.zTile);
                    this.inData = this.field_70170_p.func_72805_g(this.xTile, this.yTile, this.zTile);
                    this.field_70159_w = (float)(var4.field_72307_f.field_72450_a - this.field_70165_t);
                    this.field_70181_x = (float)(var4.field_72307_f.field_72448_b - this.field_70163_u);
                    this.field_70179_y = (float)(var4.field_72307_f.field_72449_c - this.field_70161_v);
                    float var20 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y));
                    this.field_70165_t -= this.field_70159_w / (double)var20 * (double)0.05f;
                    this.field_70163_u -= this.field_70181_x / (double)var20 * (double)0.05f;
                    this.field_70161_v -= this.field_70179_y / (double)var20 * (double)0.05f;
                    this.field_70170_p.func_72956_a((Entity)this, "random.bowhit", 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
                    this.inGround = true;
                    this.field_70249_b = 7;
                    this.func_70243_d(false);
                }
            }
            if (this.func_70241_g()) {
                for (int var21 = 0; var21 < 4; ++var21) {
                    this.field_70170_p.func_72869_a("crit", this.field_70165_t + this.field_70159_w * (double)var21 / 4.0, this.field_70163_u + this.field_70181_x * (double)var21 / 4.0, this.field_70161_v + this.field_70179_y * (double)var21 / 4.0, -this.field_70159_w, -this.field_70181_x + 0.2, -this.field_70179_y);
                }
            }
            this.field_70165_t += this.field_70159_w;
            this.field_70163_u += this.field_70181_x;
            this.field_70161_v += this.field_70179_y;
            float var20 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
            this.field_70125_A = (float)(Math.atan2(this.field_70181_x, var20) * 180.0 / Math.PI);
            while (this.field_70125_A - this.field_70127_C < -180.0f) {
                this.field_70127_C -= 360.0f;
            }
            while (this.field_70125_A - this.field_70127_C >= 180.0f) {
                this.field_70127_C += 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B < -180.0f) {
                this.field_70126_B -= 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B >= 180.0f) {
                this.field_70126_B += 360.0f;
            }
            this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
            this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
            float var23 = 0.99f;
            var11 = 0.05f;
            if (this.func_70090_H()) {
                for (int var26 = 0; var26 < 4; ++var26) {
                    float var27 = 0.25f;
                    this.field_70170_p.func_72869_a("bubble", this.field_70165_t - this.field_70159_w * (double)var27, this.field_70163_u - this.field_70181_x * (double)var27, this.field_70161_v - this.field_70179_y * (double)var27, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                }
                var23 = 0.8f;
            }
            this.field_70159_w *= (double)var23;
            this.field_70181_x *= (double)var23;
            this.field_70179_y *= (double)var23;
            this.field_70181_x -= (double)var11;
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            this.func_145775_I();
        }
    }

    public void func_70106_y() {
        if (this.count < 1) {
            super.func_70106_y();
        } else {
            this.isDie = true;
        }
    }

    public void func_70100_b_(EntityPlayer par1EntityPlayer) {
        if (!this.field_70170_p.field_72995_K && this.inGround && this.field_70249_b <= 0) {
            boolean var2;
            boolean bl = var2 = this.field_70251_a == 1 || this.field_70251_a == 2 && par1EntityPlayer.field_71075_bZ.field_75098_d;
            if (this.field_70251_a == 1 && !par1EntityPlayer.field_71071_by.func_70441_a(this.getPickUpItem())) {
                var2 = false;
            }
            if (var2) {
                this.field_70170_p.func_72956_a((Entity)this, "random.pop", 0.2f, ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                par1EntityPlayer.func_71001_a((Entity)this, 1);
                this.func_70106_y();
            }
        }
    }

    public ItemStack getPickUpItem() {
        if (this.isExplode) {
            return new ItemStack(BambooInit.bambooSpear, 1, 1);
        }
        return new ItemStack(BambooInit.bambooSpear, 1, 0);
    }

    static {
        String[] ignoreEntitys;
        ignoreList = new ArrayList();
        for (String str : ignoreEntitys = new String[]{"LittleMaid"}) {
            if (!EntityList.field_75625_b.containsKey(str)) continue;
            ignoreList.add((Class)EntityList.field_75625_b.get(str));
        }
        try {
            Class<?> fAva = Class.forName("LMM_EntityLittleMaidAvatar");
            ignoreList.add(fAva);
        }
        catch (ClassNotFoundException e) {
            System.out.println("LMM\u3092\u691c\u77e5\u3057\u307e\u305b\u3093\u3067\u3057\u305f");
        }
    }
}

