/*
 * Decompiled with CFR 0.152.
 */
package ruby.bamboo.block;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import ruby.bamboo.entity.EntityWhiteSmokeFX;
import ruby.bamboo.tileentity.spa.ITileEntitySpa;
import ruby.bamboo.tileentity.spa.TileEntitySpaChild;

public class BlockSpaWater
extends BlockLiquid
implements ITileEntityProvider {
    private static final ForgeDirection[] directions = new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.WEST, ForgeDirection.EAST};

    public BlockSpaWater() {
        super(Material.field_151586_h);
        float f = 0.0f;
        float f1 = 0.0f;
        this.func_149676_a(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        this.func_149675_a(true);
        this.func_149649_H();
        this.func_149722_s();
        this.func_149752_b(6000000.0f);
        this.func_149713_g(0);
        this.field_149758_A = true;
    }

    public void func_149749_a(World p_149749_1_, int p_149749_2_, int p_149749_3_, int p_149749_4_, Block p_149749_5_, int p_149749_6_) {
        super.func_149749_a(p_149749_1_, p_149749_2_, p_149749_3_, p_149749_4_, p_149749_5_, p_149749_6_);
        p_149749_1_.func_147475_p(p_149749_2_, p_149749_3_, p_149749_4_);
    }

    public boolean func_149696_a(World p_149696_1_, int p_149696_2_, int p_149696_3_, int p_149696_4_, int p_149696_5_, int p_149696_6_) {
        super.func_149696_a(p_149696_1_, p_149696_2_, p_149696_3_, p_149696_4_, p_149696_5_, p_149696_6_);
        TileEntity tileentity = p_149696_1_.func_147438_o(p_149696_2_, p_149696_3_, p_149696_4_);
        return tileentity != null ? tileentity.func_145842_c(p_149696_5_, p_149696_6_) : false;
    }

    public int func_149635_D() {
        return 0xFFFFFF;
    }

    private int getWaterColor(IBlockAccess iblockaccess, int posX, int posY, int posZ) {
        ITileEntitySpa tsp = (ITileEntitySpa)iblockaccess.func_147438_o(posX, posY, posZ);
        if (tsp != null) {
            return tsp.getColor();
        }
        return 0xFFFFFF;
    }

    public void func_149670_a(World world, int posX, int posY, int posZ, Entity entity) {
        if (!world.field_72995_K) {
            if (entity instanceof EntityLivingBase) {
                ((ITileEntitySpa)world.func_147438_o(posX, posY, posZ)).onEntityLivingCollision((EntityLivingBase)entity);
            } else if (entity instanceof EntityItem) {
                ((ITileEntitySpa)world.func_147438_o(posX, posY, posZ)).onEntityItemCollision((EntityItem)entity);
            }
        }
    }

    public int func_149720_d(IBlockAccess iblockaccess, int i, int j, int k) {
        return this.getWaterColor(iblockaccess, i, j, k);
    }

    public void func_149674_a(World world, int posX, int posY, int posZ, Random random) {
        if (!world.field_72995_K) {
            ITileEntitySpa tileSpa = (ITileEntitySpa)world.func_147438_o(posX, posY, posZ);
            if (tileSpa == null) {
                world.func_147468_f(posX, posY, posZ);
            } else {
                int meta = world.func_72805_g(posX, posY, posZ);
                if (meta != tileSpa.getLastTickMeta()) {
                    this.setTickSchedule(world, posX, posY, posZ, tileSpa);
                    tileSpa.setLastTickMeta(meta);
                } else {
                    tileSpa.setTickSchedule(false);
                }
                if (tileSpa.isStay()) {
                    if (world.func_147439_a(posX, posY - 1, posZ) != this) {
                        this.spread(world, posX, posY, posZ, meta, world.field_73012_v);
                    }
                } else {
                    this.waterLevelDown(world, posX, posY, posZ);
                }
            }
        }
    }

    private void setTickSchedule(World world, int posX, int posY, int posZ, ITileEntitySpa tileSpa) {
        world.func_147464_a(posX, posY, posZ, (Block)this, this.func_149738_a(world));
        tileSpa.setTickSchedule(true);
    }

    private void spread(World world, int posX, int posY, int posZ, int meta, Random random) {
        if (this.canSpread(world, posX, posY, posZ)) {
            if (this.isDirOffsettedIsAirBlock(world, posX, posY, posZ, ForgeDirection.DOWN)) {
                if (posY >= 0) {
                    this.setThisChildBlock(world, posX, posY, posZ, 0, ForgeDirection.DOWN);
                }
            } else {
                ForgeDirection dirTravel = this.getDirTravel(world, posX, posY, posZ);
                if (this.getDirOffsettedBlockID(world, posX, posY, posZ, dirTravel) == this) {
                    if (meta < this.getDirOffsettedMetadata(world, posX, posY, posZ, dirTravel)) {
                        this.waterLevelUP(world, posX, posY, posZ, dirTravel);
                    }
                } else if (this.isDirOffsettedIsAirBlock(world, posX, posY, posZ, dirTravel)) {
                    this.setThisChildBlock(world, posX, posY, posZ, dirTravel);
                }
            }
        }
    }

    private ForgeDirection getDirTravel(World world, int posX, int posY, int posZ) {
        ForgeDirection resultDir = ForgeDirection.NORTH;
        int meta = 0;
        for (ForgeDirection dir : directions) {
            if (this.isDirOffsettedIsAirBlock(world, posX, posY, posZ, dir)) {
                resultDir = dir;
                break;
            }
            int targetMeta = this.getDirOffsettedMetadata(world, posX, posY, posZ, dir);
            if (this.getDirOffsettedBlockID(world, posX, posY, posZ, dir) != this || meta >= targetMeta) continue;
            resultDir = dir;
            meta = targetMeta;
        }
        return resultDir;
    }

    private boolean isDirOffsettedIsAirBlock(World world, int posX, int posY, int posZ, ForgeDirection dir) {
        return world.func_147437_c(posX + dir.offsetX, posY + dir.offsetY, posZ + dir.offsetZ);
    }

    private Block getDirOffsettedBlockID(World world, int posX, int posY, int posZ, ForgeDirection dir) {
        return world.func_147439_a(posX + dir.offsetX, posY + dir.offsetY, posZ + dir.offsetZ);
    }

    private int getDirOffsettedMetadata(World world, int posX, int posY, int posZ, ForgeDirection dir) {
        return world.func_72805_g(posX + dir.offsetX, posY + dir.offsetY, posZ + dir.offsetZ);
    }

    private void setThisChildBlock(World world, int posX, int posY, int posZ, int amount, ForgeDirection dir) {
        world.func_147465_d(posX + dir.offsetX, posY + dir.offsetY, posZ + dir.offsetZ, (Block)this, amount, 3);
        TileEntity tile = world.func_147438_o(posX + dir.offsetX, posY + dir.offsetY, posZ + dir.offsetZ);
        if (tile instanceof TileEntitySpaChild) {
            ((TileEntitySpaChild)tile).setParentPosition(((ITileEntitySpa)world.func_147438_o(posX, posY, posZ)).getParentPosition());
        } else {
            world.func_147468_f(posX + dir.offsetX, posY + dir.offsetY, posZ + dir.offsetZ);
        }
    }

    private void setThisChildBlock(World world, int posX, int posY, int posZ, ForgeDirection dir) {
        this.setThisChildBlock(world, posX, posY, posZ, 7, dir);
    }

    private boolean canSpread(World world, int posX, int posY, int posZ) {
        return world.func_72805_g(posX, posY, posZ) < 7;
    }

    private void waterLevelUP(World world, int posX, int posY, int posZ) {
        int meta = world.func_72805_g(posX, posY, posZ);
        if (meta > 0) {
            world.func_72921_c(posX, posY, posZ, meta - 1, 3);
        }
    }

    private void waterLevelUP(World world, int posX, int posY, int posZ, ForgeDirection dir) {
        this.waterLevelUP(world, posX + dir.offsetX, posY + dir.offsetY, posZ + dir.offsetZ);
    }

    private void waterLevelDown(World world, int posX, int posY, int posZ) {
        int meta = world.func_72805_g(posX, posY, posZ);
        if (meta < 7) {
            world.func_72921_c(posX, posY, posZ, meta + 1, 3);
        } else {
            world.func_147468_f(posX, posY, posZ);
        }
    }

    public void func_149695_a(World world, int posX, int posY, int posZ, Block par5) {
        ITileEntitySpa tileSpa;
        if (!world.field_72995_K && (tileSpa = (ITileEntitySpa)world.func_147438_o(posX, posY, posZ)) != null && !tileSpa.isTickScheduled()) {
            this.setTickSchedule(world, posX, posY, posZ, tileSpa);
        }
    }

    public void func_149726_b(World par1World, int par2, int par3, int par4) {
        super.func_149726_b(par1World, par2, par3, par4);
        par1World.func_147464_a(par2, par3, par4, (Block)this, this.func_149738_a(par1World));
    }

    public int func_149738_a(World par1World) {
        return 20;
    }

    public int func_149645_b() {
        return 4;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    public boolean func_149747_d(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, int par5) {
        return false;
    }

    public boolean func_149646_a(IBlockAccess iblockaccess, int i, int j, int k, int l) {
        Material material = iblockaccess.func_147439_a(i, j, k).func_149688_o();
        if (material == this.field_149764_J) {
            return false;
        }
        if (l == 1) {
            return true;
        }
        return super.func_149646_a(iblockaccess, i, j, k, l);
    }

    public int func_149701_w() {
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World par1World, int par2, int par3, int par4, Random par5Random) {
        int j1;
        if (par5Random.nextInt(10) == 0 && par1World.func_147437_c(par2, par3 + 1, par4)) {
            FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((EntityFX)new EntityWhiteSmokeFX(par1World, (double)par2 + 0.5, par3 + 1, (double)par4 + 0.5, 0.0, 0.0, 0.0, 1.0f));
            int l = par1World.func_72805_g(par2, par3, par4);
            if (l <= 0 || l >= 8) {
                par1World.func_72869_a("suspended", (double)((float)par2 + par5Random.nextFloat()), (double)((float)par3 + par5Random.nextFloat()), (double)((float)par4 + par5Random.nextFloat()), 0.0, 0.0, 0.0);
            }
        }
        for (int i1 = 0; i1 < 0; ++i1) {
            int k1 = par5Random.nextInt(4);
            int l1 = par2;
            int i2 = par4;
            if (k1 == 0) {
                --l1;
            }
            if (k1 == 1) {
                ++l1;
            }
            if (k1 == 2) {
                --i2;
            }
            if (k1 == 3) {
                ++i2;
            }
            if (par1World.func_147439_a(l1, par3, i2).func_149688_o() != Material.field_151579_a || !par1World.func_147439_a(l1, par3 - 1, i2).func_149688_o().func_76230_c() && !par1World.func_147439_a(l1, par3 - 1, i2).func_149688_o().func_76224_d()) continue;
            float f = 0.0625f;
            double d6 = (float)par2 + par5Random.nextFloat();
            double d7 = (float)par3 + par5Random.nextFloat();
            double d8 = (float)par4 + par5Random.nextFloat();
            if (k1 == 0) {
                d6 = (float)par2 - f;
            }
            if (k1 == 1) {
                d6 = (float)(par2 + 1) + f;
            }
            if (k1 == 2) {
                d8 = (float)par4 - f;
            }
            if (k1 == 3) {
                d8 = (float)(par4 + 1) + f;
            }
            double d9 = 0.0;
            double d10 = 0.0;
            if (k1 == 0) {
                d9 = -f;
            }
            if (k1 == 1) {
                d9 = f;
            }
            if (k1 == 2) {
                d10 = -f;
            }
            if (k1 == 3) {
                d10 = f;
            }
            par1World.func_72869_a("splash", d6, d7, d8, d9, 0.0, d10);
        }
        if (par5Random.nextInt(64) == 0 && (j1 = par1World.func_72805_g(par2, par3, par4)) > 0 && j1 < 8) {
            par1World.func_72908_a((double)((float)par2 + 0.5f), (double)((float)par3 + 0.5f), (double)((float)par4 + 0.5f), "liquid.water", par5Random.nextFloat() * 0.25f + 0.75f, par5Random.nextFloat() * 1.0f + 0.5f);
        }
        if (par5Random.nextInt(10) == 0 && par1World.func_147445_c(par2, par3 - 1, par4, false) && !par1World.func_147439_a(par2, par3 - 2, par4).func_149688_o().func_76220_a()) {
            double d1 = (float)par2 + par5Random.nextFloat();
            double d3 = (double)par3 - 1.05;
            double d5 = (float)par4 + par5Random.nextFloat();
            par1World.func_72869_a("dripWater", d1, d3, d5, 0.0, 0.0, 0.0);
        }
    }

    public AxisAlignedBB func_149668_a(World world, int i, int j, int k) {
        return null;
    }

    public AxisAlignedBB func_149633_g(World world, int i, int j, int k) {
        return AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
    }

    public TileEntity func_149915_a(World var1, int var2) {
        return new TileEntitySpaChild();
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        return null;
    }
}

