/*
 * Decompiled with CFR 0.152.
 */
package com.mumfrey.liteloader.core;

import com.mumfrey.liteloader.JoinGameListener;
import com.mumfrey.liteloader.PacketHandler;
import com.mumfrey.liteloader.ServerChatFilter;
import com.mumfrey.liteloader.api.InterfaceProvider;
import com.mumfrey.liteloader.api.Listener;
import com.mumfrey.liteloader.common.transformers.PacketEventInfo;
import com.mumfrey.liteloader.core.InterfaceRegistrationDelegate;
import com.mumfrey.liteloader.core.LiteLoader;
import com.mumfrey.liteloader.core.event.HandlerList;
import com.mumfrey.liteloader.core.runtime.Packets;
import com.mumfrey.liteloader.interfaces.FastIterable;
import com.mumfrey.liteloader.interfaces.FastIterableDeque;
import com.mumfrey.liteloader.util.log.LiteLoaderLogger;
import java.util.List;

public abstract class PacketEvents
implements InterfaceProvider {
    protected static PacketEvents instance;
    protected final LiteLoader loader;
    private PacketHandlerList[] packetHandlers = new PacketHandlerList[Packets.count()];
    private FastIterable<ServerChatFilter> serverChatFilters = new HandlerList<ServerChatFilter>(ServerChatFilter.class, HandlerList.ReturnLogicOp.AND_BREAK_ON_FALSE);
    private FastIterableDeque<JoinGameListener> joinGameListeners = new HandlerList<JoinGameListener>(JoinGameListener.class);
    private final int loginSuccessPacketId = Packets.S02PacketLoginSuccess.getIndex();
    private final int serverChatPacketId = Packets.S02PacketChat.getIndex();
    private final int clientChatPacketId = Packets.C01PacketChatMessage.getIndex();
    private final int joinGamePacketId = Packets.S01PacketJoinGame.getIndex();
    private final int serverPayloadPacketId = Packets.S3FPacketCustomPayload.getIndex();
    private final int clientPayloadPacketId = Packets.C17PacketCustomPayload.getIndex();

    public PacketEvents() {
        instance = this;
        this.loader = LiteLoader.getInstance();
    }

    @Override
    public Class<? extends Listener> getListenerBaseType() {
        return Listener.class;
    }

    @Override
    public void registerInterfaces(InterfaceRegistrationDelegate delegate) {
        delegate.registerInterface(PacketHandler.class);
        delegate.registerInterface(JoinGameListener.class);
        delegate.registerInterface(ServerChatFilter.class);
    }

    @Override
    public void initProvider() {
    }

    public void registerJoinGameListener(JoinGameListener joinGameListener) {
        this.joinGameListeners.add(joinGameListener);
    }

    public void registerServerChatFilter(ServerChatFilter serverChatFilter) {
        this.serverChatFilters.add(serverChatFilter);
    }

    public void registerPacketHandler(PacketHandler handler) {
        List<Class<? extends ft>> handledPackets = handler.getHandledPackets();
        if (handledPackets != null) {
            for (Class<? extends ft> packetClass : handledPackets) {
                String packetClassName = packetClass.getName();
                int packetId = Packets.indexOf(packetClassName);
                if (packetId == -1 || packetId >= this.packetHandlers.length) {
                    LiteLoaderLogger.warning("PacketHandler %s attempted to register a handler for unupported packet class %s", handler.getName(), packetClassName);
                    continue;
                }
                if (this.packetHandlers[packetId] == null) {
                    this.packetHandlers[packetId] = new PacketHandlerList();
                }
                this.packetHandlers[packetId].add(handler);
            }
        }
    }

    public static void handlePacket(PacketEventInfo<ft> e, fb netHandler) {
        instance.handlePacket(e, netHandler, e.getPacketId());
    }

    private void handlePacket(PacketEventInfo<ft> e, fb netHandler, int packetId) {
        if (this.handlePacketEvent(e, netHandler, packetId) || this.packetHandlers[packetId] == null || e.isCancelled()) {
            return;
        }
        if (((PacketHandler)this.packetHandlers[packetId].all()).handlePacket(netHandler, (ft)e.getSource())) {
            return;
        }
        e.cancel();
    }

    protected boolean handlePacketEvent(PacketEventInfo<ft> e, fb netHandler, int packetId) {
        ft packet = (ft)e.getSource();
        if (packetId == this.loginSuccessPacketId) {
            this.handlePacket(e, netHandler, (js)packet);
            return true;
        }
        if (packetId == this.serverChatPacketId) {
            this.handlePacket(e, netHandler, (gj)packet);
            return true;
        }
        if (packetId == this.clientChatPacketId) {
            this.handlePacket(e, netHandler, (ir)packet);
            return true;
        }
        if (packetId == this.joinGamePacketId) {
            this.handlePacket(e, netHandler, (hd)packet);
            return true;
        }
        if (packetId == this.serverPayloadPacketId) {
            this.handlePacket(e, netHandler, (gr)packet);
            return true;
        }
        if (packetId == this.clientPayloadPacketId) {
            this.handlePacket(e, netHandler, (iz)packet);
            return true;
        }
        return false;
    }

    protected abstract void handlePacket(PacketEventInfo<ft> var1, fb var2, js var3);

    protected abstract void handlePacket(PacketEventInfo<ft> var1, fb var2, gj var3);

    protected void handlePacket(PacketEventInfo<ft> e, fb netHandler, ir packet) {
        mw player;
        mw mw2 = player = netHandler instanceof nh ? ((nh)netHandler).b : null;
        if (!this.serverChatFilters.all().onChat(player, packet, packet.c())) {
            e.cancel();
        }
    }

    protected void handlePacket(PacketEventInfo<ft> e, fb netHandler, hd packet) {
        this.loader.onJoinGame(netHandler, packet);
        ((JoinGameListener)this.joinGameListeners.all()).onJoinGame(netHandler, packet);
    }

    protected void handlePacket(PacketEventInfo<ft> e, fb netHandler, gr packet) {
        LiteLoader.getClientPluginChannels().onPluginChannelMessage(packet);
    }

    protected void handlePacket(PacketEventInfo<ft> e, fb netHandler, iz packet) {
        LiteLoader.getServerPluginChannels().onPluginChannelMessage(netHandler, packet);
    }

    class PacketHandlerList
    extends HandlerList<PacketHandler> {
        private static final long serialVersionUID = 1L;

        PacketHandlerList() {
            super(PacketHandler.class, HandlerList.ReturnLogicOp.AND_BREAK_ON_FALSE);
        }
    }
}

