/*
 * Decompiled with CFR 0.152.
 */
package com.lulan.shincolle.utility;

import com.lulan.shincolle.init.ModBlocks;
import com.lulan.shincolle.proxy.ClientProxy;
import com.lulan.shincolle.tileentity.TileEntityLightBlock;
import com.lulan.shincolle.utility.LogHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.IFluidBlock;

public class BlockHelper {
    private static Random rand = new Random();

    public static int[] getSafeBlockWithin5x5(World world, int x, int y, int z) {
        return BlockHelper.getSafeBlockWithinRange(world, x, y, z, 3, 4, 3);
    }

    public static int[] getSafeBlockWithinRange(World world, int x, int y, int z, int ranX, int ranY, int ranZ) {
        int[] pos = new int[]{x, y, z};
        int xlimit = ranX * 2;
        int ylimit = ranY * 2;
        int zlimit = ranZ * 2;
        int x2 = 0;
        int y2 = 0;
        int z2 = 0;
        for (int ix = 0; ix <= xlimit; ++ix) {
            int addx = (ix & 1) == 0 ? ix * -1 : ix;
            x2 += addx;
            z2 = 0;
            for (int iz = 0; iz <= zlimit; ++iz) {
                int addz = (iz & 1) == 0 ? iz * -1 : iz;
                z2 += addz;
                y2 = 0;
                for (int iy = 0; iy <= ylimit; ++iy) {
                    int z3;
                    int x3 = pos[0] + x2;
                    int addy = (iy & 1) == 0 ? iy * -1 : iy;
                    int y3 = pos[1] + (y2 += addy);
                    if (!BlockHelper.checkBlockSafe(world, x3, y3, z3 = pos[2] + z2)) continue;
                    for (int decY = 0; decY <= MathHelper.func_76130_a((int)y2); ++decY) {
                        if (!BlockHelper.checkBlockCanStandAt(world.func_147439_a(x3, y3 - decY - 1, z3))) continue;
                        pos[0] = x3;
                        pos[1] = y3 - decY;
                        pos[2] = z3;
                        return pos;
                    }
                }
            }
        }
        LogHelper.info("DEBUG : find block fail");
        return null;
    }

    public static boolean checkBlockSafe(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        return BlockHelper.checkBlockSafe(block);
    }

    public static boolean checkBlockSafe(Block block) {
        return block.func_149688_o() == Material.field_151579_a || block == null || BlockHelper.checkBlockIsLiquid(block);
    }

    public static boolean checkBlockIsLiquid(Block block) {
        return block instanceof BlockLiquid || block instanceof IFluidBlock || block instanceof BlockFluidBase;
    }

    public static boolean checkBlockNearbyHasLiquid(World world, int x, int y, int z, int range) {
        for (int ix = -range; ix <= range; ++ix) {
            for (int iy = -range; iy <= range; ++iy) {
                for (int iz = -range; iz <= range; ++iz) {
                    if (!BlockHelper.checkBlockIsLiquid(world.func_147439_a(x + ix, y + iy, z + iz))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean checkBlockCanStandAt(Block block) {
        Material mat;
        return block != null && (mat = block.func_149688_o()) != Material.field_151579_a && mat != Material.field_151581_o && (BlockHelper.checkBlockIsLiquid(block) || block.func_149688_o().func_76230_c());
    }

    public static double[] findRandomPosition(Entity host, Entity target, double minDist, double randDist, int mode) {
        Block findBlock = null;
        double[] newPos = new double[]{0.0, 0.0, 0.0};
        for (int i = 0; i < 25; ++i) {
            switch (mode) {
                case 0: {
                    newPos[0] = rand.nextDouble() * randDist + minDist;
                    newPos[1] = rand.nextDouble() * randDist + target.field_70163_u + 1.0;
                    newPos[2] = rand.nextDouble() * randDist + minDist;
                    switch (rand.nextInt(4)) {
                        case 0: {
                            newPos[0] = target.field_70165_t + newPos[0];
                            newPos[2] = target.field_70161_v - newPos[2];
                            break;
                        }
                        case 1: {
                            newPos[0] = target.field_70165_t - newPos[0];
                            newPos[2] = target.field_70161_v + newPos[2];
                            break;
                        }
                        case 2: {
                            newPos[0] = target.field_70165_t - newPos[0];
                            newPos[2] = target.field_70161_v - newPos[2];
                            break;
                        }
                        case 3: {
                            newPos[0] = target.field_70165_t + newPos[0];
                            newPos[2] = target.field_70161_v + newPos[2];
                        }
                    }
                    break;
                }
                case 1: {
                    newPos[0] = rand.nextDouble() * randDist + minDist;
                    newPos[1] = rand.nextDouble() * randDist + target.field_70163_u + 0.5;
                    newPos[2] = rand.nextDouble() * randDist + minDist;
                    double dx = host.field_70165_t - target.field_70165_t;
                    double dz = host.field_70161_v - target.field_70161_v;
                    newPos[0] = dx > 0.0 ? target.field_70165_t - newPos[0] : target.field_70165_t + newPos[0];
                    if (dz > 0.0) {
                        newPos[2] = target.field_70161_v - newPos[2];
                        break;
                    }
                    newPos[2] = target.field_70161_v - newPos[2];
                    break;
                }
                case 2: {
                    newPos[0] = rand.nextDouble() * randDist + minDist;
                    newPos[1] = rand.nextDouble() * randDist + target.field_70163_u + 1.0;
                    newPos[2] = rand.nextDouble() * randDist + minDist;
                    newPos[0] = host.field_70159_w < 0.0 ? target.field_70165_t - newPos[0] : target.field_70165_t + newPos[0];
                    newPos[2] = host.field_70179_y < 0.0 ? target.field_70161_v - newPos[2] : target.field_70161_v + newPos[2];
                }
            }
            findBlock = host.field_70170_p.func_147439_a((int)newPos[0], (int)newPos[1], (int)newPos[2]);
            if (findBlock == null || findBlock != Blocks.field_150350_a && findBlock != Blocks.field_150355_j) continue;
            return newPos;
        }
        newPos[0] = target.field_70165_t;
        newPos[1] = target.field_70163_u + 2.0;
        newPos[2] = target.field_70161_v;
        return newPos;
    }

    @SideOnly(value=Side.CLIENT)
    public static MovingObjectPosition getPlayerMouseOverBlock(double dist, float duringTicks) {
        EntityPlayer player = ClientProxy.getClientPlayer();
        Vec3 vec3 = player.func_70666_h(duringTicks);
        Vec3 vec31 = player.func_70676_i(duringTicks);
        Vec3 vec32 = vec3.func_72441_c(vec31.field_72450_a * dist, vec31.field_72448_b * dist, vec31.field_72449_c * dist);
        return player.field_70170_p.func_147447_a(vec3, vec32, true, false, false);
    }

    public static void placeLightBlock(World world, int x, int y, int z) {
        for (int i = -1; i <= 1; ++i) {
            for (int j = 1; j <= 2; ++j) {
                for (int k = -1; k <= 1; ++k) {
                    TileEntity te;
                    Block b = world.func_147439_a(x + i, y + j, z + k);
                    if (b == Blocks.field_150355_j) {
                        world.func_147449_b(x + i, y + j, z + k, (Block)ModBlocks.BlockLightFluid);
                        return;
                    }
                    if (b == Blocks.field_150350_a) {
                        world.func_147449_b(x + i, y + j, z + k, ModBlocks.BlockLightAir);
                        return;
                    }
                    if (b != ModBlocks.BlockLightFluid || !((te = world.func_147438_o(x + i, y + j, z + k)) instanceof TileEntityLightBlock)) continue;
                    ((TileEntityLightBlock)te).tick = 1;
                    return;
                }
            }
        }
    }

    public static void updateNearbyLightBlock(World world, int x, int y, int z) {
        for (int i = -1; i <= 1; ++i) {
            for (int j = 1; j <= 2; ++j) {
                for (int k = -1; k <= 1; ++k) {
                    TileEntity te = world.func_147438_o(x + i, y + j, z + k);
                    if (!(te instanceof TileEntityLightBlock)) continue;
                    ((TileEntityLightBlock)te).tick = 1;
                    return;
                }
            }
        }
    }

    public static Set<ChunkCoordIntPair> getChunksWithinRange(World world, int x, int z, int mode) {
        HashSet<ChunkCoordIntPair> chunks = new HashSet<ChunkCoordIntPair>();
        switch (mode) {
            case 1: {
                chunks.add(new ChunkCoordIntPair(x, z));
                break;
            }
            case 2: {
                for (int i = -1; i <= 1; ++i) {
                    for (int j = -1; j <= 1; ++j) {
                        chunks.add(new ChunkCoordIntPair(x + i, z + j));
                    }
                }
                break;
            }
        }
        return chunks;
    }

    public static int getToppestWaterHeight(World world, int x, int y, int z) {
        int cy;
        Block b = world.func_147439_a(x, y, z);
        if (b != null && b.func_149688_o() == Material.field_151586_h) {
            for (cy = y + 1; cy < 255 && (b = world.func_147439_a(x, cy, z)) != null && b.func_149688_o() == Material.field_151586_h; ++cy) {
            }
        }
        return cy--;
    }
}

