/*
 * Decompiled with CFR 0.152.
 */
package com.lulan.shincolle.tileentity;

import com.lulan.shincolle.crafting.LargeRecipes;
import com.lulan.shincolle.entity.renderentity.EntityRenderVortex;
import com.lulan.shincolle.handler.ConfigHandler;
import com.lulan.shincolle.init.ModItems;
import com.lulan.shincolle.tileentity.BasicTileMulti;
import com.lulan.shincolle.tileentity.ITileLiquidFurnace;
import com.lulan.shincolle.utility.CalcHelper;
import com.lulan.shincolle.utility.TileEntityHelper;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileMultiGrudgeHeavy
extends BasicTileMulti
implements ITileLiquidFurnace,
IFluidHandler {
    private static final int TANKCAPA = 1000;
    private static final Fluid F_LAVA = FluidRegistry.LAVA;
    private FluidTank tank = new FluidTank(new FluidStack(F_LAVA, 0), 1000);
    private int powerConsumed = 0;
    private int powerRemained = 0;
    private int powerGoal = 0;
    private int buildType = 0;
    private int invMode = 0;
    private int selectMat = 0;
    private boolean isActive;
    private int[] matsBuild;
    private int[] matsStock;
    public static int buildSpeed = 48;
    public static final int POWERMAX = 1382400;
    public static final int SLOTS_NUM = 10;
    public static final int SLOTS_OUT = 0;
    public static final int[] SLOTS_ALL = new int[]{0, 2, 3, 4, 5, 6, 7, 8, 9};

    public TileMultiGrudgeHeavy() {
        this.slots = new ItemStack[10];
        this.isActive = false;
        this.matsBuild = new int[]{0, 0, 0, 0};
        this.matsStock = new int[]{0, 0, 0, 0};
        this.syncTime = 0;
        if (ConfigHandler.easyMode) {
            buildSpeed = 480;
        }
    }

    @Override
    public int[] func_94128_d(int side) {
        if (this.structType == 1 || this.structType == 2) {
            return SLOTS_ALL;
        }
        return new int[0];
    }

    @Override
    public String func_145825_b() {
        return this.func_145818_k_() ? this.customName : "tile.shincolle:BlockLargeShipyard";
    }

    @Override
    public boolean func_70300_a(EntityPlayer player) {
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.tank.readFromNBT(compound);
        NBTTagList list = compound.func_150295_c("Items", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound item = list.func_150305_b(i);
            byte sid = item.func_74771_c("Slot");
            if (sid < 0 || sid >= this.slots.length) continue;
            this.slots[sid] = ItemStack.func_77949_a((NBTTagCompound)item);
        }
        this.powerConsumed = compound.func_74762_e("powerConsumed");
        this.powerRemained = compound.func_74762_e("powerRemained");
        this.powerGoal = compound.func_74762_e("powerGoal");
        this.buildType = compound.func_74762_e("buildType");
        this.invMode = compound.func_74762_e("invMode");
        this.selectMat = compound.func_74762_e("selectMat");
        this.matsBuild = compound.func_74759_k("matsBuild");
        this.matsStock = compound.func_74759_k("matsStock");
    }

    @Override
    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        this.tank.writeToNBT(compound);
        NBTTagList list = new NBTTagList();
        compound.func_74782_a("Items", (NBTBase)list);
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] == null) continue;
            NBTTagCompound item = new NBTTagCompound();
            item.func_74774_a("Slot", (byte)i);
            this.slots[i].func_77955_b(item);
            list.func_74742_a((NBTBase)item);
        }
        compound.func_74768_a("powerConsumed", this.powerConsumed);
        compound.func_74768_a("powerRemained", this.powerRemained);
        compound.func_74768_a("powerGoal", this.powerGoal);
        compound.func_74768_a("buildType", this.buildType);
        compound.func_74768_a("invMode", this.invMode);
        compound.func_74768_a("selectMat", this.selectMat);
        compound.func_74783_a("matsBuild", this.matsBuild);
        compound.func_74783_a("matsStock", this.matsStock);
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack itemstack) {
        return slot != 0;
    }

    @Override
    public boolean func_102008_b(int slot, ItemStack itemstack, int side) {
        return true;
    }

    public void buildComplete() {
        switch (this.buildType) {
            default: {
                this.slots[0] = LargeRecipes.getBuildResultShip(this.matsBuild);
                break;
            }
            case 2: 
            case 4: {
                this.slots[0] = LargeRecipes.getBuildResultEquip(this.matsBuild);
            }
        }
    }

    public boolean isBuilding() {
        return this.hasPowerRemained() && this.canBuild();
    }

    public boolean hasPowerRemained() {
        return this.powerRemained > buildSpeed;
    }

    public boolean canBuild() {
        return this.powerGoal > 0 && this.slots[0] == null;
    }

    public void func_145845_h() {
        if (this.getStructType() == 0) {
            return;
        }
        boolean sendUpdate = false;
        this.powerGoal = this.buildType != 0 ? LargeRecipes.calcGoalPower(this.matsBuild) : 0;
        if (!this.field_145850_b.field_72995_K) {
            int i;
            if (TileEntityHelper.decrItemFuel(this)) {
                sendUpdate = true;
            }
            TileEntityHelper.decrLiquidFuel(this);
            if (this.invMode == 0) {
                for (i = 1; i < 10; ++i) {
                    if (!LargeRecipes.addMaterialStock(this, this.slots[i])) continue;
                    --this.slots[i].field_77994_a;
                    if (this.slots[i].field_77994_a == 0) {
                        this.slots[i] = null;
                    }
                    sendUpdate = true;
                    break;
                }
            } else {
                int compressNum = 9;
                int normalNum = 1;
                if (ConfigHandler.easyMode) {
                    compressNum = 90;
                    normalNum = 10;
                }
                if (this.getMatStock(this.selectMat) >= compressNum) {
                    if (LargeRecipes.outputMaterialToSlot(this, this.selectMat, true)) {
                        this.addMatStock(this.selectMat, -compressNum);
                        sendUpdate = true;
                    }
                } else if (this.getMatStock(this.selectMat) >= normalNum && LargeRecipes.outputMaterialToSlot(this, this.selectMat, false)) {
                    this.addMatStock(this.selectMat, -normalNum);
                    sendUpdate = true;
                }
            }
            if (this.isBuilding()) {
                ++this.syncTime;
                this.powerRemained -= buildSpeed;
                this.powerConsumed += buildSpeed;
                for (i = 1; i < 10; ++i) {
                    if (this.slots[i] == null || this.slots[i].func_77973_b() != ModItems.InstantConMat) continue;
                    --this.slots[i].field_77994_a;
                    this.powerConsumed += 57600;
                    if (this.slots[i].field_77994_a == 0) {
                        this.slots[i] = null;
                    }
                    sendUpdate = true;
                    break;
                }
                if (this.syncTime > 60) {
                    this.sendSyncPacket();
                    this.syncTime = 0;
                    sendUpdate = true;
                }
                if (this.powerConsumed >= this.powerGoal) {
                    this.buildComplete();
                    this.powerConsumed = 0;
                    this.powerGoal = 0;
                    switch (this.buildType) {
                        default: {
                            this.buildType = 0;
                            this.matsBuild[0] = 0;
                            this.matsBuild[1] = 0;
                            this.matsBuild[2] = 0;
                            this.matsBuild[3] = 0;
                            break;
                        }
                        case 3: 
                        case 4: {
                            this.setRepeatBuild();
                        }
                    }
                    sendUpdate = true;
                }
            }
            if (!this.canBuild()) {
                this.powerConsumed = 0;
            }
            if (this.isActive != this.isBuilding()) {
                this.isActive = this.isBuilding();
                AxisAlignedBB aabb = AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c - 1.5), (double)((double)this.field_145848_d - 1.5), (double)((double)this.field_145849_e - 1.5), (double)((double)this.field_145851_c + 1.5), (double)((double)this.field_145848_d + 0.5), (double)((double)this.field_145849_e + 1.5));
                List renderEntityList = this.field_145850_b.func_72872_a(EntityRenderVortex.class, aabb);
                for (int i2 = 0; i2 < renderEntityList.size(); ++i2) {
                    ((EntityRenderVortex)((Object)renderEntityList.get(i2))).setIsActive(this.isBuilding());
                }
                this.sendSyncPacket();
            }
        }
    }

    public void setRepeatBuild() {
        for (int i = 0; i < 4; ++i) {
            if (this.matsStock[i] >= this.matsBuild[i]) {
                int n = i;
                this.matsStock[n] = this.matsStock[n] - this.matsBuild[i];
                continue;
            }
            this.matsBuild[i] = 0;
            this.buildType = 0;
        }
    }

    public int getPowerRemainingScaled(int i) {
        return this.powerRemained * i / 1382400;
    }

    public String getBuildTimeString() {
        int timeSec = (this.powerGoal - this.powerConsumed) / buildSpeed / 20;
        return CalcHelper.getTimeFormated(timeSec);
    }

    @Override
    public int getPowerConsumed() {
        return this.powerConsumed;
    }

    @Override
    public int getPowerRemained() {
        return this.powerRemained;
    }

    @Override
    public int getPowerGoal() {
        return this.powerGoal;
    }

    @Override
    public int getPowerMax() {
        return 1382400;
    }

    public int getBuildType() {
        return this.buildType;
    }

    public int getInvMode() {
        return this.invMode;
    }

    public int getSelectMat() {
        return this.selectMat;
    }

    public int getMatBuild(int id) {
        return this.matsBuild[id];
    }

    public int getMatStock(int id) {
        return this.matsStock[id];
    }

    @Override
    public void setPowerConsumed(int par1) {
        this.powerConsumed = par1;
    }

    @Override
    public void setPowerRemained(int par1) {
        this.powerRemained = par1;
    }

    @Override
    public void setPowerGoal(int par1) {
        this.powerGoal = par1;
    }

    @Override
    public void setPowerMax(int par1) {
    }

    public void setBuildType(int par1) {
        this.buildType = par1;
    }

    public void setInvMode(int par1) {
        this.invMode = par1;
    }

    public void setSelectMat(int par1) {
        this.selectMat = par1;
    }

    public void setMatBuild(int id, int par1) {
        this.matsBuild[id] = par1;
    }

    public void setMatStock(int id, int par1) {
        this.matsStock[id] = par1;
    }

    public void addMatBuild(int id, int par1) {
        int n = id;
        this.matsBuild[n] = this.matsBuild[n] + par1;
    }

    public void addMatStock(int id, int par1) {
        int n = id;
        this.matsStock[n] = this.matsStock[n] + par1;
    }

    @Override
    public int getFuelSlotMin() {
        return 1;
    }

    @Override
    public int getFuelSlotMax() {
        return 9;
    }

    public int fill(ForgeDirection from, FluidStack fluid, boolean doFill) {
        if (TileEntityHelper.checkLiquidIsLava(fluid)) {
            return this.tank.fill(fluid, doFill);
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return TileEntityHelper.checkLiquidIsLava(fluid);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    @Override
    public int getFluidFuelAmount() {
        return this.tank.getFluidAmount();
    }

    @Override
    public FluidStack drainFluidFuel(int amount) {
        return this.tank.drain(amount, true);
    }
}

