/*
 * Decompiled with CFR 0.152.
 */
package com.lulan.shincolle.tileentity;

import com.lulan.shincolle.block.ItemBlockWaypoint;
import com.lulan.shincolle.entity.BasicEntityShip;
import com.lulan.shincolle.entity.ExtendShipProps;
import com.lulan.shincolle.handler.ConfigHandler;
import com.lulan.shincolle.init.ModBlocks;
import com.lulan.shincolle.init.ModItems;
import com.lulan.shincolle.item.PointerItem;
import com.lulan.shincolle.proxy.ClientProxy;
import com.lulan.shincolle.tileentity.BasicTileInventory;
import com.lulan.shincolle.tileentity.ITileWaypoint;
import com.lulan.shincolle.utility.EntityHelper;
import com.lulan.shincolle.utility.LogHelper;
import com.lulan.shincolle.utility.ParticleHelper;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.oredict.OreDictionary;

public class TileEntityCrane
extends BasicTileInventory
implements ITileWaypoint {
    public int lx;
    public int ly;
    public int lz;
    public int nx;
    public int ny;
    public int nz;
    public int cx;
    public int cy;
    public int cz;
    public int tick;
    public int playerUID;
    public int partDelay;
    public int itemMode;
    public int redMode;
    public int redTick;
    public boolean isActive;
    public boolean isPaired;
    public boolean checkMetadata;
    public boolean checkOredict;
    public boolean checkNbt;
    public boolean enabLoad;
    public boolean enabUnload;
    public int craneMode;
    public BasicEntityShip ship;
    private IInventory chest;

    public TileEntityCrane() {
        this.slots = new ItemStack[18];
        this.ship = null;
        this.chest = null;
        this.isActive = false;
        this.isPaired = false;
        this.enabLoad = true;
        this.enabUnload = true;
        this.checkMetadata = false;
        this.checkOredict = false;
        this.checkNbt = false;
        this.craneMode = 0;
        this.playerUID = 0;
        this.tick = 0;
        this.partDelay = 0;
        this.itemMode = 0;
        this.redMode = 0;
        this.redTick = 0;
        this.cx = -1;
        this.cy = -1;
        this.cz = -1;
        this.lx = -1;
        this.ly = -1;
        this.lz = -1;
        this.nx = -1;
        this.ny = -1;
        this.nz = -1;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagList list = nbt.func_150295_c("Items", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound item = list.func_150305_b(i);
            byte sid = item.func_74771_c("Slot");
            if (sid < 0 || sid >= this.slots.length) continue;
            this.slots[sid] = ItemStack.func_77949_a((NBTTagCompound)item);
        }
        this.isActive = nbt.func_74767_n("active");
        this.isPaired = nbt.func_74767_n("paired");
        this.enabLoad = nbt.func_74767_n("load");
        this.enabUnload = nbt.func_74767_n("unload");
        this.checkMetadata = nbt.func_74767_n("meta");
        this.checkOredict = nbt.func_74767_n("dict");
        this.checkNbt = nbt.func_74767_n("nbt");
        this.craneMode = nbt.func_74762_e("mode");
        this.playerUID = nbt.func_74762_e("uid");
        this.itemMode = nbt.func_74762_e("imode");
        this.redMode = nbt.func_74762_e("rmode");
        this.cx = nbt.func_74762_e("cx");
        this.cy = nbt.func_74762_e("cy");
        this.cz = nbt.func_74762_e("cz");
        this.lx = nbt.func_74762_e("lx");
        this.ly = nbt.func_74762_e("ly");
        this.lz = nbt.func_74762_e("lz");
        this.nx = nbt.func_74762_e("nx");
        this.ny = nbt.func_74762_e("ny");
        this.nz = nbt.func_74762_e("nz");
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        NBTTagList list = new NBTTagList();
        nbt.func_74782_a("Items", (NBTBase)list);
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] == null) continue;
            NBTTagCompound item = new NBTTagCompound();
            item.func_74774_a("Slot", (byte)i);
            this.slots[i].func_77955_b(item);
            list.func_74742_a((NBTBase)item);
        }
        nbt.func_74757_a("active", this.isActive);
        nbt.func_74757_a("paired", this.isPaired);
        nbt.func_74757_a("load", this.enabLoad);
        nbt.func_74757_a("unload", this.enabUnload);
        nbt.func_74757_a("meta", this.checkMetadata);
        nbt.func_74757_a("dict", this.checkOredict);
        nbt.func_74757_a("nbt", this.checkNbt);
        nbt.func_74768_a("mode", this.craneMode);
        nbt.func_74768_a("uid", this.playerUID);
        nbt.func_74768_a("imode", this.itemMode);
        nbt.func_74768_a("rmode", this.redMode);
        nbt.func_74768_a("cx", this.cx);
        nbt.func_74768_a("cy", this.cy);
        nbt.func_74768_a("cz", this.cz);
        nbt.func_74768_a("lx", this.lx);
        nbt.func_74768_a("ly", this.ly);
        nbt.func_74768_a("lz", this.lz);
        nbt.func_74768_a("nx", this.nx);
        nbt.func_74768_a("ny", this.ny);
        nbt.func_74768_a("nz", this.nz);
    }

    public void setPairedChest(int x, int y, int z) {
        TileEntity tile = this.field_145850_b.func_147438_o(x, y, z);
        if (tile instanceof IInventory) {
            this.cx = x;
            this.cy = y;
            this.cz = z;
            this.isPaired = true;
            this.chest = (IInventory)tile;
        } else {
            this.clearPairedChest();
        }
    }

    public void checkPairedChest() {
        if (this.isPaired) {
            TileEntity tile;
            if (this.chest == null && (tile = this.field_145850_b.func_147438_o(this.cx, this.cy, this.cz)) instanceof IInventory) {
                this.chest = (IInventory)tile;
            }
            if (this.chest instanceof IInventory && !((TileEntity)this.chest).func_145837_r()) {
                return;
            }
            this.clearPairedChest();
            this.sendSyncPacket();
        }
    }

    public void clearPairedChest() {
        this.chest = null;
        this.isPaired = false;
        this.cx = -1;
        this.cy = -1;
        this.cz = -1;
    }

    public void setSyncData(int[] data) {
        if (data != null) {
            this.lx = data[0];
            this.ly = data[1];
            this.lz = data[2];
            this.nx = data[3];
            this.ny = data[4];
            this.nz = data[5];
            this.setPairedChest(data[6], data[7], data[8]);
        }
    }

    @Override
    public void setNextWaypoint(int[] next) {
        if (next != null) {
            this.nx = next[0];
            this.ny = next[1];
            this.nz = next[2];
        }
    }

    @Override
    public int[] getNextWaypoint() {
        return new int[]{this.nx, this.ny, this.nz};
    }

    @Override
    public void setLastWaypoint(int[] next) {
        if (next != null) {
            this.lx = next[0];
            this.ly = next[1];
            this.lz = next[2];
        }
    }

    @Override
    public int[] getLastWaypoint() {
        return new int[]{this.lx, this.ly, this.lz};
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            boolean update = false;
            ++this.tick;
            if (this.redTick > 0) {
                --this.redTick;
                if (this.redTick <= 0) {
                    this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, ModBlocks.BlockCrane);
                }
            }
            if (this.isActive && this.isPaired && this.tick > 64 && this.tick % 16 == 0) {
                this.checkPairedChest();
                this.checkCraningShip();
                if (this.redMode == 1 && this.ship != null) {
                    this.redTick = 17;
                    this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, ModBlocks.BlockCrane);
                }
                if (this.chest != null && this.ship != null) {
                    boolean movedLoad = false;
                    boolean movedUnload = false;
                    boolean endCraning = false;
                    int waitTime = TileEntityCrane.getWaitTimeInMin(this.craneMode) * 1200;
                    try {
                        if (this.enabLoad) {
                            movedLoad = this.applyItemTransfer(true);
                        }
                        if (this.enabUnload) {
                            movedUnload = this.applyItemTransfer(false);
                        }
                        switch (this.craneMode) {
                            case 0: {
                                if (movedLoad || movedUnload) break;
                                endCraning = true;
                                break;
                            }
                            case 1: {
                                if (!this.checkWaitForever()) break;
                                endCraning = true;
                                break;
                            }
                            default: {
                                int t = this.ship.getStateTimer(1);
                                if (t <= waitTime) break;
                                endCraning = true;
                            }
                        }
                        if (endCraning) {
                            if (this.redMode == 2) {
                                this.redTick = 1;
                                this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, ModBlocks.BlockCrane);
                            }
                            this.ship.setStateMinor(43, 0);
                            this.ship.setStateTimer(1, 0);
                            if (EntityHelper.applyNextWaypoint(this, this.ship, false, 0)) {
                                this.ship.setStateMinor(10, 2);
                            }
                            this.ship.func_85030_a("shincolle:ship-bell", ConfigHandler.volumeShip * 1.5f, this.ship.func_70681_au().nextFloat() * 0.3f + 1.0f);
                            this.ship = null;
                        }
                    }
                    catch (Exception e) {
                        LogHelper.info("EXCEPTION : ship loading/unloading fail: " + e);
                        e.printStackTrace();
                        return;
                    }
                }
            }
            if (this.tick > 510) {
                this.tick = 0;
                if (this.ly > 0 || this.ny > 0 || this.cy > 0) {
                    update = true;
                }
            }
            if (update) {
                this.sendSyncPacket();
            }
        } else {
            ++this.tick;
            if (this.partDelay > 0) {
                --this.partDelay;
            }
            if (this.isActive && this.ship != null && this.partDelay <= 0) {
                this.partDelay = 128;
                double len = (double)this.field_145848_d - this.ship.field_70163_u - 1.0;
                if (len < 1.0) {
                    len = 1.0;
                }
                ParticleHelper.spawnAttackParticleAt((double)this.field_145851_c + 0.5, (double)this.field_145848_d - 1.0, (double)this.field_145849_e + 0.5, len, 0.0, 0.25, (byte)40);
            }
            if (this.tick % 16 == 0) {
                EntityPlayer player = ClientProxy.getClientPlayer();
                ItemStack item = player.field_71071_by.func_70448_g();
                if (item != null && (item.func_77973_b() instanceof ItemBlockWaypoint || item.func_77973_b() == ModItems.TargetWrench || item.func_77973_b() instanceof PointerItem && item.func_77960_j() < 3)) {
                    double dz;
                    double dy;
                    double dx;
                    if (this.ny > 0) {
                        dx = this.nx - this.field_145851_c;
                        dy = this.ny - this.field_145848_d;
                        dz = this.nz - this.field_145849_e;
                        ParticleHelper.spawnAttackParticleAt((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, dx *= 0.01, dy *= 0.01, dz *= 0.01, (byte)38);
                    }
                    if (this.cy > 0) {
                        dx = this.cx - this.field_145851_c;
                        dy = this.cy - this.field_145848_d;
                        dz = this.cz - this.field_145849_e;
                        ParticleHelper.spawnAttackParticleAt((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, dx *= 0.01, dy *= 0.01, dz *= 0.01, (byte)39);
                    }
                }
            }
        }
    }

    private boolean checkWaitForever() {
        boolean doneLoad = true;
        boolean doneUnload = true;
        boolean allNull = true;
        if (this.ship != null) {
            if (this.enabLoad) {
                doneLoad = this.checkInventoryFull(this.ship.getExtProps());
            }
            if (this.enabUnload) {
                for (int i = 0; i < 9; ++i) {
                    ExtendShipProps inv;
                    int slotid;
                    ItemStack temp = this.getItemstackTemp(i, false);
                    if (temp != null) {
                        allNull = false;
                        if (!this.getItemMode(i + 9) && (slotid = this.matchTempItem(inv = this.ship.getExtProps(), temp)) > 0) {
                            doneUnload = false;
                            break;
                        }
                    }
                    if (i != 8 || !allNull || (slotid = this.matchAnyItemExceptNotModeItem(inv = this.ship.getExtProps(), false)) <= 0) continue;
                    doneUnload = false;
                }
            }
        }
        return doneLoad && doneUnload;
    }

    private boolean checkInventoryFull(IInventory inv) {
        block5: {
            int i;
            block6: {
                block4: {
                    Object item = null;
                    i = 0;
                    if (!(inv instanceof ExtendShipProps)) break block4;
                    ((ExtendShipProps)inv).setInventoryPage(0);
                    for (i = 6; i < ((ExtendShipProps)inv).getSizeInventoryPaged(); ++i) {
                        if (inv.func_70301_a(i) != null) continue;
                        return false;
                    }
                    break block5;
                }
                if (!(inv instanceof TileEntityChest)) break block6;
                for (i = 0; i < inv.func_70302_i_(); ++i) {
                    if (inv.func_70301_a(i) != null) continue;
                    return false;
                }
                TileEntityChest chest2 = this.getAdjChest((TileEntityChest)inv);
                if (chest2 == null) break block5;
                for (i = 0; i < chest2.func_70302_i_(); ++i) {
                    if (chest2.func_70301_a(i) != null) continue;
                    return false;
                }
                break block5;
            }
            for (i = 0; i < inv.func_70302_i_(); ++i) {
                if (inv.func_70301_a(i) != null) continue;
                return false;
            }
        }
        return true;
    }

    private boolean applyItemTransfer(boolean isLoading) {
        IInventory invFrom = null;
        IInventory invTo = null;
        ItemStack tempitem = null;
        ItemStack moveitem = null;
        boolean allNull = true;
        boolean moved = false;
        int slotid = -1;
        for (int i = 0; i < 9; ++i) {
            TileEntityChest chest2;
            if (isLoading) {
                invFrom = this.chest;
                invTo = this.ship.getExtProps();
            } else {
                invTo = this.chest;
                invFrom = this.ship.getExtProps();
            }
            tempitem = this.getItemstackTemp(i, isLoading);
            if (tempitem != null) {
                allNull = false;
                slotid = this.matchTempItem(invFrom, tempitem);
                if (slotid < 0 && invFrom instanceof TileEntityChest && (chest2 = this.getAdjChest((TileEntityChest)invFrom)) != null) {
                    invFrom = chest2;
                    slotid = this.matchTempItem(invFrom, tempitem);
                }
                if (slotid < 0) continue;
                moveitem = invFrom.func_70301_a(slotid);
                moved = this.moveItemstackToInv(invTo, moveitem);
                if (moved && moveitem.field_77994_a <= 0) {
                    invFrom.func_70299_a(slotid, null);
                }
                if (!moved) continue;
                break;
            }
            if (i != 8 || !allNull) continue;
            slotid = this.matchAnyItemExceptNotModeItem(invFrom, isLoading);
            if (slotid < 0 && invFrom instanceof TileEntityChest && (chest2 = this.getAdjChest((TileEntityChest)invFrom)) != null) {
                invFrom = chest2;
                slotid = this.matchAnyItemExceptNotModeItem(invFrom, isLoading);
            }
            if (slotid < 0 || !(moved = this.moveItemstackToInv(invTo, moveitem = invFrom.func_70301_a(slotid))) || moveitem.field_77994_a > 0) continue;
            invFrom.func_70299_a(slotid, null);
        }
        return moved;
    }

    private boolean moveItemstackToInv(IInventory inv, ItemStack moveitem) {
        boolean moved = false;
        if (moveitem != null) {
            if (inv instanceof ExtendShipProps) {
                moved = this.mergeItemStack(inv, moveitem);
            } else if (inv instanceof TileEntityChest) {
                TileEntityChest chest = (TileEntityChest)inv;
                TileEntityChest chest2 = null;
                moved = this.mergeItemStack((IInventory)chest, moveitem);
                if (!moved && (chest2 = this.getAdjChest(chest)) != null) {
                    moved = this.mergeItemStack((IInventory)chest2, moveitem);
                }
            } else {
                moved = this.mergeItemStack(inv, moveitem);
            }
        }
        return moved;
    }

    private TileEntityChest getAdjChest(TileEntityChest chest) {
        TileEntityChest chest2 = null;
        if (chest != null && !chest.func_145837_r()) {
            chest.func_145979_i();
            chest2 = chest.field_145991_k;
            if (chest2 == null && (chest2 = chest.field_145990_j) == null && (chest2 = chest.field_145992_i) == null) {
                chest2 = chest.field_145988_l;
            }
        }
        if (chest2 != null && chest2.func_145837_r()) {
            return null;
        }
        return chest2;
    }

    private ItemStack getItemstackTemp(int i, boolean isLoadingTemp) {
        if (this.getItemMode(isLoadingTemp ? i : i + 9)) {
            return null;
        }
        if (isLoadingTemp) {
            return this.slots[i];
        }
        return this.slots[i + 9];
    }

    private boolean mergeItemStack(IInventory inv, ItemStack itemstack) {
        ItemStack slotstack;
        boolean movedItem = false;
        int k = 0;
        int startid = 0;
        int maxSize = inv.func_70302_i_();
        if (inv instanceof ExtendShipProps) {
            ((ExtendShipProps)inv).setInventoryPage(0);
            startid = 6;
            maxSize = ((ExtendShipProps)inv).getSizeInventoryPaged();
        }
        if (itemstack.func_77985_e()) {
            for (k = startid; itemstack.field_77994_a > 0 && k < maxSize; ++k) {
                slotstack = inv.func_70301_a(k);
                if (slotstack == null || slotstack.func_77973_b() != itemstack.func_77973_b() || itemstack.func_77981_g() && itemstack.func_77960_j() != slotstack.func_77960_j() || !ItemStack.func_77970_a((ItemStack)itemstack, (ItemStack)slotstack)) continue;
                int l = slotstack.field_77994_a + itemstack.field_77994_a;
                if (l <= itemstack.func_77976_d()) {
                    itemstack.field_77994_a = 0;
                    slotstack.field_77994_a = l;
                    movedItem = true;
                    continue;
                }
                if (slotstack.field_77994_a >= itemstack.func_77976_d()) continue;
                itemstack.field_77994_a -= itemstack.func_77976_d() - slotstack.field_77994_a;
                slotstack.field_77994_a = itemstack.func_77976_d();
                movedItem = true;
            }
        }
        if (itemstack.field_77994_a > 0) {
            for (k = startid; k < maxSize; ++k) {
                slotstack = inv.func_70301_a(k);
                if (slotstack != null) continue;
                inv.func_70299_a(k, itemstack.func_77946_l());
                itemstack.field_77994_a = 0;
                movedItem = true;
                break;
            }
        }
        return movedItem;
    }

    private int matchTempItem(IInventory inv, ItemStack target) {
        ItemStack getitem = null;
        int slotid = 0;
        int startid = 0;
        int maxSize = inv.func_70302_i_();
        if (inv instanceof ExtendShipProps) {
            ((ExtendShipProps)inv).setInventoryPage(0);
            startid = 6;
            maxSize = ((ExtendShipProps)inv).getSizeInventoryPaged();
        }
        if (target != null) {
            for (slotid = startid; slotid < maxSize; ++slotid) {
                getitem = inv.func_70301_a(slotid);
                if (getitem == null) continue;
                if (getitem.func_77973_b() == target.func_77973_b()) {
                    if (this.checkNbt && this.checkMetadata) {
                        if (!ItemStack.func_77970_a((ItemStack)getitem, (ItemStack)target) || getitem.func_77960_j() != target.func_77960_j()) continue;
                        return slotid;
                    }
                    if (this.checkNbt) {
                        if (!ItemStack.func_77970_a((ItemStack)getitem, (ItemStack)target)) continue;
                        return slotid;
                    }
                    if (this.checkMetadata) {
                        if (getitem.func_77960_j() != target.func_77960_j()) continue;
                        return slotid;
                    }
                    return slotid;
                }
                if (!this.checkOredict) continue;
                int[] a = OreDictionary.getOreIDs((ItemStack)target);
                int[] b = OreDictionary.getOreIDs((ItemStack)getitem);
                if (a.length <= 0 || b.length <= 0 || a[0] != b[0]) continue;
                return slotid;
            }
        } else {
            for (slotid = startid; slotid < maxSize; ++slotid) {
                getitem = inv.func_70301_a(slotid);
                if (getitem == null) continue;
                return slotid;
            }
        }
        return -1;
    }

    private int matchAnyItemExceptNotModeItem(IInventory inv, boolean isLoading) {
        ItemStack getitem = null;
        int slotid = 0;
        int startid = 0;
        int maxSize = inv.func_70302_i_();
        if (inv instanceof ExtendShipProps) {
            ((ExtendShipProps)inv).setInventoryPage(0);
            startid = 6;
            maxSize = ((ExtendShipProps)inv).getSizeInventoryPaged();
        }
        for (slotid = startid; slotid < maxSize; ++slotid) {
            getitem = inv.func_70301_a(slotid);
            if (getitem == null || this.checkNotModeItem(slotid, getitem, isLoading) < 0) continue;
            return slotid;
        }
        return -1;
    }

    private int checkNotModeItem(int slotid, ItemStack item, boolean isLoading) {
        ItemStack temp = null;
        for (int i = 0; i < 9; ++i) {
            if (!this.getItemMode(isLoading ? i : i + 9) || (temp = this.slots[isLoading ? i : i + 9]) == null) continue;
            if (item.func_77973_b() == temp.func_77973_b()) {
                if (this.checkNbt && this.checkMetadata) {
                    if (!ItemStack.func_77970_a((ItemStack)item, (ItemStack)temp) || item.func_77960_j() != temp.func_77960_j()) continue;
                    return -1;
                }
                if (this.checkNbt) {
                    if (!ItemStack.func_77970_a((ItemStack)item, (ItemStack)temp)) continue;
                    return -1;
                }
                if (this.checkMetadata) {
                    if (item.func_77960_j() != temp.func_77960_j()) continue;
                    return -1;
                }
                return -1;
            }
            if (!this.checkOredict) continue;
            int[] a = OreDictionary.getOreIDs((ItemStack)item);
            int[] b = OreDictionary.getOreIDs((ItemStack)temp);
            if (a.length <= 0 || b.length <= 0 || a[0] != b[0]) continue;
            return -1;
        }
        return slotid;
    }

    private void checkCraningShip() {
        AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c - 7.0), (double)((double)this.field_145848_d - 6.0), (double)((double)this.field_145849_e - 7.0), (double)((double)this.field_145851_c + 7.0), (double)((double)this.field_145848_d + 6.0), (double)((double)this.field_145849_e + 7.0));
        List slist = this.field_145850_b.func_72872_a(BasicEntityShip.class, box);
        if (slist != null && !slist.isEmpty()) {
            for (BasicEntityShip s : slist) {
                if (s.getStateMinor(43) != 2 || s.getGuardedPos(0) != this.field_145851_c || s.getGuardedPos(1) != this.field_145848_d || s.getGuardedPos(2) != this.field_145849_e) continue;
                this.ship = s;
                this.ship.getExtProps().setInventoryPage(0);
                this.ship.getShipNavigate().tryMoveToXYZ((double)this.field_145851_c + 0.5, (double)this.field_145848_d - 2.0, (double)this.field_145849_e + 0.5, 0.5);
                this.sendSyncPacket();
                return;
            }
            for (BasicEntityShip s : slist) {
                if (s.getStateMinor(43) != 1 || s.getGuardedPos(0) != this.field_145851_c || s.getGuardedPos(1) != this.field_145848_d || s.getGuardedPos(2) != this.field_145849_e) continue;
                this.ship = s;
                this.ship.setStateMinor(43, 2);
                this.ship.getExtProps().setInventoryPage(0);
                this.ship.getShipNavigate().tryMoveToXYZ((double)this.field_145851_c + 0.5, (double)this.field_145848_d - 2.0, (double)this.field_145849_e + 0.5, 0.5);
                this.sendSyncPacket();
                return;
            }
        } else {
            this.ship = null;
            this.sendSyncPacket();
        }
    }

    @Override
    public int getFuelSlotMin() {
        return -1;
    }

    @Override
    public int getFuelSlotMax() {
        return -1;
    }

    @Override
    public ItemStack func_70301_a(int i) {
        return this.slots[i];
    }

    @Override
    public ItemStack func_70298_a(int i, int j) {
        return null;
    }

    @Override
    public void func_70299_a(int i, ItemStack itemstack) {
        this.slots[i] = itemstack;
        if (itemstack != null) {
            itemstack.field_77994_a = 1;
        }
    }

    @Override
    public int func_70297_j_() {
        return 0;
    }

    @Override
    public boolean func_102007_a(int slot, ItemStack itemstack, int side) {
        return false;
    }

    public static int getWaitTimeInMin(int mode) {
        if (mode >= 6 && mode <= 15) {
            return mode - 5;
        }
        if (mode >= 16 && mode <= 19) {
            return (mode - 16) * 5 + 15;
        }
        if (mode >= 20 && mode <= 22) {
            return (mode - 20) * 10 + 40;
        }
        if (mode >= 23 && mode <= 25) {
            return (mode - 23) * 60 + 120;
        }
        return 0;
    }

    @Override
    public void setWpStayTime(int time) {
    }

    @Override
    public int getWpStayTime() {
        return 0;
    }

    public void setItemMode(int slotID, boolean notMode) {
        int slot = 1 << slotID - 1;
        this.itemMode = notMode ? (this.itemMode |= slot) : (this.itemMode &= ~slot);
    }

    public boolean getItemMode(int slotID) {
        return (this.itemMode >> slotID - 1 & 1) == 1;
    }
}

