/*
 * Decompiled with CFR 0.152.
 */
package com.lulan.shincolle.server;

import com.lulan.shincolle.proxy.ServerProxy;
import com.lulan.shincolle.team.TeamData;
import com.lulan.shincolle.utility.LogHelper;
import com.lulan.shincolle.utility.NBTHelper;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.world.WorldSavedData;

public class ShinWorldData
extends WorldSavedData {
    public static final String SAVEID = "shincolle";
    public static final String TAG_NEXTPLAYERID = "nextPlayerID";
    public static final String TAG_NEXTSHIPID = "nextShipID";
    public static final String TAG_PLAYERDATA = "playerData";
    public static final String TAG_TEAMDATA = "teamData";
    public static final String TAG_PUID = "pUID";
    public static final String TAG_PDATA = "pData";
    public static final String TAG_TUID = "tUID";
    public static final String TAG_TNAME = "tName";
    public static final String TAG_TLNAME = "tLName";
    public static final String TAG_TBAN = "tBan";
    public static final String TAG_TALLY = "tAlly";
    public static NBTTagCompound nbtData;

    public ShinWorldData() {
        super(SAVEID);
    }

    public ShinWorldData(String saveid) {
        super(saveid);
    }

    public void func_76184_a(NBTTagCompound nbt) {
        nbtData = (NBTTagCompound)nbt.func_74737_b();
        LogHelper.info("DEBUG : world data: load NBT: " + nbtData.toString());
    }

    public void func_76187_b(NBTTagCompound nbt) {
        NBTTagCompound save;
        nbt.func_74768_a(TAG_NEXTPLAYERID, ServerProxy.getNextPlayerID());
        nbt.func_74768_a(TAG_NEXTSHIPID, ServerProxy.getNextShipID());
        List<String> strList = ServerProxy.getUnattackableTargetClassList();
        if (strList != null) {
            NBTTagList tagList = new NBTTagList();
            LogHelper.info("DEBUG : save world data: save unattackable target list: size: " + strList.size());
            for (String string : strList) {
                NBTTagString str = new NBTTagString(string);
                tagList.func_74742_a((NBTBase)str);
            }
            nbt.func_74782_a("UnatkTargetClass", (NBTBase)tagList);
        }
        NBTTagList list = new NBTTagList();
        for (Map.Entry<Integer, int[]> entry : ServerProxy.getAllPlayerWorldData().entrySet()) {
            int uid = entry.getKey();
            int[] data0 = entry.getValue();
            save = new NBTTagCompound();
            save.func_74768_a(TAG_PUID, uid);
            save.func_74783_a(TAG_PDATA, data0);
            LogHelper.info("DEBUG : save world data: save id " + uid + " data: " + data0[0]);
            strList = ServerProxy.getPlayerTargetClassList(uid);
            if (strList != null) {
                NBTTagList tagList = new NBTTagList();
                LogHelper.info("DEBUG : save world data: save id " + uid + " target list size: " + strList.size());
                for (String getc : strList) {
                    NBTTagString str = new NBTTagString(getc);
                    tagList.func_74742_a((NBTBase)str);
                }
                save.func_74782_a("CustomTargetClass", (NBTBase)tagList);
            }
            list.func_74742_a((NBTBase)save);
        }
        nbt.func_74782_a(TAG_PLAYERDATA, (NBTBase)list);
        list = new NBTTagList();
        for (Map.Entry<Integer, Object> entry : ServerProxy.getAllTeamWorldData().entrySet()) {
            int uid = entry.getKey();
            TeamData data = (TeamData)entry.getValue();
            save = new NBTTagCompound();
            save.func_74768_a(TAG_TUID, uid);
            save.func_74778_a(TAG_TNAME, data.getTeamName());
            save.func_74778_a(TAG_TLNAME, data.getTeamLeaderName());
            NBTHelper.saveIntListToNBT(save, TAG_TBAN, data.getTeamBannedList());
            NBTHelper.saveIntListToNBT(save, TAG_TALLY, data.getTeamAllyList());
            list.func_74742_a((NBTBase)save);
        }
        nbt.func_74782_a(TAG_TEAMDATA, (NBTBase)list);
    }
}

