/*
 * Decompiled with CFR 0.152.
 */
package com.lulan.shincolle.network;

import com.lulan.shincolle.utility.EntityHelper;
import com.lulan.shincolle.utility.LogHelper;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;

public class S2CInputPackets
implements IMessage {
    private World world;
    private EntityPlayer player;
    private int type;
    private int worldID;
    private int entityID;
    private int value;
    private int value2;
    private int[] value3;

    public S2CInputPackets() {
    }

    public S2CInputPackets(int type, int ... parms) {
        this.type = type;
        if (parms != null && parms.length > 0) {
            this.value3 = (int[])parms.clone();
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.type = buf.readByte();
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: {
                try {
                    this.value = buf.readInt();
                    if (this.value <= 0) break;
                    this.value3 = new int[this.value];
                    for (int i = 0; i < this.value; ++i) {
                        this.value3[i] = buf.readInt();
                    }
                    break;
                }
                catch (Exception e) {
                    LogHelper.info("DEBUG : S2C input packet: get data fail: " + e);
                }
            }
        }
    }

    public void toBytes(ByteBuf buf) {
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: {
                buf.writeByte((int)((byte)this.type));
                if (this.value3 != null) {
                    buf.writeInt(this.value3.length);
                    for (int geti : this.value3) {
                        buf.writeInt(geti);
                    }
                    break;
                }
                buf.writeInt(0);
            }
        }
    }

    public static class Handler
    implements IMessageHandler<S2CInputPackets, IMessage> {
        public IMessage onMessage(S2CInputPackets message, MessageContext ctx) {
            switch (message.type) {
                case 0: {
                    EntityHelper.processShipChangeOwner(message.value3[0], message.value3[1]);
                    break;
                }
                case 1: {
                    EntityHelper.processShowShipInfo(message.value3[0]);
                    break;
                }
                case 2: {
                    EntityHelper.processSetShipAttrs(message.value3);
                }
            }
            return null;
        }
    }

    public static final class PID {
        public static final byte CmdChOwner = 0;
        public static final byte CmdShipInfo = 1;
        public static final byte CmdShipAttr = 2;
    }
}

