/*
 * Decompiled with CFR 0.152.
 */
package com.lulan.shincolle.network;

import com.lulan.shincolle.entity.BasicEntityShip;
import com.lulan.shincolle.entity.ExtendPlayerProps;
import com.lulan.shincolle.entity.renderentity.EntityRenderVortex;
import com.lulan.shincolle.proxy.ClientProxy;
import com.lulan.shincolle.proxy.ServerProxy;
import com.lulan.shincolle.team.TeamData;
import com.lulan.shincolle.tileentity.TileEntityCrane;
import com.lulan.shincolle.tileentity.TileEntityDesk;
import com.lulan.shincolle.tileentity.TileEntitySmallShipyard;
import com.lulan.shincolle.tileentity.TileEntityVolCore;
import com.lulan.shincolle.tileentity.TileEntityWaypoint;
import com.lulan.shincolle.tileentity.TileMultiGrudgeHeavy;
import com.lulan.shincolle.utility.EntityHelper;
import com.lulan.shincolle.utility.LogHelper;
import com.lulan.shincolle.utility.PacketHelper;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class S2CGUIPackets
implements IMessage {
    private TileEntity tile;
    private TileEntitySmallShipyard tile1;
    private TileMultiGrudgeHeavy tile2;
    private EntityPlayer player;
    private ExtendPlayerProps props;
    private BasicEntityShip ship;
    private World world;
    private int type;
    private int entityID;
    private int recvX;
    private int recvY;
    private int recvZ;
    private int value;
    private int value2;
    private int[] value3;
    private boolean flag;
    private List dataList;
    private Map dataMap;

    public S2CGUIPackets() {
    }

    public S2CGUIPackets(TileEntity tile) {
        if (tile instanceof TileEntitySmallShipyard) {
            this.tile1 = (TileEntitySmallShipyard)tile;
            this.type = 0;
        } else if (tile instanceof TileMultiGrudgeHeavy) {
            this.tile2 = (TileMultiGrudgeHeavy)tile;
            this.type = 1;
        } else if (tile instanceof TileEntityDesk) {
            this.tile = tile;
            this.type = 2;
        } else if (tile instanceof TileEntityVolCore) {
            this.tile = tile;
            this.type = 14;
        } else if (tile instanceof TileEntityWaypoint) {
            this.tile = tile;
            this.type = 15;
        } else if (tile instanceof TileEntityCrane) {
            this.tile = tile;
            this.type = 16;
        }
    }

    public S2CGUIPackets(ExtendPlayerProps extProps, int type) {
        if (extProps != null) {
            this.type = type;
            this.props = extProps;
            switch (type) {
                case 7: {
                    this.dataList = ServerProxy.getPlayerTargetClassList(this.props.getPlayerUID());
                    break;
                }
                case 9: {
                    this.value3 = this.props.getFormatID();
                }
            }
        }
    }

    public S2CGUIPackets(ExtendPlayerProps extProps, int type, int ... parms) {
        if (extProps != null) {
            this.type = type;
            this.props = extProps;
            if (parms != null && parms.length > 0) {
                this.value3 = (int[])parms.clone();
            }
        }
    }

    public S2CGUIPackets(BasicEntityShip ship) {
        this.type = 4;
        this.ship = ship;
    }

    public S2CGUIPackets(int type, int value, boolean flag) {
        this.type = type;
        switch (type) {
            case 5: {
                this.flag = flag;
            }
        }
    }

    public S2CGUIPackets(int type, List list) {
        this.type = type;
        this.dataList = list;
    }

    public S2CGUIPackets(int type, int ... parms) {
        this.type = type;
        if (parms != null && parms.length > 0) {
            this.value3 = (int[])parms.clone();
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.world = ClientProxy.getClientWorld();
        this.type = buf.readByte();
        switch (this.type) {
            case 0: {
                this.recvX = buf.readInt();
                this.recvY = buf.readInt();
                this.recvZ = buf.readInt();
                this.tile1 = (TileEntitySmallShipyard)this.world.func_147438_o(this.recvX, this.recvY, this.recvZ);
                if (this.tile1 != null) {
                    this.tile1.setPowerConsumed(buf.readInt());
                    this.tile1.setPowerRemained(buf.readInt());
                    this.tile1.setPowerGoal(buf.readInt());
                    break;
                }
                buf.clear();
                break;
            }
            case 1: {
                this.recvX = buf.readInt();
                this.recvY = buf.readInt();
                this.recvZ = buf.readInt();
                this.tile2 = (TileMultiGrudgeHeavy)this.world.func_147438_o(this.recvX, this.recvY, this.recvZ);
                if (this.tile2 != null) {
                    this.tile2.setPowerConsumed(buf.readInt());
                    this.tile2.setPowerRemained(buf.readInt());
                    this.tile2.setPowerGoal(buf.readInt());
                    this.tile2.setMatStock(0, buf.readInt());
                    this.tile2.setMatStock(1, buf.readInt());
                    this.tile2.setMatStock(2, buf.readInt());
                    this.tile2.setMatStock(3, buf.readInt());
                    AxisAlignedBB aabb = AxisAlignedBB.func_72330_a((double)((double)this.recvX - 1.5), (double)((double)this.recvY - 2.0), (double)((double)this.recvZ - 1.5), (double)((double)this.recvX + 1.5), (double)((double)this.recvY + 1.0), (double)((double)this.recvZ + 1.5));
                    List renderEntityList = this.world.func_72872_a(EntityRenderVortex.class, aabb);
                    for (int i = 0; i < renderEntityList.size(); ++i) {
                        ((EntityRenderVortex)((Object)renderEntityList.get(i))).setIsActive(this.tile2.isBuilding());
                    }
                    break;
                }
                buf.clear();
                break;
            }
            case 2: {
                this.recvX = buf.readInt();
                this.recvY = buf.readInt();
                this.recvZ = buf.readInt();
                this.tile = this.world.func_147438_o(this.recvX, this.recvY, this.recvZ);
                if (this.tile1 != null) {
                    int[] data = new int[]{buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt()};
                    EntityHelper.setTileEntityByGUI(this.tile, 0, data);
                    break;
                }
                buf.clear();
                break;
            }
            case 14: {
                this.recvX = buf.readInt();
                this.recvY = buf.readInt();
                this.recvZ = buf.readInt();
                TileEntity te = this.world.func_147438_o(this.recvX, this.recvY, this.recvZ);
                if (te instanceof TileEntityVolCore) {
                    ((TileEntityVolCore)te).setPowerRemained(buf.readInt());
                    ((TileEntityVolCore)te).isActive = buf.readBoolean();
                    break;
                }
                buf.clear();
                break;
            }
            case 15: {
                this.recvX = buf.readInt();
                this.recvY = buf.readInt();
                this.recvZ = buf.readInt();
                this.value3 = new int[6];
                this.value3[0] = buf.readInt();
                this.value3[1] = buf.readInt();
                this.value3[2] = buf.readInt();
                this.value3[3] = buf.readInt();
                this.value3[4] = buf.readInt();
                this.value3[5] = buf.readInt();
                TileEntity te = this.world.func_147438_o(this.recvX, this.recvY, this.recvZ);
                if (!(te instanceof TileEntityWaypoint)) break;
                ((TileEntityWaypoint)te).setSyncData(this.value3);
                break;
            }
            case 16: {
                this.recvX = buf.readInt();
                this.recvY = buf.readInt();
                this.recvZ = buf.readInt();
                this.value3 = new int[11];
                this.value3[0] = buf.readInt();
                this.value3[1] = buf.readInt();
                this.value3[2] = buf.readInt();
                this.value3[3] = buf.readInt();
                this.value3[4] = buf.readInt();
                this.value3[5] = buf.readInt();
                this.value3[6] = buf.readInt();
                this.value3[7] = buf.readInt();
                this.value3[8] = buf.readInt();
                this.value3[9] = buf.readInt();
                this.value3[10] = buf.readInt();
                boolean isActive = buf.readBoolean();
                boolean checkMeta = buf.readBoolean();
                boolean checkDict = buf.readBoolean();
                boolean checkNbt = buf.readBoolean();
                TileEntity te = this.world.func_147438_o(this.recvX, this.recvY, this.recvZ);
                Entity ent = EntityHelper.getEntityByID(this.value3[9], 0, true);
                if (!(te instanceof TileEntityCrane)) break;
                TileEntityCrane t = (TileEntityCrane)te;
                t.setSyncData(this.value3);
                t.isActive = isActive;
                t.checkMetadata = checkMeta;
                t.checkOredict = checkDict;
                t.checkNbt = checkNbt;
                t.ship = (BasicEntityShip)ent;
                t.craneMode = this.value3[10];
                break;
            }
            case 3: {
                int[] propValues = new int[4];
                int[] shipValues = new int[12];
                int[] formatID = new int[9];
                int teamID = 0;
                boolean[] shipSelected = new boolean[6];
                propValues[0] = buf.readByte();
                propValues[1] = buf.readByte();
                propValues[2] = buf.readInt();
                teamID = buf.readInt();
                for (int i = 0; i < 9; ++i) {
                    formatID[i] = buf.readByte();
                }
                for (int j = 0; j < 6; ++j) {
                    shipValues[j * 2] = buf.readInt();
                    shipValues[j * 2 + 1] = buf.readInt();
                    shipSelected[j] = buf.readBoolean();
                }
                EntityHelper.setPlayerExtProps(propValues);
                EntityHelper.setPlayerExtProps(teamID, formatID, shipValues, shipSelected);
                break;
            }
            case 4: {
                Entity getEnt = EntityHelper.getEntityByID(buf.readInt(), 0, true);
                if (!(getEnt instanceof BasicEntityShip)) break;
                BasicEntityShip ship = (BasicEntityShip)getEnt;
                ship.setStateMinor(1, buf.readInt());
                ship.setStateMinor(6, buf.readInt());
                ship.getExtProps().setInventoryPage(buf.readInt());
                break;
            }
            case 5: {
                this.flag = buf.readBoolean();
                this.player = ClientProxy.getClientPlayer();
                this.props = (ExtendPlayerProps)this.player.getExtendedProperties("TeitokuExtProps");
                if (this.props == null) break;
                this.props.setInitSID(this.flag);
                break;
            }
            case 6: 
            case 12: 
            case 13: {
                int listLen = buf.readInt();
                if (listLen > 0) {
                    this.player = ClientProxy.getClientPlayer();
                    this.props = (ExtendPlayerProps)this.player.getExtendedProperties("TeitokuExtProps");
                    ArrayList<Integer> data = new ArrayList<Integer>();
                    for (int i = 0; i < listLen; ++i) {
                        data.add(buf.readInt());
                    }
                    if (this.props != null) {
                        switch (this.type) {
                            case 6: {
                                this.props.setShipEIDList(data);
                                break;
                            }
                            case 12: {
                                this.props.setColleShipList(data);
                                break;
                            }
                            case 13: {
                                this.props.setColleEquipList(data);
                            }
                        }
                    }
                }
                break;
            }
            case 7: {
                this.player = ClientProxy.getClientPlayer();
                this.props = (ExtendPlayerProps)this.player.getExtendedProperties("TeitokuExtProps");
                ArrayList<String> data = new ArrayList<String>();
                int listLen = buf.readInt();
                if (listLen > 0) {
                    for (int i = 0; i < listLen; ++i) {
                        data.add(ByteBufUtils.readUTF8String((ByteBuf)buf));
                    }
                    if (this.props == null) break;
                    this.props.setTargetClass(data);
                    break;
                }
                if (this.props == null) break;
                this.props.clearAllTargetClass();
                LogHelper.info("DEBUG : S2C gui sync: clear target class list ");
                break;
            }
            case 8: {
                this.player = ClientProxy.getClientPlayer();
                this.props = (ExtendPlayerProps)this.player.getExtendedProperties("TeitokuExtProps");
                this.value = buf.readInt();
                this.props.setPlayerTeamID(this.value);
                this.value = buf.readInt();
                HashMap<Integer, TeamData> tmap = new HashMap<Integer, TeamData>();
                for (int i = 0; i < this.value; ++i) {
                    TeamData tdata = new TeamData();
                    tdata.setTeamID(buf.readInt());
                    this.dataList = PacketHelper.getListInt(buf);
                    tdata.setTeamBannedList(this.dataList);
                    this.dataList = PacketHelper.getListInt(buf);
                    tdata.setTeamAllyList(this.dataList);
                    String tname = PacketHelper.getString(buf);
                    tdata.setTeamName(tname);
                    String lname = PacketHelper.getString(buf);
                    tdata.setTeamLeaderName(lname);
                    tmap.put(tdata.getTeamID(), tdata);
                }
                this.props.setPlayerTeamDataMap(tmap);
                break;
            }
            case 9: {
                this.value = buf.readInt();
                if (this.value > 0) {
                    this.value3 = new int[this.value];
                    for (int i = 0; i < this.value; ++i) {
                        this.value3[i] = buf.readInt();
                    }
                }
                this.player = ClientProxy.getClientPlayer();
                this.props = (ExtendPlayerProps)this.player.getExtendedProperties("TeitokuExtProps");
                if (this.props == null) break;
                this.props.setFormatID(this.value3);
                break;
            }
            case 10: {
                this.value = buf.readInt();
                this.value3 = new int[9];
                for (int i = 0; i < 9; ++i) {
                    this.value3[i] = buf.readByte();
                }
                this.value2 = buf.readByte();
                if (this.value2 <= 0) break;
                BasicEntityShip[][] ships = new BasicEntityShip[9][6];
                int[][] sids = new int[9][6];
                boolean[][] sels = new boolean[9][6];
                for (int k = 0; k < 9; ++k) {
                    for (int i = 0; i < 6; ++i) {
                        int temp = buf.readInt();
                        ships[k][i] = (BasicEntityShip)EntityHelper.getEntityByID(temp, 0, true);
                        sids[k][i] = buf.readInt();
                        sels[k][i] = buf.readBoolean();
                    }
                }
                this.player = ClientProxy.getClientPlayer();
                this.props = (ExtendPlayerProps)this.player.getExtendedProperties("TeitokuExtProps");
                if (this.props == null) break;
                this.props.setPointerTeamID(this.value);
                this.props.setFormatID(this.value3);
                this.props.setTeamList(ships);
                this.props.setSelectState(sels);
                this.props.setSIDList(sids);
                break;
            }
            case 11: {
                this.value = buf.readInt();
                this.value2 = buf.readByte();
                byte flag = buf.readByte();
                if (flag <= 0) break;
                BasicEntityShip[] ships = new BasicEntityShip[6];
                int[] sids = new int[6];
                boolean[] sels = new boolean[6];
                for (int i = 0; i < 6; ++i) {
                    int temp = buf.readInt();
                    ships[i] = (BasicEntityShip)EntityHelper.getEntityByID(temp, 0, true);
                    sids[i] = buf.readInt();
                    sels[i] = buf.readBoolean();
                }
                this.player = ClientProxy.getClientPlayer();
                this.props = (ExtendPlayerProps)this.player.getExtendedProperties("TeitokuExtProps");
                if (this.props == null) break;
                this.props.setFormatID(this.value, this.value2);
                this.props.setTeamList(this.value, ships);
                this.props.setSelectState(this.value, sels);
                this.props.setSIDList(this.value, sids);
            }
        }
    }

    public void toBytes(ByteBuf buf) {
        switch (this.type) {
            case 0: {
                buf.writeByte(this.type);
                buf.writeInt(this.tile1.field_145851_c);
                buf.writeInt(this.tile1.field_145848_d);
                buf.writeInt(this.tile1.field_145849_e);
                buf.writeInt(this.tile1.getPowerConsumed());
                buf.writeInt(this.tile1.getPowerRemained());
                buf.writeInt(this.tile1.getPowerGoal());
                break;
            }
            case 1: {
                buf.writeByte(this.type);
                buf.writeInt(this.tile2.field_145851_c);
                buf.writeInt(this.tile2.field_145848_d);
                buf.writeInt(this.tile2.field_145849_e);
                buf.writeInt(this.tile2.getPowerConsumed());
                buf.writeInt(this.tile2.getPowerRemained());
                buf.writeInt(this.tile2.getPowerGoal());
                buf.writeInt(this.tile2.getMatStock(0));
                buf.writeInt(this.tile2.getMatStock(1));
                buf.writeInt(this.tile2.getMatStock(2));
                buf.writeInt(this.tile2.getMatStock(3));
                break;
            }
            case 2: {
                buf.writeByte(this.type);
                buf.writeInt(this.tile.field_145851_c);
                buf.writeInt(this.tile.field_145848_d);
                buf.writeInt(this.tile.field_145849_e);
                switch (this.type) {
                    case 2: {
                        buf.writeInt(((TileEntityDesk)this.tile).guiFunc);
                        buf.writeInt(((TileEntityDesk)this.tile).book_chap);
                        buf.writeInt(((TileEntityDesk)this.tile).book_page);
                        buf.writeInt(((TileEntityDesk)this.tile).radar_zoomLv);
                    }
                }
                break;
            }
            case 14: {
                buf.writeByte(this.type);
                buf.writeInt(this.tile.field_145851_c);
                buf.writeInt(this.tile.field_145848_d);
                buf.writeInt(this.tile.field_145849_e);
                buf.writeInt(((TileEntityVolCore)this.tile).getPowerRemained());
                buf.writeBoolean(((TileEntityVolCore)this.tile).isActive);
                break;
            }
            case 16: {
                TileEntityCrane te = (TileEntityCrane)this.tile;
                buf.writeByte(this.type);
                buf.writeInt(this.tile.field_145851_c);
                buf.writeInt(this.tile.field_145848_d);
                buf.writeInt(this.tile.field_145849_e);
                buf.writeInt(te.lx);
                buf.writeInt(te.ly);
                buf.writeInt(te.lz);
                buf.writeInt(te.nx);
                buf.writeInt(te.ny);
                buf.writeInt(te.nz);
                buf.writeInt(te.cx);
                buf.writeInt(te.cy);
                buf.writeInt(te.cz);
                if (te.ship != null) {
                    buf.writeInt(te.ship.func_145782_y());
                } else {
                    buf.writeInt(-1);
                }
                buf.writeInt(te.craneMode);
                buf.writeBoolean(te.isActive);
                buf.writeBoolean(te.checkMetadata);
                buf.writeBoolean(te.checkOredict);
                buf.writeBoolean(te.checkNbt);
                break;
            }
            case 15: {
                TileEntityWaypoint te = (TileEntityWaypoint)this.tile;
                buf.writeByte(this.type);
                buf.writeInt(this.tile.field_145851_c);
                buf.writeInt(this.tile.field_145848_d);
                buf.writeInt(this.tile.field_145849_e);
                buf.writeInt(te.lx);
                buf.writeInt(te.ly);
                buf.writeInt(te.lz);
                buf.writeInt(te.nx);
                buf.writeInt(te.ny);
                buf.writeInt(te.nz);
                break;
            }
            case 3: {
                buf.writeByte(this.type);
                buf.writeByte(this.props.isRingActiveI());
                buf.writeByte(this.props.getMarriageNum());
                buf.writeInt(this.props.getPlayerUID());
                buf.writeInt(this.props.getPointerTeamID());
                int[] fid = this.props.getFormatID();
                for (int j = 0; j < 9; ++j) {
                    buf.writeByte((int)((byte)fid[j]));
                }
                for (int i = 0; i < 6; ++i) {
                    if (this.props.getShipEntityCurrentTeam(i) != null) {
                        buf.writeInt(this.props.getShipEntityCurrentTeam(i).func_145782_y());
                    } else {
                        buf.writeInt(-1);
                    }
                    buf.writeInt(this.props.getSIDCurrentTeam(i));
                    buf.writeBoolean(this.props.getSelectStateCurrentTeam(i));
                }
                break;
            }
            case 4: {
                buf.writeByte(this.type);
                buf.writeInt(this.ship.func_145782_y());
                buf.writeInt(this.ship.getStateMinor(1));
                buf.writeInt(this.ship.getStateMinor(6));
                buf.writeInt(this.ship.getExtProps().getInventoryPage());
                break;
            }
            case 5: {
                buf.writeByte(this.type);
                buf.writeBoolean(this.flag);
                break;
            }
            case 6: 
            case 7: 
            case 12: 
            case 13: {
                buf.writeByte(this.type);
                if (this.dataList != null) {
                    buf.writeInt(this.dataList.size());
                    Iterator iter = this.dataList.iterator();
                    switch (this.type) {
                        case 6: 
                        case 12: 
                        case 13: {
                            while (iter.hasNext()) {
                                buf.writeInt(((Integer)iter.next()).intValue());
                            }
                            break;
                        }
                        case 7: {
                            LogHelper.info("DEBUG : S2C gui packet: send list size " + this.dataList.size());
                            while (iter.hasNext()) {
                                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)((String)iter.next()));
                            }
                            break;
                        }
                    }
                    break;
                }
                buf.writeInt(-1);
                break;
            }
            case 8: {
                buf.writeByte(this.type);
                buf.writeInt(this.props.getPlayerTeamID());
                this.dataMap = ServerProxy.getAllTeamWorldData();
                if (this.dataMap != null) {
                    int tsize = this.dataMap.size();
                    buf.writeInt(tsize);
                    for (Map.Entry ent : this.dataMap.entrySet()) {
                        int tid = (Integer)ent.getKey();
                        TeamData tdata = (TeamData)ent.getValue();
                        buf.writeInt(tid);
                        PacketHelper.sendListInt(buf, tdata.getTeamBannedList());
                        PacketHelper.sendListInt(buf, tdata.getTeamAllyList());
                        PacketHelper.sendString(buf, tdata.getTeamName());
                        PacketHelper.sendString(buf, tdata.getTeamLeaderName());
                    }
                    break;
                }
                buf.writeInt(-1);
                break;
            }
            case 9: {
                buf.writeByte(this.type);
                if (this.value3 != null) {
                    buf.writeInt(this.value3.length);
                    for (int geti : this.value3) {
                        buf.writeInt(geti);
                    }
                    break;
                }
                buf.writeInt(0);
                break;
            }
            case 10: {
                buf.writeByte(this.type);
                buf.writeInt(this.props.getPointerTeamID());
                int[] fid = this.props.getFormatID();
                for (int j = 0; j < 9; ++j) {
                    buf.writeByte((int)((byte)fid[j]));
                }
                BasicEntityShip[][] ships = this.props.getShipEntityAllTeams();
                int[][] sids = this.props.getSID();
                boolean[][] sels = this.props.getSelectStateAllTeams();
                if (ships != null && sids != null && sels != null) {
                    buf.writeByte(1);
                    for (int k = 0; k < 9; ++k) {
                        for (int i = 0; i < 6; ++i) {
                            if (ships[k][i] != null) {
                                buf.writeInt(ships[k][i].func_145782_y());
                            } else {
                                buf.writeInt(-1);
                            }
                            buf.writeInt(sids[k][i]);
                            buf.writeBoolean(sels[k][i]);
                        }
                    }
                    break;
                }
                buf.writeByte(-1);
                break;
            }
            case 11: {
                buf.writeByte(this.type);
                buf.writeInt(this.value3[0]);
                buf.writeByte(this.props.getFormatID(this.value3[0]));
                BasicEntityShip[] ships = this.props.getShipEntityAll(this.value3[0]);
                int[] sids = this.props.getSID(this.value3[0]);
                boolean[] sels = this.props.getSelectState(this.value3[0]);
                if (ships != null && sids != null && sels != null) {
                    buf.writeByte(1);
                    for (int i = 0; i < 6; ++i) {
                        if (ships[i] != null) {
                            buf.writeInt(ships[i].func_145782_y());
                        } else {
                            buf.writeInt(-1);
                        }
                        buf.writeInt(sids[i]);
                        buf.writeBoolean(sels[i]);
                    }
                    break;
                }
                buf.writeByte(-1);
            }
        }
    }

    public static class Handler
    implements IMessageHandler<S2CGUIPackets, IMessage> {
        public IMessage onMessage(S2CGUIPackets message, MessageContext ctx) {
            return null;
        }
    }

    public static final class PID {
        public static final byte TileSmallSY = 0;
        public static final byte TileLargeSY = 1;
        public static final byte TileDesk = 2;
        public static final byte SyncPlayerProp = 3;
        public static final byte SyncShipInv = 4;
        public static final byte FlagInitSID = 5;
        public static final byte SyncShipList = 6;
        public static final byte SyncPlayerProp_TargetClass = 7;
        public static final byte SyncPlayerProp_TeamData = 8;
        public static final byte SyncPlayerProp_Formation = 9;
        public static final byte SyncPlayerProp_ShipsAll = 10;
        public static final byte SyncPlayerProp_ShipsInTeam = 11;
        public static final byte SyncPlayerProp_ColledShip = 12;
        public static final byte SyncPlayerProp_ColledEquip = 13;
        public static final byte TileVolCore = 14;
        public static final byte TileWaypoint = 15;
        public static final byte TileCrane = 16;
    }
}

