/*
 * Decompiled with CFR 0.152.
 */
package com.lulan.shincolle.item;

import com.lulan.shincolle.entity.BasicEntityShip;
import com.lulan.shincolle.entity.BasicEntityShipHostile;
import com.lulan.shincolle.item.BasicItem;
import com.lulan.shincolle.network.C2SGUIPackets;
import com.lulan.shincolle.proxy.CommonProxy;
import com.lulan.shincolle.proxy.ServerProxy;
import com.lulan.shincolle.tileentity.BasicTileEntity;
import com.lulan.shincolle.tileentity.ITileWaypoint;
import com.lulan.shincolle.tileentity.TileEntityCrane;
import com.lulan.shincolle.utility.EntityHelper;
import com.lulan.shincolle.utility.LogHelper;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class TargetWrench
extends BasicItem {
    private int[] tileChest;
    private int[][] tilePoint;
    private int pointID;

    public TargetWrench() {
        this.func_77655_b("TargetWrench");
        this.field_77777_bU = 1;
        this.func_77664_n();
        this.tileChest = new int[]{-1, -1, -1};
        this.tilePoint = new int[][]{{-1, -1, -1}, {-1, -1, -1}};
        this.pointID = 0;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasEffect(ItemStack item, int pass) {
        return true;
    }

    public boolean onEntitySwing(EntityLivingBase entityLiving, ItemStack item) {
        int meta = item.func_77960_j();
        EntityPlayer player = null;
        if (entityLiving instanceof EntityPlayer) {
            player = (EntityPlayer)entityLiving;
            if (entityLiving.field_70170_p.field_72995_K) {
                MovingObjectPosition hitObj = EntityHelper.getPlayerMouseOverEntity(64.0, 1.0f);
                if (hitObj != null && hitObj.field_72308_g != null && !(hitObj.field_72308_g instanceof BasicEntityShip) && !(hitObj.field_72308_g instanceof BasicEntityShipHostile)) {
                    String tarName = hitObj.field_72308_g.getClass().getSimpleName();
                    LogHelper.info("DEBUG : target wrench get class: " + tarName);
                    CommonProxy.channelG.sendToServer((IMessage)new C2SGUIPackets(player, -23, tarName));
                    return false;
                }
            } else if (player.func_70093_af()) {
                List<String> tarlist = ServerProxy.getUnattackableTargetClassList();
                player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "Show unattackable entity list:"));
                for (String s : tarlist) {
                    player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.AQUA + s));
                }
                return true;
            }
        }
        return false;
    }

    public ItemStack func_77659_a(ItemStack item, World world, EntityPlayer player) {
        return item;
    }

    public boolean func_77648_a(ItemStack item, EntityPlayer player, World world, int x, int y, int z, int side, float hitx, float hity, float hitz) {
        if (!world.field_72995_K && player != null && player.func_70093_af()) {
            TileEntity tile = world.func_147438_o(x, y, z);
            if (tile instanceof TileEntityCrane) {
                this.tilePoint[this.pointID] = new int[]{x, y, z};
                this.pointID = this.changePoint(this.pointID);
                if (!this.pairCrane(world)) {
                    return this.setWaypoint(world);
                }
                return true;
            }
            if (tile instanceof IInventory) {
                this.tileChest = new int[]{x, y, z};
                return this.pairCrane(world);
            }
            if (tile instanceof ITileWaypoint) {
                this.tilePoint[this.pointID] = new int[]{x, y, z};
                this.pointID = this.changePoint(this.pointID);
                return this.setWaypoint(world);
            }
            ServerProxy.getServer().func_71203_ab().func_148539_a((IChatComponent)new ChatComponentText(EnumChatFormatting.YELLOW + StatCollector.func_74838_a((String)"chat.shincolle:wrench.wrongtile")));
        }
        return false;
    }

    public void func_77624_a(ItemStack itemstack, EntityPlayer player, List list, boolean par4) {
        list.add(EnumChatFormatting.RED + I18n.func_135052_a((String)"gui.shincolle:wrench1", (Object[])new Object[0]));
        list.add(EnumChatFormatting.AQUA + I18n.func_135052_a((String)"gui.shincolle:wrench2", (Object[])new Object[0]));
        list.add(EnumChatFormatting.YELLOW + I18n.func_135052_a((String)"gui.shincolle:wrench3", (Object[])new Object[0]));
    }

    private int changePoint(int par1) {
        return par1 == 0 ? 1 : 0;
    }

    private void resetPos() {
        this.tileChest = new int[]{-1, -1, -1};
        this.tilePoint = new int[][]{{-1, -1, -1}, {-1, -1, -1}};
        this.pointID = 0;
    }

    private boolean setWaypoint(World world) {
        try {
            if (this.tilePoint != null && this.tilePoint[0][1] > 0 && this.tilePoint[1][1] > 0) {
                int dx = this.tilePoint[0][0] - this.tilePoint[1][0];
                int dy = this.tilePoint[0][1] - this.tilePoint[1][1];
                int dz = this.tilePoint[0][2] - this.tilePoint[1][2];
                dx *= dx;
                dy *= dy;
                dz *= dz;
                if (dx == 0 && dy == 0 && dz == 0) {
                    this.resetPos();
                    return false;
                }
                if (dx + dy + dz < 2304) {
                    TileEntity tile1 = world.func_147438_o(this.tilePoint[this.pointID][0], this.tilePoint[this.pointID][1], this.tilePoint[this.pointID][2]);
                    this.pointID = this.changePoint(this.pointID);
                    TileEntity tile2 = world.func_147438_o(this.tilePoint[this.pointID][0], this.tilePoint[this.pointID][1], this.tilePoint[this.pointID][2]);
                    if (tile1 instanceof ITileWaypoint && tile2 instanceof ITileWaypoint) {
                        ITileWaypoint wpFrom = (ITileWaypoint)tile1;
                        ITileWaypoint wpTo = (ITileWaypoint)tile2;
                        int[] posT = new int[]{this.tilePoint[this.pointID][0], this.tilePoint[this.pointID][1], this.tilePoint[this.pointID][2]};
                        this.pointID = this.changePoint(this.pointID);
                        int[] posF = new int[]{this.tilePoint[this.pointID][0], this.tilePoint[this.pointID][1], this.tilePoint[this.pointID][2]};
                        int[] nextWpTo = wpTo.getNextWaypoint();
                        wpFrom.setNextWaypoint(posT);
                        if (nextWpTo[0] != posF[0] || nextWpTo[1] != posF[1] || nextWpTo[2] != posF[2]) {
                            wpTo.setLastWaypoint(posF);
                        }
                        ((BasicTileEntity)((Object)wpFrom)).sendSyncPacket();
                        ((BasicTileEntity)((Object)wpTo)).sendSyncPacket();
                        this.resetPos();
                        ServerProxy.getServer().func_71203_ab().func_148539_a((IChatComponent)new ChatComponentText(EnumChatFormatting.AQUA + StatCollector.func_74838_a((String)"chat.shincolle:wrench.setwp") + "  " + EnumChatFormatting.GREEN + posF[0] + " " + posF[1] + " " + posF[2] + EnumChatFormatting.AQUA + " --> " + EnumChatFormatting.GOLD + posT[0] + " " + posT[1] + " " + posT[2]));
                        return true;
                    }
                } else {
                    ServerProxy.getServer().func_71203_ab().func_148539_a((IChatComponent)new ChatComponentText(EnumChatFormatting.YELLOW + StatCollector.func_74838_a((String)"chat.shincolle:wrench.wptoofar")));
                }
                this.resetPos();
            }
        }
        catch (Exception e) {
            LogHelper.info("EXCEPTION : set waypoint fail: " + e);
            return false;
        }
        return false;
    }

    private boolean pairCrane(World world) {
        try {
            if (this.tileChest[1] <= 0) {
                return false;
            }
            TileEntity tile1 = world.func_147438_o(this.tileChest[0], this.tileChest[1], this.tileChest[2]);
            this.pointID = this.changePoint(this.pointID);
            TileEntity tile2 = world.func_147438_o(this.tilePoint[this.pointID][0], this.tilePoint[this.pointID][1], this.tilePoint[this.pointID][2]);
            if (tile1 instanceof IInventory && tile2 instanceof TileEntityCrane) {
                int dx = this.tileChest[0] - tile2.field_145851_c;
                int dy = this.tileChest[1] - tile2.field_145848_d;
                int dz = this.tileChest[2] - tile2.field_145849_e;
                dx *= dx;
                dy *= dy;
                dz *= dz;
                int dist = dx + dy + dz;
                if (dx == 0 && dy == 0 && dz == 0) {
                    this.resetPos();
                    return false;
                }
                if (dist <= 40) {
                    ((TileEntityCrane)tile2).setPairedChest(this.tileChest[0], this.tileChest[1], this.tileChest[2]);
                    ServerProxy.getServer().func_71203_ab().func_148539_a((IChatComponent)new ChatComponentText(EnumChatFormatting.AQUA + StatCollector.func_74838_a((String)"chat.shincolle:wrench.paired") + " " + EnumChatFormatting.GREEN + this.tileChest[0] + " " + this.tileChest[1] + " " + this.tileChest[2] + EnumChatFormatting.AQUA + " & " + EnumChatFormatting.GOLD + tile2.field_145851_c + " " + tile2.field_145848_d + " " + tile2.field_145849_e));
                    ((TileEntityCrane)tile2).sendSyncPacket();
                    this.resetPos();
                    return true;
                }
                ServerProxy.getServer().func_71203_ab().func_148539_a((IChatComponent)new ChatComponentText(EnumChatFormatting.YELLOW + StatCollector.func_74838_a((String)"chat.shincolle:wrench.toofar")));
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }
}

