/*
 * Decompiled with CFR 0.152.
 */
package com.lulan.shincolle.item;

import com.lulan.shincolle.crafting.ShipCalc;
import com.lulan.shincolle.creativetab.CreativeTabSC;
import com.lulan.shincolle.entity.BasicEntityShip;
import com.lulan.shincolle.entity.ExtendShipProps;
import com.lulan.shincolle.entity.IShipOwner;
import com.lulan.shincolle.utility.EntityHelper;
import com.lulan.shincolle.utility.LogHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class ShipSpawnEgg
extends Item {
    Random rand;
    private IIcon[] iconEgg = new IIcon[3];
    private EntityLiving entityToSpawn = null;
    private String entityToSpawnName = null;

    public ShipSpawnEgg() {
        this.func_77627_a(true);
        this.func_77637_a(CreativeTabSC.SC_TAB);
        this.field_77777_bU = 1;
        this.rand = new Random();
    }

    public String func_77667_c(ItemStack itemstack) {
        int metaid = itemstack.func_77960_j();
        switch (metaid) {
            case 0: {
                return String.format("item.shincolle:smallegg", new Object[0]);
            }
            case 1: {
                return String.format("item.shincolle:largeegg", new Object[0]);
            }
        }
        return String.format("item.shincolle:shipegg" + metaid, new Object[0]);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        for (int i = 0; i < 3; ++i) {
            this.iconEgg[i] = iconRegister.func_94245_a("shincolle:shipegg_" + i);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int meta) {
        if (meta > 2) {
            meta = 2;
        }
        return this.iconEgg[meta];
    }

    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        list.add(new ItemStack(item, 1, 0));
        list.add(new ItemStack(item, 1, 1));
        list.add(new ItemStack(item, 1, 2));
        list.add(new ItemStack(item, 1, 3));
        list.add(new ItemStack(item, 1, 4));
        list.add(new ItemStack(item, 1, 5));
        list.add(new ItemStack(item, 1, 11));
        list.add(new ItemStack(item, 1, 12));
        list.add(new ItemStack(item, 1, 14));
        list.add(new ItemStack(item, 1, 16));
        list.add(new ItemStack(item, 1, 17));
        list.add(new ItemStack(item, 1, 18));
        list.add(new ItemStack(item, 1, 19));
        list.add(new ItemStack(item, 1, 20));
        list.add(new ItemStack(item, 1, 21));
        list.add(new ItemStack(item, 1, 22));
        list.add(new ItemStack(item, 1, 23));
        list.add(new ItemStack(item, 1, 28));
        list.add(new ItemStack(item, 1, 30));
        list.add(new ItemStack(item, 1, 33));
        list.add(new ItemStack(item, 1, 35));
        list.add(new ItemStack(item, 1, 53));
        list.add(new ItemStack(item, 1, 2053));
        list.add(new ItemStack(item, 1, 54));
        list.add(new ItemStack(item, 1, 2054));
        list.add(new ItemStack(item, 1, 55));
        list.add(new ItemStack(item, 1, 2055));
        list.add(new ItemStack(item, 1, 56));
        list.add(new ItemStack(item, 1, 2056));
        list.add(new ItemStack(item, 1, 38));
        list.add(new ItemStack(item, 1, 2038));
        list.add(new ItemStack(item, 1, 39));
        list.add(new ItemStack(item, 1, 2039));
        list.add(new ItemStack(item, 1, 48));
        list.add(new ItemStack(item, 1, 2048));
        list.add(new ItemStack(item, 1, 40));
        list.add(new ItemStack(item, 1, 2040));
        list.add(new ItemStack(item, 1, 41));
        list.add(new ItemStack(item, 1, 2041));
        list.add(new ItemStack(item, 1, 49));
        list.add(new ItemStack(item, 1, 2049));
        list.add(new ItemStack(item, 1, 50));
        list.add(new ItemStack(item, 1, 2050));
    }

    private Entity spawnEntity(EntityPlayer player, ItemStack item, double parX, double parY, double parZ, boolean checkPlayer) {
        int entityType = 0;
        if (player != null && !player.field_70170_p.field_72995_K) {
            int uid;
            if (checkPlayer && (uid = EntityHelper.getPlayerUID((Entity)player)) <= 0) {
                return null;
            }
            entityType = ShipCalc.rollShipType(item);
            this.entityToSpawnName = ShipCalc.getEntityToSpawnName(entityType);
            LogHelper.info("DEBUG : spawn entity: " + this.entityToSpawnName);
            if (EntityList.field_75625_b.containsKey(this.entityToSpawnName)) {
                this.entityToSpawn = (EntityLiving)EntityList.func_75620_a((String)this.entityToSpawnName, (World)player.field_70170_p);
                this.entityToSpawn.func_70012_b(parX, parY, parZ, MathHelper.func_76142_g((float)(player.field_70170_p.field_73012_v.nextFloat() * 360.0f)), 0.0f);
                player.field_70170_p.func_72838_d((Entity)this.entityToSpawn);
                this.entityToSpawn.func_110161_a((IEntityLivingData)null);
                this.entityToSpawn.func_70642_aH();
            } else {
                LogHelper.info("Entity not found " + this.entityToSpawnName);
            }
        }
        return this.entityToSpawn;
    }

    private void initEntityAttribute(ItemStack itemstack, EntityPlayer player, BasicEntityShip entity) {
        LogHelper.info("DEBUG : init ship states");
        entity.func_70903_f(true);
        entity.func_70778_a(null);
        entity.setEntityTarget(null);
        if (itemstack.func_77960_j() > 1) {
            NBTTagCompound nbt = itemstack.func_77978_p();
            if (nbt != null) {
                String ownerid;
                NBTTagList list = nbt.func_150295_c("ShipInv", 10);
                ExtendShipProps extProps = entity.getExtProps();
                try {
                    for (int i = 0; i < list.func_74745_c(); ++i) {
                        NBTTagCompound item = list.func_150305_b(i);
                        byte sid = item.func_74771_c("Slot");
                        if (sid < 0 || sid >= extProps.slots.length) continue;
                        extProps.slots[sid] = ItemStack.func_77949_a((NBTTagCompound)item);
                    }
                }
                catch (Exception e) {
                    LogHelper.info("EXCEPTION : init ship inventory fail: " + e);
                }
                int[] attrs = nbt.func_74759_k("Attrs");
                int[] attrs2 = nbt.func_74759_k("Attrs2");
                byte[] flags = nbt.func_74770_j("Flags");
                try {
                    if (flags.length >= 14) {
                        entity.setStateFlag(1, flags[0] > 0);
                        entity.setStateFlag(3, flags[1] > 0);
                        entity.setStateFlag(4, flags[2] > 0);
                        entity.setStateFlag(5, flags[3] > 0);
                        entity.setStateFlag(6, flags[4] > 0);
                        entity.setStateFlag(7, flags[5] > 0);
                        entity.setStateFlag(9, flags[6] > 0);
                        entity.setStateFlag(12, flags[7] > 0);
                        entity.setStateFlag(18, flags[8] > 0);
                        entity.setStateFlag(19, flags[9] > 0);
                        entity.setStateFlag(20, flags[10] > 0);
                        entity.setStateFlag(21, flags[11] > 0);
                        entity.setStateFlag(22, flags[12] > 0);
                        entity.setStateFlag(23, flags[13] > 0);
                    }
                    if (attrs2.length >= 6) {
                        entity.setStateEmotion(0, attrs2[0], false);
                        entity.setStateEmotion(4, attrs2[1], false);
                        entity.setStateMinor(10, attrs2[2]);
                        entity.setStateMinor(11, attrs2[3]);
                        entity.setStateMinor(12, attrs2[4]);
                        entity.setStateMinor(44, attrs2[5]);
                    }
                    if (attrs.length >= 7) {
                        entity.setBonusPoint(0, (byte)attrs[1]);
                        entity.setBonusPoint(1, (byte)attrs[2]);
                        entity.setBonusPoint(2, (byte)attrs[3]);
                        entity.setBonusPoint(3, (byte)attrs[4]);
                        entity.setBonusPoint(4, (byte)attrs[5]);
                        entity.setBonusPoint(5, (byte)attrs[6]);
                        entity.setShipLevel(attrs[0], true);
                    }
                }
                catch (Exception e) {
                    LogHelper.info("EXCEPTION: init ship attrs fail: " + e);
                    e.printStackTrace();
                }
                String customname = nbt.func_74779_i("customname");
                if (customname != null && customname.length() > 0) {
                    entity.setNameTag(customname);
                }
                if ((ownerid = nbt.func_74779_i("owner")) != null && ownerid.length() > 5) {
                    entity.func_152115_b(ownerid);
                }
                int pid = nbt.func_74762_e("PlayerID");
                int sid = nbt.func_74762_e("ShipID");
                if (pid > 0) {
                    entity.setStateMinor(21, pid);
                }
                if (sid > 0) {
                    entity.setStateMinor(22, sid);
                }
                EntityHelper.setPetPlayerUUID(pid, (EntityTameable)entity);
            } else {
                entity.setShipLevel(1, true);
                EntityHelper.setPetPlayerUUID(player.func_110124_au().toString(), (EntityTameable)entity);
                EntityHelper.setPetPlayerUID(player, (IShipOwner)entity);
            }
        } else {
            LogHelper.info("DEBUG : new spawn egg (random)");
            EntityHelper.setPetPlayerUUID(player.func_110124_au().toString(), (EntityTameable)entity);
            EntityHelper.setPetPlayerUID(player, (IShipOwner)entity);
            entity.setBonusPoint(0, (byte)0);
            entity.setBonusPoint(1, (byte)0);
            entity.setBonusPoint(2, (byte)0);
            entity.setBonusPoint(3, (byte)0);
            entity.setBonusPoint(4, (byte)0);
            entity.setBonusPoint(5, (byte)0);
            entity.setShipLevel(1, true);
        }
    }

    public ItemStack func_77659_a(ItemStack itemstack, World world, EntityPlayer player) {
        if (world.field_72995_K) {
            return itemstack;
        }
        MovingObjectPosition movingobjectposition = this.func_77621_a(world, player, true);
        if (movingobjectposition == null) {
            return itemstack;
        }
        if (movingobjectposition.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            int i = movingobjectposition.field_72311_b;
            int j = movingobjectposition.field_72312_c;
            int k = movingobjectposition.field_72309_d;
            if (!world.func_72962_a(player, i, j, k)) {
                return itemstack;
            }
            if (!player.func_82247_a(i, j, k, movingobjectposition.field_72310_e, itemstack)) {
                return itemstack;
            }
            if (!player.field_71075_bZ.field_75098_d) {
                if (itemstack.func_77960_j() > 1 && itemstack.func_77942_o()) {
                    NBTTagCompound nbt = itemstack.func_77978_p();
                    int costLevel = nbt.func_74759_k("Attrs")[0] / 3;
                    if (player.field_71068_ca < costLevel) {
                        player.func_145747_a((IChatComponent)new ChatComponentText("LEVEL is too LOW!"));
                        return itemstack;
                    }
                    player.func_82242_a(-costLevel);
                }
                --itemstack.field_77994_a;
            }
            if (itemstack.func_77960_j() > 2000) {
                LogHelper.info("DEBUG : use boss egg");
                this.spawnEntity(player, itemstack, i, (double)j + 1.0, k, false);
            } else {
                LogHelper.info("DEBUG : use normal egg");
                BasicEntityShip entity = (BasicEntityShip)this.spawnEntity(player, itemstack, i, (double)j + 1.0, k, true);
                if (entity != null) {
                    if (itemstack.func_82837_s()) {
                        entity.func_94058_c(itemstack.func_82833_r());
                    }
                    this.initEntityAttribute(itemstack, player, entity);
                    entity.sendSyncPacketAllValue();
                }
            }
        }
        return itemstack;
    }

    public void func_77624_a(ItemStack itemstack, EntityPlayer player, List list, boolean par4) {
        int[] material = new int[4];
        if (itemstack.func_77942_o()) {
            NBTTagCompound nbt = itemstack.func_77978_p();
            if (nbt.func_74764_b("Attrs")) {
                list.add(EnumChatFormatting.AQUA + "" + I18n.func_135052_a((String)"gui.shincolle:eggText", (Object[])new Object[0]) + " " + nbt.func_74759_k("Attrs")[0] / 3);
                list.add(EnumChatFormatting.WHITE + "" + nbt.func_74779_i("customname"));
                list.add(EnumChatFormatting.RED + "" + nbt.func_74779_i("ownername"));
            } else {
                material[0] = itemstack.field_77990_d.func_74762_e("Grudge");
                material[1] = itemstack.field_77990_d.func_74762_e("Abyssium");
                material[2] = itemstack.field_77990_d.func_74762_e("Ammo");
                material[3] = itemstack.field_77990_d.func_74762_e("Polymetal");
                list.add(EnumChatFormatting.WHITE + "" + material[0] + " " + I18n.func_135052_a((String)"item.shincolle:Grudge.name", (Object[])new Object[0]));
                list.add(EnumChatFormatting.RED + "" + material[1] + " " + I18n.func_135052_a((String)"item.shincolle:AbyssMetal.name", (Object[])new Object[0]));
                list.add(EnumChatFormatting.GREEN + "" + material[2] + " " + I18n.func_135052_a((String)"item.shincolle:Ammo.name", (Object[])new Object[0]));
                list.add(EnumChatFormatting.AQUA + "" + material[3] + " " + I18n.func_135052_a((String)"item.shincolle:AbyssMetal1.name", (Object[])new Object[0]));
            }
        }
    }
}

