/*
 * Decompiled with CFR 0.152.
 */
package com.lulan.shincolle.entity.submarine;

import com.lulan.shincolle.ai.EntityAIShipPickItem;
import com.lulan.shincolle.ai.EntityAIShipRangeAttack;
import com.lulan.shincolle.entity.BasicEntityShipSmall;
import com.lulan.shincolle.entity.ExtendShipProps;
import com.lulan.shincolle.entity.IShipAttackBase;
import com.lulan.shincolle.entity.IShipInvisible;
import com.lulan.shincolle.entity.other.EntityAbyssMissile;
import com.lulan.shincolle.handler.ConfigHandler;
import com.lulan.shincolle.network.S2CSpawnParticle;
import com.lulan.shincolle.proxy.CommonProxy;
import com.lulan.shincolle.utility.EntityHelper;
import com.lulan.shincolle.utility.ParticleHelper;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class EntitySubmYo
extends BasicEntityShipSmall
implements IShipInvisible {
    private static float ilevel = 20.0f;

    public EntitySubmYo(World world) {
        super(world);
        this.func_70105_a(0.6f, 1.8f);
        this.setStateMinor(19, 8);
        this.setStateMinor(20, 18);
        this.setStateMinor(25, 6);
        this.setGrudgeConsumption(ConfigHandler.consumeGrudgeShip[9]);
        this.setAmmoConsumption(ConfigHandler.consumeAmmoShip[9]);
        this.ModelPos = new float[]{0.0f, 10.0f, 0.0f, 45.0f};
        this.ExtProps = (ExtendShipProps)this.getExtendedProperties("ShipExtProps");
        this.StateFlag[17] = true;
        this.StateFlag[15] = false;
        this.StateFlag[16] = false;
        this.StateFlag[24] = true;
        this.postInit();
    }

    @Override
    public float func_70047_e() {
        return 1.7f;
    }

    @Override
    public int getEquipType() {
        return 1;
    }

    @Override
    public void setAIList() {
        super.setAIList();
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new EntityAIShipRangeAttack(this));
        this.field_70714_bg.func_75776_a(20, (EntityAIBase)new EntityAIShipPickItem(this, 4.0f));
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70173_aa % 128 == 0) {
                if (this.getStateFlag(9)) {
                    EntityPlayerMP player = (EntityPlayerMP)EntityHelper.getEntityPlayerByUID(this.getPlayerUID());
                    if (this.getStateFlag(1) && this.getStateMinor(6) > 0 && player != null && this.func_70068_e((Entity)player) < 256.0) {
                        player.func_70690_d(new PotionEffect(Potion.field_76441_p.field_76415_H, 100 + this.getLevel() * 2));
                    }
                }
                if (this.field_70173_aa % 256 == 0 && this.getStateFlag(9) && this.getStateMinor(6) > 0) {
                    this.func_70690_d(new PotionEffect(Potion.field_76441_p.field_76415_H, 46 + this.getLevel()));
                }
            }
        } else if (this.field_70173_aa % 4 == 0 && this.getStateEmotion(0) > 0 && !this.getStateFlag(2) && (this.func_70906_o() && this.getStateEmotion(1) != 4 || !this.func_70906_o())) {
            float[] eyePosR;
            float[] eyePosL;
            float radYaw = this.field_70761_aq * ((float)Math.PI / 180);
            float radPitch = this.field_70125_A * ((float)Math.PI / 180);
            if (this.func_70906_o()) {
                eyePosL = new float[]{0.35f, 1.35f, -0.4f};
                eyePosR = new float[]{-0.35f, 1.35f, -0.4f};
            } else {
                eyePosL = new float[]{0.35f, 1.5f, -0.4f};
                eyePosR = new float[]{-0.35f, 1.5f, -0.4f};
            }
            eyePosL = ParticleHelper.rotateXYZByYawPitch(eyePosL[0], eyePosL[1], eyePosL[2], radYaw, radPitch, 1.0f);
            eyePosR = ParticleHelper.rotateXYZByYawPitch(eyePosR[0], eyePosR[1], eyePosR[2], radYaw, radPitch, 1.0f);
            ParticleHelper.spawnAttackParticleAt(this.field_70165_t + (double)eyePosL[0], this.field_70163_u + (double)eyePosL[1], this.field_70161_v + (double)eyePosL[2], 0.0, 0.05, 0.5, (byte)16);
            ParticleHelper.spawnAttackParticleAt(this.field_70165_t + (double)eyePosR[0], this.field_70163_u + (double)eyePosR[1], this.field_70161_v + (double)eyePosR[2], 0.0, 0.05, 0.5, (byte)16);
        }
    }

    @Override
    public boolean func_70085_c(EntityPlayer player) {
        ItemStack itemstack = player.field_71071_by.func_70448_g();
        if (itemstack != null && itemstack.func_77973_b() == Items.field_151105_aU) {
            this.setShipOutfit(player.func_70093_af());
            return true;
        }
        super.func_70085_c(player);
        return false;
    }

    @Override
    public int getKaitaiType() {
        return 0;
    }

    @Override
    public double func_70042_X() {
        if (this.getStateEmotion(0) > 0) {
            if (this.func_70906_o()) {
                if (this.getStateEmotion(1) == 4) {
                    return 0.75;
                }
                return 0.1f;
            }
            return (double)this.field_70131_O * 0.25;
        }
        if (this.func_70906_o()) {
            if (this.getStateEmotion(1) == 4) {
                return 0.65f;
            }
            return 0.0;
        }
        return 0.9f;
    }

    @Override
    public float getInvisibleLevel() {
        return ilevel;
    }

    @Override
    public void setInvisibleLevel(float level) {
        ilevel = level;
    }

    @Override
    public void setShipOutfit(boolean isSneaking) {
        if (isSneaking) {
            switch (this.getStateEmotion(4)) {
                case 0: {
                    this.setStateEmotion(4, 1, true);
                    break;
                }
                default: {
                    this.setStateEmotion(4, 0, true);
                    break;
                }
            }
        } else {
            switch (this.getStateEmotion(0)) {
                case 0: {
                    this.setStateEmotion(0, 1, true);
                    break;
                }
                default: {
                    this.setStateEmotion(0, 0, true);
                }
            }
        }
    }

    @Override
    public boolean attackEntityWithAmmo(Entity target) {
        float atk = this.StateFinal[1];
        boolean isDirect = false;
        float tarX = (float)target.field_70165_t;
        float tarY = (float)target.field_70163_u;
        float tarZ = (float)target.field_70161_v;
        float distX = tarX - (float)this.field_70165_t;
        float distY = tarY - (float)this.field_70163_u;
        float distZ = tarZ - (float)this.field_70161_v;
        float distSqrt = MathHelper.func_76129_c((float)(distX * distX + distY * distY + distZ * distZ));
        float launchPos = (float)this.field_70163_u + this.field_70131_O * 0.7f;
        if (distX * distX + distY * distY + distZ * distZ < 36.0f) {
            isDirect = true;
        }
        if (this.getShipDepth() > 0.0) {
            isDirect = true;
            launchPos = (float)this.field_70163_u;
        }
        NetworkRegistry.TargetPoint point = new NetworkRegistry.TargetPoint(this.field_71093_bK, this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0);
        CommonProxy.channelP.sendToAllAround((IMessage)new S2CSpawnParticle((Entity)this, 0, true), point);
        this.addShipExp(ConfigHandler.expGain[1]);
        this.decrGrudgeNum(ConfigHandler.consumeGrudgeAction[0]);
        this.decrMorale(1);
        this.setCombatTick(this.field_70173_aa);
        this.func_85030_a("shincolle:ship-fireheavy", ConfigHandler.volumeFire, 0.7f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        if (this.func_70681_au().nextInt(10) > 7) {
            this.func_85030_a(this.getSoundString(2), ConfigHandler.volumeShip, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        }
        if (!this.decrAmmoNum(0, this.getAmmoConsumption())) {
            return false;
        }
        float missChance = 0.2f + 0.15f * (distSqrt / this.StateFinal[5]) - 0.001f * (float)this.StateMinor[0];
        if ((missChance -= this.EffectEquip[3]) > 0.35f) {
            missChance = 0.35f;
        }
        if (this.field_70146_Z.nextFloat() < missChance) {
            tarX = tarX - 3.0f + this.field_70146_Z.nextFloat() * 6.0f;
            tarY += this.field_70146_Z.nextFloat() * 3.0f;
            tarZ = tarZ - 3.0f + this.field_70146_Z.nextFloat() * 6.0f;
            CommonProxy.channelP.sendToAllAround((IMessage)new S2CSpawnParticle((Entity)this, 10, false), point);
        }
        EntityAbyssMissile missile = new EntityAbyssMissile(this.field_70170_p, (IShipAttackBase)this, tarX, tarY + target.field_70131_O * 0.2f, tarZ, launchPos, atk, 0.1f, isDirect, 0.08f);
        this.field_70170_p.func_72838_d((Entity)missile);
        this.applyEmotesReaction(3);
        if (ConfigHandler.canFlare) {
            this.flareTarget(target);
        }
        return true;
    }
}

