/*
 * Decompiled with CFR 0.152.
 */
package com.lulan.shincolle.entity.other;

import com.lulan.shincolle.ai.EntityAIShipRangeAttack;
import com.lulan.shincolle.ai.path.ShipMoveHelper;
import com.lulan.shincolle.ai.path.ShipPathNavigate;
import com.lulan.shincolle.entity.IShipAttackBase;
import com.lulan.shincolle.entity.IShipCannonAttack;
import com.lulan.shincolle.entity.other.EntityAbyssMissile;
import com.lulan.shincolle.handler.ConfigHandler;
import com.lulan.shincolle.network.S2CEntitySync;
import com.lulan.shincolle.network.S2CSpawnParticle;
import com.lulan.shincolle.proxy.CommonProxy;
import com.lulan.shincolle.utility.BlockHelper;
import com.lulan.shincolle.utility.CalcHelper;
import com.lulan.shincolle.utility.EntityHelper;
import com.lulan.shincolle.utility.ParticleHelper;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class EntityRensouhouBoss
extends EntityMob
implements IShipCannonAttack {
    protected IShipAttackBase host;
    protected EntityLivingBase host2;
    protected World world;
    protected ShipPathNavigate shipNavigator;
    protected ShipMoveHelper shipMoveHelper;
    protected Entity atkTarget;
    protected Entity rvgTarget;
    protected int revengeTime;
    protected float atk;
    protected float atkSpeed;
    protected float atkRange;
    protected float defValue;
    protected float movSpeed;
    protected float kbValue;
    protected int numAmmoLight;
    protected int numAmmoHeavy;
    protected byte StateEmotion;
    protected byte StateEmotion2;
    protected int StartEmotion;
    protected int StartEmotion2;
    protected int StartEmotion3;
    protected boolean headTilt;

    public EntityRensouhouBoss(World world) {
        super(world);
        this.func_70105_a(0.9f, 1.7f);
        this.field_70178_ae = true;
    }

    public EntityRensouhouBoss(World world, IShipAttackBase host, Entity target) {
        super(world);
        this.world = world;
        this.host = host;
        this.host2 = (EntityLivingBase)host;
        this.atkTarget = target;
        this.field_70178_ae = true;
        this.shipNavigator = new ShipPathNavigate((EntityLiving)this, this.field_70170_p);
        this.shipMoveHelper = new ShipMoveHelper((EntityLiving)this, 40.0f);
        this.atk = 30.0f;
        this.atkSpeed = 0.8f;
        this.atkRange = host.getAttackRange();
        this.defValue = host.getDefValue() * 0.5f;
        this.movSpeed = 0.6f;
        this.numAmmoLight = 6;
        this.numAmmoHeavy = 0;
        this.StateEmotion = 0;
        this.StateEmotion2 = 0;
        this.StartEmotion = 0;
        this.StartEmotion2 = 0;
        this.headTilt = false;
        this.field_70165_t = this.host2.field_70165_t + this.field_70146_Z.nextDouble() * 6.0 - 3.0;
        this.field_70163_u = this.host2.field_70163_u + 0.5;
        this.field_70161_v = this.host2.field_70161_v + this.field_70146_Z.nextDouble() * 6.0 - 3.0;
        if (!BlockHelper.checkBlockSafe(world, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v)) {
            this.field_70165_t = this.host2.field_70165_t;
            this.field_70163_u = this.host2.field_70163_u;
            this.field_70161_v = this.host2.field_70161_v;
        }
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(ConfigHandler.scaleBossSmall[0] * 0.125);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)this.movSpeed);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a((double)(this.atkRange + 32.0f));
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.2);
        if (this.func_110143_aJ() < this.func_110138_aP()) {
            this.func_70606_j(this.func_110138_aP());
        }
        this.setAIList();
    }

    public float func_70047_e() {
        return this.field_70131_O;
    }

    protected void setAIList() {
        this.clearAITasks();
        this.clearAITargetTasks();
        this.func_70661_as().func_75490_c(true);
        this.func_70661_as().func_75491_a(false);
        this.func_70661_as().func_75495_e(true);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIShipRangeAttack(this));
        this.setEntityTarget(this.atkTarget);
    }

    public boolean func_70097_a(DamageSource attacker, float atk) {
        if (attacker.func_76355_l() == "inWall") {
            return false;
        }
        if (EntityHelper.canDodge(this, 0.0f)) {
            return false;
        }
        if (this.getStateEmotion(1) != 3) {
            this.setStateEmotion(1, 3, true);
        }
        if (this.func_85032_ar()) {
            return false;
        }
        if (attacker.func_76364_f() != null) {
            Entity entity = attacker.func_76364_f();
            if (entity.equals((Object)this)) {
                return false;
            }
            if (attacker.func_76355_l().equals("outOfWorld")) {
                this.func_70106_y();
                return false;
            }
            float reduceAtk = atk;
            reduceAtk = atk * (1.0f - this.getDefValue() * 0.01f);
            if (entity instanceof IShipAttackBase) {
                int modSet = this.field_70170_p.field_73011_w.isDaytime() ? 0 : 1;
                reduceAtk = CalcHelper.calcDamageByType(reduceAtk, ((IShipAttackBase)entity).getDamageType(), this.getDamageType(), modSet);
            }
            if (reduceAtk < 1.0f) {
                reduceAtk = 1.0f;
            }
            return super.func_70097_a(attacker, reduceAtk);
        }
        return false;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            double motX = this.field_70165_t - this.field_70169_q;
            double motZ = this.field_70161_v - this.field_70166_s;
            double parH = this.field_70163_u - (double)((int)this.field_70163_u);
            if (motX != 0.0 || motZ != 0.0) {
                ParticleHelper.spawnAttackParticleAt(this.field_70165_t + motX * 1.5, this.field_70163_u, this.field_70161_v + motZ * 1.5, -motX * 0.5, 0.0, -motZ * 0.5, (byte)15);
            }
        } else {
            boolean setdead = false;
            if (this.host == null || !((Entity)this.host).func_70089_S()) {
                setdead = true;
            } else {
                if (this.field_70173_aa > 1200) {
                    setdead = true;
                }
                if (this.getEntityTarget() == null || this.getEntityTarget().field_70128_L) {
                    if (this.host != null && this.host.getEntityTarget() != null && this.host.getEntityTarget().func_70089_S()) {
                        this.atkTarget = this.host.getEntityTarget();
                    } else {
                        setdead = true;
                    }
                }
                if (this.func_70090_H() && this.field_70173_aa % 100 == 0) {
                    this.func_70050_g(300);
                }
            }
            if (setdead) {
                this.func_70106_y();
            }
        }
    }

    @Override
    public byte getStateEmotion(int id) {
        return id == 1 ? this.StateEmotion : this.StateEmotion2;
    }

    @Override
    public void setStateEmotion(int id, int value, boolean sync) {
        switch (id) {
            case 1: {
                this.StateEmotion = (byte)value;
                break;
            }
            case 2: {
                this.StateEmotion2 = (byte)value;
                break;
            }
        }
        if (sync && !this.field_70170_p.field_72995_K) {
            NetworkRegistry.TargetPoint point = new NetworkRegistry.TargetPoint(this.field_71093_bK, this.field_70165_t, this.field_70163_u, this.field_70161_v, 32.0);
            CommonProxy.channelE.sendToAllAround((IMessage)new S2CEntitySync(this, 4), point);
        }
    }

    @Override
    public boolean getStateFlag(int flag) {
        switch (flag) {
            default: {
                return true;
            }
            case 8: {
                return this.headTilt;
            }
            case 12: 
        }
        return false;
    }

    @Override
    public void setStateFlag(int id, boolean flag) {
        this.headTilt = flag;
    }

    @Override
    public int getFaceTick() {
        return this.StartEmotion;
    }

    @Override
    public int getHeadTiltTick() {
        return this.StartEmotion2;
    }

    @Override
    public void setFaceTick(int par1) {
        this.StartEmotion = par1;
    }

    @Override
    public void setHeadTiltTick(int par1) {
        this.StartEmotion2 = par1;
    }

    @Override
    public int getTickExisted() {
        return this.field_70173_aa;
    }

    @Override
    public int getAttackTime() {
        return this.field_70724_aR;
    }

    public boolean func_70650_aV() {
        return true;
    }

    protected void clearAITasks() {
        this.field_70714_bg.field_75782_a.clear();
    }

    protected void clearAITargetTasks() {
        this.field_70715_bh.field_75782_a.clear();
    }

    @Override
    public boolean attackEntityWithAmmo(Entity target) {
        boolean isTargetHurt;
        float atkLight = CalcHelper.calcDamageBySpecialEffect(this, target, this.atk, 0);
        this.func_85030_a("shincolle:ship-firesmall", ConfigHandler.volumeFire, 0.7f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        float distX = (float)(target.field_70165_t - this.field_70165_t);
        float distY = (float)(target.field_70163_u - this.field_70163_u);
        float distZ = (float)(target.field_70161_v - this.field_70161_v);
        float distSqrt = MathHelper.func_76129_c((float)(distX * distX + distY * distY + distZ * distZ));
        NetworkRegistry.TargetPoint point0 = new NetworkRegistry.TargetPoint(this.field_71093_bK, this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0);
        CommonProxy.channelP.sendToAllAround((IMessage)new S2CSpawnParticle((Entity)this, 6, this.field_70165_t, this.field_70163_u + 1.5, this.field_70161_v, distX /= distSqrt, distY /= distSqrt, distZ /= distSqrt, true), point0);
        NetworkRegistry.TargetPoint point = new NetworkRegistry.TargetPoint(this.field_71093_bK, this.host2.field_70165_t, this.host2.field_70163_u, this.host2.field_70161_v, 64.0);
        float missChance = 0.25f;
        if (this.field_70146_Z.nextFloat() < missChance) {
            atkLight = 0.0f;
            CommonProxy.channelP.sendToAllAround((IMessage)new S2CSpawnParticle((Entity)this.host2, 10, false), point);
        } else if (this.field_70146_Z.nextFloat() < 0.1f) {
            atkLight *= 1.5f;
            CommonProxy.channelP.sendToAllAround((IMessage)new S2CSpawnParticle((Entity)this.host2, 11, false), point);
        } else if (this.field_70146_Z.nextFloat() < 0.1f) {
            atkLight *= 2.0f;
            CommonProxy.channelP.sendToAllAround((IMessage)new S2CSpawnParticle((Entity)this.host2, 12, false), point);
        } else if (this.field_70146_Z.nextFloat() < 0.1f) {
            atkLight *= 3.0f;
            CommonProxy.channelP.sendToAllAround((IMessage)new S2CSpawnParticle((Entity)this.host2, 13, false), point);
        }
        if (target instanceof EntityPlayer) {
            atkLight *= 0.25f;
            if (!ConfigHandler.friendlyFire) {
                atkLight = 0.0f;
            } else if (atkLight > 59.0f) {
                atkLight = 59.0f;
            }
        }
        if (isTargetHurt = target.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this).func_76349_b(), atkLight)) {
            NetworkRegistry.TargetPoint point1 = new NetworkRegistry.TargetPoint(this.field_71093_bK, target.field_70165_t, target.field_70163_u, target.field_70161_v, 64.0);
            CommonProxy.channelP.sendToAllAround((IMessage)new S2CSpawnParticle(target, 9, false), point1);
        }
        if (this.numAmmoLight > 0) {
            --this.numAmmoLight;
            if (this.numAmmoLight <= 0) {
                this.func_70106_y();
            }
        }
        return isTargetHurt;
    }

    @Override
    public boolean attackEntityWithHeavyAmmo(Entity target) {
        float atkHeavy = this.atk;
        float kbValue = 0.08f;
        this.func_85030_a("shincolle:ship-fireheavy", ConfigHandler.volumeFire, 0.7f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        boolean isDirect = false;
        float tarX = (float)target.field_70165_t;
        float tarY = (float)target.field_70163_u;
        float tarZ = (float)target.field_70161_v;
        float distX = tarX - (float)this.field_70165_t;
        float distY = tarY - (float)this.field_70163_u;
        float distZ = tarZ - (float)this.field_70161_v;
        float distSqrt = MathHelper.func_76129_c((float)(distX * distX + distY * distY + distZ * distZ));
        float launchPos = (float)this.field_70163_u + this.field_70131_O * 0.7f;
        if (distX * distX + distY * distY + distZ * distZ < 36.0f) {
            isDirect = true;
        }
        if (this.func_70090_H()) {
            isDirect = true;
            launchPos = (float)this.field_70163_u;
        }
        float missChance = 0.25f;
        if (this.field_70146_Z.nextFloat() < missChance) {
            atkHeavy = 0.0f;
            NetworkRegistry.TargetPoint point = new NetworkRegistry.TargetPoint(this.field_71093_bK, this.host2.field_70165_t, this.host2.field_70163_u, this.host2.field_70161_v, 64.0);
            CommonProxy.channelP.sendToAllAround((IMessage)new S2CSpawnParticle((Entity)this.host2, 10, false), point);
        }
        EntityAbyssMissile missile = new EntityAbyssMissile(this.field_70170_p, (IShipAttackBase)this, tarX, tarY + target.field_70131_O * 0.2f, tarZ, launchPos, atkHeavy, kbValue, isDirect, -1.0f);
        this.field_70170_p.func_72838_d((Entity)missile);
        if (this.numAmmoHeavy > 0) {
            --this.numAmmoHeavy;
            if (this.numAmmoHeavy <= 0) {
                this.func_70106_y();
            }
        }
        return true;
    }

    public void func_70612_e(float p_70612_1_, float p_70612_2_) {
        if (this.func_70090_H() || this.func_70058_J()) {
            this.func_70060_a(p_70612_1_, p_70612_2_, 0.04f);
            this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= 0.8;
            this.field_70181_x *= 0.8;
            this.field_70179_y *= 0.8;
        } else {
            float f2 = 0.91f;
            if (this.field_70122_E) {
                f2 = this.field_70170_p.func_147439_a((int)MathHelper.func_76128_c((double)this.field_70165_t), (int)(MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b) - 1), (int)MathHelper.func_76128_c((double)this.field_70161_v)).field_149765_K * 0.91f;
            }
            float f3 = 0.16277136f / (f2 * f2 * f2);
            float f4 = this.field_70122_E ? this.func_70689_ay() * f3 : this.field_70747_aH;
            this.func_70060_a(p_70612_1_, p_70612_2_, f4);
            f2 = 0.91f;
            if (this.field_70122_E) {
                f2 = this.field_70170_p.func_147439_a((int)MathHelper.func_76128_c((double)this.field_70165_t), (int)(MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b) - 1), (int)MathHelper.func_76128_c((double)this.field_70161_v)).field_149765_K * 0.91f;
            }
            if (this.func_70617_f_()) {
                boolean flag;
                float f5 = 0.15f;
                if (this.field_70159_w < (double)(-f5)) {
                    this.field_70159_w = -f5;
                }
                if (this.field_70159_w > (double)f5) {
                    this.field_70159_w = f5;
                }
                if (this.field_70179_y < (double)(-f5)) {
                    this.field_70179_y = -f5;
                }
                if (this.field_70179_y > (double)f5) {
                    this.field_70179_y = f5;
                }
                this.field_70143_R = 0.0f;
                if (this.field_70181_x < -0.15) {
                    this.field_70181_x = -0.15;
                }
                if ((flag = this.func_70093_af()) && this.field_70181_x < 0.0) {
                    this.field_70181_x = 0.0;
                }
            }
            this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            if (this.field_70123_F && this.func_70617_f_()) {
                this.field_70181_x = 0.2;
            }
            this.field_70181_x = !(!this.field_70170_p.field_72995_K || this.field_70170_p.func_72899_e((int)this.field_70165_t, 0, (int)this.field_70161_v) && this.field_70170_p.func_72938_d((int)((int)this.field_70165_t), (int)((int)this.field_70161_v)).field_76636_d) ? (this.field_70163_u > 0.0 ? -0.1 : 0.0) : (this.field_70181_x -= 0.08);
            this.field_70181_x *= (double)0.98f;
            this.field_70159_w *= (double)f2;
            this.field_70179_y *= (double)f2;
        }
        this.field_70722_aY = this.field_70721_aZ;
        double d0 = this.field_70165_t - this.field_70169_q;
        double d1 = this.field_70161_v - this.field_70166_s;
        float f6 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1)) * 4.0f;
        if (f6 > 1.0f) {
            f6 = 1.0f;
        }
        this.field_70721_aZ += (f6 - this.field_70721_aZ) * 0.4f;
        this.field_70754_ba += this.field_70721_aZ;
    }

    @Override
    public float getAttackSpeed() {
        return this.atkSpeed;
    }

    @Override
    public float getAttackRange() {
        return this.atkRange;
    }

    @Override
    public float getMoveSpeed() {
        return this.movSpeed;
    }

    @Override
    public int getAmmoLight() {
        return this.numAmmoLight;
    }

    @Override
    public int getAmmoHeavy() {
        return this.numAmmoHeavy;
    }

    @Override
    public boolean hasAmmoLight() {
        return this.numAmmoLight > 0;
    }

    @Override
    public boolean hasAmmoHeavy() {
        return false;
    }

    @Override
    public void setAmmoLight(int num) {
        this.numAmmoLight = num;
    }

    @Override
    public void setAmmoHeavy(int num) {
        this.numAmmoHeavy = num;
    }

    @Override
    public float getAttackDamage() {
        return 0.0f;
    }

    @Override
    public Entity getEntityTarget() {
        return this.atkTarget;
    }

    @Override
    public void setEntityTarget(Entity target) {
        this.atkTarget = target;
    }

    @Override
    public boolean getIsRiding() {
        return false;
    }

    @Override
    public boolean getIsSprinting() {
        return false;
    }

    @Override
    public boolean getIsSitting() {
        return false;
    }

    @Override
    public boolean getIsSneaking() {
        return false;
    }

    @Override
    public ShipPathNavigate getShipNavigate() {
        return this.shipNavigator;
    }

    @Override
    public ShipMoveHelper getShipMoveHelper() {
        return this.shipMoveHelper;
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        EntityHelper.updateShipNavigator(this);
    }

    @Override
    public boolean canFly() {
        return false;
    }

    public boolean func_70648_aU() {
        return true;
    }

    @Override
    public boolean getIsLeashed() {
        return false;
    }

    @Override
    public int getLevel() {
        return 150;
    }

    @Override
    public boolean useAmmoLight() {
        return true;
    }

    @Override
    public boolean useAmmoHeavy() {
        return false;
    }

    @Override
    public int getStateMinor(int id) {
        return 0;
    }

    @Override
    public void setStateMinor(int state, int par1) {
    }

    @Override
    public float getEffectEquip(int id) {
        switch (id) {
            case 0: {
                return 0.15f;
            }
            case 4: 
            case 5: {
                return this.atk * 0.5f;
            }
            case 6: {
                return 20.0f;
            }
        }
        return 0.0f;
    }

    @Override
    public float getDefValue() {
        return this.defValue;
    }

    @Override
    public void setEntitySit() {
    }

    @Override
    public float getModelRotate(int par1) {
        return 0.0f;
    }

    @Override
    public void setModelRotate(int par1, float par2) {
    }

    @Override
    public boolean getAttackType(int par1) {
        return true;
    }

    @Override
    public int getPlayerUID() {
        return -100;
    }

    @Override
    public void setPlayerUID(int uid) {
    }

    @Override
    public Entity getHostEntity() {
        return this.host2;
    }

    @Override
    public int getDamageType() {
        return 5;
    }

    @Override
    public Entity getEntityRevengeTarget() {
        return this.rvgTarget;
    }

    @Override
    public int getEntityRevengeTime() {
        return this.revengeTime;
    }

    @Override
    public void setEntityRevengeTarget(Entity target) {
        this.rvgTarget = target;
    }

    @Override
    public void setEntityRevengeTime() {
        this.revengeTime = this.field_70173_aa;
    }

    @Override
    public int getAttackAniTick() {
        return this.StartEmotion3;
    }

    @Override
    public void setAttackAniTick(int par1) {
        this.StartEmotion3 = par1;
    }

    @Override
    public float getSwingTime(float partialTick) {
        return 0.0f;
    }
}

