/*
 * Decompiled with CFR 0.152.
 */
package com.lulan.shincolle.entity.other;

import com.lulan.shincolle.entity.IShipAttackBase;
import com.lulan.shincolle.entity.IShipAttributes;
import com.lulan.shincolle.entity.IShipOwner;
import com.lulan.shincolle.handler.ConfigHandler;
import com.lulan.shincolle.network.S2CEntitySync;
import com.lulan.shincolle.network.S2CSpawnParticle;
import com.lulan.shincolle.proxy.CommonProxy;
import com.lulan.shincolle.utility.CalcHelper;
import com.lulan.shincolle.utility.EntityHelper;
import com.lulan.shincolle.utility.ParticleHelper;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class EntityProjectileBeam
extends Entity
implements IShipOwner,
IShipAttributes {
    private IShipAttackBase host;
    private Entity host2;
    private int playerUID;
    private int type;
    private int lifeLength;
    private float atk;
    private float kbValue;
    private float acc;
    private float accX;
    private float accY;
    private float accZ;

    public EntityProjectileBeam(World world) {
        super(world);
        this.field_70158_ak = true;
        this.field_70145_X = true;
        this.field_70138_W = 0.0f;
        this.func_70105_a(1.0f, 1.0f);
    }

    public EntityProjectileBeam(World world, IShipAttackBase host, int type, float ax, float ay, float az, float atk, float kb) {
        super(world);
        this.field_70158_ak = true;
        this.field_70145_X = true;
        this.field_70138_W = 0.0f;
        this.func_70105_a(1.0f, 1.0f);
        this.host = host;
        this.host2 = (Entity)host;
        this.playerUID = host.getPlayerUID();
        this.type = type;
        switch (type) {
            case 1: {
                this.func_70107_b(this.host2.field_70165_t + (double)ax, this.host2.field_70163_u + (double)this.host2.field_70131_O * 0.5, this.host2.field_70161_v + (double)az);
                this.lifeLength = 31;
                this.acc = 4.0f;
                break;
            }
            default: {
                this.func_70107_b(this.host2.field_70165_t + (double)ax, this.host2.field_70163_u + (double)this.host2.field_70131_O * 0.5, this.host2.field_70161_v + (double)az);
                this.lifeLength = 31;
                this.acc = 4.0f;
            }
        }
        this.accX = ax * this.acc;
        this.accY = ay * this.acc;
        this.accZ = az * this.acc;
        this.atk = atk;
        this.kbValue = kb;
    }

    @Override
    public float getEffectEquip(int id) {
        if (this.host != null) {
            return this.host.getEffectEquip(id);
        }
        return 0.0f;
    }

    @Override
    public int getPlayerUID() {
        return this.playerUID;
    }

    @Override
    public void setPlayerUID(int uid) {
    }

    @Override
    public Entity getHostEntity() {
        return this.host2;
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        nbt.func_74782_a("speed", (NBTBase)this.func_70087_a(new double[]{this.accX, this.accY, this.accZ}));
        nbt.func_74776_a("atk", this.atk);
        nbt.func_74776_a("kb", this.kbValue);
        nbt.func_74768_a("type", this.type);
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        if (nbt.func_150297_b("speed", 9)) {
            NBTTagList nbttaglist = nbt.func_150295_c("speed", 6);
            this.accX = (float)nbttaglist.func_150309_d(0);
            this.accY = (float)nbttaglist.func_150309_d(1);
            this.accZ = (float)nbttaglist.func_150309_d(2);
        } else {
            this.accX = 0.0f;
            this.accY = 0.0f;
            this.accZ = 0.0f;
        }
        this.atk = nbt.func_74760_g("atk");
        this.kbValue = nbt.func_74760_g("kb");
        this.type = nbt.func_74762_e("type");
    }

    public boolean func_85032_ar() {
        return true;
    }

    public boolean func_70067_L() {
        return false;
    }

    public boolean func_70104_M() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public float func_70053_R() {
        return 0.0f;
    }

    public void setProjectileType(int par1) {
        this.type = par1;
    }

    public void func_70071_h_() {
        this.field_70159_w = this.accX;
        this.field_70181_x = this.accY;
        this.field_70179_y = this.accZ;
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.field_70165_t += this.field_70159_w;
        this.field_70163_u += this.field_70181_x;
        this.field_70161_v += this.field_70179_y;
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70173_aa > this.lifeLength || this.host == null) {
                this.func_70106_y();
                return;
            }
            if (this.field_70173_aa == 1) {
                NetworkRegistry.TargetPoint point = new NetworkRegistry.TargetPoint(this.field_71093_bK, this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0);
                CommonProxy.channelE.sendToAllAround((IMessage)new S2CEntitySync(this, this.type, 8), point);
            }
            Entity hitEntity = null;
            List hitList = null;
            hitList = this.field_70170_p.func_72872_a(Entity.class, this.field_70121_D.func_72314_b(1.5, 1.5, 1.5));
            if (hitList != null && !hitList.isEmpty()) {
                for (int i = 0; !(i >= hitList.size() || (hitEntity = (Entity)hitList.get(i)).func_70067_L() && this.isNotHost(hitEntity) && EntityHelper.checkAttackable(hitEntity) && !EntityHelper.checkSameOwner(this.host2, hitEntity)); ++i) {
                    hitEntity = null;
                }
            }
            if (hitEntity != null) {
                this.onImpact();
            }
        } else {
            ParticleHelper.spawnAttackParticleAtEntity(this, 0.0, 32 - this.field_70173_aa, 0.0, (byte)4);
        }
    }

    public boolean func_70097_a(DamageSource attacker, float atk) {
        return false;
    }

    protected void onImpact() {
        this.func_85030_a("shincolle:ship-explode", ConfigHandler.volumeFire * 1.5f, 0.7f / (this.field_70146_Z.nextFloat() * 0.4f + 0.8f));
        if (!this.field_70170_p.field_72995_K) {
            float beamAtk = this.atk;
            Entity hitEntity = null;
            AxisAlignedBB impactBox = this.type == 1 ? this.field_70121_D.func_72314_b(3.0, 3.0, 3.0) : this.field_70121_D.func_72314_b(1.5, 1.5, 1.5);
            List hitList = this.field_70170_p.func_72872_a(Entity.class, impactBox);
            NetworkRegistry.TargetPoint point = new NetworkRegistry.TargetPoint(this.field_71093_bK, this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0);
            if (hitList != null && !hitList.isEmpty()) {
                for (int i = 0; i < hitList.size(); ++i) {
                    beamAtk = this.atk;
                    hitEntity = (Entity)hitList.get(i);
                    if (!EntityHelper.checkAttackable(hitEntity)) continue;
                    beamAtk = CalcHelper.calcDamageBySpecialEffect(this, hitEntity, beamAtk, 1);
                    if (!hitEntity.func_70067_L() || !this.isNotHost(hitEntity)) continue;
                    if (EntityHelper.checkSameOwner(this.host2, hitEntity)) {
                        beamAtk = 0.0f;
                    } else {
                        if (this.host != null && this.field_70146_Z.nextFloat() < this.host.getEffectEquip(0)) {
                            beamAtk *= 3.0f;
                            CommonProxy.channelP.sendToAllAround((IMessage)new S2CSpawnParticle(this.host2, 11, false), point);
                        }
                        if (hitEntity instanceof EntityPlayer && (beamAtk *= 0.25f) > 59.0f) {
                            beamAtk = 59.0f;
                        }
                        if (!EntityHelper.doFriendlyFire(this.host, hitEntity)) {
                            beamAtk = 0.0f;
                        }
                    }
                    if (!hitEntity.func_70097_a(DamageSource.func_76354_b((Entity)this, (Entity)this.host2).func_94540_d(), beamAtk)) continue;
                    CommonProxy.channelP.sendToAllAround((IMessage)new S2CSpawnParticle(hitEntity, 9, false), point);
                }
            }
        }
    }

    private boolean isNotHost(Entity entity) {
        if (entity.equals((Object)this)) {
            return false;
        }
        return this.host2 == null || this.host2.func_145782_y() != entity.func_145782_y();
    }
}

