/*
 * Decompiled with CFR 0.152.
 */
package com.lulan.shincolle.entity.other;

import com.lulan.shincolle.entity.BasicEntityAirplane;
import com.lulan.shincolle.entity.BasicEntityShip;
import com.lulan.shincolle.entity.IShipAircraftAttack;
import com.lulan.shincolle.network.S2CSpawnParticle;
import com.lulan.shincolle.proxy.CommonProxy;
import com.lulan.shincolle.utility.CalcHelper;
import com.lulan.shincolle.utility.EntityHelper;
import com.lulan.shincolle.utility.ParticleHelper;
import com.lulan.shincolle.utility.TargetHelper;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class EntityFloatingFort
extends BasicEntityAirplane {
    public EntityFloatingFort(World world) {
        super(world);
        this.func_70105_a(0.5f, 0.5f);
    }

    @Override
    public void setAttrs(World world, IShipAircraftAttack host, Entity target, double launchPos) {
        this.world = world;
        this.host = host;
        this.atkTarget = target;
        if (host instanceof BasicEntityShip) {
            BasicEntityShip ship = (BasicEntityShip)((Object)host);
            this.targetSelector = new TargetHelper.Selector((Entity)ship);
            this.targetSorter = new TargetHelper.Sorter((Entity)ship);
            this.atk = ship.getStateFinal(6) * 0.75f;
            this.def = ship.getStateFinal(2) * 0.75f;
            this.atkSpeed = ship.getStateFinal(3);
            this.movSpeed = 0.3f;
            this.numAmmoLight = 0;
            this.numAmmoHeavy = 1;
            this.useAmmoLight = false;
            this.useAmmoHeavy = true;
            this.backHome = false;
            this.canFindTarget = false;
            this.field_70165_t = ship.field_70165_t;
            this.field_70163_u = launchPos;
            this.field_70161_v = ship.field_70161_v;
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)ship.getStateFinal(0) * 0.1);
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)this.movSpeed);
            this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a((double)ship.getStateFinal(5) + 32.0);
            this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.5);
            if (this.func_110143_aJ() < this.func_110138_aP()) {
                this.func_70606_j(this.func_110138_aP());
            }
        } else {
            return;
        }
        this.setAIList();
    }

    @Override
    protected void setAIList() {
        this.clearAITasks();
        this.clearAITargetTasks();
        this.func_70661_as().func_75490_c(true);
        this.func_70661_as().func_75491_a(false);
        this.func_70661_as().func_75495_e(true);
        this.setEntityTarget(this.atkTarget);
    }

    @Override
    public void func_70071_h_() {
        if (this.field_70170_p.field_72995_K) {
            if (this.field_70173_aa % 2 == 0) {
                ParticleHelper.spawnAttackParticleAt(this.field_70165_t, this.field_70163_u + 0.2, this.field_70161_v, -this.field_70159_w * 0.5, 0.07, -this.field_70179_y * 0.5, (byte)29);
            }
        } else {
            if (this.backHome || this.atkTarget == null || !this.atkTarget.func_70089_S() || this.field_70173_aa >= 500) {
                this.onImpact();
                return;
            }
            this.updateAttackAI();
        }
        super.func_70071_h_();
    }

    private void updateAttackAI() {
        if (this.atkTarget != null) {
            float distX = (float)(this.atkTarget.field_70165_t - this.field_70165_t);
            float distY = (float)(this.atkTarget.field_70163_u + 1.0 - this.field_70163_u);
            float distZ = (float)(this.atkTarget.field_70161_v - this.field_70161_v);
            float distSq = distX * distX + distY * distY + distZ * distZ;
            if (this.field_70173_aa % 16 == 0 && distSq > 4.0f) {
                this.getShipNavigate().tryMoveToEntityLiving(this.atkTarget, 1.0);
            }
            if (distSq <= 6.0f) {
                this.getShipNavigate().clearPathEntity();
                this.onImpact();
            }
        }
    }

    private void onImpact() {
        boolean isTargetHurt = false;
        EntityLivingBase hostent = null;
        if (!(this.host instanceof EntityLivingBase)) {
            return;
        }
        hostent = (EntityLivingBase)this.host;
        EntityLivingBase hitEntity = null;
        AxisAlignedBB impactBox = this.field_70121_D.func_72314_b(4.5, 4.5, 4.5);
        List hitList = this.field_70170_p.func_72872_a(EntityLivingBase.class, impactBox);
        if (hitList != null && !hitList.isEmpty()) {
            for (int i = 0; i < hitList.size(); ++i) {
                float atk2 = this.atk;
                hitEntity = (EntityLivingBase)hitList.get(i);
                if (!EntityHelper.checkAttackable((Entity)hitEntity)) continue;
                atk2 = CalcHelper.calcDamageBySpecialEffect(this, (Entity)hitEntity, atk2, 0);
                if (!hitEntity.func_70067_L() || EntityHelper.checkSameOwner((Entity)hostent, (Entity)hitEntity)) continue;
                if (this.host != null && this.field_70146_Z.nextFloat() < this.host.getEffectEquip(0)) {
                    atk2 *= 3.0f;
                    NetworkRegistry.TargetPoint point = new NetworkRegistry.TargetPoint(this.field_71093_bK, this.field_70165_t, this.field_70163_u, this.field_70161_v, 48.0);
                    CommonProxy.channelP.sendToAllAround((IMessage)new S2CSpawnParticle((Entity)hostent, 11, false), point);
                }
                if (hitEntity instanceof EntityPlayer && (atk2 *= 0.25f) > 59.0f) {
                    atk2 = 59.0f;
                }
                if (!EntityHelper.doFriendlyFire(this.host, (Entity)hitEntity)) {
                    atk2 = 0.0f;
                }
                isTargetHurt = this.host != null ? hitEntity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)hostent).func_94540_d(), atk2) : hitEntity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this).func_94540_d(), atk2);
            }
        }
        NetworkRegistry.TargetPoint point = new NetworkRegistry.TargetPoint(this.field_71093_bK, this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0);
        CommonProxy.channelP.sendToAllAround((IMessage)new S2CSpawnParticle((Entity)this, 2, false), point);
        this.func_70106_y();
    }

    @Override
    public boolean useAmmoLight() {
        return false;
    }

    @Override
    public boolean useAmmoHeavy() {
        return true;
    }
}

