/*
 * Decompiled with CFR 0.152.
 */
package com.lulan.shincolle.entity.hime;

import com.lulan.shincolle.ai.EntityAIShipCarrierAttack;
import com.lulan.shincolle.ai.EntityAIShipRangeAttack;
import com.lulan.shincolle.entity.BasicEntityMount;
import com.lulan.shincolle.entity.BasicEntityShip;
import com.lulan.shincolle.entity.BasicEntityShipCV;
import com.lulan.shincolle.entity.ExtendShipProps;
import com.lulan.shincolle.entity.IShipAttackBase;
import com.lulan.shincolle.entity.mounts.EntityMountHbH;
import com.lulan.shincolle.entity.other.EntityAbyssMissile;
import com.lulan.shincolle.handler.ConfigHandler;
import com.lulan.shincolle.network.S2CSpawnParticle;
import com.lulan.shincolle.proxy.CommonProxy;
import com.lulan.shincolle.utility.CalcHelper;
import com.lulan.shincolle.utility.EntityHelper;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class EntityHarbourHime
extends BasicEntityShipCV {
    public EntityHarbourHime(World world) {
        super(world);
        this.func_70105_a(0.7f, 2.2f);
        this.setStateMinor(19, 10);
        this.setStateMinor(20, 28);
        this.setStateMinor(25, 2);
        this.setGrudgeConsumption(ConfigHandler.consumeGrudgeShip[8]);
        this.setAmmoConsumption(ConfigHandler.consumeAmmoShip[8]);
        this.ModelPos = new float[]{-6.0f, 15.0f, 0.0f, 40.0f};
        this.ExtProps = (ExtendShipProps)this.getExtendedProperties("ShipExtProps");
        this.launchHeight = this.field_70131_O * 0.7f;
        this.StateFlag[17] = true;
        this.setFoodSaturationMax(20);
        this.postInit();
    }

    @Override
    public float func_70047_e() {
        return 1.7375f;
    }

    @Override
    public int getEquipType() {
        return 2;
    }

    @Override
    public void setAIList() {
        super.setAIList();
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new EntityAIShipCarrierAttack(this));
        this.field_70714_bg.func_75776_a(12, (EntityAIBase)new EntityAIShipRangeAttack(this));
    }

    @Override
    public void func_70636_d() {
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa % 128 == 0) {
            if (this.getStateMinor(6) > 0 && this.func_110143_aJ() < this.func_110138_aP()) {
                this.func_70606_j(this.func_110143_aJ() + this.func_110138_aP() * 0.03125f);
            }
            if (this.getStateFlag(1) && this.getStateFlag(9) && this.getStateMinor(6) > 0) {
                int healCount = this.getLevel() / 50 + 1;
                EntityLivingBase hitEntity = null;
                List hitList = null;
                hitList = this.field_70170_p.func_72872_a(EntityLivingBase.class, this.field_70121_D.func_72314_b(12.0, 12.0, 12.0));
                NetworkRegistry.TargetPoint point = new NetworkRegistry.TargetPoint(this.field_71093_bK, this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0);
                for (int i = 0; i < hitList.size(); ++i) {
                    boolean canHeal = false;
                    if (healCount <= 0) break;
                    hitEntity = (EntityLivingBase)hitList.get(i);
                    if (hitEntity == this || !(hitEntity.func_110143_aJ() / hitEntity.func_110138_aP() < 0.94f)) continue;
                    if (hitEntity instanceof EntityPlayer && EntityHelper.checkIsAlly((Entity)this, (Entity)hitEntity)) {
                        hitEntity.func_70691_i(4.0f + (float)this.getLevel() * 0.06f);
                        canHeal = true;
                    } else if (hitEntity instanceof BasicEntityShip && EntityHelper.checkIsAlly((Entity)this, (Entity)hitEntity)) {
                        hitEntity.func_70691_i(4.0f + hitEntity.func_110138_aP() * 0.06f + (float)this.getLevel() * 0.2f);
                        canHeal = true;
                    }
                    if (!canHeal) continue;
                    CommonProxy.channelP.sendToAllAround((IMessage)new S2CSpawnParticle((Entity)this, (Entity)hitEntity, 1.0, 0.0, 0.0, 4, false), point);
                    --healCount;
                    this.decrGrudgeNum(50);
                }
            }
        }
        super.func_70636_d();
    }

    @Override
    public boolean func_70085_c(EntityPlayer player) {
        ItemStack itemstack = player.field_71071_by.func_70448_g();
        if (itemstack != null && itemstack.func_77973_b() == Items.field_151105_aU) {
            this.setShipOutfit(player.func_70093_af());
            return true;
        }
        return super.func_70085_c(player);
    }

    @Override
    public int getKaitaiType() {
        return 1;
    }

    @Override
    public float getAttackBaseDamage(int type, Entity target) {
        switch (type) {
            case 1: {
                return CalcHelper.calcDamageBySpecialEffect(this, target, this.StateFinal[1], 0);
            }
            case 2: {
                return this.StateFinal[6] * 0.75f;
            }
            case 3: {
                return this.StateFinal[7];
            }
            case 4: {
                return this.StateFinal[8];
            }
        }
        return this.StateFinal[1];
    }

    @Override
    public boolean attackEntityWithHeavyAmmo(Entity target) {
        float[] distVec;
        float atk = this.StateFinal[6] * 0.75f;
        float launchPos = (float)this.field_70163_u + 0.4f;
        float tarX = (float)target.field_70165_t;
        float tarY = (float)target.field_70163_u;
        float tarZ = (float)target.field_70161_v;
        distVec = new float[]{tarX - (float)this.field_70165_t, tarY - (float)this.field_70163_u, tarZ - (float)this.field_70161_v, MathHelper.func_76129_c((float)(distVec[0] * distVec[0] + distVec[1] * distVec[1] + distVec[2] * distVec[2]))};
        if (this.field_70154_o != null && this.field_70154_o instanceof BasicEntityMount) {
            launchPos = (float)this.field_70163_u - 1.2f;
        }
        this.addShipExp(ConfigHandler.expGain[2]);
        this.decrGrudgeNum(ConfigHandler.consumeGrudgeAction[1]);
        this.decrMorale(2);
        this.setCombatTick(this.field_70173_aa);
        this.applySoundAtAttacker(2, target);
        this.applyParticleAtAttacker(2, target, distVec);
        if (!this.decrAmmoNum(1, this.getAmmoConsumption())) {
            return false;
        }
        float missChance = 0.2f + 0.15f * (distVec[3] / this.StateFinal[5]) - 0.001f * (float)this.StateMinor[0];
        if ((missChance -= this.EffectEquip[3]) > 0.35f) {
            missChance = 0.35f;
        }
        if (this.field_70146_Z.nextFloat() < missChance) {
            tarX = tarX - 5.0f + this.field_70146_Z.nextFloat() * 10.0f;
            tarY += this.field_70146_Z.nextFloat() * 5.0f;
            tarZ = tarZ - 5.0f + this.field_70146_Z.nextFloat() * 10.0f;
            this.applyParticleSpecialEffect(0);
        }
        EntityAbyssMissile missile = new EntityAbyssMissile(this.field_70170_p, (IShipAttackBase)this, tarX, tarY + target.field_70131_O * 0.35f, tarZ, launchPos, atk, 0.15f, true, 0.3f);
        this.field_70170_p.func_72838_d((Entity)missile);
        this.applySoundAtTarget(2, target);
        this.applyParticleAtTarget(2, target, distVec);
        this.applyEmotesReaction(3);
        if (ConfigHandler.canFlare) {
            this.flareTarget(target);
        }
        return true;
    }

    public boolean func_70104_M() {
        return this.field_70154_o == null;
    }

    @Override
    public boolean canSummonMounts() {
        return true;
    }

    @Override
    public BasicEntityMount summonMountEntity() {
        return new EntityMountHbH(this.field_70170_p, this);
    }

    @Override
    public float[] getModelPos() {
        this.ModelPos[1] = this.func_70115_ae() ? -25.0f : 15.0f;
        return this.ModelPos;
    }

    @Override
    public double func_70042_X() {
        if (this.func_70906_o()) {
            if (this.getStateEmotion(1) == 4) {
                return (double)this.field_70131_O * 0.0;
            }
            return (double)this.field_70131_O * 0.5;
        }
        return (double)this.field_70131_O * (double)0.85f;
    }

    @Override
    public void setShipOutfit(boolean isSneaking) {
        if (isSneaking) {
            switch (this.getStateEmotion(4)) {
                case 0: {
                    this.setStateEmotion(4, 1, true);
                    break;
                }
                case 1: {
                    this.setStateEmotion(4, 2, true);
                    break;
                }
                case 2: {
                    this.setStateEmotion(4, 3, true);
                    break;
                }
                case 3: {
                    this.setStateEmotion(4, 0, true);
                    break;
                }
                default: {
                    this.setStateEmotion(4, 0, true);
                    break;
                }
            }
        } else {
            switch (this.getStateEmotion(0)) {
                case 0: {
                    this.setStateEmotion(0, 1, true);
                    break;
                }
                case 1: {
                    this.setStateEmotion(0, 0, true);
                    this.func_70634_a(this.field_70165_t, this.field_70163_u + 2.0, this.field_70161_v);
                    break;
                }
                default: {
                    this.setStateEmotion(0, 0, true);
                }
            }
        }
    }
}

