/*
 * Decompiled with CFR 0.152.
 */
package com.lulan.shincolle.entity.battleship;

import com.lulan.shincolle.ai.EntityAIShipRangeAttack;
import com.lulan.shincolle.entity.BasicEntityShipHostile;
import com.lulan.shincolle.handler.ConfigHandler;
import com.lulan.shincolle.init.ModItems;
import com.lulan.shincolle.network.S2CSpawnParticle;
import com.lulan.shincolle.proxy.CommonProxy;
import com.lulan.shincolle.utility.CalcHelper;
import com.lulan.shincolle.utility.EntityHelper;
import com.lulan.shincolle.utility.ParticleHelper;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class EntityBattleshipNGTBoss
extends BasicEntityShipHostile
implements IBossDisplayData {
    public EntityBattleshipNGTBoss(World world) {
        super(world);
        this.func_70105_a(1.7f, 7.0f);
        this.func_94058_c(StatCollector.func_74838_a((String)"entity.shincolle.EntityBattleshipNGT.name"));
        this.setStateMinor(20, 37);
        this.dropItem = new ItemStack((Item)ModItems.ShipSpawnEgg, 1, this.getStateMinor(20) + 2);
        this.atk = (float)ConfigHandler.scaleBossLarge[1];
        this.atkSpeed = (float)ConfigHandler.scaleBossLarge[3];
        this.atkRange = (float)ConfigHandler.scaleBossLarge[5];
        this.defValue = (float)ConfigHandler.scaleBossLarge[2];
        this.movSpeed = (float)ConfigHandler.scaleBossLarge[4];
        this.StartEmotion = 0;
        this.StartEmotion2 = 0;
        this.headTilt = false;
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(ConfigHandler.scaleBossLarge[0]);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)this.movSpeed);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a((double)(this.atkRange + 32.0f));
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
        if (this.func_110143_aJ() < this.func_110138_aP()) {
            this.func_70606_j(this.func_110138_aP());
        }
        this.setAIList();
        this.setAITargetList();
        this.setStateEmotion(0, 3, false);
    }

    protected boolean func_70692_ba() {
        return this.field_70173_aa > 12000;
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.5f;
    }

    @Override
    protected void setAIList() {
        super.setAIList();
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIShipRangeAttack(this));
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K && this.field_70173_aa % 10 == 0) {
            if (this.getStateEmotion(5) == 1 || this.getStateEmotion(5) == 3) {
                ParticleHelper.spawnAttackParticleAtEntity((Entity)this, 0.3, 2.0, 0.0, (byte)1);
            }
            if (this.getStateEmotion(0) >= 1) {
                float[] partPos = ParticleHelper.rotateXZByAxis(-1.8f, 0.0f, this.field_70761_aq % 360.0f / 57.2957f, 1.0f);
                ParticleHelper.spawnAttackParticleAt(this.field_70165_t + (double)partPos[1], this.field_70163_u + 5.5, this.field_70161_v + (double)partPos[0], 0.0, 0.0, 0.0, (byte)24);
            }
        }
    }

    @Override
    public boolean attackEntityWithAmmo(Entity target) {
        boolean isTargetHurt;
        float atk = CalcHelper.calcDamageBySpecialEffect(this, target, this.atk, 0);
        float distX = (float)(target.field_70165_t - this.field_70165_t);
        float distY = (float)(target.field_70163_u - this.field_70163_u);
        float distZ = (float)(target.field_70161_v - this.field_70161_v);
        float distSqrt = MathHelper.func_76129_c((float)(distX * distX + distY * distY + distZ * distZ));
        distY /= distSqrt;
        NetworkRegistry.TargetPoint point = new NetworkRegistry.TargetPoint(this.field_71093_bK, this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0);
        CommonProxy.channelP.sendToAllAround((IMessage)new S2CSpawnParticle((Entity)this, 19, this.field_70165_t, this.field_70163_u + 3.5, this.field_70161_v, distX /= distSqrt, 2.8, distZ /= distSqrt, true), point);
        this.func_85030_a("shincolle:ship-firesmall", ConfigHandler.volumeFire, 0.7f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        if (this.field_70146_Z.nextInt(10) > 7) {
            this.func_85030_a("shincolle:ship-hitsmall", ConfigHandler.volumeShip, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        }
        if (this.field_70146_Z.nextFloat() < 0.2f) {
            atk = 0.0f;
            CommonProxy.channelP.sendToAllAround((IMessage)new S2CSpawnParticle((Entity)this, 10, false), point);
        } else if (this.field_70146_Z.nextFloat() < 0.15f) {
            atk *= 1.5f;
            CommonProxy.channelP.sendToAllAround((IMessage)new S2CSpawnParticle((Entity)this, 11, false), point);
        } else if (this.field_70146_Z.nextFloat() < 0.15f) {
            atk *= 2.0f;
            CommonProxy.channelP.sendToAllAround((IMessage)new S2CSpawnParticle((Entity)this, 12, false), point);
        } else if (this.field_70146_Z.nextFloat() < 0.15f) {
            atk *= 3.0f;
            CommonProxy.channelP.sendToAllAround((IMessage)new S2CSpawnParticle((Entity)this, 13, false), point);
        }
        if (target instanceof EntityPlayer && (atk *= 0.25f) > 159.0f) {
            atk = 159.0f;
        }
        if (isTargetHurt = target.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this).func_76349_b(), atk)) {
            NetworkRegistry.TargetPoint point1 = new NetworkRegistry.TargetPoint(this.field_71093_bK, target.field_70165_t, target.field_70163_u, target.field_70161_v, 64.0);
            CommonProxy.channelP.sendToAllAround((IMessage)new S2CSpawnParticle(target, 9, false), point1);
            this.applyEmotesReaction(3);
        }
        return isTargetHurt;
    }

    @Override
    public boolean attackEntityWithHeavyAmmo(Entity target) {
        float atk1 = CalcHelper.calcDamageBySpecialEffect(this, target, this.atk * 3.0f, 2);
        float atk2 = this.atk * 3.0f;
        float kbValue = 0.15f;
        boolean isTargetHurt = false;
        float tarX = (float)target.field_70165_t;
        float tarY = (float)target.field_70163_u;
        float tarZ = (float)target.field_70161_v;
        float distX = tarX - (float)this.field_70165_t;
        float distY = tarY - (float)this.field_70163_u;
        float distZ = tarZ - (float)this.field_70161_v;
        float distSqrt = MathHelper.func_76129_c((float)(distX * distX + distY * distY + distZ * distZ));
        float dX = distX / distSqrt;
        float dY = distY / distSqrt;
        float dZ = distZ / distSqrt;
        int atkPhase = this.getStateEmotion(5);
        switch (atkPhase) {
            case 0: 
            case 2: {
                this.func_85030_a("shincolle:ship-ap_phase1", ConfigHandler.volumeFire, 1.0f);
                break;
            }
            case 1: {
                this.func_85030_a("shincolle:ship-ap_phase2", ConfigHandler.volumeFire, 1.0f);
                break;
            }
            case 3: {
                this.func_85030_a("shincolle:ship-ap_attack", ConfigHandler.volumeFire, 1.0f);
                break;
            }
            default: {
                this.func_85030_a("shincolle:ship-ap_phase1", ConfigHandler.volumeFire, 1.0f);
            }
        }
        if (this.func_70681_au().nextInt(10) > 7) {
            this.func_85030_a("shincolle:ship-hitsmall", ConfigHandler.volumeShip, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        }
        NetworkRegistry.TargetPoint point = new NetworkRegistry.TargetPoint(this.field_71093_bK, this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0);
        if (++atkPhase > 3) {
            CommonProxy.channelP.sendToAllAround((IMessage)new S2CSpawnParticle((Entity)this, 21, this.field_70165_t, this.field_70163_u, this.field_70161_v, target.field_70165_t, target.field_70163_u, target.field_70161_v, true), point);
            if (this.field_70146_Z.nextFloat() < 0.2f) {
                atk1 = 0.0f;
                atk2 *= 0.5f;
                CommonProxy.channelP.sendToAllAround((IMessage)new S2CSpawnParticle((Entity)this, 10, false), point);
            } else if (this.field_70146_Z.nextFloat() < 0.15f) {
                atk1 *= 1.5f;
                atk2 *= 1.5f;
                CommonProxy.channelP.sendToAllAround((IMessage)new S2CSpawnParticle((Entity)this, 11, false), point);
            }
            if (target instanceof EntityPlayer) {
                atk1 *= 0.25f;
                if ((atk2 *= 0.25f) > 40.0f) {
                    atk1 = 160.0f;
                    atk2 = 40.0f;
                }
            }
            isTargetHurt = target.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), atk1);
            this.field_70159_w = 0.0;
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
            this.field_70165_t = tarX + dX * 2.0f;
            this.field_70163_u = tarY;
            this.field_70161_v = tarZ + dZ * 2.0f;
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            EntityLivingBase hitEntity = null;
            AxisAlignedBB impactBox = this.field_70121_D.func_72314_b(4.5, 4.5, 4.5);
            List hitList = this.field_70170_p.func_72872_a(EntityLivingBase.class, impactBox);
            float atkTemp = atk2;
            if (hitList != null && !hitList.isEmpty()) {
                for (int i = 0; i < hitList.size(); ++i) {
                    atkTemp = atk2;
                    hitEntity = (EntityLivingBase)hitList.get(i);
                    if (hitEntity == this || !EntityHelper.checkAttackable((Entity)hitEntity) || !hitEntity.func_70067_L() || !EntityHelper.checkNotSameEntityID((Entity)this, (Entity)hitEntity)) continue;
                    if (this.field_70146_Z.nextFloat() < 0.2f) {
                        atkTemp *= 0.5f;
                    } else if (this.field_70146_Z.nextFloat() < 0.15f) {
                        atkTemp *= 1.5f;
                    }
                    if (EntityHelper.checkSameOwner((Entity)this, (Entity)hitEntity)) {
                        atkTemp = 0.0f;
                    }
                    if (hitEntity instanceof EntityPlayer && (atkTemp *= 0.25f) > 59.0f) {
                        atkTemp = 59.0f;
                    }
                    hitEntity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), atkTemp);
                }
            }
            this.setStateEmotion(5, 0, true);
        } else {
            if (atkPhase == 2) {
                CommonProxy.channelP.sendToAllAround((IMessage)new S2CSpawnParticle((Entity)this, 23, this.field_70165_t, this.field_70163_u, this.field_70161_v, 3.0, 0.3, 0.0, true), point);
            } else {
                CommonProxy.channelP.sendToAllAround((IMessage)new S2CSpawnParticle((Entity)this, 22, this.field_70165_t, this.field_70163_u, this.field_70161_v, 3.0, 3.0, 0.0, true), point);
            }
            this.setStateEmotion(5, atkPhase, true);
        }
        this.applyEmotesReaction(3);
        return isTargetHurt;
    }

    @Override
    public int getDamageType() {
        return 3;
    }
}

