/*
 * Decompiled with CFR 0.152.
 */
package com.lulan.shincolle.entity;

import com.lulan.shincolle.entity.BasicEntityShip;
import com.lulan.shincolle.utility.LogHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;

public class ExtendShipProps
implements IExtendedEntityProperties,
IInventory {
    public static final String SHIP_EXTPROP_NAME = "ShipExtProps";
    public static final String tagName = "ShipInv";
    public static final int SlotPages = 3;
    public static final int SlotMax = 60;
    public ItemStack[] slots = new ItemStack[60];
    public BasicEntityShip entity;
    private World world;
    private int inventoryPage = 0;

    public void init(Entity entity, World world) {
        this.world = world;
        this.entity = (BasicEntityShip)entity;
    }

    public void saveNBTData(NBTTagCompound nbt) {
        NBTTagCompound nbtExt = new NBTTagCompound();
        NBTTagCompound nbtExt_add0 = new NBTTagCompound();
        NBTTagCompound nbtExt_add2 = new NBTTagCompound();
        NBTTagCompound nbtExt_add3 = new NBTTagCompound();
        NBTTagCompound nbtExt_add4 = new NBTTagCompound();
        NBTTagCompound nbtExt_add5 = new NBTTagCompound();
        nbtExt.func_74782_a("Minor", (NBTBase)nbtExt_add0);
        nbtExt_add0.func_74768_a("Level", this.entity.getStateMinor(0));
        nbtExt_add0.func_74768_a("Kills", this.entity.getStateMinor(1));
        nbtExt_add0.func_74768_a("Exp", this.entity.getStateMinor(2));
        nbtExt_add0.func_74768_a("NumAmmoL", this.entity.getStateMinor(4));
        nbtExt_add0.func_74768_a("NumAmmoH", this.entity.getStateMinor(5));
        nbtExt_add0.func_74768_a("NumGrudge", this.entity.getStateMinor(6));
        nbtExt_add0.func_74768_a("NumAirL", this.entity.getStateMinor(7));
        nbtExt_add0.func_74768_a("NumAirH", this.entity.getStateMinor(8));
        nbtExt_add0.func_74768_a("FMin", this.entity.getStateMinor(10));
        nbtExt_add0.func_74768_a("FMax", this.entity.getStateMinor(11));
        nbtExt_add0.func_74768_a("FHP", this.entity.getStateMinor(12));
        nbtExt_add0.func_74768_a("GuardX", this.entity.getStateMinor(14));
        nbtExt_add0.func_74768_a("GuardY", this.entity.getStateMinor(15));
        nbtExt_add0.func_74768_a("GuardZ", this.entity.getStateMinor(16));
        nbtExt_add0.func_74768_a("GuardDim", this.entity.getStateMinor(17));
        nbtExt_add0.func_74768_a("GuardID", this.entity.getStateMinor(18));
        nbtExt_add0.func_74768_a("GuardType", this.entity.getStateMinor(24));
        nbtExt_add0.func_74768_a("PlayerUID", this.entity.getStateMinor(21));
        nbtExt_add0.func_74768_a("ShipUID", this.entity.getStateMinor(22));
        nbtExt_add0.func_74768_a("FType", this.entity.getStateMinor(26));
        nbtExt_add0.func_74768_a("FPos", this.entity.getStateMinor(27));
        nbtExt_add0.func_74768_a("Morale", this.entity.getStateMinor(30));
        nbtExt_add0.func_74768_a("Food", this.entity.getStateMinor(31));
        nbtExt_add0.func_74768_a("Crane", this.entity.getStateMinor(43));
        nbtExt_add0.func_74768_a("WpStay", this.entity.getStateMinor(44));
        nbtExt_add0.func_74778_a("tagName", this.entity.func_94057_bL());
        nbtExt.func_74782_a("Emotion", (NBTBase)nbtExt_add2);
        nbtExt_add2.func_74774_a("State", this.entity.getStateEmotion(0));
        nbtExt_add2.func_74774_a("State2", this.entity.getStateEmotion(4));
        nbtExt_add2.func_74774_a("Emotion", this.entity.getStateEmotion(1));
        nbtExt_add2.func_74774_a("Emotion2", this.entity.getStateEmotion(2));
        nbtExt_add2.func_74774_a("Phase", this.entity.getStateEmotion(5));
        nbtExt.func_74782_a("Point", (NBTBase)nbtExt_add3);
        nbtExt_add3.func_74774_a("HP", this.entity.getBonusPoint(0));
        nbtExt_add3.func_74774_a("ATK", this.entity.getBonusPoint(1));
        nbtExt_add3.func_74774_a("DEF", this.entity.getBonusPoint(2));
        nbtExt_add3.func_74774_a("SPD", this.entity.getBonusPoint(3));
        nbtExt_add3.func_74774_a("MOV", this.entity.getBonusPoint(4));
        nbtExt_add3.func_74774_a("HIT", this.entity.getBonusPoint(5));
        nbtExt.func_74782_a("ShipFlags", (NBTBase)nbtExt_add4);
        nbtExt_add4.func_74757_a("CanFloat", this.entity.getStateFlag(0));
        nbtExt_add4.func_74757_a("IsMarried", this.entity.getStateFlag(1));
        nbtExt_add4.func_74757_a("NoFuel", this.entity.getStateFlag(2));
        nbtExt_add4.func_74757_a("Melee", this.entity.getStateFlag(3));
        nbtExt_add4.func_74757_a("AmmoL", this.entity.getStateFlag(4));
        nbtExt_add4.func_74757_a("AmmoH", this.entity.getStateFlag(5));
        nbtExt_add4.func_74757_a("AirL", this.entity.getStateFlag(6));
        nbtExt_add4.func_74757_a("AirH", this.entity.getStateFlag(7));
        nbtExt_add4.func_74757_a("WedEffect", this.entity.getStateFlag(9));
        nbtExt_add4.func_74757_a("CanDrop", this.entity.getStateFlag(10));
        nbtExt_add4.func_74757_a("CanFollow", this.entity.getStateFlag(11));
        nbtExt_add4.func_74757_a("OnSight", this.entity.getStateFlag(12));
        nbtExt_add4.func_74757_a("PVPFirst", this.entity.getStateFlag(18));
        nbtExt_add4.func_74757_a("AA", this.entity.getStateFlag(19));
        nbtExt_add4.func_74757_a("ASM", this.entity.getStateFlag(20));
        nbtExt_add4.func_74757_a("PassiveAI", this.entity.getStateFlag(21));
        nbtExt_add4.func_74757_a("TimeKeeper", this.entity.getStateFlag(22));
        nbtExt_add4.func_74757_a("PickItem", this.entity.getStateFlag(23));
        nbtExt.func_74782_a("Timer", (NBTBase)nbtExt_add5);
        nbtExt_add5.func_74768_a("Crane", this.entity.getStateTimer(1));
        NBTTagList list = new NBTTagList();
        nbt.func_74782_a(tagName, (NBTBase)list);
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] == null) continue;
            NBTTagCompound item = new NBTTagCompound();
            item.func_74774_a("Slot", (byte)i);
            this.slots[i].func_77955_b(item);
            list.func_74742_a((NBTBase)item);
        }
        nbt.func_74782_a(SHIP_EXTPROP_NAME, (NBTBase)nbtExt);
        LogHelper.info("DEBUG : save entity ExtNBT data on id: " + this.entity.func_145782_y());
    }

    public void loadNBTData(NBTTagCompound nbt) {
        NBTTagCompound nbt_tag = (NBTTagCompound)nbt.func_74781_a(SHIP_EXTPROP_NAME);
        NBTTagCompound nbt_load = new NBTTagCompound();
        nbt_load = (NBTTagCompound)nbt_tag.func_74781_a("Minor");
        this.entity.setStateMinor(0, nbt_load.func_74762_e("Level"));
        this.entity.setStateMinor(1, nbt_load.func_74762_e("Kills"));
        this.entity.setStateMinor(2, nbt_load.func_74762_e("Exp"));
        this.entity.setStateMinor(4, nbt_load.func_74762_e("NumAmmoL"));
        this.entity.setStateMinor(5, nbt_load.func_74762_e("NumAmmoH"));
        this.entity.setStateMinor(6, nbt_load.func_74762_e("NumGrudge"));
        this.entity.setStateMinor(7, nbt_load.func_74762_e("NumAirL"));
        this.entity.setStateMinor(8, nbt_load.func_74762_e("NumAirH"));
        this.entity.setStateMinor(10, nbt_load.func_74762_e("FMin"));
        this.entity.setStateMinor(11, nbt_load.func_74762_e("FMax"));
        this.entity.setStateMinor(12, nbt_load.func_74762_e("FHP"));
        this.entity.setStateMinor(14, nbt_load.func_74762_e("GuardX"));
        this.entity.setStateMinor(15, nbt_load.func_74762_e("GuardY"));
        this.entity.setStateMinor(16, nbt_load.func_74762_e("GuardZ"));
        this.entity.setStateMinor(17, nbt_load.func_74762_e("GuardDim"));
        this.entity.setStateMinor(18, nbt_load.func_74762_e("GuardID"));
        this.entity.setStateMinor(24, nbt_load.func_74762_e("GuardType"));
        this.entity.setStateMinor(21, nbt_load.func_74762_e("PlayerUID"));
        this.entity.setStateMinor(22, nbt_load.func_74762_e("ShipUID"));
        this.entity.setStateMinor(26, nbt_load.func_74762_e("FType"));
        this.entity.setStateMinor(27, nbt_load.func_74762_e("FPos"));
        this.entity.setStateMinor(30, nbt_load.func_74762_e("Morale"));
        this.entity.setStateMinor(31, nbt_load.func_74762_e("Food"));
        this.entity.setStateMinor(43, nbt_load.func_74762_e("Crane"));
        this.entity.setStateMinor(44, nbt_load.func_74762_e("WpStay"));
        this.entity.setNameTag(nbt_load.func_74779_i("tagName"));
        nbt_load = (NBTTagCompound)nbt_tag.func_74781_a("Emotion");
        this.entity.setStateEmotion(0, nbt_load.func_74771_c("State"), false);
        this.entity.setStateEmotion(4, nbt_load.func_74771_c("State2"), false);
        this.entity.setStateEmotion(1, nbt_load.func_74771_c("Emotion"), false);
        this.entity.setStateEmotion(2, nbt_load.func_74771_c("Emotion2"), false);
        this.entity.setStateEmotion(5, nbt_load.func_74771_c("Phase"), false);
        nbt_load = (NBTTagCompound)nbt_tag.func_74781_a("Point");
        this.entity.setBonusPoint(0, nbt_load.func_74771_c("HP"));
        this.entity.setBonusPoint(1, nbt_load.func_74771_c("ATK"));
        this.entity.setBonusPoint(2, nbt_load.func_74771_c("DEF"));
        this.entity.setBonusPoint(3, nbt_load.func_74771_c("SPD"));
        this.entity.setBonusPoint(4, nbt_load.func_74771_c("MOV"));
        this.entity.setBonusPoint(5, nbt_load.func_74771_c("HIT"));
        nbt_load = (NBTTagCompound)nbt_tag.func_74781_a("ShipFlags");
        this.entity.setStateFlag(0, nbt_load.func_74767_n("CanFloat"));
        this.entity.setStateFlag(1, nbt_load.func_74767_n("IsMarried"));
        this.entity.setStateFlag(2, nbt_load.func_74767_n("NoFuel"));
        this.entity.setStateFlag(3, nbt_load.func_74767_n("Melee"));
        this.entity.setStateFlag(4, nbt_load.func_74767_n("AmmoL"));
        this.entity.setStateFlag(5, nbt_load.func_74767_n("AmmoH"));
        this.entity.setStateFlag(6, nbt_load.func_74767_n("AirL"));
        this.entity.setStateFlag(7, nbt_load.func_74767_n("AirH"));
        this.entity.setStateFlag(9, nbt_load.func_74767_n("WedEffect"));
        this.entity.setStateFlag(10, nbt_load.func_74767_n("CanDrop"));
        this.entity.setStateFlag(11, nbt_load.func_74767_n("CanFollow"));
        this.entity.setStateFlag(12, nbt_load.func_74767_n("OnSight"));
        this.entity.setStateFlag(18, nbt_load.func_74767_n("PVPFirst"));
        this.entity.setStateFlag(19, nbt_load.func_74767_n("AA"));
        this.entity.setStateFlag(20, nbt_load.func_74767_n("ASM"));
        this.entity.setStateFlag(21, nbt_load.func_74767_n("PassiveAI"));
        this.entity.setStateFlag(22, nbt_load.func_74767_n("TimeKeeper"));
        this.entity.setStateFlag(23, nbt_load.func_74767_n("PickItem"));
        nbt_load = (NBTTagCompound)nbt_tag.func_74781_a("Timer");
        this.entity.setStateTimer(1, nbt_load.func_74762_e("Crane"));
        NBTTagList list = nbt.func_150295_c(tagName, 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound item = list.func_150305_b(i);
            byte sid = item.func_74771_c("Slot");
            if (sid < 0 || sid >= this.slots.length) continue;
            this.slots[sid] = ItemStack.func_77949_a((NBTTagCompound)item);
        }
        this.entity.setExpNext();
        this.entity.calcEquipAndUpdateState();
        LogHelper.info("DEBUG : load entity ExtNBT data on id: " + this.entity.func_145782_y());
    }

    public int func_70302_i_() {
        return 24;
    }

    public int getSizeInventoryPaged() {
        if (this.entity != null) {
            return 24 + this.entity.getStateMinor(36) * 18;
        }
        return 24;
    }

    public ItemStack func_70301_a(int i) {
        if (i < this.func_70302_i_()) {
            if (i < 6) {
                return this.slots[i];
            }
            return this.slots[i + this.inventoryPage * 18];
        }
        return this.slots[i];
    }

    public ItemStack func_70298_a(int i, int j) {
        ItemStack itemStack = this.func_70301_a(i);
        if (itemStack != null) {
            if (itemStack.field_77994_a <= j) {
                this.func_70299_a(i, null);
            } else {
                itemStack = itemStack.func_77979_a(j);
                if (itemStack.field_77994_a == 0) {
                    this.func_70299_a(i, null);
                }
            }
        }
        return itemStack;
    }

    public ItemStack func_70304_b(int i) {
        ItemStack itemStack = this.func_70301_a(i);
        if (itemStack != null) {
            this.func_70299_a(i, null);
        }
        return itemStack;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        if (i < this.func_70302_i_()) {
            if (i < 6) {
                this.slots[i] = itemstack;
            } else {
                this.slots[i + this.inventoryPage * 18] = itemstack;
            }
        } else {
            this.slots[i] = itemstack;
        }
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
        if (!this.world.field_72995_K && i < 6) {
            this.entity.calcEquipAndUpdateState();
        }
    }

    public String func_145825_b() {
        return "Ship Inventory";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer p_70300_1_) {
        return true;
    }

    public void func_70296_d() {
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int p_94041_1_, ItemStack p_94041_2_) {
        return true;
    }

    public int getInventoryPage() {
        return this.inventoryPage;
    }

    public void setInventoryPage(int par1) {
        this.inventoryPage = par1 >= 0 && par1 < 3 ? par1 : 0;
        this.entity.sendGUISyncPacket();
    }

    public boolean isSlotAvailable(int slotid) {
        if (this.entity.getInventoryPageSize() < 2) {
            if (slotid >= 42) {
                return false;
            }
            if (this.entity.getInventoryPageSize() < 1 && slotid >= 24) {
                return false;
            }
        }
        return true;
    }

    public int getFirstSlotForItem() {
        for (int i = 6; i < this.slots.length; ++i) {
            if (!this.isSlotAvailable(i)) {
                return -1;
            }
            if (this.slots[i] != null) continue;
            return i;
        }
        return -1;
    }

    private int getFirstSlotStackable(ItemStack itemstack) {
        for (int i = 6; i < this.slots.length; ++i) {
            if (!this.isSlotAvailable(i)) {
                return -1;
            }
            if (this.slots[i] == null || this.slots[i].func_77973_b() != itemstack.func_77973_b() || !this.slots[i].func_77985_e() || this.slots[i].field_77994_a >= this.slots[i].func_77976_d() || this.slots[i].field_77994_a >= this.func_70297_j_() || this.slots[i].func_77981_g() && this.slots[i].func_77960_j() != itemstack.func_77960_j() || !ItemStack.func_77970_a((ItemStack)this.slots[i], (ItemStack)itemstack)) continue;
            return i;
        }
        return -1;
    }

    private int storePartialItemStack(ItemStack itemstack) {
        Item item = itemstack.func_77973_b();
        int i = itemstack.field_77994_a;
        if (itemstack.func_77976_d() == 1) {
            int j = this.getFirstSlotForItem();
            if (j < 0) {
                return i;
            }
            this.slots[j] = ItemStack.func_77944_b((ItemStack)itemstack);
            return 0;
        }
        int j = this.getFirstSlotStackable(itemstack);
        if (j < 0) {
            j = this.getFirstSlotForItem();
        }
        if (j < 0) {
            return i;
        }
        if (this.slots[j] == null) {
            this.slots[j] = new ItemStack(item, 0, itemstack.func_77960_j());
            if (itemstack.func_77942_o()) {
                this.slots[j].func_77982_d((NBTTagCompound)itemstack.func_77978_p().func_74737_b());
            }
        }
        int k = i;
        if (i > this.slots[j].func_77976_d() - this.slots[j].field_77994_a) {
            k = this.slots[j].func_77976_d() - this.slots[j].field_77994_a;
        }
        if (k > this.func_70297_j_() - this.slots[j].field_77994_a) {
            k = this.func_70297_j_() - this.slots[j].field_77994_a;
        }
        if (k == 0) {
            return i;
        }
        this.slots[j].field_77994_a += k;
        this.slots[j].field_77992_b = 5;
        return i -= k;
    }

    public boolean addItemStackToInventory(ItemStack itemstack) {
        if (itemstack != null && itemstack.field_77994_a != 0 && itemstack.func_77973_b() != null) {
            try {
                int i;
                if (itemstack.func_77951_h()) {
                    int i2 = this.getFirstSlotForItem();
                    if (i2 >= 0) {
                        this.slots[i2] = ItemStack.func_77944_b((ItemStack)itemstack);
                        this.slots[i2].field_77992_b = 5;
                        itemstack.field_77994_a = 0;
                        return true;
                    }
                    return false;
                }
                do {
                    i = itemstack.field_77994_a;
                    itemstack.field_77994_a = this.storePartialItemStack(itemstack);
                } while (itemstack.field_77994_a > 0 && itemstack.field_77994_a < i);
                return itemstack.field_77994_a < i;
            }
            catch (Exception e) {
                LogHelper.log("EXCEPTION : add item to ship's inventory fail: " + e + " " + itemstack);
                return false;
            }
        }
        return false;
    }
}

