/*
 * Decompiled with CFR 0.152.
 */
package com.lulan.shincolle.entity;

import com.lulan.shincolle.entity.BasicEntityShip;
import com.lulan.shincolle.handler.ConfigHandler;
import com.lulan.shincolle.network.S2CGUIPackets;
import com.lulan.shincolle.proxy.CommonProxy;
import com.lulan.shincolle.proxy.ServerProxy;
import com.lulan.shincolle.team.TeamData;
import com.lulan.shincolle.utility.CalcHelper;
import com.lulan.shincolle.utility.EntityHelper;
import com.lulan.shincolle.utility.FormationHelper;
import com.lulan.shincolle.utility.LogHelper;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;

public class ExtendPlayerProps
implements IExtendedEntityProperties {
    public static final String PLAYER_EXTPROP_NAME = "TeitokuExtProps";
    public EntityPlayer player;
    public World world;
    private boolean isOpeningGUI;
    private boolean hasRing;
    private boolean isRingActive;
    private boolean isRingFlying;
    private int[] ringEffect;
    private int marriageNum;
    private int bossCooldown;
    private int teamCooldown;
    private BasicEntityShip[][] teamList;
    private boolean[][] selectState;
    private boolean initSID = false;
    private int[][] sidList;
    private int[] formatID;
    private int saveId;
    private int teamId;
    private List<Integer> listShipEID;
    private List<Integer> listColleShip;
    private List<Integer> listColleEquip;
    private int playerUID;
    private int playerTeamID;
    private Map<Integer, TeamData> mapTeamData;
    private List<TeamData> listTeamData;
    private List<String> targetClassList;

    public void init(Entity entity, World world) {
        this.world = world;
        this.player = (EntityPlayer)entity;
        this.hasRing = false;
        this.isRingActive = false;
        this.isRingFlying = false;
        this.ringEffect = new int[]{0, 0, 0, 0};
        this.marriageNum = 0;
        this.bossCooldown = ConfigHandler.bossCooldown;
        this.teamList = new BasicEntityShip[9][6];
        this.selectState = new boolean[9][6];
        this.sidList = new int[9][6];
        this.formatID = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0};
        this.listShipEID = new ArrayList<Integer>();
        this.listColleShip = new ArrayList<Integer>();
        this.listColleEquip = new ArrayList<Integer>();
        this.targetClassList = new ArrayList<String>();
        this.initSID = false;
        this.saveId = 0;
        this.teamId = 0;
        this.playerUID = -1;
        this.isOpeningGUI = false;
        this.playerTeamID = 0;
        this.teamCooldown = 20;
        this.mapTeamData = new HashMap<Integer, TeamData>();
        this.listTeamData = new ArrayList<TeamData>();
    }

    public void saveNBTData(NBTTagCompound nbt) {
        NBTTagCompound nbtExt = new NBTTagCompound();
        nbtExt.func_74757_a("hasRing", this.hasRing);
        nbtExt.func_74757_a("RingOn", this.isRingActive);
        nbtExt.func_74757_a("RingFly", this.isRingFlying);
        nbtExt.func_74783_a("RingEffect", this.ringEffect);
        nbtExt.func_74783_a("FormatID", this.formatID);
        nbtExt.func_74768_a("MarriageNum", this.marriageNum);
        nbtExt.func_74768_a("BossCD", this.bossCooldown);
        nbtExt.func_74768_a("PlayerUID", this.playerUID);
        nbtExt.func_74768_a("TeamCD", this.teamCooldown);
        nbtExt.func_74768_a("PlayerTeamID", this.playerTeamID);
        if (this.initSID) {
            LogHelper.info("DEBUG : save player ExtNBT: update ship UID from teamList");
            this.updateSID();
        }
        for (int i = 0; i < 9; ++i) {
            LogHelper.info("DEBUG : save player ExtNBT: " + this.getSID(i)[0]);
            nbtExt.func_74783_a("TeamList" + i, this.getSID(i));
            nbtExt.func_74773_a("SelectState" + i, this.getSelectStateByte(i));
        }
        int[] arrtemp = CalcHelper.intListToArray(this.listColleShip);
        nbtExt.func_74783_a("ColleShip", arrtemp);
        arrtemp = CalcHelper.intListToArray(this.listColleEquip);
        nbtExt.func_74783_a("ColleEquip", arrtemp);
        if (this.targetClassList != null) {
            NBTTagList list = new NBTTagList();
            nbtExt.func_74782_a("CustomTargetClass", (NBTBase)list);
            for (String getc : this.targetClassList) {
                NBTTagString str = new NBTTagString(getc);
                list.func_74742_a((NBTBase)str);
            }
        }
        nbt.func_74782_a(PLAYER_EXTPROP_NAME, (NBTBase)nbtExt);
        LogHelper.info("DEBUG : save player ExtNBT data on id: " + this.player.func_145782_y());
        LogHelper.info("DEBUG : player saveNBTData: backup player extProps in ServerProxy");
        ServerProxy.setPlayerData(this.player.func_110124_au().toString(), nbtExt);
    }

    public void loadNBTData(NBTTagCompound nbt) {
        NBTTagCompound nbtExt = (NBTTagCompound)nbt.func_74781_a(PLAYER_EXTPROP_NAME);
        if (nbtExt == null) {
            if (!nbt.func_74764_b("PlayerUID")) {
                LogHelper.info("DEBUG : player loadNBTData: fail, data is null " + nbt + " " + nbtExt);
                return;
            }
            LogHelper.info("DEBUG : player loadNBTData: get data without tag name");
            nbtExt = nbt;
        }
        LogHelper.info("DEBUG : player loadNBTData: get data " + nbt + " " + nbtExt);
        try {
            this.hasRing = nbtExt.func_74767_n("hasRing");
            this.isRingActive = nbtExt.func_74767_n("RingOn");
            this.isRingFlying = nbtExt.func_74767_n("RingFly");
            this.ringEffect = nbtExt.func_74759_k("RingEffect");
            this.formatID = nbtExt.func_74759_k("FormatID");
            this.marriageNum = nbtExt.func_74762_e("MarriageNum");
            this.bossCooldown = nbtExt.func_74762_e("BossCD");
            this.playerUID = nbtExt.func_74762_e("PlayerUID");
            this.teamCooldown = nbtExt.func_74762_e("TeamCD");
            this.playerTeamID = nbtExt.func_74762_e("PlayerTeamID");
            int[] arrtemp = nbtExt.func_74759_k("ColleShip");
            this.listColleShip = CalcHelper.intArrayToList(arrtemp);
            arrtemp = nbtExt.func_74759_k("ColleEquip");
            this.listColleEquip = CalcHelper.intArrayToList(arrtemp);
            if (!this.world.field_72995_K) {
                for (int i = 0; i < 9; ++i) {
                    byte[] byteSelect = nbtExt.func_74770_j("SelectState" + i);
                    int[] sid = nbtExt.func_74759_k("TeamList" + i);
                    if (sid == null || sid.length <= 5) continue;
                    for (int j = 0; j < 6; ++j) {
                        this.selectState[i][j] = byteSelect[j] == 1;
                        this.sidList[i][j] = sid[j];
                    }
                }
            }
        }
        catch (Exception e) {
            LogHelper.info("DEBUG : player loadNBTData: load fail: " + e);
        }
        LogHelper.info("DEBUG : load player ExtNBT data on id: " + this.player.func_145782_y() + " client? " + this.world.field_72995_K);
    }

    public boolean isRingActive() {
        return this.isRingActive;
    }

    public int isRingActiveI() {
        return this.isRingActive ? 1 : 0;
    }

    public boolean isRingFlying() {
        return this.isRingFlying;
    }

    public boolean hasRing() {
        return this.hasRing;
    }

    public int getRingEffect(int id) {
        return this.ringEffect[id];
    }

    public int getMarriageNum() {
        return this.marriageNum;
    }

    public int getDigSpeedBoost() {
        return this.isRingActive ? this.marriageNum : 0;
    }

    public int getBossCooldown() {
        return this.bossCooldown;
    }

    public int[] getEntityIDofTeam(int tid) {
        int[] eid = new int[6];
        for (int i = 0; i < 6; ++i) {
            eid[i] = this.teamList[tid][i] != null ? this.teamList[tid][i].func_145782_y() : -1;
        }
        return eid;
    }

    public BasicEntityShip getShipEntityCurrentTeam(int id) {
        return this.getShipEntity(this.teamId, id);
    }

    public BasicEntityShip getShipEntity(int tid, int id) {
        try {
            return this.teamList[tid][id];
        }
        catch (Exception e) {
            LogHelper.info("EXCEPTION : get ship entity from extProps fail: " + e);
            return null;
        }
    }

    public BasicEntityShip[] getShipEntityAll(int tid) {
        try {
            return this.teamList[tid];
        }
        catch (Exception e) {
            LogHelper.info("EXCEPTION : get all ship entity from extProps fail: " + e);
            return null;
        }
    }

    public BasicEntityShip[][] getShipEntityAllTeams() {
        try {
            return this.teamList;
        }
        catch (Exception e) {
            LogHelper.info("EXCEPTION : get all ship entity from extProps fail: " + e);
            return null;
        }
    }

    public BasicEntityShip[] getShipEntityByMode(int mode) {
        BasicEntityShip[] ships = new BasicEntityShip[6];
        boolean shouldSync = false;
        for (int k = 0; k < 6; ++k) {
            if (this.teamList[this.teamId][k] == null || EntityHelper.checkSameOwner((Entity)this.teamList[this.teamId][k], (Entity)this.player)) continue;
            this.addShipEntityToCurrentTeam(k, null);
            shouldSync = true;
        }
        if (shouldSync) {
            this.sendSyncPacket(0);
        }
        switch (mode) {
            default: {
                for (int i = 0; i < 6; ++i) {
                    if (!this.getSelectStateCurrentTeam(i)) continue;
                    ships[0] = this.teamList[this.teamId][i];
                    return ships;
                }
                break;
            }
            case 1: {
                int j = 0;
                for (int i = 0; i < 6; ++i) {
                    if (!this.getSelectStateCurrentTeam(i)) continue;
                    ships[j] = this.teamList[this.teamId][i];
                    ++j;
                }
                break;
            }
            case 2: {
                return this.teamList[this.teamId];
            }
        }
        return ships;
    }

    public byte[] getSelectStateByte(int tid) {
        byte[] byteState = new byte[6];
        if (tid > 5) {
            tid = 0;
        }
        if (this.selectState[tid] != null) {
            for (int i = 0; i < 6; ++i) {
                byteState[i] = this.selectState[tid][i] ? (byte)1 : 0;
            }
        }
        return byteState;
    }

    public boolean[][] getSelectStateAllTeams() {
        return this.selectState;
    }

    public boolean[] getSelectState(int tid) {
        try {
            return this.selectState[tid];
        }
        catch (Exception e) {
            LogHelper.info("EXCEPTION : get ship select state fail: " + e);
            return new boolean[6];
        }
    }

    public boolean getSelectState(int tid, int pos) {
        try {
            return this.selectState[tid][pos];
        }
        catch (Exception e) {
            LogHelper.info("EXCEPTION : get ship select state fail: " + e);
            return false;
        }
    }

    public boolean getSelectStateCurrentTeam(int id) {
        if (id > 5) {
            id = 0;
        }
        return this.selectState[this.teamId][id];
    }

    public int getSID(int tid, int pos) {
        try {
            return this.sidList[tid][pos];
        }
        catch (Exception e) {
            LogHelper.info("EXCEPTION : get ship ID fail: " + e);
            return -1;
        }
    }

    public int[] getSID(int tid) {
        if (this.sidList != null && this.sidList[tid] != null) {
            return this.sidList[tid];
        }
        return null;
    }

    public int[][] getSID() {
        return this.sidList;
    }

    public int getSIDCurrentTeam(int id) {
        if (id > 5) {
            id = 0;
        }
        return this.sidList[this.teamId][id];
    }

    public int getPointerTeamID() {
        return this.teamId;
    }

    public int getPlayerUID() {
        return this.playerUID;
    }

    public int getPlayerTeamID() {
        return this.playerTeamID;
    }

    public String getPlayerTeamName() {
        TeamData tdata;
        if (this.playerTeamID > 0 && (tdata = this.mapTeamData.get(this.playerTeamID)) != null) {
            return tdata.getTeamName();
        }
        return null;
    }

    public List<Integer> getPlayerTeamBannedList() {
        TeamData tdata;
        if (this.playerTeamID > 0 && (tdata = this.mapTeamData.get(this.playerTeamID)) != null) {
            return tdata.getTeamBannedList();
        }
        return null;
    }

    public List<Integer> getPlayerTeamAllyList() {
        TeamData tdata;
        if (this.playerTeamID > 0 && (tdata = this.mapTeamData.get(this.playerTeamID)) != null) {
            return tdata.getTeamAllyList();
        }
        return null;
    }

    public Map<Integer, TeamData> getPlayerTeamDataMap() {
        return this.mapTeamData;
    }

    public List<TeamData> getPlayerTeamDataList() {
        return this.listTeamData;
    }

    public TeamData getPlayerTeamData(int par1) {
        return this.mapTeamData.get(par1);
    }

    public int getPlayerTeamCooldown() {
        return this.teamCooldown;
    }

    public int getPlayerTeamCooldownInSec() {
        return (int)((float)this.teamCooldown * 0.05f);
    }

    public boolean getInitSID() {
        return this.initSID;
    }

    public List<Integer> getShipEIDList() {
        return this.listShipEID;
    }

    public List<Integer> getColleShipList() {
        return this.listColleShip;
    }

    public List<Integer> getColleEquipList() {
        return this.listColleEquip;
    }

    public List<String> getTargetClassList() {
        return this.targetClassList;
    }

    public boolean isOpeningGUI() {
        return this.isOpeningGUI;
    }

    public int[] getFormatID() {
        if (this.formatID == null || this.formatID.length != 9) {
            this.formatID = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0};
        }
        return this.formatID;
    }

    public int getFormatID(int teamID) {
        try {
            return this.formatID[teamID];
        }
        catch (Exception e) {
            LogHelper.info("EXCEPTION : get formation id fail: " + e);
            return 0;
        }
    }

    public int getFormatIDCurrentTeam() {
        return this.getFormatID(this.teamId);
    }

    public int getNumberOfShip(int teamID) {
        int num = 0;
        if (this.teamList != null) {
            for (int i = 0; i < 6; ++i) {
                if (this.teamList[teamID][i] == null || !this.teamList[teamID][i].func_70089_S()) continue;
                ++num;
            }
        }
        return num;
    }

    public int getFormationPos(int teamID, int sid) {
        int pos = 0;
        for (int i = 0; i < 6; ++i) {
            if (this.teamList[teamID][i] == null) continue;
            if (this.sidList[teamID][i] == sid) {
                return pos;
            }
            ++pos;
        }
        return -1;
    }

    public float getMinMOVInTeam(int teamID) {
        float mov = 10.0f;
        float temp = 0.0f;
        try {
            for (BasicEntityShip ship : this.teamList[teamID]) {
                if (ship == null || !((temp = ship.getStateFinalBU(4)) < mov)) continue;
                mov = temp;
            }
            if (mov >= 10.0f) {
                LogHelper.info("DEBUG : get min move speed: no ship in team");
                mov = 0.0f;
            }
        }
        catch (Exception e) {
            LogHelper.info("EXCEPTION : get entity MOV from extProps fail: " + e);
            return 0.0f;
        }
        return mov;
    }

    public void setRingActive(boolean par1) {
        this.isRingActive = par1;
    }

    public void setRingActiveI(int par1) {
        this.isRingActive = par1 != 0;
    }

    public void setRingFlying(boolean par1) {
        this.isRingFlying = par1;
    }

    public void setHasRing(boolean par1) {
        this.hasRing = par1;
    }

    public void setRingEffect(int id, int par1) {
        this.ringEffect[id] = par1;
    }

    public void setMarriageNum(int par1) {
        this.marriageNum = par1;
    }

    public void setBossCooldown(int par1) {
        this.bossCooldown = par1;
    }

    public void setSID(int tid, int pos, int sid) {
        try {
            this.sidList[tid][pos] = sid;
        }
        catch (Exception e) {
            LogHelper.info("EXCEPTION : set ship ID fail: " + e);
        }
    }

    public void setSIDCurrentTeam(int pos, int sid) {
        try {
            this.sidList[this.teamId][pos] = sid;
        }
        catch (Exception e) {
            LogHelper.info("EXCEPTION : set current team ship ID fail: " + e);
        }
    }

    public void setSelectState(int tid, int pos, boolean par1) {
        try {
            this.selectState[tid][pos] = par1;
        }
        catch (Exception e) {
            LogHelper.info("EXCEPTION : set ship select state fail: " + e);
        }
    }

    public void setSelectStateCurrentTeam(int id, boolean par1) {
        try {
            this.selectState[this.teamId][id] = par1;
        }
        catch (Exception e) {
            LogHelper.info("EXCEPTION : set current team select state fail: " + e);
        }
    }

    public void setPointerTeamID(int par1) {
        if (par1 > 9) {
            par1 = 0;
        }
        this.teamId = par1;
    }

    public void setPlayerUID(int par1) {
        this.playerUID = par1;
    }

    public void setPlayerTeamID(int par1) {
        this.playerTeamID = par1;
    }

    public void setPlayerTeamDataMap(Map<Integer, TeamData> par1) {
        if (this.mapTeamData != null) {
            this.mapTeamData = par1;
            this.listTeamData = new ArrayList<TeamData>();
            if (this.mapTeamData.size() > 0) {
                for (Map.Entry<Integer, TeamData> entry : this.mapTeamData.entrySet()) {
                    TeamData data = entry.getValue();
                    this.listTeamData.add(data);
                }
            }
        } else {
            this.mapTeamData = new HashMap<Integer, TeamData>();
            this.listTeamData = new ArrayList<TeamData>();
        }
    }

    public void setPlayerTeamCooldown(int par1) {
        this.teamCooldown = par1;
    }

    public void setInitSID(boolean par1) {
        this.initSID = par1;
    }

    public void setShipEIDList(List<Integer> list) {
        this.listShipEID = list;
    }

    public void setColleShipList(List<Integer> list) {
        this.listColleShip = list;
    }

    public void setColleEquipList(List<Integer> list) {
        this.listColleEquip = list;
    }

    public void setColleShip(int shipID) {
        if (!this.listColleShip.contains(shipID)) {
            this.listColleShip.add(shipID);
        }
    }

    public void setColleEquip(int equipID) {
        if (!this.listColleEquip.contains(equipID)) {
            this.listColleEquip.add(equipID);
        }
    }

    public void setTargetClass(List<String> list) {
        if (list != null) {
            this.targetClassList = list;
        }
    }

    public void setTargetClass(String str) {
        if (str != null && str.length() > 1) {
            for (String s : this.targetClassList) {
                if (!str.equals(s)) continue;
                this.targetClassList.remove(s);
                return;
            }
            this.targetClassList.add(str);
        }
    }

    public void setOpeningGUI(boolean par1) {
        this.isOpeningGUI = par1;
    }

    public void setFormatID(int[] par1) {
        this.formatID = par1;
    }

    public void setFormatID(int tid, int fid) {
        try {
            this.formatID[tid] = fid;
        }
        catch (Exception e) {
            LogHelper.info("EXCEPTION : set ship team formation id fail: " + e);
        }
    }

    public void setFormatIDCurrentTeam(int fid) {
        try {
            this.formatID[this.teamId] = fid;
        }
        catch (Exception e) {
            LogHelper.info("EXCEPTION : set current team formation id fail: " + e);
        }
    }

    public void setTeamList(BasicEntityShip[][] par1) {
        this.teamList = par1;
    }

    public void setSelectState(boolean[][] par1) {
        this.selectState = par1;
    }

    public void setSIDList(int[][] par1) {
        this.sidList = par1;
    }

    public void setTeamList(int tid, BasicEntityShip[] par1) {
        try {
            this.teamList[tid] = par1;
        }
        catch (Exception e) {
            LogHelper.info("EXCEPTION : set ship team entity fail: " + e);
        }
    }

    public void setSelectState(int tid, boolean[] par1) {
        try {
            this.selectState[tid] = par1;
        }
        catch (Exception e) {
            LogHelper.info("EXCEPTION : set ship team select state fail: " + e);
        }
    }

    public void setSIDList(int tid, int[] par1) {
        try {
            this.sidList[tid] = par1;
        }
        catch (Exception e) {
            LogHelper.info("EXCEPTION : set ship team SID list fail: " + e);
        }
    }

    public void addShipEntityToCurrentTeam(int slot, BasicEntityShip entity) {
        if (slot > 5) {
            return;
        }
        if (entity == null) {
            this.teamList[this.teamId][slot] = null;
            this.sidList[this.teamId][slot] = -1;
            this.selectState[this.teamId][slot] = false;
        } else {
            this.teamList[this.teamId][slot] = entity;
            this.sidList[this.teamId][slot] = entity.getShipUID();
        }
    }

    public void addShipEntity(int slot, BasicEntityShip entity, boolean forceAdd) {
        boolean canAdd = false;
        if (forceAdd) {
            if (slot > 5) {
                slot = 0;
            }
            this.addShipEntityToCurrentTeam(slot, entity);
            return;
        }
        if (entity != null) {
            if (this.player != null && !EntityHelper.checkSameOwner((Entity)this.player, (Entity)entity)) {
                return;
            }
            int inTeam = this.checkIsInCurrentTeam(entity.getShipUID());
            if (inTeam >= 0) {
                this.addShipEntityToCurrentTeam(inTeam, null);
                this.saveId = inTeam;
                this.setSelectStateCurrentTeam(inTeam, false);
                return;
            }
            for (int i = 0; i < 6; ++i) {
                if (this.teamList[this.teamId][i] != null) continue;
                this.setSelectStateCurrentTeam(i, false);
                this.addShipEntityToCurrentTeam(i, entity);
                this.saveId = i + 1;
                if (this.saveId > 5) {
                    this.saveId = 0;
                }
                return;
            }
            this.setSelectStateCurrentTeam(this.saveId, false);
            this.addShipEntityToCurrentTeam(this.saveId, entity);
            ++this.saveId;
            if (this.saveId > 5) {
                this.saveId = 0;
            }
            return;
        }
        if (slot > 5) {
            slot = 0;
        }
        this.setSelectStateCurrentTeam(slot, false);
        this.addShipEntityToCurrentTeam(slot, null);
    }

    public int[] checkIsInFormationTeam(int shipID) {
        int[] val = new int[]{-1, -1};
        if (shipID > 0) {
            for (int i = 0; i < 9; ++i) {
                if (this.getFormatID(i) <= 0 || (val = this.checkIsInTeam(shipID, i))[0] <= 4 || val[1] < 0) continue;
                val[0] = i;
                break;
            }
        }
        if (val[1] < 0) {
            val[0] = -1;
        }
        return val;
    }

    public int checkIsInCurrentTeam(int shipID) {
        return this.checkIsInTeam(shipID, this.teamId)[1];
    }

    public int[] checkIsInTeam(int shipID) {
        int[] val = new int[]{-1, -1};
        if (shipID > 0) {
            for (int i = 0; i < 9; ++i) {
                val[1] = this.checkIsInTeam(shipID, i)[1];
                if (val[1] > 0) {
                    val[0] = i;
                    break;
                }
                val[1] = -1;
            }
        }
        return val;
    }

    public int[] checkIsInTeam(int shipID, int teamID) {
        int[] val = new int[]{0, -1};
        try {
            for (int i = 0; i < 6; ++i) {
                if (this.teamList[teamID][i] != null && this.teamList[teamID][i].func_70089_S()) {
                    val[0] = val[0] + 1;
                    if (this.teamList[teamID][i].getShipUID() != shipID) continue;
                    val[1] = i;
                    continue;
                }
                this.teamList[teamID][i] = null;
            }
        }
        catch (Exception e) {
            LogHelper.info("EXCEPTION : check ship in team fail: " + e);
        }
        return val;
    }

    public void clearSelectStateCurrentTeam() {
        this.selectState[this.teamId][0] = false;
        this.selectState[this.teamId][1] = false;
        this.selectState[this.teamId][2] = false;
        this.selectState[this.teamId][3] = false;
        this.selectState[this.teamId][4] = false;
        this.selectState[this.teamId][5] = false;
    }

    public void removeShipCurrentTeam(int id) {
        this.teamList[this.teamId][id] = null;
        this.sidList[this.teamId][id] = -1;
        this.selectState[this.teamId][id] = false;
    }

    public void removeShipCurrentTeam() {
        for (int i = 0; i < 6; ++i) {
            this.teamList[this.teamId][i] = null;
            this.sidList[this.teamId][i] = -1;
            this.selectState[this.teamId][i] = false;
        }
    }

    public void clearAllTargetClass() {
        this.targetClassList = new ArrayList<String>();
    }

    public void updateSID() {
        if (this.sidList != null && this.teamList != null) {
            for (int i = 0; i < 9; ++i) {
                for (int j = 0; j < 6; ++j) {
                    if (this.teamList[i][j] == null) continue;
                    this.sidList[i][j] = this.teamList[i][j].getShipUID();
                }
            }
        }
    }

    public void updateShipEntityBySID() {
        if (this.sidList != null) {
            for (int i = 0; i < 9; ++i) {
                for (int j = 0; j < 6; ++j) {
                    this.teamList[i][j] = this.sidList[i][j] > 0 ? EntityHelper.getShipBySID(this.sidList[i][j]) : null;
                }
            }
            this.initSID = true;
        }
    }

    public boolean isTeamLeader() {
        return this.getPlayerTeamID() > 0;
    }

    public boolean isTeamAlly(int par1) {
        if (par1 == 0) {
            return true;
        }
        return this.world.field_72995_K && this.getPlayerTeamID() > 0 && this.getPlayerTeamAllyList() != null && this.getPlayerTeamAllyList().contains(par1);
    }

    public boolean isTeamBanned(int par1) {
        if (par1 == 0) {
            return false;
        }
        return this.world.field_72995_K && this.getPlayerTeamID() > 0 && this.getPlayerTeamBannedList() != null && this.getPlayerTeamBannedList().contains(par1);
    }

    public void sendSyncPacket(int type) {
        if (this.world != null && !this.world.field_72995_K) {
            switch (type) {
                case 0: {
                    CommonProxy.channelG.sendTo((IMessage)new S2CGUIPackets(this, 3), (EntityPlayerMP)this.player);
                    break;
                }
                case 1: {
                    CommonProxy.channelG.sendTo((IMessage)new S2CGUIPackets(this, 9), (EntityPlayerMP)this.player);
                    break;
                }
                case 2: {
                    CommonProxy.channelG.sendTo((IMessage)new S2CGUIPackets(this, 7), (EntityPlayerMP)this.player);
                    break;
                }
                case 3: {
                    CommonProxy.channelG.sendTo((IMessage)new S2CGUIPackets(this, 8), (EntityPlayerMP)this.player);
                    break;
                }
                case 4: {
                    CommonProxy.channelG.sendTo((IMessage)new S2CGUIPackets(this, 10), (EntityPlayerMP)this.player);
                    break;
                }
                case 5: {
                    CommonProxy.channelG.sendTo((IMessage)new S2CGUIPackets(12, this.getColleShipList()), (EntityPlayerMP)this.player);
                    break;
                }
                case 6: {
                    CommonProxy.channelG.sendTo((IMessage)new S2CGUIPackets(13, this.getColleEquipList()), (EntityPlayerMP)this.player);
                }
            }
        }
    }

    public void syncShips() {
        this.sendSyncPacket(4);
    }

    public void syncShips(int teamID) {
        if (this.world != null && !this.world.field_72995_K) {
            CommonProxy.channelG.sendTo((IMessage)new S2CGUIPackets(this, 11, teamID), (EntityPlayerMP)this.player);
        }
    }

    public void swapShip(int tid, int posA, int posB) {
        if (tid < 0 || tid > 8 || posA < 0 || posA > 5 || posB < 0 || posB > 5) {
            return;
        }
        BasicEntityShip shipA = this.teamList[tid][posA];
        int sidA = this.sidList[tid][posA];
        boolean selA = this.selectState[tid][posA];
        this.teamList[tid][posA] = this.teamList[tid][posB];
        this.sidList[tid][posA] = this.sidList[tid][posB];
        this.selectState[tid][posA] = this.selectState[tid][posB];
        this.teamList[tid][posB] = shipA;
        this.sidList[tid][posB] = sidA;
        this.selectState[tid][posB] = selA;
        if (this.teamList[tid][posA] != null) {
            this.teamList[tid][posA].setUpdateFlag(0, true);
        }
        if (this.teamList[tid][posB] != null) {
            this.teamList[tid][posB].setUpdateFlag(0, true);
        }
        FormationHelper.applyFormationMoving(this.teamList[tid], this.getFormatID(tid));
    }
}

