/*
 * Decompiled with CFR 0.152.
 */
package com.lulan.shincolle.entity;

import com.lulan.shincolle.ai.EntityAIShipAircraftAttack;
import com.lulan.shincolle.ai.EntityAIShipOpenDoor;
import com.lulan.shincolle.ai.path.ShipMoveHelper;
import com.lulan.shincolle.ai.path.ShipPathNavigate;
import com.lulan.shincolle.entity.BasicEntityMount;
import com.lulan.shincolle.entity.BasicEntityShip;
import com.lulan.shincolle.entity.BasicEntityShipCV;
import com.lulan.shincolle.entity.IShipAircraftAttack;
import com.lulan.shincolle.entity.IShipAttackBase;
import com.lulan.shincolle.entity.IShipCannonAttack;
import com.lulan.shincolle.entity.IShipFlyable;
import com.lulan.shincolle.entity.other.EntityAbyssMissile;
import com.lulan.shincolle.entity.other.EntityAirplane;
import com.lulan.shincolle.entity.other.EntityRensouhou;
import com.lulan.shincolle.handler.ConfigHandler;
import com.lulan.shincolle.network.S2CSpawnParticle;
import com.lulan.shincolle.proxy.CommonProxy;
import com.lulan.shincolle.utility.CalcHelper;
import com.lulan.shincolle.utility.EntityHelper;
import com.lulan.shincolle.utility.TargetHelper;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.Collections;
import java.util.List;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public abstract class BasicEntityAirplane
extends EntityLiving
implements IShipCannonAttack,
IShipFlyable {
    protected IShipAircraftAttack host;
    protected World world;
    protected ShipPathNavigate shipNavigator;
    protected ShipMoveHelper shipMoveHelper;
    protected Entity atkTarget;
    protected Entity rvgTarget;
    protected int revengeTime;
    public float atk;
    public float atkSpeed;
    public float movSpeed;
    public float def;
    public float kbValue;
    protected int numAmmoLight;
    protected int numAmmoHeavy;
    protected boolean useAmmoLight;
    protected boolean useAmmoHeavy;
    protected boolean backHome;
    protected boolean canFindTarget;
    protected int deadTick;
    protected TargetHelper.Sorter targetSorter = null;
    protected IEntitySelector targetSelector = null;

    public BasicEntityAirplane(World world) {
        super(world);
        this.field_70771_an = 2;
        this.backHome = false;
        this.canFindTarget = true;
        this.field_70178_ae = true;
        this.shipNavigator = new ShipPathNavigate(this, this.field_70170_p);
        this.shipMoveHelper = new ShipMoveHelper(this, 30.0f);
        this.shipNavigator.setCanFly(true);
        this.field_70138_W = 7.0f;
        this.deadTick = 0;
    }

    public abstract void setAttrs(World var1, IShipAircraftAttack var2, Entity var3, double var4);

    public boolean func_70650_aV() {
        return true;
    }

    protected void setAIList() {
        this.clearAITasks();
        this.clearAITargetTasks();
        this.func_70661_as().func_75490_c(true);
        this.func_70661_as().func_75491_a(false);
        this.func_70661_as().func_75495_e(true);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIShipAircraftAttack(this));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new EntityAIShipOpenDoor(this, true));
        this.setEntityTarget(this.atkTarget);
    }

    protected void func_82167_n(Entity target) {
        if (target instanceof BasicEntityShip || target instanceof BasicEntityMount) {
            return;
        }
        target.func_70108_f((Entity)this);
    }

    protected void clearAITasks() {
        this.field_70714_bg.field_75782_a.clear();
    }

    protected void clearAITargetTasks() {
        this.field_70715_bh.field_75782_a.clear();
    }

    protected void func_70069_a(float world) {
    }

    protected void func_70064_a(double par1, boolean par2) {
    }

    public boolean func_70617_f_() {
        return false;
    }

    public boolean canFindTarget() {
        return this.canFindTarget;
    }

    @Override
    public float getAttackDamage() {
        return this.atk;
    }

    @Override
    public float getAttackSpeed() {
        return this.atkSpeed;
    }

    @Override
    public float getAttackRange() {
        return 6.0f;
    }

    @Override
    public float getMoveSpeed() {
        return this.movSpeed;
    }

    @Override
    public int getAmmoLight() {
        return this.numAmmoLight;
    }

    @Override
    public int getAmmoHeavy() {
        return this.numAmmoHeavy;
    }

    @Override
    public boolean hasAmmoLight() {
        return this.numAmmoLight > 0;
    }

    @Override
    public boolean hasAmmoHeavy() {
        return this.numAmmoHeavy > 0;
    }

    @Override
    public void setAmmoLight(int num) {
        this.numAmmoLight = num;
    }

    @Override
    public void setAmmoHeavy(int num) {
        this.numAmmoHeavy = num;
    }

    public void func_70612_e(float movX, float movZ) {
        this.func_70060_a(movX, movZ, this.movSpeed * 0.4f);
        this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        this.field_70159_w *= 0.91;
        this.field_70181_x *= 0.91;
        this.field_70179_y *= 0.91;
        if (this.field_70123_F && this.func_70038_c(this.field_70159_w, this.field_70181_x + 0.6, this.field_70179_y)) {
            this.field_70181_x += 0.2;
        }
        this.field_70722_aY = this.field_70721_aZ;
        double d1 = this.field_70165_t - this.field_70169_q;
        double d0 = this.field_70161_v - this.field_70166_s;
        float f4 = MathHelper.func_76133_a((double)(d1 * d1 + d0 * d0)) * 4.0f;
        if (f4 > 1.0f) {
            f4 = 1.0f;
        }
        this.field_70721_aZ += (f4 - this.field_70721_aZ) * 0.4f;
        this.field_70754_ba += this.field_70721_aZ;
    }

    protected void recycleAmmo() {
        if (this.host instanceof BasicEntityShipCV) {
            BasicEntityShipCV ship = (BasicEntityShipCV)this.host;
            this.numAmmoLight -= 3;
            if (this.numAmmoLight < 0) {
                this.numAmmoLight = 0;
            }
            --this.numAmmoHeavy;
            if (this.numAmmoHeavy < 0) {
                this.numAmmoHeavy = 0;
            }
            ship.setStateMinor(4, ship.getStateMinor(4) + this.numAmmoLight * ship.getAmmoConsumption());
            ship.setStateMinor(5, ship.getStateMinor(5) + this.numAmmoHeavy * ship.getAmmoConsumption());
            if (this instanceof EntityAirplane) {
                ship.setNumAircraftLight(ship.getNumAircraftLight() + 1);
            } else {
                ship.setNumAircraftHeavy(ship.getNumAircraftHeavy() + 1);
            }
        }
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K) {
            this.deadTick = Math.abs(this.field_70165_t + this.field_70163_u + this.field_70161_v - this.field_70169_q - this.field_70167_r - this.field_70166_s) < 0.01 ? ++this.deadTick : 0;
            if (this.getPlayerUID() == 0 || this.getPlayerUID() == -1 || this.deadTick > 100) {
                this.func_70106_y();
            } else {
                if (this.host instanceof EntityLivingBase) {
                    EntityLivingBase hostent = (EntityLivingBase)this.host;
                    if (this.backHome && this.func_70089_S()) {
                        float dist = this.func_70032_d((Entity)hostent);
                        if (dist > 2.7f) {
                            if (this.field_70173_aa % 16 == 0) {
                                this.getShipNavigate().tryMoveToXYZ(hostent.field_70165_t, hostent.field_70163_u + 2.3, hostent.field_70161_v, 1.0);
                            }
                        } else {
                            this.recycleAmmo();
                            this.func_70106_y();
                        }
                    }
                    if (this.field_70173_aa < 34 && this.getEntityTarget() != null) {
                        double distX = this.getEntityTarget().field_70165_t - this.field_70165_t;
                        double distZ = this.getEntityTarget().field_70161_v - this.field_70161_v;
                        double distSqrt = MathHelper.func_76133_a((double)(distX * distX + distZ * distZ));
                        this.field_70159_w = distX / distSqrt * 0.375;
                        this.field_70179_y = distZ / distSqrt * 0.375;
                        this.field_70181_x = 0.1;
                    }
                }
                if (this.field_70173_aa % 16 == 0 && this.canFindTarget) {
                    if (this.field_70173_aa < 900) {
                        this.backHome = this.getEntityTarget() == null ? true : !this.getEntityTarget().func_70089_S();
                    }
                    if (this.field_70173_aa >= 20) {
                        Entity newTarget = null;
                        List list = null;
                        if (this.host.getStateFlag(19)) {
                            list = this.field_70170_p.func_82733_a(BasicEntityAirplane.class, this.field_70121_D.func_72314_b(24.0, 24.0, 24.0), this.targetSelector);
                        }
                        if (list == null || list.isEmpty()) {
                            list = this.field_70170_p.func_82733_a(Entity.class, this.field_70121_D.func_72314_b(16.0, 16.0, 16.0), this.targetSelector);
                        }
                        if (list != null && !list.isEmpty()) {
                            Collections.sort(list, this.targetSorter);
                            newTarget = (Entity)list.get(0);
                        }
                        if (list == null || list.isEmpty()) {
                            newTarget = this.host.getEntityTarget();
                        }
                        if (newTarget != null) {
                            this.setEntityTarget(newTarget);
                        }
                    }
                }
                if (this.func_70090_H() && this.field_70173_aa % 256 == 0) {
                    this.func_70050_g(300);
                }
                if (this.field_70173_aa > 1800) {
                    this.recycleAmmo();
                    this.func_70106_y();
                }
                if (this.field_70173_aa >= 900) {
                    this.backHome = true;
                    this.canFindTarget = false;
                    this.setEntityTarget(null);
                }
            }
        }
        if (this.field_70173_aa % 2 == 0) {
            float[] degree = CalcHelper.getLookDegree(this.field_70165_t - this.field_70169_q, this.field_70163_u - this.field_70167_r, this.field_70161_v - this.field_70166_s, true);
            this.field_70177_z = degree[0];
            this.field_70125_A = degree[1];
        }
        super.func_70071_h_();
    }

    public boolean func_70097_a(DamageSource source, float atk) {
        Entity entity;
        float dist;
        if (source.func_76355_l() == "inWall") {
            return false;
        }
        if (source.func_76355_l() == "outOfWorld") {
            this.func_70106_y();
            return false;
        }
        if (source.func_76346_g() != null && EntityHelper.canDodge(this, dist = (float)this.func_70068_e(source.func_76346_g()))) {
            return false;
        }
        float reduceAtk = atk;
        if (this.host != null) {
            reduceAtk = atk * (1.0f - this.getDefValue() * 0.01f);
        }
        if ((entity = source.func_76346_g()) instanceof BasicEntityShip || entity instanceof BasicEntityAirplane || entity instanceof EntityRensouhou || entity instanceof BasicEntityMount) {
            reduceAtk = reduceAtk * (float)ConfigHandler.dmgSummon * 0.01f;
        }
        if (entity instanceof IShipAttackBase) {
            int modSet = this.field_70170_p.field_73011_w.isDaytime() ? 0 : 1;
            reduceAtk = CalcHelper.calcDamageByType(reduceAtk, ((IShipAttackBase)entity).getDamageType(), this.getDamageType(), modSet);
        }
        if (reduceAtk < 1.0f) {
            reduceAtk = 1.0f;
        }
        return super.func_70097_a(source, reduceAtk);
    }

    @Override
    public boolean attackEntityWithAmmo(Entity target) {
        float atkLight = CalcHelper.calcDamageBySpecialEffect(this, target, this.getAttackDamage(), 0);
        EntityLivingBase hostent = null;
        if (!(this.host instanceof EntityLivingBase)) {
            return false;
        }
        hostent = (EntityLivingBase)this.host;
        this.func_85030_a("shincolle:ship-machinegun", ConfigHandler.volumeFire, 0.7f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        NetworkRegistry.TargetPoint point0 = new NetworkRegistry.TargetPoint(this.field_71093_bK, this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0);
        CommonProxy.channelP.sendToAllAround((IMessage)new S2CSpawnParticle((Entity)this, 8, false), point0);
        NetworkRegistry.TargetPoint point = new NetworkRegistry.TargetPoint(this.field_71093_bK, hostent.field_70165_t, hostent.field_70163_u, hostent.field_70161_v, 64.0);
        float missChance = 0.25f - 0.001f * (float)this.host.getStateMinor(0);
        missChance -= this.host.getEffectEquip(3);
        if (missChance > 0.35f) {
            missChance = 0.35f;
        }
        if (this.field_70146_Z.nextFloat() < missChance) {
            atkLight = 0.0f;
            CommonProxy.channelP.sendToAllAround((IMessage)new S2CSpawnParticle((Entity)hostent, 10, false), point);
        } else if (this.field_70146_Z.nextFloat() < this.host.getEffectEquip(0)) {
            atkLight *= 1.5f;
            CommonProxy.channelP.sendToAllAround((IMessage)new S2CSpawnParticle((Entity)hostent, 11, false), point);
        } else if (this.field_70146_Z.nextFloat() < this.host.getEffectEquip(1)) {
            atkLight *= 2.0f;
            CommonProxy.channelP.sendToAllAround((IMessage)new S2CSpawnParticle((Entity)hostent, 12, false), point);
        } else if (this.field_70146_Z.nextFloat() < this.host.getEffectEquip(2)) {
            atkLight *= 3.0f;
            CommonProxy.channelP.sendToAllAround((IMessage)new S2CSpawnParticle((Entity)hostent, 13, false), point);
        }
        if (target instanceof EntityPlayer) {
            atkLight *= 0.25f;
        }
        if (!EntityHelper.doFriendlyFire(this.host, target)) {
            atkLight = 0.0f;
        }
        if (atkLight > 59.0f) {
            atkLight = 59.0f;
        }
        boolean isTargetHurt = false;
        if (this.host != null) {
            isTargetHurt = target.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)hostent).func_76349_b(), atkLight);
        }
        if (isTargetHurt) {
            NetworkRegistry.TargetPoint point1 = new NetworkRegistry.TargetPoint(this.field_71093_bK, target.field_70165_t, target.field_70163_u, target.field_70161_v, 64.0);
            CommonProxy.channelP.sendToAllAround((IMessage)new S2CSpawnParticle(target, 0, false), point1);
        }
        if (this.numAmmoLight > 0) {
            --this.numAmmoLight;
        }
        return isTargetHurt;
    }

    @Override
    public boolean attackEntityWithHeavyAmmo(Entity target) {
        float atkHeavy = this.getAttackDamage();
        EntityLivingBase hostent = null;
        if (!(this.host instanceof EntityLivingBase)) {
            return false;
        }
        hostent = (EntityLivingBase)this.host;
        this.func_85030_a("shincolle:ship-fireheavy", ConfigHandler.volumeFire, 0.7f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        float missChance = 0.25f - 0.001f * (float)this.host.getStateMinor(0);
        missChance -= this.host.getEffectEquip(3);
        if (missChance > 0.35f) {
            missChance = 0.35f;
        }
        if (this.field_70146_Z.nextFloat() < missChance) {
            atkHeavy = 0.0f;
            NetworkRegistry.TargetPoint point = new NetworkRegistry.TargetPoint(this.field_71093_bK, hostent.field_70165_t, hostent.field_70163_u, hostent.field_70161_v, 64.0);
            CommonProxy.channelP.sendToAllAround((IMessage)new S2CSpawnParticle((Entity)hostent, 10, false), point);
        }
        EntityAbyssMissile missile = new EntityAbyssMissile(this.field_70170_p, (IShipAttackBase)this, (float)target.field_70165_t, (float)(target.field_70163_u + (double)(target.field_70131_O * 0.2f)), (float)target.field_70161_v, (float)(this.field_70163_u - (double)0.8f), atkHeavy, this.kbValue, true, -1.0f);
        this.field_70170_p.func_72838_d((Entity)missile);
        if (this.numAmmoHeavy > 0) {
            --this.numAmmoHeavy;
        }
        return true;
    }

    @Override
    public Entity getEntityTarget() {
        return this.atkTarget;
    }

    @Override
    public void setEntityTarget(Entity target) {
        this.atkTarget = target;
    }

    @Override
    public ShipPathNavigate getShipNavigate() {
        return this.shipNavigator;
    }

    @Override
    public ShipMoveHelper getShipMoveHelper() {
        return this.shipMoveHelper;
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        EntityHelper.updateShipNavigator(this);
    }

    @Override
    public boolean canFly() {
        return true;
    }

    public boolean func_70648_aU() {
        return true;
    }

    @Override
    public byte getStateEmotion(int id) {
        return 0;
    }

    @Override
    public void setStateEmotion(int id, int value, boolean sync) {
    }

    @Override
    public int getFaceTick() {
        return 0;
    }

    @Override
    public int getHeadTiltTick() {
        return 0;
    }

    @Override
    public void setFaceTick(int par1) {
    }

    @Override
    public void setHeadTiltTick(int par1) {
    }

    @Override
    public int getTickExisted() {
        return this.field_70173_aa;
    }

    @Override
    public boolean useAmmoLight() {
        return this.useAmmoLight;
    }

    @Override
    public boolean useAmmoHeavy() {
        return this.useAmmoHeavy;
    }

    @Override
    public int getAttackTime() {
        return this.field_70724_aR;
    }

    @Override
    public boolean getIsRiding() {
        return false;
    }

    @Override
    public boolean getIsSprinting() {
        return false;
    }

    @Override
    public boolean getIsSitting() {
        return false;
    }

    @Override
    public boolean getIsSneaking() {
        return false;
    }

    @Override
    public boolean getIsLeashed() {
        return false;
    }

    @Override
    public boolean getStateFlag(int flag) {
        switch (flag) {
            default: {
                return true;
            }
            case 12: 
        }
        return false;
    }

    @Override
    public void setStateFlag(int id, boolean flag) {
    }

    @Override
    public int getLevel() {
        if (this.host != null) {
            return this.host.getLevel();
        }
        return 150;
    }

    @Override
    public int getStateMinor(int id) {
        return 0;
    }

    @Override
    public void setStateMinor(int state, int par1) {
    }

    @Override
    public float getEffectEquip(int id) {
        if (this.host != null) {
            return this.host.getEffectEquip(id);
        }
        return 0.0f;
    }

    @Override
    public float getDefValue() {
        return this.def;
    }

    @Override
    public void setEntitySit() {
    }

    @Override
    public float getModelRotate(int par1) {
        return 0.0f;
    }

    @Override
    public void setModelRotate(int par1, float par2) {
    }

    @Override
    public boolean getAttackType(int par1) {
        return true;
    }

    @Override
    public int getPlayerUID() {
        if (this.host != null) {
            return this.host.getPlayerUID();
        }
        return -1;
    }

    @Override
    public void setPlayerUID(int uid) {
    }

    @Override
    public Entity getHostEntity() {
        if (this.host instanceof Entity) {
            return (Entity)this.host;
        }
        return null;
    }

    @Override
    public int getDamageType() {
        return 7;
    }

    @Override
    public Entity getEntityRevengeTarget() {
        return this.rvgTarget;
    }

    @Override
    public int getEntityRevengeTime() {
        return this.revengeTime;
    }

    @Override
    public void setEntityRevengeTarget(Entity target) {
        this.rvgTarget = target;
    }

    @Override
    public void setEntityRevengeTime() {
        this.revengeTime = this.field_70173_aa;
    }

    @Override
    public int getAttackAniTick() {
        return 0;
    }

    @Override
    public void setAttackAniTick(int par1) {
    }

    public boolean func_70104_M() {
        return false;
    }

    @Override
    public float getSwingTime(float partialTick) {
        return 0.0f;
    }
}

