/*
 * Decompiled with CFR 0.152.
 */
package com.lulan.shincolle.crafting;

import com.lulan.shincolle.crafting.EquipCalc;
import com.lulan.shincolle.crafting.ShipCalc;
import com.lulan.shincolle.handler.ConfigHandler;
import com.lulan.shincolle.init.ModBlocks;
import com.lulan.shincolle.init.ModItems;
import com.lulan.shincolle.item.BasicItem;
import com.lulan.shincolle.item.IShipResourceItem;
import com.lulan.shincolle.item.ShipSpawnEgg;
import com.lulan.shincolle.tileentity.TileMultiGrudgeHeavy;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class LargeRecipes {
    private static Random rand = new Random();
    private static final int MIN_AMOUNT = 100;
    private static final int MAX_STOCK = 1000000;
    private static final int BASE_POWER = 460800;
    private static final int POWER_PER_MAT = 256;

    public static boolean canRecipeBuild(int[] matAmount) {
        return matAmount[0] >= 100 && matAmount[1] >= 100 && matAmount[2] >= 100 && matAmount[3] >= 100;
    }

    public static int calcGoalPower(int[] matAmount) {
        if (LargeRecipes.canRecipeBuild(matAmount)) {
            int extraAmount = matAmount[0] + matAmount[1] + matAmount[2] + matAmount[3] - 400;
            return 460800 + 256 * extraAmount;
        }
        return 0;
    }

    private static void addSlotContents(TileMultiGrudgeHeavy tile, Item item, int meta, int slot) {
        if (tile.func_70301_a(slot) == null) {
            tile.func_70299_a(slot, new ItemStack(item, 1, meta));
        } else {
            ++tile.func_70301_a((int)slot).field_77994_a;
        }
    }

    private static int getFitSlot(TileMultiGrudgeHeavy tile, Item item, int meta) {
        for (int i = 1; i < 10; ++i) {
            if (tile.func_70301_a(i) != null && (tile.func_70301_a(i).func_77973_b() != item || tile.func_70301_a(i).func_77960_j() != meta || tile.func_70301_a((int)i).field_77994_a >= tile.func_70301_a(i).func_77976_d())) continue;
            return i;
        }
        return -1;
    }

    public static boolean outputMaterialToSlot(TileMultiGrudgeHeavy tile, int selectMat, boolean compress) {
        BasicItem matchItem = null;
        int meta = 0;
        int slot = -1;
        if (compress) {
            switch (selectMat) {
                case 0: {
                    matchItem = Item.func_150898_a((Block)ModBlocks.BlockGrudge);
                    meta = 0;
                    break;
                }
                case 1: {
                    matchItem = Item.func_150898_a((Block)ModBlocks.BlockAbyssium);
                    meta = 0;
                    break;
                }
                case 2: {
                    matchItem = ModItems.Ammo;
                    meta = 1;
                    break;
                }
                case 3: {
                    matchItem = Item.func_150898_a((Block)ModBlocks.BlockPolymetal);
                    meta = 0;
                }
            }
        } else {
            switch (selectMat) {
                case 0: {
                    matchItem = ModItems.Grudge;
                    meta = 0;
                    break;
                }
                case 1: {
                    matchItem = ModItems.AbyssMetal;
                    meta = 0;
                    break;
                }
                case 2: {
                    matchItem = ModItems.Ammo;
                    meta = 0;
                    break;
                }
                case 3: {
                    matchItem = ModItems.AbyssMetal;
                    meta = 1;
                }
            }
        }
        if (matchItem != null && (slot = LargeRecipes.getFitSlot(tile, matchItem, meta)) > -1) {
            LargeRecipes.addSlotContents(tile, matchItem, meta, slot);
            return true;
        }
        return false;
    }

    public static boolean addMaterialStock(TileMultiGrudgeHeavy tile, ItemStack item) {
        block13: {
            boolean canAdd = false;
            if (item != null) {
                try {
                    ItemStack[] items;
                    int matStockCurrent = 0;
                    canAdd = true;
                    for (int j = 0; j < 4; ++j) {
                        matStockCurrent = tile.getMatStock(j);
                        if (matStockCurrent <= 1000000) continue;
                        canAdd = false;
                        break;
                    }
                    if (!canAdd) break block13;
                    if (item.func_77973_b() instanceof IShipResourceItem) {
                        int meta = item.func_77960_j();
                        int[] addMats = ((IShipResourceItem)item.func_77973_b()).getResourceValue(meta);
                        if (ConfigHandler.easyMode) {
                            for (int i = 0; i < 4; ++i) {
                                addMats[i] = addMats[i] * 10;
                            }
                        }
                        for (int k = 0; k < 4; ++k) {
                            tile.addMatStock(k, addMats[k]);
                        }
                        return true;
                    }
                    if (!(item.func_77973_b() instanceof ShipSpawnEgg) || item.func_77960_j() <= 1) break block13;
                    for (ItemStack i : items = ShipCalc.getKaitaiItems(item.func_77960_j() - 2)) {
                        if (i != null) {
                            int size = i.field_77994_a;
                            int meta = i.func_77960_j();
                            int[] addMats = ((IShipResourceItem)i.func_77973_b()).getResourceValue(meta);
                            addMats[0] = addMats[0] * size;
                            addMats[1] = addMats[1] * size;
                            addMats[2] = addMats[2] * size;
                            addMats[3] = addMats[3] * size;
                            if (ConfigHandler.easyMode) {
                                for (int j = 0; j < 4; ++j) {
                                    addMats[j] = addMats[j] * 10;
                                }
                            }
                            for (int k = 0; k < 4; ++k) {
                                tile.addMatStock(k, addMats[k]);
                            }
                            continue;
                        }
                        return false;
                    }
                    return true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return false;
                }
            }
        }
        return false;
    }

    public static ItemStack getBuildResultShip(int[] matAmount) {
        ItemStack buildResult = new ItemStack((Item)ModItems.ShipSpawnEgg, 1, 1);
        buildResult.field_77990_d = new NBTTagCompound();
        buildResult.field_77990_d.func_74768_a("Grudge", matAmount[0]);
        buildResult.field_77990_d.func_74768_a("Abyssium", matAmount[1]);
        buildResult.field_77990_d.func_74768_a("Ammo", matAmount[2]);
        buildResult.field_77990_d.func_74768_a("Polymetal", matAmount[3]);
        return buildResult;
    }

    public static ItemStack getBuildResultEquip(int[] matAmount) {
        Object buildResult = null;
        int rollType = -1;
        int totalMat = matAmount[0] + matAmount[1] + matAmount[2] + matAmount[3];
        float randRate = rand.nextFloat();
        rollType = EquipCalc.rollEquipType(1, matAmount);
        return EquipCalc.rollEquipsOfTheType(rollType, totalMat, 1);
    }
}

